#include "BinaryLoader.h"

CBinaryLoader::CBinaryLoader(CImageRenderer *renderer) :
	CImageLoader(renderer) 
{


}


CBinaryLoader::~CBinaryLoader() {

}


void CBinaryLoader::startLoad(CImageContext *context, CImageData *data) {
	m_renderer->setImage(context, data);
}


CImageData *CBinaryLoader::loadFile(const char *filename) {

	CBinaryData *binaryData = new CBinaryData();
	binaryData->copyFilename(filename);
	binaryData->loadFileAsBinary(filename);
	if (binaryData->m_sauce)
		binaryData->m_fileLength -= 128;

	loadFileFromDataImp(binaryData->m_fileData, binaryData->m_fileLength, binaryData);
	return binaryData;
}


CImageData *CBinaryLoader::loadFileFromData(const char *data, const int length) {

	CBinaryData *binaryData = new CBinaryData();
	binaryData->m_sauce   = getSauceFromData(data, length);
	if (binaryData->m_sauce)
		binaryData->m_fileLength -= 128;

	loadFileFromDataImp(data, length, binaryData);
	return binaryData;
}
