// DirTreeCtrl.cpp: 
// 
// wrapped CTreeCtrl to select and or display folders and files (optional )
// 

#include "stdafx.h"

#include "DirTreeCtrl.h"
#include "SortStringArray.h"
#include "acidview.h"
#include "mainfrm.h"
#include "CompressedFileFactory.h"
#include "CompressedFileFind.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDirTreeCtrl

CDirTreeCtrl::CDirTreeCtrl() :
	m_strRoot(""),
	m_loaded(false),
	m_fileMask("*.*")
{	
}

CDirTreeCtrl::~CDirTreeCtrl() {
	m_imgList.Detach();
}

BOOL CDirTreeCtrl::PreCreateWindow(CREATESTRUCT& cs) {
	cs.style |= TVS_NOTOOLTIPS;	
	return CTreeCtrl::PreCreateWindow(cs);
}

BEGIN_MESSAGE_MAP(CDirTreeCtrl, CTreeCtrl)
	//{{AFX_MSG_MAP(CDirTreeCtrl)
	ON_NOTIFY_REFLECT(TVN_ITEMEXPANDED, OnItemexpanded)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelChanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////


DirTreeCtrlThreadData CDirTreeCtrl::m_threadData;


BOOL CDirTreeCtrl::DisplayDrives() {
	// Displaying the Availible Drives on this PC
	DeleteAllItems();
	char  szDrives[128];
	char* pDrive;

	if ( !GetLogicalDriveStrings( sizeof(szDrives), szDrives ) ) {
		m_strError = "Error Getting Logical DriveStrings!";
		return FALSE;
	}

	pDrive = szDrives;
	while( *pDrive ) {
		HTREEITEM hParent = AddItem( TVI_ROOT, pDrive );
		if (GetDriveType(pDrive)==DRIVE_FIXED && FindSubDir( pDrive ) ) {
			InsertItem( "", 0, 0, hParent);
		} else {
			InsertItem( "", 0, 0, hParent);
		}
		pDrive += strlen( pDrive ) + 1;
	}

	return TRUE;
}


BOOL CDirTreeCtrl::GetSysImgList() {

	SHFILEINFO shFinfo;
	HIMAGELIST hImgList = NULL;

	if ( GetImageList( TVSIL_NORMAL ) )
		m_imgList.Detach();
	
	hImgList = (HIMAGELIST)SHGetFileInfo( "C:\\",
							  0,
							  &shFinfo,
							  sizeof( shFinfo ),
							  SHGFI_SYSICONINDEX | 
							  SHGFI_SMALLICON );
	if ( !hImgList ) {
		m_strError = "Cannot retrieve the Handle of SystemImageList!";
		return FALSE;
	}

	m_imgList.m_hImageList = hImgList;        
	SetImageList( &m_imgList, TVSIL_NORMAL );
	return TRUE;  
}


UINT CDirTreeCtrl::DisplayTreeImp(LPVOID pParam) {

	CDirTreeCtrl *tree = m_threadData.tree;

	// Display the DirTree with the Rootname e.g. C:\
	// if Rootname == NULL then Display all Drives on this PC
    // First, we need the system-ImageList
	tree->DeleteAllItems();

	if (!tree->GetSysImgList()) {
		return FALSE;
	}

	tree->SetRedraw(FALSE);
	tree->DisplayDrives();
	//tree->JumpToDir(m_threadData.strPath, TRUE);
	tree->SetSelPath(m_threadData.strPath);
	tree->m_loaded = true;
	tree->SetRedraw(TRUE);
	AfxEndThread(0);
	return 0;
}

BOOL CDirTreeCtrl::DisplayTree(LPCTSTR strRoot, BOOL bFiles)
{
	DWORD dwStyle = GetStyle();
	if ( dwStyle & TVS_EDITLABELS )	{
		// Don't allow the user to edit ItemLabels
		ModifyStyle( TVS_EDITLABELS , 0 );
	}

	m_threadData.strPath = strRoot;
	m_threadData.tree = this;
	CWinThread *thread = AfxBeginThread((AFX_THREADPROC)DisplayTreeImp, NULL, THREAD_PRIORITY_IDLE);
	thread->SetThreadPriority(THREAD_PRIORITY_IDLE);
	
	return TRUE;	
}

BOOL CDirTreeCtrl::JumpToDir(LPCTSTR strRoot, BOOL setSel) {
	
	if (!IsValidPath(strRoot))	{
		return FALSE;
	}

	m_strRoot = strRoot;
	if ( m_strRoot.Right(1) != '\\' )
		m_strRoot += "\\";
	
	int index = 0;
	HTREEITEM hRoot = GetRootItem();
	CString totalDir = "";
	
	m_strRoot.MakeLower();
	CString s = m_strRoot;
	while(totalDir!=s) {
		
		//if this is the first iteration, then first child is a sibling to the root
		//	rather than an actual child
		HTREEITEM child;
		CString childText, dir;
		if (index==0) {
			child = GetNextSiblingItem(hRoot);
		} else {
			child = GetChildItem(hRoot);
		}
		childText = GetItemText(child);
		childText.MakeLower();
		
		//Get path name to look for
		int index2	= s.Find('\\', index+1);
		if (index==0) {
			dir	= s.Left(index2);
		} else {
			dir	= s.Mid(index+1, index2-(index+1));
		}
		dir.MakeLower();
		index = index2;
		while(childText!=dir && child!=NULL) {			
			child		= GetNextSiblingItem(child);
			childText   = GetItemText(child);
			childText.MakeLower();
		}
		
		if (child==NULL) {
			return FALSE;
		}

//		if (setSel) 
//			ExpandItem(child, TVE_EXPAND);
//		else 
			Expand(child, TVE_EXPAND);
		hRoot = child;	
		
		totalDir += childText+"\\";
	}

	/*! \note this may cause many errors */
	if (setSel)
		SetSelPath(s);  

	return TRUE;
}


void CDirTreeCtrl::DisplayPath(HTREEITEM hParent, LPCTSTR strPath) {
	
	SetRedraw( FALSE );
	CSortStringArray strDirArray;
	CSortStringArray strFileArray;

	// Displaying the Path in the TreeCtrl
	CString   strPathFiles = strPath;
	BOOL      bFind;
	
	if ( strPathFiles.Right(1) != "\\" )
		strPathFiles += "\\";

	CCompressedFileFind find(strPathFiles);
	bFind = find.findFile(m_fileMask);
	while ( bFind )	{

		bFind = find.findNextFile();

		if (bFind) {
			if (find.isDirectory())	{		
				strDirArray.Add( find.getFilePath() );
			} else {
				strFileArray.Add( find.getFilePath() );
			}
		}
	}
	
	strDirArray.Sort();
	strFileArray.Sort();
	
	//Add normal directories at the top
	bool compressed = find.isCompressed();
	for ( int i = 0; i < strDirArray.GetSize(); i++ ){ 
		LPCTSTR path = strDirArray.GetAt(i);
		if (!CCompressedFileFactory::isCompressedFile(path)) {

			if (compressed) {

				CString p = path;
				int slash0 = p.ReverseFind('\\')+1;
				if (slash0==strPathFiles.GetLength() && p.Left(slash0)==strPathFiles) {
					HTREEITEM hItem = AddItem(hParent, path, !compressed, TRUE);	
					InsertItem( "", 0, 0, hItem );
				}

			} else {
				HTREEITEM hItem = AddItem(hParent, path, !compressed);
				//speed optimzation
				//if (FindSubDir(path) )
				InsertItem( "", 0, 0, hItem );
			}
		}
	}
	
	//Add compressed files below directories
	for (i = 0; i < strDirArray.GetSize(); i++ ){ 
		LPCTSTR path = strDirArray.GetAt(i);
		if (CCompressedFileFactory::isCompressedFile(path)) {
			HTREEITEM hItem = AddItem(hParent, path, !compressed);
			InsertItem("", 0, 0, hItem);
		}
	}
	
	//Add regular files
	for ( i = 0; i < strFileArray.GetSize(); i++ )	{
		
		if (compressed) {
			CString path = strFileArray.GetAt(i);
			int slash0 = path.ReverseFind('\\');
			int slash1 = strPathFiles.ReverseFind('\\');
			if (slash0==slash1 && path.Left(slash0)==strPathFiles.Left(slash0)) {
				HTREEITEM hItem = AddItem( hParent, path, FALSE);			
			}
		} else {
			HTREEITEM hItem = AddItem( hParent, strFileArray.GetAt(i), TRUE);			
		}
	}

	if (m_loaded)
		SetRedraw(TRUE);
}


HTREEITEM CDirTreeCtrl::AddItem(HTREEITEM hParent, LPCTSTR strPath, BOOL exists, BOOL useFolderIcon)
{
	// Adding the Item to the TreeCtrl with the current Icons
	SHFILEINFO shFinfo;
	int iIcon, iIconSel;
    
    CString    strTemp = strPath;
	if ( strTemp.Right(1) != '\\' )
		 strTemp += "\\";

	if (exists) {


		if ( !SHGetFileInfo( strTemp,
							0,
							&shFinfo,
							sizeof( shFinfo ),
							SHGFI_SYSICONINDEX |
							SHGFI_SMALLICON ) )	{
			m_strError = "Error Gettting SystemFileInfo!";
			return NULL;
		}
		iIcon = shFinfo.iIcon;

		if ( !SHGetFileInfo( strTemp,
							0,
							&shFinfo,
							sizeof( shFinfo ),
							SHGFI_SYSICONINDEX |
							SHGFI_OPENICON |
							SHGFI_SMALLICON ) )	{
			m_strError = "Error Gettting SystemFileInfo!";
			return NULL;
		}
		iIconSel = shFinfo.iIcon;

	} else {

		if (!useFolderIcon) {

			if ( !SHGetFileInfo( strPath,
								FILE_ATTRIBUTE_NORMAL,
								&shFinfo,
								sizeof( shFinfo ),
								SHGFI_USEFILEATTRIBUTES |
								SHGFI_SYSICONINDEX |
								SHGFI_SMALLICON ) )	{
				m_strError = "Error Gettting SystemFileInfo!";
				return NULL;
			}
			iIcon	 = shFinfo.iIcon;
			iIconSel = shFinfo.iIcon;

		} else {
			
			/*! \todo There must be a normal way to just get the folder icon */
			if ( !SHGetFileInfo( "c:\\windows\\",
								0,
								&shFinfo,
								sizeof( shFinfo ),
								SHGFI_ICON | 
								SHGFI_SYSICONINDEX |
								SHGFI_SMALLICON ) )	{
				m_strError = "Error Gettting SystemFileInfo!";
				return NULL;
			}
			iIcon = shFinfo.iIcon;
			
			if ( !SHGetFileInfo( "c:\\windows\\",
								0,
								&shFinfo,
								sizeof( shFinfo ),
								SHGFI_ICON | 
								SHGFI_OPENICON |
								SHGFI_SYSICONINDEX |
								SHGFI_SMALLICON ) )	{
				m_strError = "Error Gettting SystemFileInfo!";
				return NULL;
			}
			iIconSel = shFinfo.iIcon;
		}
	}

	strTemp.SetAt( strTemp.GetLength() - 1, '\0' );
	if (hParent==TVI_ROOT)
		return InsertItem(strTemp, iIcon, iIconSel, hParent );
	
	return InsertItem(GetSubPath(strTemp), iIcon, iIconSel, hParent );
}

LPCTSTR CDirTreeCtrl::GetSubPath(LPCTSTR strPath)
{
	//
	// getting the last SubPath from a PathString
	// e.g. C:\temp\readme.txt
	// the result = readme.txt
	static CString strTemp;
	int     iPos;

	strTemp = strPath;
	if ( strTemp.Right(1) == '\\' )
		 strTemp.SetAt( strTemp.GetLength() - 1, '\0' );
	iPos = strTemp.ReverseFind( '\\' );
	if ( iPos != -1 )
	    strTemp = strTemp.Mid( iPos + 1);

	return (LPCTSTR)strTemp;
}

BOOL CDirTreeCtrl::FindSubDir( LPCTSTR strPath) {
	//
	// Are there subDirs ?
	//
	CFileFind find;
	CString   strTemp = strPath;
	BOOL      bFind;

	if (!CCompressedFileFactory::isCompressedFile(strPath))
		return TRUE;

	if ( strTemp[strTemp.GetLength()-1] == '\\' )
		strTemp += "*.*";
	else
		strTemp += "\\*.*";
		
	bFind = find.FindFile( strTemp );	
	while ( bFind )	{
		bFind = find.FindNextFile();
		if ( find.IsDirectory() && !find.IsDots() )
			return TRUE;
		if ( !find.IsDirectory() && !find.IsHidden() )
			return TRUE;		
	}

	return FALSE;
}

void CDirTreeCtrl::OnItemexpanded(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	CString strPath;
	 
	if ( pNMTreeView->itemNew.state & TVIS_EXPANDED )
	{
		//UINT uTest = TVIS_EXPANDEDONCE;
		ExpandItem( pNMTreeView->itemNew.hItem, TVE_EXPAND );

	    /*
		//
		// Delete All items
		// And display the subpath
		//
		HTREEITEM hChild = GetChildItem( pNMTreeView->itemNew.hItem );
		while ( hChild )
		{
			DeleteItem( hChild );
			hChild = GetChildItem( pNMTreeView->itemNew.hItem );
		}
        
		strPath = GetFullPath( pNMTreeView->itemNew.hItem );
		DisplayPath( pNMTreeView->itemNew.hItem, strPath );
		*/
	}
	else
	{
		//
		// Delete the Items, but leave one there, for 
		// expanding the item next time
		//
		HTREEITEM hChild = GetChildItem( pNMTreeView->itemNew.hItem );
				
		while ( hChild ) 
		{
			DeleteItem( hChild );
			hChild = GetChildItem( pNMTreeView->itemNew.hItem );
		}
		InsertItem( "", pNMTreeView->itemNew.hItem );
	}

	*pResult = 0;
}


void CDirTreeCtrl::OnSelChanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	HTREEITEM hChild = GetChildItem( pNMTreeView->itemNew.hItem);
	if (!hChild) {
		CString filename = GetFullPath(pNMTreeView->itemNew.hItem);
		AfxGetApp()->OpenDocumentFile(filename);
	} else {
		CString path = GetFullPath(pNMTreeView->itemNew.hItem);
		if (CCompressedFileFactory::isCompressedFile(path)) {

			if (path.Right(1)!='\\')
				path+='\\';

			if (CCompressedFileFactory::getFactory()->fileExists(path+"file_id.diz"))
				AfxGetApp()->OpenDocumentFile(path+"file_id.diz");
			else if (CCompressedFileFactory::getFactory()->fileExists(path+"readme.txt"))
				AfxGetApp()->OpenDocumentFile(path+"readme.txt");
			else if (CCompressedFileFactory::getFactory()->fileExists(path+"infofile.txt"))
				AfxGetApp()->OpenDocumentFile(path+"infofile.txt");
			else if (CCompressedFileFactory::getFactory()->fileExists(path+"info.txt"))
				AfxGetApp()->OpenDocumentFile(path+"info.txt");
		}
	}
	
	*pResult = 0;
}


CString CDirTreeCtrl::GetFullPath(HTREEITEM hItem)
{
	// get the Full Path of the item
	CString strReturn;
	CString strTemp;
	HTREEITEM hParent = hItem;

	strReturn = "";
	while ( hParent )
	{		
		strTemp  = GetItemText( hParent );
		strTemp += "\\";
		strReturn = strTemp + strReturn;
		hParent = GetParentItem( hParent );
	}
    
	strReturn.TrimRight( '\\' );
    return strReturn;
}

BOOL CDirTreeCtrl::SetSelPath(LPCTSTR strPath)
{
	// Setting the Selection in the Tree
	HTREEITEM hParent  = TVI_ROOT;
	int       iLen    = strlen(strPath) + 2;
	char*     pszPath = new char[iLen];
	char*     pPath   = pszPath;
	BOOL      bRet    = FALSE;
    
	if ( !IsValidPath( strPath ) )
	{
		delete [] pszPath; // this must be added 29.03.99
		return FALSE;
	}
		
	strcpy( pszPath, strPath );
	strupr( pszPath );
	
	if ( pszPath[strlen(pszPath)-1] != '\\' )
		strcat( pszPath, "\\" );
    
	int iLen2 = strlen( pszPath );
	
	for (WORD i = 0; i < iLen2; i++ )
	{
		if ( pszPath[i] == '\\' )
		{
			SetRedraw( FALSE );
			pszPath[i] = '\0';
			hParent = SearchSiblingItem( hParent, pPath );
			if ( !hParent )  // Not found!
				break;
			else
			{				
				// Info:
				// the notification OnItemExpanded 
				// will not called every time 
				// after the call Expand. 
				// You must call Expand with TVE_COLLAPSE | TVE_COLLAPSERESET
				// to Reset the TVIS_EXPANDEDONCE Flag
				
				UINT uState;
				uState = GetItemState( hParent, TVIS_EXPANDEDONCE );
				if ( uState )
				{
					Expand( hParent, TVE_EXPAND );
					Expand( hParent, TVE_COLLAPSE | TVE_COLLAPSERESET );
					InsertItem("", hParent ); // insert a blank child-item
					Expand( hParent, TVE_EXPAND ); // now, expand send a notification
				}
				else
					Expand( hParent, TVE_EXPAND );
			}
			pPath += strlen(pPath) + 1;
		}
	}

	delete [] pszPath;
	
	if ( hParent ) // Ok the last subpath was found
	{		
		SelectItem( hParent ); // select the last expanded item
		bRet = TRUE;
	}
	else
	{
		bRet = FALSE;
	}
	
	m_strRoot = strPath;
	if (m_loaded)
		SetRedraw(TRUE);

    return bRet;
}

HTREEITEM CDirTreeCtrl::SearchSiblingItem( HTREEITEM hItem, LPCTSTR strText)
{
	HTREEITEM hFound = GetChildItem( hItem );
	CString   strTemp;
	while ( hFound )
	{
		strTemp = GetItemText( hFound );
        strTemp.MakeUpper();
		if ( strTemp == strText )
			return hFound;
		hFound = GetNextItem( hFound, TVGN_NEXT );
	}

	return NULL;
}


void CDirTreeCtrl::ExpandItem(HTREEITEM hItem, UINT nCode)
{	
	CString strPath;
	
	if ( nCode == TVE_EXPAND )	{
		
		HTREEITEM hChild = GetChildItem( hItem );
		while ( hChild )
		{
			DeleteItem( hChild );
			hChild = GetChildItem( hItem );
		}
        
		strPath = GetFullPath(hItem);		
		DisplayPath(hItem, strPath);	
		m_strRoot = strPath;		
	}
}

BOOL CDirTreeCtrl::IsValidPath(LPCTSTR strPath)
{
	// This function check the Pathname
	
	HTREEITEM hChild;
	CString   strItem;
	CString   strTempPath = strPath;
	BOOL      bFound = FALSE;
	CFileFind find;

	hChild = GetChildItem( TVI_ROOT );
	strTempPath.MakeUpper();
	strTempPath.TrimRight('\\');

	while ( hChild )
	{
		strItem = GetItemText( hChild );
		strItem.MakeUpper();
		if ( strItem == strTempPath.Mid( 0, strItem.GetLength() ) )
		{
			bFound = TRUE;
			break;
		}
		hChild = GetNextItem( hChild, TVGN_NEXT );
	}
    
	if ( !bFound )
		return FALSE;

	strTempPath += "\\nul";
	if ( find.FindFile( strTempPath ) )
		return TRUE;
     
	return FALSE;
}

void CDirTreeCtrl::OpenNext() {
	HTREEITEM hItem = GetSelectedItem();
	SelectItem(GetNextSiblingItem(hItem));	
}

void CDirTreeCtrl::OpenPrevious() {
	HTREEITEM hItem = GetSelectedItem();
	SelectItem(GetPrevSiblingItem(hItem));	
}

void CDirTreeCtrl::SetFileMask(CString s) {

	int i=0;
	s.Remove(' ');
	s.MakeLower();
	if (s.Find("*.*")!=-1 || s.IsEmpty()) {
		m_fileMask = "*.*";
	} else {

		m_fileMask = "";
		s += ";";
		s.ReleaseBuffer();
		char *token = strtok((char *)(const char *)s, ";");
		while(token!=NULL) {
			if (strlen(token)) {
				m_fileMask += CString(token)+";";
			}
			token = strtok(NULL, ";");
		}

		if (m_fileMask.Right(1)==";")
			m_fileMask = m_fileMask.Left(m_fileMask.GetLength()-1);
	}

	//JumpToDir(m_strRoot);
	SetSelPath(m_strRoot);
}


CString CDirTreeCtrl::GetSelected() {
	return GetFullPath(GetSelectedItem());
}