#include "imagedata.h"
#include <afxmt.h>


CImageData::CImageData() :
	m_semaphore(0),
	m_sauce(0),
	m_fileLength(0),
	m_filePos(0),
	m_filename(0),
	m_fileData(0),
	m_fileType(NONE),
	m_threadDone(true),
	m_animation(false),
	m_animateable(false)
{

	m_semaphore = new CSemaphore();
}


CImageData::~CImageData() {


	if (m_sauce) {
		delete m_sauce;
		m_sauce = 0;
	}
	
	if (m_filename) {
		delete [] m_filename;
		m_filename = 0;
	}

	if (m_fileData) {
		delete [] m_fileData;
		m_fileData = 0;
	}

	if (m_semaphore)
		delete m_semaphore;
}


void CImageData::copyFilename(const char *filename) {

	if (filename) {
		m_filename = new char [strlen(filename)+1];
		strcpy(m_filename, filename);
	}
}


void CImageData::loadFileAsBinary(const char *filename) {

	FILE *fp = fopen(filename, "rb");
	m_sauce = getSauce(fp);
	fseek(fp, 0, SEEK_END);
	m_fileLength = ftell(fp);

	m_fileData = new char[m_fileLength];
	fseek(fp, 0, SEEK_SET);
	fread(m_fileData, m_fileLength, 1, fp);
	fclose(fp);
}


void CImageData::loadFileAsText(const char *filename) {

	/*! \note cannot just use fseeks because of the sauce */
	//read file length
	FILE *fp = fopen(filename, "rb");
	m_sauce = getSauce(fp);
	fseek(fp, 0, SEEK_SET);
	char ch;
	while(!feof(fp)) {
		if ((ch = fgetc(fp))==0x1a) //0x1a = CTRLZ
			break;
		m_fileLength++;
	}

	//allocate memory and read entire file into memory
	//everything has to be loaded into memory so in ansimation mode you don't 
	//constantly hit the hd
	/*! \note may be off-by-one here */
	m_fileData = new char[m_fileLength];
	fseek(fp, 0, SEEK_SET);
	fread(m_fileData, m_fileLength-1, 1, fp);
	m_fileData[m_fileLength-1] = 0;
	fclose(fp);	
}

bool CImageData::getThreadDone() {
	return m_threadDone;
}

void CImageData::setThreadDone(bool b) {
	CSingleLock singleLock(m_semaphore);
	singleLock.Lock();
	m_threadDone = b;
	singleLock.Unlock();
	Sleep(1);
}