#pragma once


#include <vector>

class CAcidImage;
class CTextRenderer;
class CBinaryRenderer;
class CRipRenderer;
class CImageLoader;



class CImageFactory {

private:
	std::vector<CImageLoader *>	m_loaders;
	CTextRenderer			*m_textRenderer;
	CBinaryRenderer			*m_binaryRenderer;
	CRipRenderer			*m_ripRenderer;

	bool	m_enableRip;

public:


	CImageFactory();
	~CImageFactory();

	CAcidImage		*loadFile(const char *);
	CAcidImage		*loadFileFromData(const char *, int, const char *filename=0);
	CAcidImage		*loadFileFromResource(int);
	
	void			enableRip();

};