/**************************************************************************
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 *  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
 *  PURPOSE.
 *
 *  Copyright (C) 1992 - 1997 Microsoft Corporation.  All Rights Reserved.
 *
 **************************************************************************/
/* ApiAvi.cpp JUST CUT FROM WRITEAVI.C WINDOWS SAMPLE  M.Lievin @1999
   So don't ask me for any kind of explanation
*/


#include "avicomp.h"


namespace avicompiler {
	int g_width, g_height;
	int g_numFrames;

BOOL AVI_Init()
{
        /* first let's make sure we are running on 1.1 */
        WORD wVer = HIWORD(VideoForWindowsVersion());
        if (wVer < 0x010a){
                 /* oops, we are too old, blow out of here */
                MessageBeep(MB_ICONHAND);
                MessageBox(NULL, "Sorry, Cant't init AVI File !", "Error", MB_OK|MB_ICONSTOP);
                return FALSE;
        }

        AVIFileInit();

        return TRUE;
}

BOOL AVI_FileOpenWrite(PAVIFILE * pfile, 
                                           char *filename)
{
        HRESULT hr = AVIFileOpen(pfile,             // returned file pointer
                       filename,                            // file name
                       OF_WRITE | OF_CREATE,        // mode to open file with
                       NULL);                                           // use handler determined
                                                                                        // from file extension....
        if (hr != AVIERR_OK)
                return FALSE;

        return TRUE;
}

// Fill in the header for the video stream....
// The video stream will run in rate ths of a second....
BOOL AVI_CreateStream(PAVIFILE pfile, 
                                          PAVISTREAM * ps, 
                                          int rate,                             // sample/second
                                          unsigned long buffersize,
                                          int rectwidth,
                                          int rectheight)
{

        AVISTREAMINFO strhdr;

        _fmemset(&strhdr, 0, sizeof(strhdr));
        strhdr.fccType                = streamtypeVIDEO;// stream type
        strhdr.fccHandler             = 0;
        strhdr.dwScale                = 1;
        strhdr.dwRate                 = rate;               // rate fps
        strhdr.dwSuggestedBufferSize  = buffersize;
        SetRect(&strhdr.rcFrame, 0, 0,              // rectangle for stream
            (int) rectwidth,
            (int) rectheight);

        // And create the stream;
        HRESULT hr = AVIFileCreateStream(pfile,             // file pointer
                                 ps,                // returned stream pointer
                                 &strhdr);          // stream header
        if (hr != AVIERR_OK) {
                return FALSE;
        }

        return TRUE;
}

BOOL AVI_SetOptions(PAVISTREAM * ps,
                                        PAVISTREAM * psCompressed, 
                                        LPBITMAPINFOHEADER lpbi)
{
         
        AVICOMPRESSOPTIONS opts;
        AVICOMPRESSOPTIONS FAR * aopts[1] = {&opts};

        _fmemset(&opts, 0, sizeof(opts));

        if (!AVISaveOptions(NULL, 0, 1, ps, (LPAVICOMPRESSOPTIONS FAR *) &aopts))
            return FALSE;

        HRESULT hr = AVIMakeCompressedStream(psCompressed, *ps, &opts, NULL);
        if (hr != AVIERR_OK) {
                return FALSE;
        }

        hr = AVIStreamSetFormat(*psCompressed, 0,
                               lpbi,                    // stream format
                               lpbi->biSize             // format size
                                   + lpbi->biClrUsed * sizeof(RGBQUAD)
                                   );
        if (hr != AVIERR_OK) {
        return FALSE;
        }

        return TRUE;
}

BOOL AVI_SetText(PAVIFILE pfile, 
                                 PAVISTREAM psText,
                                 char *szText,
                                 int width,
                                 int height,
                                 int TextHeight)
{
        // Fill in the stream header for the text stream....
        AVISTREAMINFO strhdr;
        DWORD dwTextFormat;
        // The text stream is in 60ths of a second....

        _fmemset(&strhdr, 0, sizeof(strhdr));
        strhdr.fccType                = streamtypeTEXT;
        strhdr.fccHandler             = mmioFOURCC('D', 'R', 'A', 'W');
        strhdr.dwScale                = 1;
        strhdr.dwRate                 = 60;
        strhdr.dwSuggestedBufferSize  = sizeof(szText);
        SetRect(&strhdr.rcFrame, 0, (int) height,
            (int) width, (int) height + TextHeight); // #define TEXT_HEIGHT 20

        // ....and create the stream.
        HRESULT hr = AVIFileCreateStream(pfile, &psText, &strhdr);
        if (hr != AVIERR_OK) {
                return FALSE;
        }

        dwTextFormat = sizeof(dwTextFormat);
        hr = AVIStreamSetFormat(psText, 0, &dwTextFormat, sizeof(dwTextFormat));
        if (hr != AVIERR_OK) {
                return FALSE;
        }

        return TRUE;
}

BOOL AVI_AddFrame(	PAVISTREAM psCompressed,
					int time,
					LPBITMAPINFOHEADER lpbi)
{
        HRESULT hr = AVIStreamWrite(psCompressed,       // stream pointer
                time,                                                                   // time of this frame
                1,                                                                              // number to write
                (LPBYTE) lpbi +                                                 // pointer to data
                        lpbi->biSize + 
                        lpbi->biClrUsed * sizeof(RGBQUAD),
                        lpbi->biSizeImage,                                      // size of this frame
                AVIIF_KEYFRAME,                                                 // flags....
                NULL,
                NULL);
        if (hr != AVIERR_OK)
                return FALSE;
        
        return TRUE;
}

BOOL AVI_AddFramePixels(	PAVISTREAM psCompressed,
					int time,
					unsigned int *pixels)
{
        HRESULT hr = AVIStreamWrite(psCompressed,       // stream pointer
                time,                                                                   // time of this frame
                1,                                                                              // number to write
                (LPBYTE)pixels,
                avicompiler::g_width*avicompiler::g_height*4,                                      // size of this frame
                AVIIF_KEYFRAME,                                                 // flags....
                NULL,
                NULL);
        if (hr != AVIERR_OK)
                return FALSE;
        
        return TRUE;
}

BOOL AVI_AddText(PAVISTREAM psText,
                                  int time,
                                  char *szText)
{
        int iLen = strlen(szText);

        HRESULT hr = AVIStreamWrite(psText,
                        time,
                        1,
                        szText,
                        iLen + 1,
                        AVIIF_KEYFRAME,
                        NULL,
                        NULL);
        if (hr != AVIERR_OK)
                return FALSE;

        return TRUE;
}

BOOL AVI_CloseStream(PAVISTREAM ps,
                                         PAVISTREAM psCompressed,
                                         PAVISTREAM psText)
{
        if (ps)
                AVIStreamClose(ps);

        if (psCompressed)
                AVIStreamClose(psCompressed);

        if (psText)
                AVIStreamClose(psText);



        return TRUE;
}

BOOL AVI_CloseFile(PAVIFILE pfile)
{
        if (pfile)
                AVIFileClose(pfile);
        
        return TRUE;
}

BOOL AVI_Exit()
{
        AVIFileExit();

        return TRUE;
}


//////////////////////////////



LPBITMAPINFOHEADER lpbi; 
PAVIFILE pfile = NULL; 
PAVISTREAM ps = NULL, psCompressed = NULL; 


HANDLE CreateDIB(HBITMAP hBitmap)
{
	BITMAP			bm;
	BITMAPINFOHEADER	bi;
	LPBITMAPINFOHEADER 	lpbi;
	DWORD			dwLen;
	HANDLE			hDIB;
	HANDLE			handle;
	HDC 			hDC;
	DWORD dwCompression = BI_RGB;


	// If a palette has not been supplied use defaul palette
	HPALETTE hPal = (HPALETTE) GetStockObject(DEFAULT_PALETTE);

	::GetObject(hBitmap, sizeof(bm),(LPSTR)&bm);

	// Initialize the bitmapinfoheader
	bi.biSize			= sizeof(BITMAPINFOHEADER);
	bi.biWidth			= bm.bmWidth;
	bi.biHeight 		= bm.bmHeight;
	bi.biPlanes 		= 1;
	bi.biBitCount		= bm.bmPlanes * bm.bmBitsPixel;
	bi.biCompression	= dwCompression;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biYPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

	// Compute the size of the  infoheader and the color table
	int nColors = (1 << bi.biBitCount);
	if( nColors > 256 ) 
		nColors = 0;
	dwLen  = bi.biSize + nColors * sizeof(RGBQUAD);

	// We need a device context to get the DIB from
	hDC = GetDC(NULL);
	hPal = SelectPalette(hDC,hPal,FALSE);
	RealizePalette(hDC);

	// Allocate enough memory to hold bitmapinfoheader and color table
	hDIB = GlobalAlloc(GMEM_FIXED,dwLen);

	if (!hDIB){
		SelectPalette(hDC,hPal,FALSE);
		ReleaseDC(NULL,hDC);
		return NULL;
	}

	lpbi = (LPBITMAPINFOHEADER)hDIB;

	*lpbi = bi;

	// Call GetDIBits with a NULL lpBits param, so the device driver 
	// will calculate the biSizeImage field 
	/*
	GetDIBits(hDC, (HBITMAP)hBitmap, 0L, (DWORD)bi.biHeight,
			(LPBYTE)NULL, (LPBITMAPINFO)lpbi, (DWORD)DIB_RGB_COLORS);
//*/
	bi = *lpbi;

	// If the driver did not fill in the biSizeImage field, then compute it
	// Each scan line of the image is aligned on a DWORD (32bit) boundary
	if (bi.biSizeImage == 0){
		bi.biSizeImage = ((((bi.biWidth * bi.biBitCount) + 31) & ~31) / 8) 
						* bi.biHeight;

		// If a compression scheme is used the result may infact be larger
		// Increase the size to account for this.
		if (dwCompression != BI_RGB)
			bi.biSizeImage = (bi.biSizeImage * 3) / 2;
	}

	// Realloc the buffer so that it can hold all the bits
	dwLen += bi.biSizeImage;
	if (handle = GlobalReAlloc(hDIB, dwLen, GMEM_MOVEABLE))
		hDIB = handle;
	else{
		GlobalFree(hDIB);

		// Reselect the original palette
		SelectPalette(hDC,hPal,FALSE);
		ReleaseDC(NULL,hDC);
		return NULL;
	}

	// Get the bitmap bits
	lpbi = (LPBITMAPINFOHEADER)hDIB;

	// FINALLY get the DIB
	/*
	int bGotBits = SetDIBits( hDC, 
				(HBITMAP)hBitmap,
				0L,				// Start scan line
				moeGetPlaneHeight(),		// # of scan lines
										//NOTE: pretty sure that this is supposed to be 
										// the height
				pixels,
				(LPBITMAPINFO)lpbi,		// address of bitmapinfo
				(DWORD)DIB_RGB_COLORS);		// Use RGB for color table

	if( !bGotBits )
	{
		GlobalFree(hDIB);
		
		SelectPalette(hDC,hPal,FALSE);
		ReleaseDC(NULL,hDC);
		return NULL;
	}
	//*/
	

	SelectPalette(hDC,hPal,FALSE);
	ReleaseDC(NULL,hDC);
	return hDIB;
}


void startAVI(char *filename, int frameRate, int w, int h) {
	
	avicompiler::g_width  = w;
	avicompiler::g_height = h;
	avicompiler::g_numFrames = 0;

    AVI_Init(); 
    AVI_FileOpenWrite(&pfile, filename); 

	HBITMAP b = CreateCompatibleBitmap(::GetDC(NULL), w, h);
	HANDLE hdib = CreateDIB(b);


	LPBITMAPINFOHEADER lpbi = (LPBITMAPINFOHEADER)GlobalLock(hdib); 
	
	AVI_CreateStream(pfile, &ps, frameRate, 
		(unsigned long) lpbi->biSizeImage, 
		(int) lpbi->biWidth, 
		(int) lpbi->biHeight); 
	
	AVI_SetOptions(&ps, &psCompressed, lpbi); 
	GlobalUnlock(lpbi); 
}

void addFrame(unsigned int *pixels) {

	AVI_AddFramePixels(psCompressed, g_numFrames++, pixels); 
}

void endAVI() {

	AVI_CloseStream(ps, psCompressed, NULL); 
	AVI_CloseFile(pfile); 
	AVI_Exit(); 
}

}