%macro cominvoke 2-* 
    %rep %0 - 2     ; repeat for each argument
        %rotate -1
        push %1
    %endrep
    %rotate -1
    mov edi, dword [%1]
    push dword edi
    mov edi,dword  [edi]
    %rotate -1
    call [edi+ %1 ]
%endm

%macro cominvoke2 2-* 
    %rep %0 - 2     ; repeat for each argument
        %rotate -1
        push %1
    %endrep
    %rotate -1
    mov edi, dword [%1]
    push dword %1
    %rotate -1
    call [edi+ %1 ]
%endm

;Variablen
D3D_SDK_VERSION                                 EQU  220

D3DCREATE_FPU_PRESERVE                          EQU     00000002h
D3DCREATE_MULTITHREADED                         EQU     00000004h
D3DCREATE_PUREDEVICE                            EQU     00000010h
D3DCREATE_SOFTWARE_VERTEXPROCESSING             EQU     00000020h
D3DCREATE_HARDWARE_VERTEXPROCESSING             EQU     00000040h
D3DCREATE_MIXED_VERTEXPROCESSING                EQU     00000080h
D3DCREATE_DISABLE_DRIVER_MANAGEMENT             EQU     00000100h

D3DTEXF_NONE                                    EQU     0       ; filtering disabled (valid for mip filter only)
D3DTEXF_POINT                                   EQU     1        ; nearest
D3DTEXF_LINEAR                                  EQU     2        ; linear interpolation
D3DTEXF_ANISOTROPIC                             EQU     3        ; anisotropic
D3DTEXF_FLATCUBIC                               EQU     4        ; cubic
D3DTEXF_GAUSSIANCUBIC                           EQU     5        ; different cubic kernel


D3DTTFF_DISABLE                                 EQU     0        ; texture coordinates are passed directly
D3DTTFF_COUNT1                                  EQU     1        ; rasterizer should expect 1-D texture coords
D3DTTFF_COUNT2                                  EQU     2        ; rasterizer should expect 2-D texture coords
D3DTTFF_COUNT3                                  EQU     3        ; rasterizer should expect 3-D texture coords
D3DTTFF_COUNT4                                  EQU     4        ; rasterizer should expect 4-D texture coords

D3DSTENCILOP_KEEP                               EQU     1
D3DSTENCILOP_ZERO                               EQU     2
D3DSTENCILOP_REPLACE                            EQU     3
D3DSTENCILOP_INCRSAT                            EQU     4
D3DSTENCILOP_DECRSAT                            EQU     5
D3DSTENCILOP_INVERT                             EQU     6
D3DSTENCILOP_INCR                               EQU     7
D3DSTENCILOP_DECR                               EQU     8

D3DVBF_DISABLE                                  EQU     0        ; Disable vertex blending
D3DVBF_1WEIGHTS                                 EQU     1        ; 2 matrix blending
D3DVBF_2WEIGHTS                                 EQU     2        ; 3 matrix blending
D3DVBF_3WEIGHTS                                 EQU     3        ; 4 matrix blending
D3DVBF_TWEENING                                 EQU     255        ; blending using D3DRS_TWEENFACTOR
D3DVBF_0WEIGHTS                                 EQU     256        ; one matrix is used with weight 1.0


D3DTSS_TCI_PASSTHRU                             EQU     00000000h
D3DTSS_TCI_CAMERASPACENORMAL                    EQU     00010000h
D3DTSS_TCI_CAMERASPACEPOSITION                  EQU     00020000h
D3DTSS_TCI_CAMERASPACEREFLECTIONVECTOR          EQU     00030000h

; Usages */
D3DUSAGE_RENDERTARGET                           EQU     00000001h
D3DUSAGE_DEPTHSTENCIL                           EQU     00000002h

; Usages for Vertex/Index buffers */
D3DUSAGE_WRITEONLY                              EQU     00000008h
D3DUSAGE_SOFTWAREPROCESSING                     EQU     00000010h
D3DUSAGE_DONOTCLIP                              EQU     00000020h
D3DUSAGE_POINTS                                 EQU     00000040h
D3DUSAGE_RTPATCHES                              EQU     00000080h
D3DUSAGE_NPATCHES                               EQU     00000100h
D3DUSAGE_DYNAMIC                                EQU     00000200h

D3DBLEND_ZERO                                   EQU     1
D3DBLEND_ONE                                    EQU     2
D3DBLEND_SRCCOLOR                               EQU     3
D3DBLEND_INVSRCCOLOR                            EQU     4
D3DBLEND_SRCALPHA                               EQU     5
D3DBLEND_INVSRCALPHA                            EQU     6
D3DBLEND_DESTALPHA                              EQU     7
D3DBLEND_INVDESTALPHA                           EQU     8
D3DBLEND_DESTCOLOR                              EQU     9
D3DBLEND_INVDESTCOLOR                           EQU     10
D3DBLEND_SRCALPHASAT                            EQU     11
D3DBLEND_BOTHSRCALPHA                           EQU     12
D3DBLEND_BOTHINVSRCALPHA                        EQU     13


D3DPOOL_DEFAULT                                 EQU     0
D3DPOOL_MANAGED                                 EQU     1
D3DPOOL_SYSTEMMEM                               EQU     2
D3DPOOL_SCRATCH                                 EQU     3

D3DBLENDOP_ADD                                  EQU     1
D3DBLENDOP_SUBTRACT                             EQU     2
D3DBLENDOP_REVSUBTRACT                          EQU     3
D3DBLENDOP_MIN                                  EQU     4
D3DBLENDOP_MAX                                  EQU     5



D3DSHADE_FLAT                                   EQU     1
D3DSHADE_GOURAUD                                EQU     2
D3DSHADE_PHONG                                  EQU     3


D3DCULL_NONE                                    EQU     1
D3DCULL_CW                                      EQU     2
D3DCULL_CCW                                     EQU     3


D3DZB_FALSE                                     EQU     0
D3DZB_TRUE                                      EQU     1
D3DZB_USEW                                      EQU     2 ;W buffering

D3DCMP_NEVER                                    EQU     1
D3DCMP_LESS                                     EQU     2
D3DCMP_EQUAL                                    EQU     3
D3DCMP_LESSEQUAL                                EQU     4
D3DCMP_GREATER                                  EQU     5
D3DCMP_NOTEQUAL                                 EQU     6
D3DCMP_GREATEREQUAL                             EQU     7
D3DCMP_ALWAYS                                   EQU     8

D3DLOCK_READONLY                                EQU     10h
D3DLOCK_DISCARD                                 EQU     2000h
D3DLOCK_NOOVERWRITE                             EQU     1000h
D3DLOCK_NOSYSLOCK                               EQU     800h

D3DLOCK_NO_DIRTY_UPDATE                         EQU     00008000h

D3DPT_POINTLIST                                 EQU     1
D3DPT_LINELIST                                  EQU     2
D3DPT_LINESTRIP                                 EQU     3
D3DPT_TRIANGLELIST                              EQU     4
D3DPT_TRIANGLESTRIP                             EQU     5
D3DPT_TRIANGLEFAN                               EQU     6


D3DTS_VIEW                                      EQU     2
D3DTS_PROJECTION                                EQU     3
D3DTS_TEXTURE0                                  EQU     16
D3DTS_TEXTURE1                                  EQU     17
D3DTS_TEXTURE2                                  EQU     18
D3DTS_TEXTURE3                                  EQU     19
D3DTS_TEXTURE4                                  EQU     20
D3DTS_TEXTURE5                                  EQU     21
D3DTS_TEXTURE6                                  EQU     22
D3DTS_TEXTURE7                                  EQU     23
D3DTS_WORLD										EQU     256


D3DMCS_MATERIAL                                 EQU     0        ; Color from material is used
D3DMCS_COLOR1                                   EQU     1        ; Diffuse vertex color is used
D3DMCS_COLOR2                                   EQU     2        ; Specular vertex color is used

D3DSBT_ALL                                      EQU     1        ;capture all state
D3DSBT_PIXELSTATE                               EQU     2        ;capture pixel state
D3DSBT_VERTEXSTATE                              EQU     3        ;capture vertex state

D3DFILL_POINT                                   EQU     1
D3DFILL_WIREFRAME                               EQU     2
D3DFILL_SOLID                                   EQU     3

D3DFOG_NONE                                     EQU     0
D3DFOG_EXP                                      EQU     1
D3DFOG_EXP2                                     EQU     2
D3DFOG_LINEAR                                   EQU     3

D3DFMT_UNKNOWN                                  EQU     0
D3DFMT_R8G8B8                                   EQU     20
D3DFMT_A8R8G8B8                                 EQU     21
D3DFMT_X8R8G8B8                                 EQU     22
D3DFMT_R5G6B5                                   EQU     23
D3DFMT_X1R5G5B5                                 EQU     24
D3DFMT_A1R5G5B5                                 EQU     25
D3DFMT_A4R4G4B4                                 EQU     26
D3DFMT_R3G3B2                                   EQU     27
D3DFMT_A8                                       EQU     28
D3DFMT_A8R3G3B2                                 EQU     29
D3DFMT_X4R4G4B4                                 EQU     30
D3DFMT_A2B10G10R10                              EQU     31
D3DFMT_G16R16                                   EQU     34

D3DFMT_A8P8                                     EQU     40
D3DFMT_P8                                       EQU     41

D3DFMT_L8                                       EQU     50
D3DFMT_A8L8                                     EQU     51
D3DFMT_A4L4                                     EQU     52

D3DFMT_V8U8                                     EQU     60
D3DFMT_L6V5U5                                   EQU     61
D3DFMT_X8L8V8U8                                 EQU     62
D3DFMT_Q8W8V8U8                                 EQU     63
D3DFMT_V16U16                                   EQU     64
D3DFMT_W11V11U10                                EQU     65
D3DFMT_A2W10V10U10                              EQU     67

D3DFMT_D16_LOCKABLE                             EQU     70
D3DFMT_D32                                      EQU     71
D3DFMT_D15S1                                    EQU     73
D3DFMT_D24S8                                    EQU     75
D3DFMT_D16                                      EQU     80
D3DFMT_D24X8                                    EQU     77
D3DFMT_D24X4S4                                  EQU     79


D3DFMT_VERTEXDATA                               EQU     100
D3DFMT_INDEX16                                  EQU     101
D3DFMT_INDEX32                                  EQU     102

D3DLIGHT_POINT                                  EQU     1
D3DLIGHT_SPOT                                   EQU     2
D3DLIGHT_DIRECTIONAL                            EQU     3

D3DFVF_RESERVED0                                EQU     0x001
D3DFVF_POSITION_MASK                            EQU     0x00E
D3DFVF_XYZ                                      EQU     0x002
D3DFVF_XYZRHW                                   EQU     0x004
D3DFVF_XYZB1                                    EQU     0x006
D3DFVF_XYZB2                                    EQU     0x008
D3DFVF_XYZB3                                    EQU     0x00a
D3DFVF_XYZB4                                    EQU     0x00c
D3DFVF_XYZB5                                    EQU     0x00e

D3DFVF_NORMAL                                   EQU     0x010
D3DFVF_PSIZE                                    EQU     0x020
D3DFVF_DIFFUSE                                  EQU     0x040
D3DFVF_SPECULAR                                 EQU     0x080

D3DFVF_TEXCOUNT_MASK                            EQU     0xf00
D3DFVF_TEXCOUNT_SHIFT                           EQU     8
D3DFVF_TEX0                                     EQU     0x000
D3DFVF_TEX1                                     EQU     0x100
D3DFVF_TEX2                                     EQU     0x200
D3DFVF_TEX3                                     EQU     0x300
D3DFVF_TEX4                                     EQU     0x400
D3DFVF_TEX5                                     EQU     0x500
D3DFVF_TEX6                                     EQU     0x600
D3DFVF_TEX7                                     EQU     0x700
D3DFVF_TEX8                                     EQU     0x800


D3DRTYPE_SURFACE                                EQU     1
D3DRTYPE_VOLUME                                 EQU     2
D3DRTYPE_TEXTURE                                EQU     3
D3DRTYPE_VOLUMETEXTURE                          EQU     4
D3DRTYPE_CUBETEXTURE                            EQU     5
D3DRTYPE_VERTEXBUFFER                           EQU     6
D3DRTYPE_INDEXBUFFER                            EQU     7

D3DSWAPEFFECT_DISCARD                           EQU     1
D3DSWAPEFFECT_FLIP                              EQU     2
D3DSWAPEFFECT_COPY                              EQU     3
D3DSWAPEFFECT_COPY_VSYNC                        EQU     4

D3DTA_SELECTMASK                                EQU     0000000fh        ; mask for arg selector
D3DTA_DIFFUSE                                   EQU     00000000h        ; select diffuse color (read only)
D3DTA_CURRENT                                   EQU     00000001h        ; select stage destination register (read/write)
D3DTA_TEXTURE                                   EQU     00000002h        ; select texture color (read only)
D3DTA_TFACTOR                                   EQU     00000003h        ; select D3DRS_TEXTUREFACTOR (read only)
D3DTA_SPECULAR                                  EQU     00000004h        ; select specular color (read only)
D3DTA_TEMP                                      EQU     00000005h        ; select temporary register color (read/write)
D3DTA_COMPLEMENT                                EQU     00000010h        ; take 1.0 - x (read modifier)
D3DTA_ALPHAREPLICATE                            EQU     00000020h        ; replicate alpha to color components (read modifier)

D3DTADDRESS_WRAP                                EQU     1
D3DTADDRESS_MIRROR                              EQU     2
D3DTADDRESS_CLAMP                               EQU     3
D3DTADDRESS_BORDER                              EQU     4
D3DTADDRESS_MIRRORONCE                          EQU     5

D3DTSS_COLOROP                                  EQU     1  ; D3DTEXTUREOP - per-stage blending controls for color channels */
D3DTSS_COLORARG1                                EQU     2  ; D3DTA_* (texture arg) */
D3DTSS_COLORARG2                                EQU     3  ; D3DTA_* (texture arg) */
D3DTSS_ALPHAOP                                  EQU     4  ; D3DTEXTUREOP - per-stage blending controls for alpha channel */
D3DTSS_ALPHAARG1                                EQU     5  ; D3DTA_* (texture arg) */
D3DTSS_ALPHAARG2                                EQU     6  ; D3DTA_* (texture arg) */
D3DTSS_BUMPENVMAT00                             EQU     7  ; float (bump mapping matrix) */
D3DTSS_BUMPENVMAT01                             EQU     8  ; float (bump mapping matrix) */
D3DTSS_BUMPENVMAT10                             EQU     9  ; float (bump mapping matrix) */
D3DTSS_BUMPENVMAT11                             EQU     10 ;float (bump mapping matrix) */
D3DTSS_TEXCOORDINDEX                            EQU     11 ; identifies which set of texture coordinates index this texture */
D3DTSS_ADDRESSU                                 EQU     13 ; D3DTEXTUREADDRESS for U coordinate */
D3DTSS_ADDRESSV                                 EQU     14 ; D3DTEXTUREADDRESS for V coordinate */
D3DTSS_BORDERCOLOR                              EQU     15 ; D3DCOLOR */
D3DTSS_MAGFILTER                                EQU     16 ; D3DTEXTUREFILTER filter to use for magnification */
D3DTSS_MINFILTER                                EQU     17 ; D3DTEXTUREFILTER filter to use for minification */
D3DTSS_MIPFILTER                                EQU     18 ; D3DTEXTUREFILTER filter to use between mipmaps during minification */
D3DTSS_MIPMAPLODBIAS                            EQU     19 ; float Mipmap LOD bias */
D3DTSS_MAXMIPLEVEL                              EQU     20 ; DWORD 0..(n-1) LOD index of largest map to use (0 == largest) */
D3DTSS_MAXANISOTROPY                            EQU     21 ; DWORD maximum anisotropy */
D3DTSS_BUMPENVLSCALE                            EQU     22 ; float scale for bump map luminance */
D3DTSS_BUMPENVLOFFSET                           EQU     23 ; float offset for bump map luminance */
D3DTSS_TEXTURETRANSFORMFLAGS                    EQU     24 ; D3DTEXTURETRANSFORMFLAGS controls texture transform */
D3DTSS_ADDRESSW                                 EQU     25 ; D3DTEXTUREADDRESS for W coordinate */
D3DTSS_COLORARG0                                EQU     26 ; D3DTA_* third arg for triadic ops */
D3DTSS_ALPHAARG0                                EQU     27 ; D3DTA_* third arg for triadic ops */
D3DTSS_RESULTARG                                EQU     28 ; D3DTA_* arg for result (CURRENT or TEMP) */


; Control
D3DTOP_DISABLE                                  EQU     1        ; disables stage
D3DTOP_SELECTARG1                               EQU     2        ; the default
D3DTOP_SELECTARG2                               EQU     3
; Modulate
D3DTOP_MODULATE                                 EQU     4        ; multiply args together
D3DTOP_MODULATE2X                               EQU     5        ; multiply and  1 bit
D3DTOP_MODULATE4X                               EQU     6        ; multiply and  2 bits
; Add
D3DTOP_ADD                                      EQU     7           ; add arguments together
D3DTOP_ADDSIGNED                                EQU     8           ; add with -0.5 bias
D3DTOP_ADDSIGNED2X                              EQU     9           ; as above but left  1 bit
D3DTOP_SUBTRACT                                 EQU     10           ; Arg1 - Arg2, with no saturation
D3DTOP_ADDSMOOTH                                EQU     11           ; add 2 args, subtract product
                                                                ; Arg1 + Arg2 - Arg1*Arg2
                                                                ; = Arg1 + (1-Arg1)*Arg2
; Linear alpha blend: Arg1*(Alpha) + Arg2*(1-Alpha)
D3DTOP_BLENDDIFFUSEALPHA                        EQU     12        ; iterated alpha
D3DTOP_BLENDTEXTUREALPHA                        EQU     13        ; texture alpha
D3DTOP_BLENDFACTORALPHA                         EQU     14        ; alpha from D3DRS_TEXTUREFACTOR
; Linear alpha blend with pre-multiplied arg1 input: Arg1 + Arg2*(1-Alpha)
D3DTOP_BLENDTEXTUREALPHAPM                      EQU     15,        ; texture alpha
D3DTOP_BLENDCURRENTALPHA                        EQU     16        ; by alpha of current color
; Specular mapping
D3DTOP_PREMODULATE                              EQU     17        ; modulate with next texture before use
D3DTOP_MODULATEALPHA_ADDCOLOR                   EQU     18        ; Arg1.RGB + Arg1.A*Arg2.RGB
                                                                    ; COLOROP only
D3DTOP_MODULATECOLOR_ADDALPHA                   EQU     19        ; Arg1.RGB*Arg2.RGB + Arg1.A
                                                                    ; COLOROP only
D3DTOP_MODULATEINVALPHA_ADDCOLOR                EQU     20        ; (1-Arg1.A)*Arg2.RGB + Arg1.RGB
                                                                    ; COLOROP only
D3DTOP_MODULATEINVCOLOR_ADDALPHA                EQU     21        ; (1-Arg1.RGB)*Arg2.RGB + Arg1.A
                                                                    ; COLOROP only
; Bump mapping
D3DTOP_BUMPENVMAP                               EQU     22        ; per pixel env map perturbation
D3DTOP_BUMPENVMAPLUMINANCE                      EQU     23        ; with luminance channel
; This can do either diffuse or specular bump mapping with correct input.
; Performs the function (Arg1.R*Arg2.R + Arg1.G*Arg2.G + Arg1.B*Arg2.B)
; where each component has been scaled and offset to make it signed.
; The result is replicated into all four (including alpha) channels.
; This is a valid COLOROP only.
D3DTOP_DOTPRODUCT3                              EQU     24
; Triadic ops
D3DTOP_MULTIPLYADD                              EQU     25        ; Arg0 + Arg1*Arg2
D3DTOP_LERP                                     EQU     26        ; (Arg0)*Arg1 + (1-Arg0)*Arg2


;Renderstates

D3DRS_ZENABLE                                   EQU     7    ;D3DZBUFFERTYPE (or TRUE/FALSE for legacy
D3DRS_FILLMODE                                  EQU     8    ; D3DFILLMODE */
D3DRS_SHADEMODE                                 EQU     9,   ; D3DSHADEMODE */
D3DRS_LINEPATTERN                               EQU     10   ; D3DLINEPATTERN */
D3DRS_ZWRITEENABLE                              EQU     14   ; TRUE to enable z writes */
D3DRS_ALPHATESTENABLE                           EQU     15   ; TRUE to enable alpha tests */
D3DRS_LASTPIXEL                                 EQU     16   ; TRUE for last-pixel on lines */
D3DRS_SRCBLEND                                  EQU     19   ; D3DBLEND */
D3DRS_DESTBLEND                                 EQU     20   ; D3DBLEND */
D3DRS_CULLMODE                                  EQU     22   ; D3DCULL */
D3DRS_ZFUNC                                     EQU     23   ; D3DCMPFUNC */
D3DRS_ALPHAREF                                  EQU     24   ; D3DFIXED */
D3DRS_ALPHAFUNC                                 EQU     25   ; D3DCMPFUNC */
D3DRS_DITHERENABLE                              EQU     26   ; TRUE to enable dithering */
D3DRS_ALPHABLENDENABLE                          EQU     27   ; TRUE to enable alpha blending */
D3DRS_FOGENABLE                                 EQU     28   ; TRUE to enable fog blending */
D3DRS_SPECULARENABLE                            EQU     29   ; TRUE to enable specular */
D3DRS_ZVISIBLE                                  EQU     30   ; TRUE to enable z checking */
D3DRS_FOGCOLOR                                  EQU     34   ; D3DCOLOR */
D3DRS_FOGTABLEMODE                              EQU     35   ; D3DFOGMODE */
D3DRS_FOGSTART                                  EQU     36   ; Fog start (for both vertex and pixel fog) */
D3DRS_FOGEND                                    EQU     37   ; Fog end      */
D3DRS_FOGDENSITY                                EQU     38   ; Fog density  */
D3DRS_EDGEANTIALIAS                             EQU     40   ; TRUE to enable edge antialiasing */
D3DRS_ZBIAS                                     EQU     47   ; LONG Z bias */
D3DRS_RANGEFOGENABLE                            EQU     48   ; Enables range-based fog */
D3DRS_STENCILENABLE                             EQU     52   ; BOOL enable/disable stenciling */
D3DRS_STENCILFAIL                               EQU     53   ; D3DSTENCILOP to do if stencil test fails */
D3DRS_STENCILZFAIL                              EQU     54   ; D3DSTENCILOP to do if stencil test passes and Z test fails */
D3DRS_STENCILPASS                               EQU     55   ; D3DSTENCILOP to do if both stencil and Z tests pass */
D3DRS_STENCILFUNC                               EQU     56   ; D3DCMPFUNC fn.  Stencil Test passes if ((ref & mask) stencilfn (stencil & mask)) is true */
D3DRS_STENCILREF                                EQU     57   ; Reference value used in stencil test */
D3DRS_STENCILMASK                               EQU     58   ; Mask value used in stencil test */
D3DRS_STENCILWRITEMASK                          EQU     59   ; Write mask applied to values written to stencil buffer */
D3DRS_TEXTUREFACTOR                             EQU     60   ; D3DCOLOR used for multi-texture blend */
D3DRS_WRAP0                                     EQU     128  ; wrap for 1st texture coord. set */
D3DRS_WRAP1                                     EQU     129  ; wrap for 2nd texture coord. set */
D3DRS_WRAP2                                     EQU     130  ; wrap for 3rd texture coord. set */
D3DRS_WRAP3                                     EQU     131  ; wrap for 4th texture coord. set */
D3DRS_WRAP4                                     EQU     132  ; wrap for 5th texture coord. set */
D3DRS_WRAP5                                     EQU     133  ; wrap for 6th texture coord. set */
D3DRS_WRAP6                                     EQU     134  ; wrap for 7th texture coord. set */
D3DRS_WRAP7                                     EQU     135  ; wrap for 8th texture coord. set */
D3DRS_CLIPPING                                  EQU     136
D3DRS_LIGHTING                                  EQU     137
D3DRS_AMBIENT                                   EQU     139
D3DRS_FOGVERTEXMODE                             EQU     140
D3DRS_COLORVERTEX                               EQU     141
D3DRS_LOCALVIEWER                               EQU     142
D3DRS_NORMALIZENORMALS                          EQU     143
D3DRS_DIFFUSEMATERIALSOURCE                     EQU     145
D3DRS_SPECULARMATERIALSOURCE                    EQU     146
D3DRS_AMBIENTMATERIALSOURCE                     EQU     147
D3DRS_EMISSIVEMATERIALSOURCE                    EQU     148
D3DRS_VERTEXBLEND                               EQU     151
D3DRS_CLIPPLANEENABLE                           EQU     152
D3DRS_SOFTWAREVERTEXPROCESSING                  EQU     153
D3DRS_POINTSIZE                                 EQU     154   ; float point size */
D3DRS_POINTSIZE_MIN                             EQU     155   ; float point size min threshold */
D3DRS_POINTSPRITEENABLE                         EQU     156   ; BOOL point texture coord control */
D3DRS_POINTSCALEENABLE                          EQU     157   ; BOOL point size scale enable */
D3DRS_POINTSCALE_A                              EQU     158   ; float point attenuation A value */
D3DRS_POINTSCALE_B                              EQU     159   ; float point attenuation B value */
D3DRS_POINTSCALE_C                              EQU     160   ; float point attenuation C value */
D3DRS_MULTISAMPLEANTIALIAS                      EQU     161   ; BOOL - set to do FSAA with multisample buffer
D3DRS_MULTISAMPLEMASK                           EQU     162   ; DWORD - per-sample enable/disable
D3DRS_PATCHEDGESTYLE                            EQU     163   ; Sets whether patch edges will use float style tessellation
D3DRS_PATCHSEGMENTS                             EQU     164   ;// Number of segments per edge when drawing patches
D3DRS_DEBUGMONITORTOKEN                         EQU     165   ; DEBUG ONLY - token to debug monitor
D3DRS_POINTSIZE_MAX                             EQU     166   ; float point size max threshold */
D3DRS_INDEXEDVERTEXBLENDENABLE                  EQU     167
D3DRS_COLORWRITEENABLE                          EQU     168   ; per-channel write enable
D3DRS_TWEENFACTOR                               EQU     170   ; float tween factor
D3DRS_BLENDOP                                   EQU     171   ; D3DBLENDOP setting
D3DRS_POSITIONORDER                             EQU     172   ; NPatch position interpolation order. D3DORDER_LINEAR or D3DORDER_CUBIC (default)
D3DRS_NORMALORDER                               EQU     173   ; NPatch normal interpolation order. D3DORDER_LINEAR (default) or D3DORDER_QUADRATIC


STRUC D3DPRESENT_PARAMETERS
    .BackBufferWidth:			resd	1
    .BackBufferHeight:			resd	1
    .BackBufferFormat:			resd	1
    .BackBufferCount:			resd	1

    .MultiSampleType:			resd	1

    .SwapEffect:			resd	1
    .hDeviceWindow:			resd	1
    .Windowed:				resd	1
    .EnableAutoDepthStencil:		resd	1
    .AutoDepthStencilFormat:		resd	1
    .Flags:				resd	1
    .FullScreen_RefreshRateInHz:	resd	1
    .FullScreen_PresentationInterval:	resd	1

ENDSTRUC


;IDirect3D8

IDirect3D8_QueryInterface                       EQU     0
IDirect3D8_AddRe                                EQU     4
IDirect3D8_Release                              EQU     8
IDirect3D8_RegisterSoftwareDevice               EQU     12
IDirect3D8_GetAdapterCount                      EQU     16
IDirect3D8_GetAdapterIdentifier                 EQU     20
IDirect3D8_GetAdapterModeCount                  EQU     24
IDirect3D8_EnumAdapterModes                     EQU     28
IDirect3D8_GetAdapterDisplayMode                EQU     32
IDirect3D8_CheckDeviceType                      EQU     36
IDirect3D8_CheckDeviceFormat                    EQU     40
IDirect3D8_CheckDeviceMultiSampleType           EQU     44
IDirect3D8_CheckDepthStencilMatch               EQU     48
IDirect3D8_GetDeviceCaps                        EQU     52
IDirect3D8_GetAdapterMonitor                    EQU     56
IDirect3D8_CreateDevice                         EQU     60


;IDirect3DDevice8 Com
IDirect3DDevice8_QueryInterface                 EQU     0
IDirect3DDevice8_AddRef                         EQU     4
IDirect3DDevice8_Release                        EQU     8
IDirect3DDevice8_TestCooperativeLevel           EQU     12
IDirect3DDevice8_GetAvailableTextureMem         EQU     16
IDirect3DDevice8_ResourceManagerDiscardBytes    EQU     20
IDirect3DDevice8_GetDirect3D                    EQU     24
IDirect3DDevice8_GetDeviceCaps                  EQU     28
IDirect3DDevice8_GetDisplayMode                 EQU     32
IDirect3DDevice8_GetCreationParameters          EQU     36
IDirect3DDevice8_SetCursorProperties            EQU     40
IDirect3DDevice8_SetCursorPosition              EQU     44
IDirect3DDevice8_ShowCursor                     EQU     48
IDirect3DDevice8_CreateAdditionalSwapChain      EQU     52
IDirect3DDevice8_Reset                          EQU     56
IDirect3DDevice8_Present                        EQU     60
IDirect3DDevice8_GetBackBuffer                  EQU     64
IDirect3DDevice8_GetRasterStatus                EQU     68
IDirect3DDevice8_SetGammaRamp                   EQU     72
IDirect3DDevice8_GetGammaRamp                   EQU     76
IDirect3DDevice8_CreateTexture                  EQU     80
IDirect3DDevice8_CreateVolumeTexture            EQU     84
IDirect3DDevice8_CreateCubeTexture              EQU     88
IDirect3DDevice8_CreateVertexBuffer             EQU     92
IDirect3DDevice8_CreateIndexBuffer              EQU     96
IDirect3DDevice8_CreateRenderTarget             EQU     100
IDirect3DDevice8_CreateDepthStencilSurface      EQU     104
IDirect3DDevice8_CreateImageSurface             EQU     108
IDirect3DDevice8_CopyRects                      EQU     112
IDirect3DDevice8_UpdateTexture                  EQU     116
IDirect3DDevice8_GetFrontBuffer                 EQU     120
IDirect3DDevice8_SetRenderTarget                EQU     124
IDirect3DDevice8_GetRenderTarget                EQU     128
IDirect3DDevice8_GetDepthStencilSurface         EQU     132
IDirect3DDevice8_BeginScene                     EQU     136
IDirect3DDevice8_EndScene                       EQU     140
IDirect3DDevice8_Clear                          EQU     144
IDirect3DDevice8_SetTransform                   EQU     148
IDirect3DDevice8_GetTransform                   EQU     152
IDirect3DDevice8_MultiplyTransform              EQU     156
IDirect3DDevice8_SetViewport                    EQU     160
IDirect3DDevice8_GetViewport                    EQU     164
IDirect3DDevice8_SetMaterial                    EQU     168
IDirect3DDevice8_GetMaterial                    EQU     172
IDirect3DDevice8_SetLight                       EQU     176
IDirect3DDevice8_GetLight                       EQU     180
IDirect3DDevice8_LightEnable                    EQU     184
IDirect3DDevice8_GetLightEnable                 EQU     188
IDirect3DDevice8_SetClipPlane                   EQU     192
IDirect3DDevice8_GetClipPlane                   EQU     196
IDirect3DDevice8_SetRenderState                 EQU     200
IDirect3DDevice8_GetRenderState                 EQU     204
IDirect3DDevice8_BeginStateBlock                EQU     208
IDirect3DDevice8_EndStateBlock                  EQU     212
IDirect3DDevice8_ApplyStateBlock                EQU     216
IDirect3DDevice8_CaptureStateBlock              EQU     220
IDirect3DDevice8_DeleteStateBlock               EQU     224
IDirect3DDevice8_CreateStateBlock               EQU     228
IDirect3DDevice8_SetClipStatus                  EQU     232
IDirect3DDevice8_GetClipStatus                  EQU     236
IDirect3DDevice8_GetTexture                     EQU     240
IDirect3DDevice8_SetTexture                     EQU     244
IDirect3DDevice8_GetTextureStageState           EQU     248
IDirect3DDevice8_SetTextureStageState           EQU     252
IDirect3DDevice8_ValidateDevice                 EQU     256
IDirect3DDevice8_GetInfo                        EQU     260
IDirect3DDevice8_SetPaletteEntries              EQU     264
IDirect3DDevice8_GetPaletteEntries              EQU     268
IDirect3DDevice8_SetCurrentTexturePalette       EQU     272
IDirect3DDevice8_GetCurrentTexturePalette       EQU     276
IDirect3DDevice8_DrawPrimitive                  EQU     280
IDirect3DDevice8_DrawIndexedPrimitive           EQU     284
IDirect3DDevice8_DrawPrimitiveUP                EQU     288
IDirect3DDevice8_DrawIndexedPrimitiveUP         EQU     292
IDirect3DDevice8_ProcessVertices                EQU     296
IDirect3DDevice8_CreateVertexShader             EQU     300
IDirect3DDevice8_SetVertexShader                EQU     304
IDirect3DDevice8_GetVertexShader                EQU     308
IDirect3DDevice8_DeleteVertexShader             EQU     312
IDirect3DDevice8_SetVertexShaderConstant        EQU     316
IDirect3DDevice8_GetVertexShaderConstant        EQU     320
IDirect3DDevice8_GetVertexShaderDeclaration     EQU     324
IDirect3DDevice8_GetVertexShaderFunction        EQU     328
IDirect3DDevice8_SetStreamSource                EQU     332
IDirect3DDevice8_GetStreamSource                EQU     336
IDirect3DDevice8_SetIndices                     EQU     340
IDirect3DDevice8_GetIndices                     EQU     344
IDirect3DDevice8_CreatePixelShader              EQU     348
IDirect3DDevice8_SetPixelShader                 EQU     352
IDirect3DDevice8_GetPixelShader                 EQU     356
IDirect3DDevice8_DeletePixelShader              EQU     360
IDirect3DDevice8_SetPixelShaderConstant         EQU     364
IDirect3DDevice8_GetPixelShaderConstant         EQU     368
IDirect3DDevice8_GetPixelShaderFunction         EQU     372
IDirect3DDevice8_DrawRectPatch                  EQU     376
IDirect3DDevice8_DrawTriPatch                   EQU     380
IDirect3DDevice8_DeletePatch                    EQU     384


;IDirect3DTexture8
IDirect3DTexture8_QueryInterface                EQU     0
IDirect3DTexture8_AddRef                        EQU     4
IDirect3DTexture8_Release                       EQU     8
IDirect3DTexture8_GetDevice                     EQU     12
IDirect3DTexture8_SetPrivateData                EQU     16
IDirect3DTexture8_GetPrivateData                EQU     20
IDirect3DTexture8_FreePrivateData               EQU     24
IDirect3DTexture8_SetPriority                   EQU     28
IDirect3DTexture8_GetPriority                   EQU     32
IDirect3DTexture8_PreLoad                       EQU     36
IDirect3DTexture8_GetType                       EQU     40
IDirect3DTexture8_SetLOD                        EQU     44
IDirect3DTexture8_GetLOD                        EQU     48
IDirect3DTexture8_GetLevelCount                 EQU     52
IDirect3DTexture8_GetLevelDesc                  EQU     56
IDirect3DTexture8_GetSurfaceLevel               EQU     60
IDirect3DTexture8_LockRect                      EQU     64
IDirect3DTexture8_UnlockRect                    EQU     68
IDirect3DTexture8_AddDirtyRect                  EQU     72

;IDirect3DVertexBuffer8
IDirect3DVertexBuffer8_QueryInterface           EQU     0
IDirect3DVertexBuffer8_AddRef                   EQU     4
IDirect3DVertexBuffer8_Release                  EQU     8
IDirect3DVertexBuffer8_GetDevice                EQU     12
IDirect3DVertexBuffer8_SetPrivateData           EQU     16
IDirect3DVertexBuffer8_GetPrivateData           EQU     20
IDirect3DVertexBuffer8_FreePrivateData          EQU     24
IDirect3DVertexBuffer8_SetPriority              EQU     28
IDirect3DVertexBuffer8_GetPriority              EQU     32
IDirect3DVertexBuffer8_PreLoad                  EQU     36
IDirect3DVertexBuffer8_GetType                  EQU     40
IDirect3DVertexBuffer8_Lock                     EQU     44
IDirect3DVertexBuffer8_Unlock                   EQU     48
IDirect3DVertexBuffer8_GetDesc                  EQU     52