/************************************************************************************************
 * Small footprint OpenGL init code made by Rasmus Christian Kaae (kaae@daimi.au.dk)            *
 * Made in January 2002 - Please credit me if you use this!                                     *
 *                                                                                              *
 * Usage:                                                                                       *
 *        Make a main.c file containing two functions :                                         *
 *                                                                                              *
 *        void InitIntro()                                                                      *
 *        {  todo: init stuff  }                                                                *
 *        void RunIntro()                                                                       *
 *        {                                                                                     *
 *             glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);                              *
 *             todo: display something nice                                                     *
 *        }                                                                                     *
 *                                                                                              *
 *        Compile your DEBUG project as normal and set your RELEASE version to no-defaultlibs.  *
 *        This OpenGL init code will leave a small footprint of about 1.5kb uncompressed code.  *                            
 *        Tested with MS Visual Studio 6.0.                                                     *
 ************************************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>

/************************************************************************************************/

// out-comment this to get windowed rendering
#define FULLSCREEN

/************************************************************************************************/


// implement these in your main.c file 
extern void InitIntro();
extern void RunIntro();

/************************************************************************************************/

#ifdef _DEBUG
int WINAPI WinMain(HINSTANCE i, HINSTANCE p, LPSTR cmd, int n)
#else
int WinMainCRTStartup()
#endif
{
 PIXELFORMATDESCRIPTOR pfd;
 HWND hwnd;
 HDC hdc;
 int  pixelFormat;
#ifdef FULLSCREEN
 DEVMODE dmScreenSettings;                                            // Device Mode
#endif
#ifndef _DEBUG
 HINSTANCE i = GetModuleHandle(NULL);
#endif

 /* init the pixelformat descriptor */ 
 pfd.nSize=sizeof(PIXELFORMATDESCRIPTOR);                             // Size 
 pfd.nVersion=1;                                                      // Version
 pfd.dwFlags=PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER;  // Selected flags
 pfd.iPixelType=PFD_TYPE_RGBA;                                        // Pixelformat
 pfd.cColorBits=32;                                                   // Pixel depth
 pfd.cDepthBits=16;                                                   // Zbuffer depth
 pfd.iLayerType=PFD_MAIN_PLANE;                                       // Place the pixelformat on the main plane


#ifdef FULLSCREEN
 /* init the resolution change settings */
 dmScreenSettings.dmSize=sizeof(dmScreenSettings);                    // Size Of The Devmode Structure
 dmScreenSettings.dmPelsWidth   = 640;                                // Selected Screen Width
 dmScreenSettings.dmPelsHeight  = 480;                                // Selected Screen Height
 dmScreenSettings.dmBitsPerPel  = 32;                                 // Selected Bits Per Pixel
 dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;  // Notify which fields we have used 

 if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL) return 0;
#endif

 /* setup the window handle */
 hwnd=CreateWindowEx(WS_EX_TOOLWINDOW, "STATIC", "blipblop", WS_POPUP|WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN, 0, 0, 640, 480, 0, 0, i, 0); 

 /* select the pixel format for the current window */ 
 hdc = GetDC(hwnd);
 pixelFormat = ChoosePixelFormat(hdc, &pfd);
 SetPixelFormat(hdc, pixelFormat, &pfd);
 wglMakeCurrent( hdc, wglCreateContext(hdc) );

 /* cursor be gone */
 ShowCursor(0);

 /* init the actual intro */	
 InitIntro();

 /* loop until escape is pressed all normal windows messages are ignored */
 while (!GetAsyncKeyState(VK_ESCAPE))
 {
   RunIntro();              // nifty effects here
   SwapBuffers(hdc);        // display the cool stuff
 }
  
  return 0;                 // exit to OS
}

