#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

#include "mtypes.h"
#include "mdriver.h"
#include "gf1hware.h"

#define MAXHANDLE 128

ULONG Ultra[MAXHANDLE];
ULONG Ultrs[MAXHANDLE];

/* Ultra[] holds the sample dram adresses
   of the samples of a module */


extern UNIMOD *pf;


void GUS_Update(void)
{
	UBYTE t;
	GHOLD *aud;
	UWORD vol;
	ULONG base,start,size,reppos,repend;

	UWORD curvol,bigvol=0,bigvoc=0;

	// ramp down voices that need to be started next

	for(t=0;t<md_numchn;t++){
		UltraSelectVoice(t);
		aud=&ghld[t];
		if(aud->kick){
			curvol=UltraReadVolume();
			if(bigvol<=curvol){
				bigvol=curvol;
				bigvoc=t;
			}
			UltraVectorLinearVolume(0,0x3f,0);
		}
	}

//      while(!UltraVolumeStopped(bigvoc));

	for(t=0;t<md_numchn;t++){
		UltraSelectVoice(t);
		aud=&ghld[t];

		if(aud->kick){
			aud->kick=0;

			base=Ultra[aud->handle];

			start=aud->start;
			reppos=aud->reppos;
			repend=aud->repend;
			size=aud->size;

			if(aud->flags&SF_16BITS){
				start<<=1;
				reppos<<=1;
				repend<<=1;
				size<<=1;
			}

			/* Stop current sample and start a new one */

			UltraStopVoice();

			UltraSetFrequency(aud->frq);
			UltraVectorLinearVolume(6U*aud->vol,0x3f,0);
			UltraSetBalance(aud->pan>>4);

			if(aud->flags&SF_LOOP){

				// Start a looping sample

				UltraStartVoice(base+start,
								base+reppos,
								base+repend,0x8|((aud->flags&SF_16BITS)?4:0)|
								((aud->flags&SF_BIDI)?16:0));
			}
			else{

				// Start a one-shot sample

				UltraStartVoice(base+start,
								base+start,
								base+size+2,(aud->flags&SF_16BITS)?4:0);
			}
		}
		else{
			UltraSetFrequency(aud->frq);
			UltraVectorLinearVolume(6U*aud->vol,0x3f,0);
			UltraSetBalance(aud->pan>>4);
		}
	}
}


WORD GUS_Load(int fhandle,ULONG length,ULONG loopstart,ULONG loopend,UWORD flags)
/*
	callback routine for the MODLOAD module.
*/
{
	int handle,t;
	long p,l;

	SL_Init(fhandle,flags,flags|SF_SIGNED);

	// Find empty slot to put sample address in

	for(handle=0;handle<MAXHANDLE;handle++){
		if(Ultra[handle]==0) break;
	}

	if(handle==MAXHANDLE){
		myerr=ERROR_OUT_OF_HANDLES;
		return -1;
	}

	if(flags&SF_16BITS){
		length<<=1;
		loopstart<<=1;
		loopend<<=1;
	}

	// Allocate GUS dram and store the address in Ultra[handle]
	// Alloc 8 bytes more for anticlick measures. see below.

	if(!(Ultra[handle]=UltraMalloc(length+8))){
		myerr=ERROR_SAMPLE_TOO_BIG;
		return -1;
	}


	// Load the sample

	Ultrs[handle]=length+8;
	p=Ultra[handle];
	l=length;

	while(l>0){
		static char buffer[1024];
		long todo;

		todo=(l>1024) ? 1024 : l;

		SL_Load(buffer,todo);

		UltraPokeChunk(p,buffer,todo);

		p+=todo;
		l-=todo;
	}

	if(flags&SF_LOOP && !(flags&SF_BIDI)){  // looping sample ?

		/*      Anticlick for looping samples:
			Copy the first bytes in the loop
			beyond the end of the loop */

		for(t=0;t<8;t++){
			UltraPoke(Ultra[handle]+loopend+t,
					  UltraPeek(Ultra[handle]+loopstart+t));
		}
	}
	else{

		/*      Anticlick for one-shot samples:
			Zero the bytes beyond the end of the sample.
		*/

		for(t=0;t<8;t++){
			UltraPoke(Ultra[handle]+length+t,0);
		}
	}

	return handle;
}



void GUS_UnLoad(WORD handle)
/*
	callback routine to unload samples

	smp                     :sampleinfo of sample that is being freed
*/
{
	UltraFree(Ultrs[handle],Ultra[handle]);
	Ultra[handle]=0;
}


BOOL GUS_Init(void)
{
	int t;
	ULONG p1,p2;

	for(t=0;t<MAXHANDLE;t++){ Ultra[t]=0; Ultrs[t]=0; }

	if(!(md_mode&DMODE_16BITS)){
		md_mode|=DMODE_16BITS;          // gus can't do 8 bit mixing
	}

	if(!(md_mode&DMODE_STEREO)){
		md_mode|=DMODE_STEREO;          // gus can't do mono mixing
	}

	if(!UltraDetect()){
		myerr="Couldn't detect gus, please check env. string";
		return 0;
	}

	UltraOpen(14);
	return 1;
}



void GUS_Exit(void)
{
	UltraClose();
}



void GUS_PlayStart(void)
{
	UltraNumVoices(md_numchn);
	UltraEnableOutput();
}



void GUS_PlayStop(void)
{
	UltraDisableOutput();
}


BOOL GUS_IsThere(void)
{
	return(_mm_getenv("ULTRASND")!=NULL);
}


DRIVER gusdriver={
	NULL,
	"Gravis Ultrasound",
	"MikMod GUS Driver v1.0 DeeLite",
	GUS_IsThere,
	GUS_Load,
	GUS_UnLoad,
	GUS_Init,
	GUS_Exit,
	GUS_PlayStart,
	GUS_PlayStop,
	GUS_Update
};
