#include <stdio.h>
#include <dos.h>
#include "mtypes.h"


void _mm_outchar(char c)
{
	asm{
		mov ah,0x2
		mov dl,c
		int 0x21
	}
}


void _mm_outstring(char *s)
{
	char c;
	while(c=*(s++)) _mm_outchar(c);
}


int _mm_open(const char *path, int access)
{
	char mode=access;
	asm{
		push ds
		lds  dx,path
		mov  al,mode
		mov  ah,0x3d
		int  0x21
		pop  ds
		jnc  okay
		mov  ax,0xffff
	}
	okay:
	return _AX;
}


void _mm_close(int handle)
{
	asm{
		mov  ah,0x3e
		mov  bx,handle
		int  0x21
	}
}


unsigned int _mm_read(int handle, void *buf, unsigned len)
{
	asm{
		push ds
		mov bx,handle
		lds dx,buf
		mov cx,len
		mov ah,0x3f
		int 0x21
		pop ds
		jnc okay
		xor ax,ax
	}
	okay:
	return _AX;
}

void _mm_lseek(int handle,long pos,char mode)
{
	asm{
		mov ah,0x42
		mov bx,handle
		mov cx,word ptr [pos+2]
		mov dx,word ptr [pos]
		mov al,mode
		int 0x21
	}
}


void *_mm_malloc(size_t size)
{
	UWORD pargs;

	pargs=(size+15)>>4;

	asm{
		mov ah,0x48
		mov bx,pargs
		int 0x21
		jnc okay
		xor ax,ax
	}
	okay:
	asm{
		mov dx,ax
		xor ax,ax
	}
}


void *_mm_realloc(void *block, size_t size)
{
	UWORD pargs=(size+15)>>4;

	asm{
		push es
		les bx,block
		mov bx,pargs
		mov ah,0x4a
		int 0x21
		pop es
		jnc okay
		xor ax,ax
	}
	okay:
	asm{
		mov dx,ax
		xor ax,ax
	}
}



void _mm_free(void *block)
{
	asm{
		push es
		les ax,block
		mov ah,0x49
		int 0x21
		pop es
	}
}

void _mm_memset(void *s, int c, size_t n)
{
	while(n--) *(((char *)s)++)=c;
}

void *_mm_calloc(size_t nitems,size_t size)
{
	void *p;
	if((p=_mm_malloc(nitems*size))==NULL) return NULL;
	_mm_memset(p,0,nitems*size);
	return p;
}

void _mm_memcpy(void *dest, const void *src, size_t n)
{
	while(n--) *(((char *)dest)++)=*(((char *)src)++);
}


int _mm_memcmp(const void *s1, const void *s2, size_t n)
{
	char c1,c2;

	while(n--){
		c1=*(((char *)s1)++);
		c2=*(((char *)s2)++);
		if(c1<c2) return -1;
		if(c1>c2) return 1;
	}
	return 0;
}


void _mm_setvect(unsigned char interruptno,void interrupt (*isr)())
{
	asm{
		mov ah,0x25
		mov al,interruptno
		push ds
		lds dx,isr
		int 0x21
		pop ds
	}
}


void interrupt (*_mm_getvect(unsigned char interruptno))()
{
	asm{
		mov ah,0x35
		mov al,interruptno
		push es
		int 0x21
		mov dx,es
		mov ax,bx
		pop es
	}
}


static char *getenvptr(void)
{
	asm{
		push es
		mov ah,0x62
		int 0x21
		mov es,bx
		mov dx,es:[0x2c]
		xor ax,ax
		pop es
	}
}


char *_mm_getenv(char *s)
{
	char *p,*n,*q;

	p=getenvptr();

	while(*p){

		// find next env string:
		n=p; while(*(n++));

		// compare env string with search string:
		q=s; while(*q && *(q++)==*(p++));

		// compare successfull ?
		if(!*q){
			if(*(p++)=='=') return p;	// -> return p
		}

		p=n;
	}
	return NULL;
}


static char *skipwhite(char *s)
{
	if(s==NULL) return NULL;
	while(*s==' ' || *s=='\t') s++;
	return *s ? s : NULL;
}


static unsigned char chrtoval(unsigned char c,int radix)
{
	if(c>='A' && c<='Z') c|=32;

	if(radix>10 && (c<'0' || c>'9'))
		c-='a'+10;
	else
		c-='0';

	return (c<radix) ? c : radix;
}


long _mm_strtol(char *s, char **endptr, int radix)
{
	long t=0;
	unsigned char c;

	if(!(s=skipwhite(s))) return 0;

	while((c=chrtoval(*s,radix))<radix){
		t*=radix;
		t+=c;
		s++;
	}

	*endptr=s;
	return t;
}


