include system.inc

.386
.model flat,prolog
locals
.stack 1000h

include int.inc
include rxm.inc
include struc.inc
;include gamesnd.inc

public __psp

sbStereo   = 1
sb16bit    = 2
DSP1xx  = 1
DSP200  = 2
DSP201  = 3
DSP3xx  = 4
DSP4xx  = 5

use8bit    =  1
useMono    =  2
useHalve   =  4
useOld     =  8
useDsp1    = 16
useNosound = 32

useVesa    = 64

;-----------------------------------------------------------------------------
;der command line parser erkennt folgendes:

;-8               : SB16: play 8 bit
;-m               : SB: play 8 bit mono
;-h               : SB: play with halve mixing rate
;-1               : SB: play in DSP 1.xx mode (compatibility mode)
;-o               : AWE: play in SB mode, IW: play in GUS mode (old mode)
;-n               : No sound

;-x*              : X resolution
;-y*              : Y resolution
;-b*              : Bit per pixel (8, 15, 16, 24, 32)


;-----------------------------------------------------------------------------
.data

low_err db 13,10,'Not enouth low mem$'
playing db 13,10,'playing... press a key to continue...$'
byebye db 13,10,'normal exit',13,10,'$'

pflag db 0

;vesa:
xres dd 320
yres dd 200
bpp  dd 8

soundtype dd ?
dmabuf dd ?

tune label byte
include ctslasse.dat


;-----------------------------------------------------------------------------
.data?
__psp dw ?
rxm_data trxmdata ?
drv_mem dd ?

test_mem db 33000 dup(?)


;-----------------------------------------------------------------------------
.code

;durch richtiges ersetzen
_getmem proc near
        lea eax,test_mem
        ret
_getmem endp
;--


readnumber proc near

        xor     eax,eax
@@l:
        dec     ecx
        jz      @@weg
        inc     edi
        mov     dl,es:[edi]
        sub     dl,'0'
        cmp     dl,10
        jae     @@weg

        imul    eax,10
        or      al,dl
        jmp     @@l
@@weg:  ret
readnumber endp

start:
        jmp     cmain
        db      'WATCOM'
cmain:
        sti
        cld

        mov     __psp,es
                ;komandozeile           ;es -> psp

        mov     edi,80h
        movzx   ecx,byte ptr es:[edi]
        inc     edi
@@scan:
        mov     al,'-'
        repne   scasb
        or      ecx,ecx
        jz      @@scw
        mov     al,es:[edi]

        cmp     al,'o'
        jne     @@sc0
        or      pflag,useOld
@@sc0:
        cmp     al,'1'
        jne     @@sc1
        or      pflag,useDsp1
@@sc1:
        cmp     al,'8'
        jne     @@sc2
        or      pflag,use8bit
@@sc2:
        cmp     al,'m'
        jne     @@sc3
        or      pflag,useMono
@@sc3:
        cmp     al,'h'
        jne     @@sc4
        or      pflag,useHalve
@@sc4:
        cmp     al,'n'
        jne     @@sc5
        or      pflag,useNosound
@@sc5:
                ;vesa
        cmp     al,'x'
        jne     @@sc6
        or      pflag,useVesa
        call    readnumber
        mov     xres,eax
@@sc6:
        cmp     al,'y'
        jne     @@sc7
        or      pflag,useVesa
        call    readnumber
        mov     yres,eax
@@sc7:
        cmp     al,'b'
        jne     @@sc8
        or      pflag,useVesa
        call    readnumber
        mov     bpp,eax
@@sc8:
                ;---
        jmp     @@scan
@@scw:


        push    ds
        pop     es                      ;es -> data segment
                ;sound-init
        lea     edi,rxm_data
        call    rxminit_

     xor     eax,eax
     test pflag,useNosound
     jnz @@0
        call    rxmdetect_              ;eax = 0: no sound, eax = 1: gus

        cmp     eax,2
        jne     @@0
        test    pflag,useOld
        jnz     @@0
        mov     eax,3                   ;awe whlen
        mov     soundtype,eax
        call    rxmselect_
        call    rxmtest_
        or      eax,eax
        jnz     @@ok
        mov     eax,2
@@0:
        mov     soundtype,eax
        call    rxmselect_
        call    rxmtest_                ;eax = 0: soundcard not found
        or      eax,eax
        jz      @@0                     ;init error

@@ok:           ;soundkarte ok

                ;driver mem
        mov     esi,rxmdata
        mov     esi,[esi]
        mov     eax,[esi].i_mem
        call    _getmem
        mov     drv_mem,eax

        cmp     soundtype,1
        jne     @@1
                ;gus
        test    pflag,useOld
        jnz     @@1
        mov     [esi].i_ver,0
@@1:
                ;sb
        cmp     soundtype,2
        jne     @@2
        call    getdmabuf_
        mov     dmabuf,eax
        or      eax,eax
        jnz     @@sb0

        mov     ah,9
        mov     edx,offset low_err
        int     21h
        jmp     @@exit1

@@sb0:  test    pflag,useDsp1
        jz      @@sb1
        mov     [esi].i_ver,DSP1xx
        and     [esi].i_flags,not (sbStereo or sb16bit)
        mov     [esi].i_rate,22050
@@sb1:
        test    pflag,use8bit
        jz      @@sb2
        and     [esi].i_flags,not sb16bit
@@sb2:
        test    pflag,useMono
        jz      @@sb3
        and     [esi].i_flags,not (sbStereo or sb16bit)
        cmp     [esi].i_ver,DSP3xx
        jne     @@sb3
        mov     [esi].i_rate,44100
@@sb3:
        test    pflag,useHalve
        jz      @@sb4
        shr     [esi].i_rate,1
@@sb4:

@@2:

        call    i8_init_

        mov     edi,drv_mem
        mov     eax,dmabuf
        call    rxmdevinit_
        mov     eax,12
        call    rxmsetvol_

        lea     esi,tune
        call    rxmplay_


mov     ah,9
mov     edx,offset playing
int     21h

xor     eax,eax
int     16h


mov     ah,9
mov     edx,offset byebye
int     21h

        call    rxmstop_
        call    rxmdevdone_
        call    i8_done_
        cmp     soundtype,2
        jne     @@weg
        call    freedmabuf_
@@exit1:
@@weg:
mov     ax,4c00h
int     21h


end start
