include switches.inc

.386                                    ;pmode/w
.model flat,prolog

locals


;rxm
extrn rxmdata:dword, tick:near, foreach:near

;von sb
extrn mixcount:near, mix16_s:near, startsample:near

public w_test
public maxtick, wavtick, xmstat


c_1 = 65536
b equ byte ptr
wp equ word ptr
;
;struc
;
include rxmstruc.inc

tablesize = 65536*2+1

tmix2 struc
 mix            tmix ?
 m_weight       dd tablesize dup(?)
ends

twdata struc
 w_info         tdinfo ?

 w_tsamples     dd ?
; w_tile         dd ?

 w_nosamples    dd ?
 w_clipsamples  dd ?

 align 4
 w              tmix2 ?
 align 4

ends

txmstat struc
 xs_pos         dd ?
 xs_row         dd ?
 xs_samples     dd ?
 xs_clipsamples dd ?
ends

;
.data
;


w_vmt  tsvmt <w_init, w_done, w_setvol, w_play, w_bpm>;, 0>



;
.code
;

w_test proc near
        ;-> edi -> tdinfo
        ;<- eax = 1

        mov     ebx,[edi].d_rate        ;Parameter korrigieren
        cmp     ebx,8000
        ja      @@rc0
        mov     ebx,8000
@@rc0:
        cmp     ebx,48000
        jb      @@rc1
        mov     ebx,48000
@@rc1:
        mov     [edi].d_rate,ebx

        mov     eax,size twdata
        test    [edi].d_flags,wav_lin
        jz      @@0
        sub     eax,tablesize*4
@@0:    mov     [edi].d_mem,eax

        lea     eax,w_vmt
        mov     [edi].d_vmt,eax

        xor     eax,eax
        inc     eax
        ret
w_test endp

w_init proc near
        ;ebx -> trxmdata
        ;edi -> twdata (inherits tdinfo)

                ;incval = f * (65536 / rate)
        xor     eax,eax
        mov     edx,256
        div     [edi].d_rate            ;(65536 / rate) *2^24
        mov     [ebx].s_freqmul,eax     ;ebx -> trxmdata

        test    [edi].d_flags,wav_lin
        jnz     @@0

        mov     ecx,c_1-1
@@l1:                                   ;(3t-5)*t*t/2 + 1
        lea     eax,[ecx+ecx*2]         ;3t
        sub     eax,5*c_1               ;-5
        imul    ecx
        shrd    eax,edx,16 -8           ;*t
        imul    ecx
        shrd    eax,edx,17              ;*t/2
        add     eax,c_1 *256 + c_1/512  ;+1
        mov     [edi].w.m_weight[ecx*4],eax
        dec     ecx
        jns     @@l1

        mov     ecx,c_1
@@l2:                                   ;((2-t)*t -1)*t/2
        mov     eax,c_1*2
        sub     eax,ecx                 ;2-t
        imul    ecx
        shrd    eax,edx,16 -8           ;*t
        sub     eax,c_1    *256         ;-1
        imul    ecx
        shrd    eax,edx,17              ;*t/2
        mov     [edi].w.m_weight[(c_1+ecx)*4],eax
        dec     ecx
        jns     @@l2

@@0:

@@weg:  ret
w_init endp

w_done proc near
        ;edi -> twdata


@@weg:  ret
w_done endp

w_setvol proc near
        ;-> eax = vol (0..32*8), ideal 12*8
        mov     [edi].w.m_vol,eax          ;vol = 32*8 entspricht *1

        ret
w_setvol endp

w_play proc near
        ;edi -> twdata
        ;esi -> rxmdata

        mov     [edi].w_nosamples,0
        mov     [edi].w_clipsamples,0

        mov     edx,offset w_sconv
        call    foreach

        ret
w_play endp

w_sconv proc near
        ;-> edi -> twdata
        ;-> esi -> tsampleh

        mov     ebx,[esi].sDataptr      ;ebx -> sample data
        mov     sOffset[esi],ebx

        test    sType[esi],sf16bit
        jz      @@weg
                ;16 bit
        shr     [esi].sOffset,1

@@weg:  ret
w_sconv endp


w_bpm proc near
        ;eax = frequenz*65536
        ;edi -> trxmdata

        push    edi
        mov     edi,[edi].s_drvmem       ;edi -> twdata

        mov     ebx,eax

;        mov     eax,45*65536            ;frequenz mu >= 45Hz sein
;        xor     edx,edx
;        div     ebx
;        inc     eax
;        mov     [edi].w_tile,eax        ;eax = tick-unterteilung
;        imul    ebx,eax                 ;ebx = frequenz * teilung

        mov     eax,[edi].d_rate
        shl     eax,16
        xor     edx,edx
        div     ebx
        mov     [edi].w_tsamples,eax    ;samples pro teil-tick


        pop     edi
        ret
w_bpm endp

maxtick proc near
        ;<- eax = max-value

        push    ebp
        mov     edi,rxmdata

        call    tick
        cmp     [edi].rflag,1           ;ende erreicht
        jne     @@rflag
        mov     eax,-1
        jmp     @@w
@@rflag:
        mov     ebx,[edi].s_drvmem      ;ebx -> twdata

        mov     eax,[ebx].w_tsamples
        mov     [ebx].w.m_tsamples,eax

@@l0:

        lea     esi,[edi].chdata
        mov     ecx,[edi].head.hdChannels

        push    edi
        lea     ebx,[ebx].w             ;ebx -> tmix
;---    linear
@@ll:
        push    ecx
        mov     edi,cmixpos[esi]        ;edi = cpos
        call    mix16_s
        mov     cmixpos[esi],edi
        pop     ecx

        add     esi,size tchannel
        dec     ecx
        jnz     @@ll

@@4p:   pop     edi                     ;edi -> trxmdata
        mov     ebx,[edi].s_drvmem      ;ebx -> twdata

        mov     ecx,[ebx].w.m_tsamples  ;ecx = samples
        shl     ecx,1                   ;*2 fr stereo
        add     [ebx].w_nosamples,ecx   ;fr clip-statistik
        dec     ecx

        xor     ebp,ebp                 ;ebp = 0
        xor     edi,edi                 ;edi = max value
;---    16 bit
@@mbl:
        mov     eax,[ebx].w.m_mixbuf16[ecx*4]
        sar     eax,8+2                 ;/1024

        cdq                             ;abs(eax)
        xor     eax,edx
        sub     eax,edx

        cmp     eax,edi
        jb      @@0
        mov     edi,eax
@@0:
        mov     [ebx].w.m_mixbuf16[ecx*4],ebp
        dec     ecx
        jns     @@mbl

        mov     eax,edi                 ;eax = max value
@@w:
        pop     ebp
        ret
maxtick endp

wavtick proc near
        ;-> ebx -> 15K-buffer
        ;<- eax = buf-size

        push    ebp
        mov     edi,rxmdata

        push    ebx

;        mov     ebx,[edi].s_drvmem     ;ebx -> twdata
;        dec     [ebx].w.m_tilecnt
;        jg      @@l0

        call    tick
        mov     ebx,[edi].s_drvmem      ;ebx -> twdata
        mov     eax,[ebx].d_loopcount
        cmp     [edi].rflag,al ;1           ;ende erreicht
        jne     @@rflag
        pop     ebx
        xor     eax,eax
        jmp     @@w
@@rflag:

        mov     eax,[ebx].w_tsamples
        mov     [ebx].w.m_tsamples,eax
;        mov     eax,[ebx].w_tile
;        mov     [ebx].w.m_tile,eax
;        mov     [ebx].w.m_tilecnt,eax

@@l0:

        lea     esi,[edi].chdata
        mov     ecx,[edi].head.hdChannels

        push    edi
        test    [ebx].d_flags,wav_lin
        lea     ebx,[ebx].w             ;ebx -> tmix
        jnz     @@ll
;---    4-punkt
@@4l:
        push    ecx
        mov     edi,cmixpos[esi]        ;edi = cpos
        call    mix_4
        mov     cmixpos[esi],edi
        pop     ecx

        add     esi,size tchannel
        dec     ecx
        jnz     @@4l
        jmp     @@4p

;---    linear
@@ll:
        push    ecx
        mov     edi,cmixpos[esi]        ;edi = cpos
        call    mix16_s
        mov     cmixpos[esi],edi
        pop     ecx

        add     esi,size tchannel
        dec     ecx
        jnz     @@ll

@@4p:   pop     edi                     ;edi -> trxmdata
        mov     ebx,[edi].s_drvmem      ;ebx -> twdata

        mov     ecx,[ebx].w.m_tsamples  ;ecx = samples
        shl     ecx,1                   ;*2 fr stereo
        add     [ebx].w_nosamples,ecx   ;fr clip-statistik
        dec     ecx


        pop     esi                     ;esi -> buffer
        xor     ebp,ebp
        test    [ebx].d_flags,wav_32bit
        jnz     @@32

;---    16 bit
@@mbl:
        mov     eax,[ebx].w.m_mixbuf16[ecx*4]
        sar     eax,8+2                 ;/1024
        add     eax,32768
        cmp     eax,65536
        jae     @@clip
@@mb0:
        mov     [ebx].w.m_mixbuf16[ecx*4],ebp

        xor     ah,80h
        mov     [esi],ax
        inc     esi
        inc     esi

        dec     ecx
        jns     @@mbl
        jmp     @@mb1
@@clip:
        sar     eax,31
        not     eax
        inc     [ebx].w_clipsamples     ;fr clip-statistik
        jmp     @@mb0
@@mb1:
        mov     eax,[ebx].w.m_tsamples  ;buf-size
        shl     eax,2                   ;16 bit stereo

        jmp     @@w
;---    32 bit
@@32:
@@mbl2:
        mov     eax,[ebx].w.m_mixbuf16[ecx*4]
;  mov eax,32768*1024-1
        xor     edx,edx
        or      eax,eax                 ;make float
        jz      @@z
        mov     dl,86h
        jns     @@ns
        mov     dh,1
        neg     eax
@@ns:
@@l:    dec     dl
        shl     eax,1
        jnc     @@l
        shl     edx,23
        shr     eax,9
        or      edx,eax
@@z:
        mov     [ebx].w.m_mixbuf16[ecx*4],ebp
        mov     [esi],edx
        add     esi,4

        dec     ecx
        jns     @@mbl2

        mov     eax,[ebx].w.m_tsamples  ;buf-size
        shl     eax,3                   ;32 bit stereo

@@w:
        pop     ebp
        ret
wavtick endp


xmstat proc near
        ;esi -> txmstat
        mov     edi,rxmdata             ;edi -> trxmdata

        mov     eax,[edi].p_pos
        mov     [esi].xs_pos,eax
        mov     eax,[edi].p_rowcnt
        mov     [esi].xs_row,eax

        mov     edi,[edi].s_drvmem      ;edi -> twdata

        mov     eax,[edi].w_nosamples
        mov     [esi].xs_samples,eax
        mov     eax,[edi].w_clipsamples
        mov     [esi].xs_clipsamples,eax

        ret
xmstat endp



mix_4 proc near                       ;stereo 16 bit mixing
        ;ebx -> tmix
        ;esi -> tchannel
        ;edi = cmixpos

        test    caktiv[esi],afStop
        jz      @@aktiv
@@stop:
        mov     eax,colivol[esi]
        mov     edx,corevol[esi]
        shl     eax,16
        shl     edx,16
        mov     m_livol[ebx],eax
        mov     m_revol[ebx],edx
        shr     eax,6
        shr     edx,6
        mov     m_liadd[ebx],eax
        mov     m_readd[ebx],edx

        mov     eax,[ebx].m_tsamples ;eax = m_tsamples
        mov     m_samples[ebx],eax
        mov     ecx,64
        call    slide

@@aktiv:
        test    caktiv[esi],afAktiv
        jz      @@cweg

        mov     eax,cfinalvol[esi]      ;0..256
        imul    eax,[ebx].m_vol
        shr     eax,3+3

        neg     eax                     ;combine panning and volume
        mov     edx,cfinalpan[esi]      ;left
        imul    edx,edx
        sub     edx,65536
        imul    edx,eax
        shr     edx,16
        mov     clivol[esi],edx

        mov     edx,cfinalpan[esi]      ;right
        sub     edx,256
        imul    edx,edx
        sub     edx,65536
        imul    edx,eax
        shr     edx,16
        mov     crevol[esi],edx


        mov     eax,cincval[esi]
        mov     cmixincval[esi],eax

        mov     eax,[ebx].m_tsamples ;eax = m_tsamples
        mov     m_samples[ebx],eax

        test    caktiv[esi],afStart
        jz      @@play

        call    startsample             ;start

        mov     colivol[esi],eax
        mov     corevol[esi],eax

        mov     eax,clivol[esi]
        mov     edx,crevol[esi]
        mov     m_liadd[ebx],eax
        mov     m_readd[ebx],edx

        jmp     @@start

@@play: cmp     cmixdir[esi],2          ;play
        jne     @@nstp
        and     caktiv[esi],not afPlay
        jmp     @@stop
@@nstp:

        test    caktiv[esi],afVol
        jnz     @@2i
                ;1mal interpolieren
        mov     eax,colivol[esi]
        shl     eax,16
        mov     m_livol[ebx],eax
        mov     edx,clivol[esi]
        sal     edx,16
        sub     eax,edx
        cdq
        idiv    m_samples[ebx]
        mov     m_liadd[ebx],eax

        mov     eax,corevol[esi]
        shl     eax,16
        mov     m_revol[ebx],eax
        mov     edx,crevol[esi]
        sal     edx,16
        sub     eax,edx
        cdq
        idiv    m_samples[ebx]
        mov     m_readd[ebx],eax

        mov     ecx,m_samples[ebx]
        call    slide

        jmp     @@cweg

@@2i:           ;2mal interpolieren

        mov     eax,cenvpan[esi]        ;interpolate envelope pan
        sub     eax,coenvpan[esi]
        sal     eax,6                   ;*64
        cdq
        idiv    [ebx].m_tsamples
        add     eax,coenvpan[esi]       ;eax = ienvpan
                ;FinalPan=Pan+(EnvelopePan-128)*(128-Abs(Pan-128))/128;
        mov     edx,cpatpan[esi]
        mov     ebp,edx
        sub     edx,128
        js      @@p4
        neg     edx
@@p4:   add     edx,128                 ;edx = 128-Abs(Pan-128)

        sub     eax,128
        imul    edx
        sar     eax,7
        add     ebp,eax                 ;ebp = panning for middle point

        mov     eax,cenvvol[esi]        ;interpolate envelope volume
        sub     eax,coenvvol[esi]
        sal     eax,6                   ;*64
        cdq
        idiv    [ebx].m_tsamples
        add     eax,coenvvol[esi]

        imul    eax,cpatvol[esi]
        shr     eax,8
        imul    eax,[ebx].m_vol
        shr     eax,3+3                 ;eax = volume for middle point

        neg     eax                     ;combine panning and volume
        mov     edx,ebp                 ;left, ebp = panning
        imul    edx,edx
        sub     edx,65536
        imul    edx,eax
        shr     edx,16
        mov     m_liadd[ebx],edx

        mov     edx,ebp                 ;right
        sub     edx,256
        imul    edx,edx
        sub     edx,65536
        imul    edx,eax
        shr     edx,16
        mov     m_readd[ebx],edx

@@start:

        mov     eax,colivol[esi]
        mov     edx,corevol[esi]

        mov     m_livol[ebx],eax
        mov     m_revol[ebx],edx

        sub     eax,m_liadd[ebx]
        sub     edx,m_readd[ebx]
        sal     eax,16-6
        sal     edx,16-6
        mov     m_liadd[ebx],eax
        mov     m_readd[ebx],edx

        shl     m_livol[ebx],16
        shl     m_revol[ebx],16

        mov     ecx,64
        call    slide


        mov     eax,m_livol[ebx]
        mov     edx,clivol[esi]
        sal     edx,16
        sub     eax,edx
        cdq
        idiv    m_samples[ebx]
        mov     m_liadd[ebx],eax

        mov     eax,m_revol[ebx]
        mov     edx,crevol[esi]
        sal     edx,16
        sub     eax,edx
        cdq
        idiv    m_samples[ebx]
        mov     m_readd[ebx],eax

        mov     ecx,m_samples[ebx]
        call    slide

@@cweg:
        ret

mix_4 endp


slide proc near
        ;-> ecx = todo
      mov     m_todo[ebx],ecx
@@sl:
      mov ecx,m_todo[ebx]
        call    mixcount                  ;ebp = incval, ecx = samples
      sub     m_todo[ebx],ecx

        add     ecx,m_samples[ebx]
        dec     ecx

        mov     m_inclo[ebx],ebp
        sar     ebp,16
        mov     m_inchi[ebx],ebp

        mov     ebp,cmixposn[esi]          ;ebp = cposn
        shr     ebp,16

        push    esi

        test    cmixtype[esi],sf16bit
        jnz     @@16bit


@@8bit: ;inner loop fr 8 bit stereo
        push    ecx
        mov     esi,ebp

        movsx   eax,b [edi+0]
        imul    m_weight[ebx+(c_1+esi)*4]
        shrd    eax,edx,8
        mov     ecx,eax

        movsx   eax,b [edi+1]
        imul    m_weight[ebx+esi*4]
        shrd    eax,edx,8
        add     ecx,eax

        neg     esi

        movsx   eax,b [edi+2]
        imul    m_weight[ebx+(c_1+esi)*4]
        shrd    eax,edx,8
        add     ecx,eax

        movsx   eax,b [edi+3]
        imul    m_weight[ebx+(c_1*2+esi)*4]
        shrd    eax,edx,8
        add     eax,ecx

        pop     ecx
        push    eax

        imul    m_livol[ebx]            ;linker kanal
        shrd    eax,edx,24
        add     m_mixbuf16[ebx+ecx*8+4],eax

        pop     eax

        imul    m_revol[ebx]            ;rechter kanal
        shrd    eax,edx,24
        add     m_mixbuf16[ebx+ecx*8],eax

        dec     ecx

        add     bp,wp m_inclo[ebx]
        adc     edi,m_inchi[ebx]

        mov     eax,m_liadd[ebx]
        mov     edx,m_readd[ebx]
        sub     m_livol[ebx],eax
        sub     m_revol[ebx],edx

        cmp     ecx,m_samples[ebx]

        jge     @@8bit

        jmp     @@2

@@16bit:;inner loop fr 16 bit stereo
        push    ecx
        mov     esi,ebp

        movsx   eax,wp [(edi+0)*2]
        imul    m_weight[ebx+(c_1+esi)*4]
        shrd    eax,edx,16
        mov     ecx,eax

        movsx   eax,wp [(edi+1)*2]
        imul    m_weight[ebx+esi*4]
        shrd    eax,edx,16
        add     ecx,eax

        neg     esi

        movsx   eax,wp [(edi+2)*2]
        imul    m_weight[ebx+(c_1+esi)*4]
        shrd    eax,edx,16
        add     ecx,eax

        movsx   eax,wp [(edi+3)*2]
        imul    m_weight[ebx+(c_1*2+esi)*4]
        shrd    eax,edx,16
        add     eax,ecx

        pop     ecx
        push    eax

        imul    m_livol[ebx]            ;linker kanal
        shrd    eax,edx,24
        add     m_mixbuf16[ebx+ecx*8+4],eax

        pop     eax

        imul    m_revol[ebx]            ;rechter kanal
        shrd    eax,edx,24
        add     m_mixbuf16[ebx+ecx*8],eax

        dec     ecx

        add     bp,wp m_inclo[ebx]
        adc     edi,m_inchi[ebx]

        mov     eax,m_liadd[ebx]
        mov     edx,m_readd[ebx]
        sub     m_livol[ebx],eax
        sub     m_revol[ebx],edx

        cmp     ecx,m_samples[ebx]

        jge     @@16bit

@@2:
        pop     esi
        shl     ebp,16
        mov     cmixposn[esi],ebp

      cmp m_todo[ebx],0
      jg @@sl


@@weg:  ret
slide endp


end