.386
.model flat,prolog
locals

public finit_
public sin_
public cos_
public arccos_
public sqr_
public sqrt_
public fabs_
public pow_
public arctan_

public fexp_
public fscale_

public cos2sin_

public setrc_
public ceil_
public floor_
public round_


w equ word ptr
d equ dword ptr
;
.data
;
c_05 dd 0.499999
;
.code
;

finit_ proc near
        finit
        push    eax
        fldcw   w [esp]
        pop     eax
        ret
finit_ endp

sin_ proc near
        fld     d [esp+4]
        fsin
        ret     4
endp

cos_ proc near
        fld     d [esp+4]
        fcos
        ret     4
endp

arccos_ proc near
        fld     d [esp+4]
        fld     st(0)
        fmul    st,st(0)
        fld1
        fsubrp  st(1),st                ;st(0) = sin = 1-cos

        ftst
        fstsw   ax
        sahf
        jae     @@0
        fstp    st
        fldz
        jmp     @@1
@@0:
        fsqrt                           ;st(0) = sin, st(1) = cos
@@1:
        fxch    st(1)
        fpatan


@@weg:  ret     4
endp


sqr_ proc near
        fld     d [esp+4]
        fmul    st,st(0)
        ret     4
endp

sqrt_ proc near
        fld     d [esp+4]
        fsqrt
        ret     4
endp

fabs_ proc near
        fld     d [esp+4]
        fabs
        ret     4
endp

pow_ proc near
        fld     d [esp+8]
        fld     d [esp+4]
        fyl2x
        fld     st
        frndint
        fxch    st(1)
        fsub    st,st(1)
        f2xm1
        fld1
        faddp   st(1),st
        fscale
        fstp    st(1)
        ret     8
endp

arctan_ proc near
        fld     d [esp+8]
        fld     d [esp+4]
        fpatan
        ret     8
arctan_ endp

fexp_ proc near
        fld     d [esp+4]
        fxtract
        fstp    st
        fistp   d [esp+4]
        mov     eax,[esp+4]

        ret     4
fexp_ endp

fscale_ proc near
        fild    d [esp+8]
        fld     d [esp+4]
        fscale
        fstp    st(1)

        ret     8
fscale_ endp

cos2sin_ proc near
        fld     d [esp+4]
        fmul    st,st(0)
        fld1
        fsubrp  st(1)                ;st(0) = sin = 1-cos

        ftst
        fstsw   ax
        sahf
        jae     @@0
        ffree   st(0)
        fldz
        jmp     @@1
@@0:
        fsqrt
@@1:
        ret     4
endp


setrc_ proc near

        push    eax
        fstcw   [esp]
        and     d [esp],0F3FFh
        shl     eax,10
        or      [esp],eax
        fldcw   [esp]
        pop     eax
        ret
endp

ceil_ proc near
        fld     d [esp+4]
        fadd    c_05
        fistp   d [esp+4]
        mov     eax,d [esp+4]
        ret     4
endp

floor_ proc near
        fld     d [esp+4]
        fsub    c_05
        fistp   d [esp+4]
        mov     eax,d [esp+4]
        ret     4
endp

round_ proc near
        fld     d [esp+4]
        frndint
        ret     4
endp

end

