				org #8181
				
				; Dummy Interrupt Service Routine
                                ei
				ret
				
				; Include the song data (must be compiled at address &8183)
				;
				; Note that these demo tunes are originally composed
				; for a 1MHz AY3 (CPC). Some sounds are a bit odd on
				; the Speccy (esp. those using the hardware env.).
atSongdata
				incbin "sng8183/molusk.bin"
				;incbin "sng8183/castle.bin"
				;incbin "sng8183/dotmenu.bin"
				;incbin "sng8183/fuckit.bin"
				;incbin "sng8183/robot.bin"

				; Our quick music test program
MAIN_PROGRAM
				; Initialize IM2 / Get rid of the system interrupt
				di
				ld hl,#8000	; HL point to the IM2 Lookup table
				ld a,h
				ld i,a		; Set I=#80
				im 2		; Switch to vectorized interrupts
				inc a
_im2_fill_lut			ld (hl),a	; Fill the IM2 LUT with #81
				inc l		; All INT will jump to #8181
				jr nz,_im2_fill_lut
				inc h
				ld (hl),a
				
				; Initialize music player
				ld de,atSongdata
				ld sp,_spTest
				call atInit
_spTest				ei

				; Test Volume fade (0=full volume / >15=no sound)
				;ld a,0
				;call atFade

				; Wait for the ~50Hz interrupt
_mainLoop			halt

				; wait for the electron beam to be in the upper border
				djnz $
				djnz $

				; change border color to white
				ld bc,#FE
				ld a,7
				out (c),a

				; play one tick of the music
				call atPlay
				
				; change the border color to black
				ld bc,#FE
				ld a,0
				out (c),a
				
				; loop forever and ever and ever and ever and ever and ...
                                jr _mainLoop

				; include the player source code
				include "atPlayer.speccy.asm"

END  MAIN_PROGRAM
