// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "tracker.h"
#include "sampleView.h"
#include "trackerview.h"

#include "MainFrm.h"
#include "TrackerControls.h"
#include "trackerscopes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	ON_MESSAGE(WM_USER+10,OnPaneText)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
		ID_INDICATOR_CAPS,
		ID_INDICATOR_NUM,
		ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here

}

CMainFrame::~CMainFrame()
{	
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	if (!m_trackerControls.Create (this,IDD_DIALOG_TRACKER_CNTRL,CBRS_GRIPPER|CBRS_LEFT|CBRS_TOOLTIPS|CBRS_FLYBY, IDD_DIALOG_TRACKER_CNTRL))
	{
		TRACE0("Failed to create tracker controls\n");
		return -1;
	}
	if (!m_trackerScopes.Create (this,IDD_DIALOG_SCOPES,CBRS_GRIPPER|CBRS_LEFT|CBRS_TOOLTIPS|CBRS_FLYBY, IDD_DIALOG_TRACKER_CNTRL))
	{
		TRACE0("Failed to create tracker controls\n");
		return -1;
	}
	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_trackerControls.SetCaption("TrackerControls");
	m_trackerScopes.SetCaption("TrackerScopes");
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_trackerControls.EnableDocking(CBRS_ALIGN_ANY);
	m_trackerScopes.EnableDocking(CBRS_ALIGN_TOP|CBRS_ALIGN_BOTTOM);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);
	DockControlBar(&m_trackerControls);
	DockControlBar(&m_trackerScopes,AFX_IDW_DOCKBAR_BOTTOM);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

/*
void CMainFrame::OnMenuSampleview() 
{
// TODO: Add your command handler code here
CMDIChildWnd* pOutFrame;
CMSDIWinApp* pApp = (CMSDIWinApp*)AfxGetApp();

pOutFrame = pApp->CreateOrActivateFrame(RUNTIME_CLASS(CInstrEditor), NULL);
m_pInstrEditor = (CInstrEditor*)pOutFrame->GetActiveView();
ASSERT(m_pInstrEditor != NULL);
ASSERT(m_pInstrEditor->IsKindOf(RUNTIME_CLASS(CInstrEditor)));

}
*/

void CMainFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	CView *mvPtr,*mvPtr2;

	mvPtr = GetActiveView ();
	if (mvPtr != NULL)
	{
		mvPtr2 = (CView *)RUNTIME_CLASS (CPatternView);
	}

	CMDIFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}
LRESULT CMainFrame::OnPaneText (WPARAM p, LPARAM l)
{
	char buffer[128];

	m_trackerControls.m_cpuUsage=100*atoi((char *)l);
	m_trackerControls.UpdateData(FALSE);
	sprintf (buffer,"%s",(char *)l);
	m_wndStatusBar.SetPaneText (0,buffer,TRUE);

	return 0;
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CMDIFrameWnd::OnSize(nType, cx, cy);
	m_trackerControls.SendMessage(WM_SIZE,nType,((cy&0xffff)<<16) | (cx & 0xffff));
	// TODO: Add your message handler code here

}
