// ModEnvelope.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "ModEnvelope.h"
#include "modulatebasedlg.h"
#include "isSynth.h"
#include "isEnvelope.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CModEnvelope dialog
#define FloatIntMAX 1024
#define uFloatToInt(a) ((a)*1024)
#define sFloatToInt(a) ((a)*1024+1024)

#define uIntToFloat(a) ((a)/1024.0f)
#define sIntToFloat(a) (((a)-1024)/1024.0f)



CModEnvelope::CModEnvelope(CWnd* pParent /*=NULL*/)
	: CModulateBaseDlg(CModEnvelope::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModEnvelope)
	//}}AFX_DATA_INIT
}


void CModEnvelope::DoDataExchange(CDataExchange* pDX)
{
	CModulateBaseDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModEnvelope)
	DDX_Control(pDX, IDC_STATIC_SVAL, m_sval);
	DDX_Control(pDX, IDC_STATIC_RVAL, m_rval);
	DDX_Control(pDX, IDC_STATIC_DVAL, m_dval);
	DDX_Control(pDX, IDC_STATIC_AVAL, m_aval);
	DDX_Control(pDX, IDC_CHECK_USESUSTAIN, m_checkSustain);
	DDX_Control(pDX, IDC_SLIDER_ENVDELAY, m_decaySlider);
	DDX_Control(pDX, IDC_SLIDER_ENVVELOSENSE, m_velosenseSlider);
	DDX_Control(pDX, IDC_SLIDER_ENVSUSTAIN, m_sustainSlider);
	DDX_Control(pDX, IDC_SLIDER_ENVRELEASE, m_releaseSlider);
	DDX_Control(pDX, IDC_SLIDER_ENVATTACK, m_attacSlider);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CModEnvelope, CModulateBaseDlg)
	//{{AFX_MSG_MAP(CModEnvelope)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_CHECK_USESUSTAIN, OnCheckUsesustain)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModEnvelope message handlers


void CModEnvelope::SetModData()
{
  isEnvelope *env;
  env = (isEnvelope *)modulator;
  env->a = 255-m_attacSlider.GetPos();
  env->d = 255-m_decaySlider.GetPos();
  env->s = uIntToFloat(1024-m_sustainSlider.GetPos());
  env->r = 255-m_releaseSlider.GetPos();
  env->veloSens = sIntToFloat(m_velosenseSlider.GetPos());



  CString bla;
  bla.Format ("%d",env->a);
  m_aval.SetWindowText (bla);
  bla.Format ("%d",env->d);
  m_dval.SetWindowText (bla);
  bla.Format ("%5.4f",env->s); 
  m_sval.SetWindowText (bla);

  bla.Format ("%d",env->r);
  m_rval.SetWindowText (bla);

  

//  instrument->Update();
  
}
void CModEnvelope::UpdateModulateData()
{
  isEnvelope *env;
  env = (isEnvelope *)modulator;
  m_attacSlider.SetPos(255-env->a);
  m_decaySlider.SetPos(255-env->d);
  m_sustainSlider.SetPos(1024-uFloatToInt(env->s));
  m_releaseSlider.SetPos(255-env->r);
  m_velosenseSlider.SetPos(sFloatToInt(env->veloSens));

  if (env->useSustain)
    m_checkSustain.SetCheck(1);
  else
    m_checkSustain.SetCheck(0);
  
  CString bla;
  bla.Format ("%d",env->a);
  m_aval.SetWindowText (bla);
  bla.Format ("%d",env->d);
  m_dval.SetWindowText (bla);

  bla.Format ("%5.4f",env->s);
  m_sval.SetWindowText (bla);
  bla.Format ("%d",env->r);
  m_rval.SetWindowText (bla);
  
}
BOOL CModEnvelope::OnInitDialog() 
{
	CModulateBaseDlg::OnInitDialog();
	

  m_attacSlider.SetRange (0,255);
  m_decaySlider.SetRange(0,255);
  m_sustainSlider.SetRange(0,1024);
  m_releaseSlider.SetRange(0,255);
  m_velosenseSlider.SetRange (0,2048);

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CModEnvelope::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  // TODO: Add your message handler code here and/or call default
  SetModData();
  CModulateBaseDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}
void CModEnvelope::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
  SetModData();	
	CModulateBaseDlg::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CModEnvelope::OnCheckUsesustain() 
{
	// TODO: Add your control notification handler code here
  isEnvelope *env;
  env = (isEnvelope *)modulator;
  
  if (env->useSustain)
  {
    m_checkSustain.SetCheck(0);
    env->useSustain=FALSE;
  }
  else
  {
    m_checkSustain.SetCheck(1);
    env->useSustain=TRUE;
  }
  
  SetModData();
  
}
