// tracker.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "tracker.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "trackerDoc.h"
#include "trackerView.h"
#include "sampleView.h"
#include "mixerview.h"
#include "tkerror.h"
#include "globals.h"
#include "SendFxView10.h"
#include "SamplePoolEditor.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
/*
	ON_COMMAND(ID_FILE_NEW, CMSDIWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CMSDIWinApp::OnFileOpen)
*/

/////////////////////////////////////////////////////////////////////////////
// CTrackerApp

BEGIN_MESSAGE_MAP(CTrackerApp, CMSDIWinApp)
	//{{AFX_MSG_MAP(CTrackerApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CMSDIWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTrackerApp construction

CTrackerApp::CTrackerApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance	
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CTrackerApp object

CTrackerApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CTrackerApp initialization

BOOL CTrackerApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	GLOBALS_INIT();

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	//SetWindowColor

    tdbg_open("debug.txt");
    
	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_TRACKETYPE,
		RUNTIME_CLASS(CTrackerDoc),
		RUNTIME_CLASS(CViewFrame), // custom MDI child frame
		RUNTIME_CLASS(CPatternView));
	AddDocTemplate(pDocTemplate);

	CMultiDocTemplate *pInstrEditorTemplate;
	pInstrEditorTemplate = new CMultiDocTemplate(
		IDR_SAMPLETYPE,
		RUNTIME_CLASS(CTrackerDoc),
		RUNTIME_CLASS(CViewFrame),
		RUNTIME_CLASS(CInstrEditor));
	AddDocTemplate(pInstrEditorTemplate);

    CMultiDocTemplate *pMixerViewTemplate;
    pMixerViewTemplate = new CMultiDocTemplate(
        IDR_SAMPLETYPE,
        RUNTIME_CLASS(CTrackerDoc),
        RUNTIME_CLASS(CViewFrame),
        RUNTIME_CLASS(CMixerView));
    AddDocTemplate(pMixerViewTemplate);

    CMultiDocTemplate *pSendFxTemplate;
    pSendFxTemplate = new CMultiDocTemplate(
        IDR_SAMPLETYPE,
        RUNTIME_CLASS(CTrackerDoc),
        RUNTIME_CLASS(CViewFrame),
        RUNTIME_CLASS(CSendFxView));
    AddDocTemplate(pSendFxTemplate);

    CMultiDocTemplate *pSPoolTemplate;
    pSPoolTemplate = new CMultiDocTemplate(
        IDR_SAMPLETYPE,
        RUNTIME_CLASS(CTrackerDoc),
        RUNTIME_CLASS(CViewFrame),
        RUNTIME_CLASS(CSamplePoolEditor));
    AddDocTemplate(pSPoolTemplate);
    
    // create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();


	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About


class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CString	m_BuildNr;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_BuildNr = _T("");
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Text(pDX, IDC_STATIC_BUILD, m_BuildNr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CTrackerApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.m_BuildNr.Format ("%s",__DATE__);
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CTrackerApp message handlers


int CTrackerApp::ExitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class
    tdbg_close();
	GLOBALS_DESTROY();
	
	return CMSDIWinApp::ExitInstance();
}
