;***************************************************************************
; EG8.ASM        A program will show the video card memory write speed.
;
;***************************************************************************

.386

.MODEL FLAT
.STACK 4000h

CYCLES          EQU     18
FREQ            EQU     18



;  Macro to print some text on the screem
;
Print MACRO string
local @text,@skip
    mov edx,offset @text
    mov ah,9
    int 21h
    jmp @skip
@text db string,36
@skip:
ENDM


    .DATA

Video_Mem       DD      ?
Ticks           DD      ?
Writes          DD      8 DUP (0)
old_INT8        DF      ?

    .CODE


Video_Speed:                                     ; Start of program


        mov     ax,3                    ; Reset TEXT mode
        int     10h

        mov     ax,0EE02h
        int     31h
        neg     ebx
        add     ebx,0b8000h
        mov     Video_Mem,ebx

    ;****** hook timer interrupt **********
        mov     ax,204h
        mov     bl,8
        int     31h
        mov     dword ptr old_INT8,edx          ; save old vector
        mov     word ptr old_INT8[4],cx

        mov     ax,205h
        mov     edx,Offset Timer_ISR            ; put in new vector
        mov     cx,cs
        int     31h


 ;------------ fill memory with REP STOSB for a set amount of time --------
        cld
        mov     ticks,0
        xor     eax,eax
Loop00:
        mov     edi,Video_Mem
        mov     ecx,4000
        rep     stosb
        inc     al
        add     Writes[0],4000 * FREQ
        cmp     ticks,CYCLES
        jb Loop00


 ;------------ fill memory with REP STOSW for a set amount of time --------
        mov     ticks,0
        xor     eax,eax
Loop01:
        mov     edi,Video_Mem
        mov     ecx,2000
        rep     stosw
        inc     al
        inc     ah
        add     Writes[4],4000 * FREQ
        cmp     ticks,CYCLES
        jb  Loop01


 ;------------ fill memory with REP STOSD for a set amount of time --------
        mov     ticks,0
        xor     eax,eax
Loop02:
        mov     edi,Video_Mem
        mov     ecx,1000
        rep     stosd
        add     Writes[8],4000 * FREQ
        inc     al
        inc     ah
        push    ax
        push    ax
        pop     eax
        cmp     ticks,CYCLES
        jb Loop02


 ;------------ fill CPU memory with REP STOSD for a set amount of time --------
        mov     ticks,0
        xor     eax,eax
        sub     esp,2000h           ; Allocate 8K on the stack
        mov     ebx,esp
Loop03:
        mov     edi,ebx
        mov     ecx,2000h/4
        rep     stosd
        add     Writes[12],2000h * FREQ
        inc     al
        inc     ah
        push    ax
        push    ax
        pop     eax
        cmp     ticks,CYCLES
        jb Loop03

skip:

        ;******* reset text mode **********
        mov     ax,3
        int     10h


        ;******* return origonal interrupt vector **********
        mov     ax,205h
        mov     edx,dword ptr old_INT8
        mov     cx,word ptr old_INT8[4]
        mov     bl,8
        int     31h

        ;******* print transfer rates on the screen **********

        Print   ' Video transfer speed using 8bit writes:  '
        mov     eax,Writes[0]
        mov     ebx,CYCLES
        xor     edx,edx
        div     ebx
        shr     eax,10
        call    Print_DecDword
        Print   <' Kb/s',10,13>

        Print   ' Video transfer speed using 16bit writes:  '
        mov     eax,Writes[4]
        mov     ebx,CYCLES
        xor     edx,edx
        div     ebx
        shr     eax,10
        call    Print_DecDword
        Print   <' Kb/s',10,13>

        Print   ' Video transfer speed using 32bit writes:  '
        mov     eax,Writes[8]
        mov     ebx,CYCLES
        xor     edx,edx
        div     ebx
        shr     eax,10
        call    Print_DecDword
        Print   <' Kb/s',10,13,10,13>

        Print   ' CPU memory fill rate using 32bit writes:  '
        mov     eax,Writes[12]
        mov     ebx,CYCLES
        xor     edx,edx
        div     ebx
        shr     eax,10
        call    Print_DecDword
        Print   <' Kb/s',10,13,10,13>

        Print   <' If this is a genuine 32bit video card then the 32bit transfer',10,13>
        Print   <' rate should be significatly greater (a factor between 1.5 and 2) than ',10,13>
        Print   <'the 16bit rate.',10,13>

        mov   ax,4C00h                          ; Termiate the program
        int   21h



Timer_ISR PROC
        Push    eax
        Push    ds
        mov     ax,SEG Timer_ISR
        mov     ds,ax
        inc     Ticks
        mov     al,20h
        out     20h,al
        Pop     ds
        Pop     eax
        iretd
Timer_ISR ENDP


;͸
;                                                                          
;  procedure to print the Decimal value of EAX                             
;                                                                          
;
; ***************  prints decimal EAX  ******************
Print_DecDword   PROC
        pushad
        mov     ESI,4*5
        mov     ecx,eax
dec83:
        mov	eax,ECX
        xor	edx,edx
        div     Dec_divider[ESI]
        mov	ECX,EDX		; reuse remainder
                add al,'0'      ; use quotient as digit number
                mov     dl,al
                mov     ah,2
                int     21h             ; send character to screen
        sub ESI,4
        jge dec83
        popad
        RET
Print_DecDword        ENDP


align 4
dec_divider dd 1,10,100,1000,10000,100000,1000000,10000000,100000000,1000000000
;-------------------------------------------------------


END  Video_Speed
