;****************************************************************************
; Filename: SETMEM.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.12.25
;  Updated: 1995.03.12 - Updated to conform with DOS32 v3.0
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: PVOID @setmem(PVOID blockptr,ULONG blocksize);
;    Input: Eax, blockptr - memory block pointer
;           Edx, blocksize - memory block size
;   Output: pointer to the first available block or NULL if the block size is
;           too small.
;  Comment: Sets the current work memory block. It returns a pointer
;           to the first available block if the block is large enough (see
;           PALaddalloc for more information). The pointer is of no real use
;           but indicates that the memory block has been added to the heap.
;****************************************************************************

	Include	STDDEF.INC
	Include	"MEMORY.INC"

	Codeseg

Proc	setmem  ,2
		Cmp	Edx,2*Size AllocBlock+Size FreeBlock+MEMALIGN
		Jb	@@Exit02			; Minimum block size
		Mov	[Eax+AllocBlock.BlockSize],Size AllocBlock
		Mov	[Eax+AllocBlock.PrevBlock],0
		Mov	[Eax+AllocBlock.Ident],ALLOCID
		Lea	Ecx,[Eax+Edx-Size AllocBlock]
		Sub	Edx,2*Size AllocBlock
		Mov	[Eax+Size AllocBlock+FreeBlock.PrevBlock],Eax
		Add	Eax,Size AllocBlock
		Mov	[Ecx+AllocBlock.BlockSize],0
		Mov	[Ecx+AllocBlock.Ident],ALLOCID
		Mov	[Ecx+AllocBlock.PrevBlock],Eax
		Mov	[Eax+FreeBlock.BlockSize],Edx
		GetSize	Ecx,Edx
		Mov	Edx,[Ecx]
		Mov	[Ecx],Eax
		Mov	[Eax+FreeBlock.PrevFree],Ecx
		Mov	[Eax+FreeBlock.NextFree],Edx
		Mov	[Edx+FreeBlock.PrevFree],Eax
		Ret
	Align	4
@@Exit02:	Clear	Eax
@@Exit01:	Ret
Endp

	End

