;****************************************************************************
; Filename: STRPBRK.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.20
;  Updated: -
;   
;****************************************************************************
; Copyright Adam Seychell, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: char *strpbrk(const char *s1, const char *s2);
;  Comment: Scans one string for the first occurrence of
;	    any character that is in a second string
;    Input: Eax, pointer to string1
;           Edx, pointer to string2
;   Output: Pointer to first character in s1 that maches a character
;	    appearing in s2. NUL if none maches found.
;****************************************************************************
Include 	STDDEF.INC

	Codeseg

Proc	strpbrk ,2
	Push	Edi,Esi
	Mov	Edi,Eax
	Mov	Esi,Edx
@@Next01:
	Mov	Dl,[Edi]
	Inc	Edi
	TestZ	Dl
	jz @@Error
	Mov	Eax,Esi
	Call	@strchr
	TestZ	Eax
	jz @@Next01
	Lea	Eax,[Edi-1]
	Pop	Esi,Edi
	Ret

@@Error:
	Clear	Eax
	Pop	Esi,Edi
	Ret
Endp

End