IF !DEF(GFXREGSINC)
GFXREGSINC SET 1

; registers and bitmasks
LCD                 EQU $FF40

LCD_ON              EQU $80
LCD_WIN_PAGE1       EQU $40
LCD_WIN_ON          EQU $20
LCD_BG_OBJTILE      EQU $10
LCD_BG_PAGE1        EQU $08
LCD_OBJ_8X16        EQU $04
LCD_OBJ_ON          EQU $02
LCD_BG_ON           EQU $01

LCDBANK             EQU $FF4F
LCDBANK_0           EQU $00
LCDBANK_1           EQU $01

LCDSTAT             EQU $FF41
LCDSTAT_LCDCInt     EQU $40
LCDSTAT_MODEMASK    EQU $03
LCDSTAT_MODEHBLANK  EQU $00
LCDSTAT_MODEVBLANK  EQU $01

BG_Y        EQU $FF42
BG_X        EQU $FF43

LCD_Y       EQU $FF44
LCD_YCOMP   EQU $FF45
LCDC        EQU LCD_YCOMP

BG_BWPAL    EQU $FF47
OBJ_BWPAL0  EQU $FF48
OBJ_BWPAL1  EQU $FF49

BG_CPAL_INDEX   EQU $FF68
BG_CPAL_COLOR   EQU $FF69
OBJ_CPAL_INDEX  EQU $FF6A
OBJ_CPAL_COLOR  EQU $FF6B

WIN_Y       EQU $FF4A
WIN_X       EQU $FF4B

INT_CTRLREG EQU $FFFF
INT_HILOW   EQU $10
INT_SERIAL  EQU $08
INT_TIMER   EQU $04
INT_LCD     EQU $02
INT_VBLANK  EQU $01
INT_LCDC    EQU INT_LCD

TILE_BGOVER  EQU $80
TILE_FLIPY   EQU $40
TILE_FLIPX   EQU $20
TILE_BWPAL   EQU $10
TILE_BANK2   EQU $08
TILE_PAL     EQU $07

; memory addresses
OAM         EQU $FE00
BG_PAGE0    EQU $9800
BG_PAGE1    EQU $9C00
BG_TILES    EQU $9000
SHARED_TILES EQU $8800
OBJ_TILES   EQU $8000


COLOR_RED       EQU $001F
COLOR_GREEN     EQU (COLOR_RED << 5)
COLOR_BLUE      EQU (COLOR_RED << 10)
COLOR_YELLOW    EQU (COLOR_RED+COLOR_GREEN)
COLOR_CYAN      EQU (COLOR_BLUE+COLOR_GREEN)
COLOR_PURPLE    EQU (COLOR_RED+COLOR_BLUE)
COLOR_WHITE     EQU $7FFF
COLOR_GREY      EQU $4210
COLOR_BLACK     EQU $0000
;=============================================================================
ColorDebug:MACRO
    push af
ColorDebug\@:
    ld a, [LCDSTAT]
    bit 1, a
    jr nz, ColorDebug\@
    ld a, $80
    ld [BG_CPAL_INDEX], a
    ld a, \1 & $FF
    ld [BG_CPAL_COLOR], a
    ld a, (\1 >> 8)& $FF
    ld [BG_CPAL_COLOR], a
    pop af
    ENDM
;=============================================================================

ENDC
