;-----------------------------------------------------------------------------
; dummy to create the sound system compact version
;-----------------------------------------------------------------------------
include "base.inc"
include "gfxdef.inc"
include "dmadef.inc"
include "soundsys.inc"
include "tiles.z80"
;=============================================================================

include "music.def"

SECTION "SFXs", CODE
include "sfx.def"
	
SECTION "Test_Main", HOME

MusicSelect:
    ld l, a
    ld h, 0
    add hl, hl
    add hl, hl
    add hl, hl
    ld de, MusicTable
    add hl, de

    ld a, [hli]
    ld [MusicInstrumentBank], a
    ld a, [hli]
    ld [MusicInstrumentBank+1], a
    ld a, [hli]
    ld [MusicInstrumentTable], a
    ld a, [hli]
    ld [MusicInstrumentTable+1], a

    ld a, [hli]
    ld c, a
    ld a, [hli]
    ld b, a
    ld a, [hli]
    ld h, [hl]
    ld l, a
    call Music_Play
    ret

Main:
		Switch2Mhz

		SoundSystemInit

		; setup SFX list
    ld a, BANK(SFX_Table) & $FF
    ld [SoundFXBank], a
    ld a, (BANK(SFX_Table) >> 8) & $FF
    ld [SoundFXBank+1], a
    ld a, SFX_Table & $FF
    ld [SoundFXTable], a
    ld a, (SFX_Table >> 8) & $FF
    ld [SoundFXTable+1], a

		; play first song
		xor a
		call MusicSelect 

		; clear sprites
    ld hl, VOAM
    ld [hl], 80
    inc hl
    ld [hl], 88
    inc hl
    ld [hl], 0
    inc hl
    ld [hl], 0
    inc hl
    ld [hl], 96
    inc hl
    ld [hl], 88
    inc hl
    ld [hl], 0
    inc hl
    ld [hl], 0
    ld c, $A0 - 8
    xor a
clearloop:
    ld [hli], a
    dec c
    jr nz, clearloop

		; copy sprite tiles
    ld de, OBJ_TILES
    ld hl, TileLabel
    ld bc, 32*16
tileloop:
    ld a, [hli]
    ld [de], a
    inc de
    dec bc
    xor a
    or c
    jr nz, tileloop
    or b
    jr nz, tileloop

    ; enable interrupts
    ld a, INT_VBLANK
    ld [INT_CTRLREG], a

    ld a,  0;LCDSTAT_LCDCInt
    ld [LCDSTAT], a

    ld a, %11100100
    ld [BG_BWPAL], a
    ld [OBJ_BWPAL0], a
    ld [OBJ_BWPAL1], a

    xor a
    ld [$FF0F], a

    ei

    ; turn display on
    ld a, LCD_ON | LCD_BG_ON | LCD_OBJ_ON
    ld [LCD], a
	
MainLoop:
    ld a, [VIntFlag]
    or a
    jr z, MainLoop
    xor a
    ld [VIntFlag], a

    ld c, 8
Waitcount:
WaitH1:
    ld a, [LCDSTAT]	
    bit 1, a
    jr z, WaitH1
WaitH2:
    ld a, [LCDSTAT]	
    bit 1, a
    jr nz, WaitH2
    dec c
    jr nz, Waitcount

    ld a, %01011010
    ld [BG_BWPAL], a
    ld a, $80
    ld [BG_CPAL_INDEX], a
    ld [BG_CPAL_COLOR], a
    ld [BG_CPAL_COLOR], a

    SoundSystemFrameProcess

WaitH4:
    ld a, [LCDSTAT]	
    bit 1, a
    jr nz, WaitH4

    ld a, %11100100
    ld [BG_BWPAL], a
    ld a, $80
    ld [BG_CPAL_INDEX], a
    ld a, $FF
    ld [BG_CPAL_COLOR], a
    ld [BG_CPAL_COLOR], a

		
    call ReadInputs

		ld a, [GamePad_Presses]
		bit PAD_RIGHT, a
		call nz, Inc_Music
		ld a, [GamePad_Presses]
		bit PAD_LEFT, a
		call nz, Dec_Music
		ld a, [GamePad_Presses]
		bit PAD_UP, a
		call nz, Inc_Sfx
		ld a, [GamePad_Presses]
		bit PAD_DOWN, a
		call nz, Dec_Sfx

		ld a, [GamePad_Presses]
		bit PAD_START, a
		jp z, skip_MusicStop
		MusicStop
skip_MusicStop:

		ld a, [GamePad_Presses]
		bit PAD_A, a
		ld a, [VOAM+2]
		call nz, MusicSelect

		ld a, [GamePad_Presses]
		bit PAD_SELECT, a
		jp z, skip_SFXStop
		SFXStop
skip_SFXStop:
		
		ld a, [GamePad_Presses]
		bit PAD_B, a
		ld a, [VOAM+6]
		ld l, 0
		jp z, skip_SFX_Play
		; normally should use the macro SFXPlay SFX_NUMBER_HERE
		fcall SFX_Play
skip_SFX_Play:

    jp MainLoop

Inc_Music:
        ld a, [VOAM+2]
        inc a
        and 31
        ld [VOAM+2], a
        ret
Dec_Music:
        ld a, [VOAM+2]
        dec a
        and 31
        ld [VOAM+2],a
        ret
Inc_Sfx:
        ld a, [VOAM+6]
        inc a
        and 31
        ld [VOAM+6],a
        ret
Dec_Sfx:
        ld a, [VOAM+6]
        dec a
        and 31
        ld [VOAM+6],a
        ret

