;-----------------------------------------------------------------------------
; dummy to create the sound system compact version
;-----------------------------------------------------------------------------
include "main.inc"
include "../gfxdef.inc"
include "sndsys_c.inc"
include "../multibnk/tiles.z80"
;-----------------------------------------------------------------------------
SECTION "Base", HOME[$0000]

RST_00:	jp	Start
	DS	5
RST_08:	jp	Start
	DS	5
RST_10:	jp	Start
	DS	5
RST_18:	jp	Start
	DS	5
RST_20:	jp	Start
	DS	5
RST_28:	jp	Start
	DS	5
RST_30:	jp	Start
	DS	5
RST_38:	jp	Start
	DS	5
	jp	irq_VBlank
	DS	5
        jp      LCDCInt_jp
	DS	5
	jp	irq_Timer
	DS	5
	jp	irq_Serial
	DS	5
	jp	irq_HiLo
        ;DS      5

        ;DS      $100-$68
SECTION "Base2", HOME[$0100]
Start:
	nop
	jp	BaseStart

	DB	$CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83,$00,$0C,$00,$0D
	DB	$00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6,$DD,$DD,$D9,$99
	DB	$BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E

		;0123456789ABCDE
	DB	GAME_NAME
        DB      COLOR_FLAG
	DW	LICENSEE_CODE
        DB      SUPERGB_FLAG
	DB	CART_TYPE

	DB	CART_ROMSIZE

	DB	CART_RAMSIZE

	DB	LANG_CODE
	DB	$33	;Manufacturer

	DB	0	;Version
	DB	0	;Complement check
	DW	0	;Checksum

;=============================================================================

SECTION "MusicTable", CODE
include "music.def"

SECTION "SFXs", CODE
include "sfx.def"
	
SECTION "Test_Main", HOME

Main:
	Switch2Mhz

	call Audio_Init
    
	xor a
	call Audio_Music_Play

    ld hl, VOAM
    ld [hl], 80
    inc hl
    ld [hl], 88
    inc hl
    ld [hl], 0
    inc hl
    ld [hl], 0
    inc hl
    ld [hl], 96
    inc hl
    ld [hl], 88
    inc hl
    ld [hl], 0
    inc hl
    ld [hl], 0
    ld c, $A0 - 8
    xor a
clearloop:
    ld [hli], a
    dec c
    jr nz, clearloop

    ld de, OBJ_TILES
    ld hl, TileLabel
    ld bc, 32*16
tileloop:
    ld a, [hli]
    ld [de], a
    inc de
    dec bc
    xor a
    or c
    jr nz, tileloop
    or b
    jr nz, tileloop

    ; enable interrupts
    ld a, INT_VBLANK
    ld [INT_CTRLREG], a

    ld a,  0;LCDSTAT_LCDCInt
    ld [LCDSTAT], a

    ld a, %11100100
    ld [BG_BWPAL], a
    ld [OBJ_BWPAL0], a
    ld [OBJ_BWPAL1], a

    xor a
    ld [$FF0F], a

    ei

    ; turn display on
    ld a, LCD_ON | LCD_BG_ON | LCD_OBJ_ON
    ld [LCD], a
	
MainLoop:
    ld a, [VIntFlag]
    or a
    jr z, MainLoop
    xor a
    ld [VIntFlag], a

    ld c, 8
Waitcount:
WaitH1:
    ld a, [LCDSTAT]	
    bit 1, a
    jr z, WaitH1
WaitH2:
    ld a, [LCDSTAT]	
    bit 1, a
    jr nz, WaitH2
    dec c
    jr nz, Waitcount

    ld a, %01011010
    ld [BG_BWPAL], a
    ld a, $80
    ld [BG_CPAL_INDEX], a
    ld [BG_CPAL_COLOR], a
    ld [BG_CPAL_COLOR], a

    call Audio_FrameProcess

WaitH4:
    ld a, [LCDSTAT]	
    bit 1, a
    jr nz, WaitH4

    ld a, %11100100
    ld [BG_BWPAL], a
    ld a, $80
    ld [BG_CPAL_INDEX], a
    ld a, $FF
    ld [BG_CPAL_COLOR], a
    ld [BG_CPAL_COLOR], a

    call ReadInputs

    ld a, [GamePad_Presses]
    bit PAD_RIGHT, a
    call nz, Inc_Music
    ld a, [GamePad_Presses]
    bit PAD_LEFT, a
    call nz, Dec_Music
    ld a, [GamePad_Presses]
    bit PAD_UP, a
    call nz, Inc_Sfx
    ld a, [GamePad_Presses]
    bit PAD_DOWN, a
    call nz, Dec_Sfx

    ld a, [GamePad_Presses]
    bit PAD_START, a
    call nz, Audio_Music_Stop

    ld a, [GamePad_Presses]
    bit PAD_A, a
    ld a, [VOAM+2]
    call nz, Audio_Music_Play

    ld a, [GamePad_Presses]
    bit PAD_SELECT, a
    call nz, Audio_SFX_Stop
    ld a, [GamePad_Presses]
    bit PAD_B, a
    ld a, [VOAM+6]
    ld l, 0
    call nz, Audio_SFX_Play

    jp MainLoop

Inc_Music:
        ld a, [VOAM+2]
        inc a
        and 31
        ld [VOAM+2], a
        ret
Dec_Music:
        ld a, [VOAM+2]
        dec a
        and 31
        ld [VOAM+2],a
        ret
Inc_Sfx:
        ld a, [VOAM+6]
        inc a
        and 31
        ld [VOAM+6],a
        ret
Dec_Sfx:
        ld a, [VOAM+6]
        dec a
        and 31
        ld [VOAM+6],a
        ret
;=============================================================================
SECTION "Base1", HOME
;-----------------------------------------------------------------------------
; --
; -- Initialize the Gameboy
; --

BaseStart:
    ; disable interrupts
    di

    ; save gb type value
    ld [Stack], a

    ; stack
    ld	hl,StackTop-1
    ld	sp,hl

    call DisplayOff

    ; clear ram (except stack)
    ld hl, StackTop
    ld a, $E0
    sub h
    ld b, a
    dec b
    ld c, 0
clearramloop:
    ld a, [hl]
    add e
    ld e, a
    xor a
    ld [hli], a
    dec c
    jr nz, clearramloop
    dec b
    jr nz, clearramloop

    ; clear voam
    ld hl, VOAM
    ld c, $A0
clearvoamloop:
    ld a, [hl]
    add d
    ld d, a
    xor a
    ld [hli], a
    dec c
    jr nz, clearvoamloop

    ; clear hi ram
    ld hl, $FF80
    ld b, $7F
clearhiramloop:
    ld a, [hl]
    add d
    ld d, a
    xor a
    ld [hli], a
    dec b
    jr nz, clearhiramloop

    ld a, e
    ld [RND], a
    ld a, d
    ld [RND+1], a

    ; save gb type
    ld a, [Stack]
    cp GBTYPE_POCKET
    jr nz, GBtypeOk
    ld a, $01
GBtypeOk:
    ld [GBType], a

    ; copy dma routine
    ld HL, OAM_DMA_RoutineImage
    ld a, OAM_DMA_RoutineEND & $FF
    sub l
    ld b, a
    ld c, $80
copydmaloop:
    ld a, [HLI]
    ld [C], A
    inc c
	dec b
    jr nz, copydmaloop

    ; prepare interrupt vectors
    ld a, $C3
    ld hl, VInt_jp
    ld [hli], a
    ld a, VInt_ret & $FF
    ld [hli], a
    ld a, (VInt_ret >> 8) & $FF
    ld [hli], a
    ld a, $C3
    ld hl, LCDCInt_jp
    ld [hli], a
    ld a, irq_LCDC & $FF
    ld [hli], a
    ld a, (irq_LCDC >> 8) & $FF
    ld [hli], a

    ; set internal RAM bank
    ld a, 1
    ld [intRAMBank], a
    ld [RAM_BANK], a

    ; disable vblanc int
    ld a, 0
    ld [$FFFF], a

    jp Main

OAM_DMA_RoutineImage:
      ld a, VOAM >> 8
      ld [$ff46],a
      ld a, $28
DMAWait:
      dec a
      jr nz,DMAWait
      ret
OAM_DMA_RoutineEND:

;=============================================================================
; always-good-to-have-ready tools & stuff
;=============================================================================
SECTION "BaseTools1", HOME

DisplayOff:
        ld a, [$FF40]
        or a
        ret z         ; already off
DisplayOff_waitv1:
	ld a, [$FF41]
	and $03
	cp $01
	jp z, DisplayOff_waitv1
DisplayOff_waitv2:
	ld a, [$FF41]
	and $03
	cp $01
	jp nz, DisplayOff_waitv2
	ld a, 0
	ld [$FF40], a
        ret

;-----------------------------------------------------------------------------
SECTION "BaseTools4", HOME
ReadInputs:
    	; read pad
        LD a, [GamePad_New]
        ld e, a

        LD A, %00010000
        LD [$FF00], A
        LD A, [$FF00]
        LD A, [$FF00]
        AND $0F
        LD B, A
    	LD A, %00100000
        LD [$FF00], A
        LD [$FF00], A
        LD [$FF00], A
        SWAP B
        LD A, [$FF00]
        AND $0F
        OR B
	    CPL
        ld b, a
        ld hl, GamePad_New
        LD [hli], A
        xor e
        ld [hli], A
        ld c, a
        and b
        ld [hli], A
        ld a, e
        and c
        ld [hl], A

	    LD A, %00110000
        LD [$FF00], A
        ret

;-----------------------------------------------------------------------------
SECTION "BaseTools5", HOME
irq_VBlank:
        push af
        push bc
        push de
        push hl

        call OAM_DMA_Routine

        ld hl, VIntFlag
        inc [hl]
        inc l
        inc [hl] ; VIntCounter

        jp VInt_jp
VInt_ret:

        pop hl
        pop de
        pop bc
        pop af
    	reti
SECTION "BaseTools6", HOME
;-----------------------------------------------------------------------------
irq_LCDC:
        reti
SECTION "BaseTools7", HOME
;-----------------------------------------------------------------------------
irq_Timer:	reti
SECTION "BaseTools8", HOME
;-----------------------------------------------------------------------------
irq_Serial:	reti
SECTION "BaseTools9", HOME
;-----------------------------------------------------------------------------
irq_HiLo:	reti
;=============================================================================
SECTION	"StartupVars",BSS[$C000]

VOAM:      DS $A0
Stack:	   DS MAINSTACK_SIZE
StackTop:
