; Call once to initialize audio system
; IN: -
; OUT: -
; Registers trashed: ALL
Audio_Init               EQU $4000

; Call once per frame to process audio
; IN: -
; OUT: -
; Registers trashed: ALL
Audio_FrameProcess       EQU $4003

; Start playing music
; IN: A=song number
; OUT: -
; Registers trashed: AF
Audio_Music_Play         EQU $4006

; Stop (pause) music
; IN: -
; OUT: -
; Registers trashed: AF
Audio_Music_Stop         EQU $4009

; Resume music (after Audio_Music_Stop)
; IN: -
; OUT: -
; Registers trashed: AF
Audio_Music_Resume       EQU $400C

; Play a sound effect
; IN: A=SFX number, L=Note (0 to 71 (decimal), 0=C1, 1=C#1, 2=D1 .. 71=B6)
; OUT: -
; Registers trashed: AF
Audio_SFX_Play           EQU $400F

; Stop all sound effects playing
; IN: -
; OUT: -
; Registers trashed: AF
Audio_SFX_Stop           EQU $4012


; Lock/Unlock channel 3
; (use to prevent player from using channel 3, allowing for your routines
; to play digital audio on the channel)
;
; IN: -
; OUT: -
; Registers trashed: AF

Audio_SFX_LockChnl3      EQU $4015

Audio_SFX_UnlockChnl3    EQU $4018


; area to reserve to sound system
Audio_RAM     EQU $DF80
Audio_RAMSIZE EQU $0080

; variables
Audio_Flag    EQU Audio_RAM   ; arbitrary flag from music
                              ; (command Zxx in the tracker)

