;----------------------------------------------------------------------------------------
; rv6502's GB sound system V1.1
; Copyright 1999-2014 Stephane Hockenhull
;
; main player code HOME
;
; fx table HOME[$3EB8]
; music cmd table HOME[$3F00]
; Inst1 cmd table HOME[$3EE8]
; Inst2 cmd table HOME[$3F28]
; Inst3 cmd table HOME[$3F40]
; Inst4 cmd table HOME[$3F58]
; Frequency table HOME[$3F70]
;
; memory BSS[$DF80]
;
;
;----------------------------------------------------------------------------------------

include "project.def"
include MBCINCFILE

IF DEF(SCOPEENABLE)
PRINTT "WARNING: Scopes ON"
GLOBAL Scopes
GLOBAL MusicPlayMode
ENDC

IF !DEF(SOUNDSYSTEM_RAMBANK)
SOUNDSYSTEM_RAMBANK EQU 0
ENDC

GLOBAL SSFP_RET

Chnl1_Env       EQU $FF12
Chnl2_Env       EQU $FF17
Chnl3_Vol       EQU $FF1C
Chnl4_Env       EQU $FF21

Chnl1_Freq      EQU $FF13
Chnl2_Freq      EQU $FF18
Chnl3_Freq      EQU $FF1D
Chnl4_FDiv      EQU $FF22

Chnl1_Len       EQU $FF11
Chnl2_Len       EQU $FF16
Chnl3_Len       EQU $FF1B
Chnl4_Len       EQU $FF20

;----------------------------------------------------------------------------------------
; Data
;----------------------------------------------------------------------------------------

IF COLOR_FLAG==COLOR_FLAG_BW
SECTION "SoundSystemData", BSS[SoundSystem_RAM_START]
DS SoundSystem_RAM_END-SoundSystem_RAM_START
ENDC
;----------------------------------------------------------------------------------------
; Sound System Code
;----------------------------------------------------------------------------------------
SECTION "SoundSystemMoveableCode", CODE

include "soundsys.inc"
include "base.inc"

SoundSystem_MOVABLECODE_START:

; initialize the sound system
SoundSystem_Init:
        ; set all channels to stopped samples
        push HL
        push bc
        push de
        push AF

        ; switch to player memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, SOUNDSYSTEM_RAMBANK
            ld [RAM_BANK], a
        ENDC

        ld HL, MusicSFXInstPtr
        ld e, 4
SoundSystem_Init_ptrloop:
        ld A, Music_InstrumentEnd & $FF
        ld [hli], A
        ld a, (Music_InstrumentEnd >> 8) & $FF
        ld [hli], A
        dec e
        jr nz, SoundSystem_Init_ptrloop

        ; set all channels to volume 8
        ld a, $80
        ld hl, ChannelVols
        ld [hli], a
        ld [hli], a
        ld [hli], a
        ld [hli], a

        ld a, 255
        ld hl, SoundFXStart
        ld [hli], a
        ld [hli], a
        ld [hli], a
        ld [hli], a
        ld [SoundFXLock], a
        ld [MusicSFXPanning], a
        ld [MusicSFXInstChnl3WaveID], a

        xor a
        ld hl, ChannelMusicEffects
        ld [hli], a
        ld [hli], a
        ld [hli], a
        ld [hli], a
        ld [MusicSFXInstChnl3Lock], a

        ; enable sound
        ld a, $F1
        ld [$FF26], a

        ;chnl 1
        ld a, $00
        ld [$FF10], a

        ; all channels off
        call Music_Stop

        ; general
        ld a, $77
        ld [$FF24], a
        ld a, $FF
        ld [$FF25], a

        ;restore memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, [intRAMBank]
            ld [RAM_BANK], a
        ENDC

        pop AF
        pop de
        pop bc
        pop HL
        ret

;----------------------------------------------------------------------------------------
; Sound FX Code
;----------------------------------------------------------------------------------------
; request that sound system play soundfx index 'A'
SFX_Play:

        ; switch to player memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            push af
            ld a, SOUNDSYSTEM_RAMBANK
            ld [RAM_BANK], a
            pop af
        ENDC

        push hl
        push bc
        push af
        ld hl, SoundFXStart
        ld c, 4
SFX_Play_multi:
        ld a, [hl]
        xor $FF
        jr z, SFX_Play_multifound
        inc hl
        dec c
        jr nz, SFX_Play_multi

SFX_Play_multifound:
        pop af
        ld [hl], A
        pop bc
        pop hl
        ld a, l
        ld [SoundFXNote], A

        ;restore memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, [intRAMBank]
            ld [RAM_BANK], a
        ENDC

        ret

; lock channel 3
SFX_LockChnl3:
        ld a, 1
        ld [MusicSFXInstChnl3Lock], a
        ld a, [SoundFXLock]
        and %10111011
        ld [SoundFXLock], a
        ld A, Music_InstrumentEnd & $FF
        ld [MusicSFXInstPtr], A
        ld a, (Music_InstrumentEnd >> 8) & $FF
        ld [MusicSFXInstPtr+1], a
        ret

; unlock channel 3
SFX_UnlockChnl3:
        xor a
        ld [MusicSFXInstChnl3Lock], a
        ld a, [SoundFXLock]
        or %01000100
        ld [SoundFXLock], a
        ret


; stop all sfx (turn off all sfx used channels)
SFX_Stop:
        ; switch to player memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, SOUNDSYSTEM_RAMBANK
            ld [RAM_BANK], a
        ENDC

        ; turn off channels used by sfx

        ld a, [SoundFXLock]
        ld b, a
        ld c, $80

        bit 0, b
        jr nz, Music_Stop_nosfx1
        xor a
        ld [Chnl1_Env], a
        ld a, c
        ld [Chnl1_Freq+1], a
        ld hl, MusicSFXInstPtr
        ld [hl], (Music_InstrumentEnd & $FF)
        inc l
        ld [hl], ((Music_InstrumentEnd >> 8) & $FF)
Music_Stop_nosfx1:

        bit 1, b
        jr nz, Music_Stop_nosfx2
        xor a
        ld [Chnl2_Env], a
        ld a, c
        ld [Chnl2_Freq+1], a
        ld hl, MusicSFXInstPtr + 2
        ld [hl], (Music_InstrumentEnd & $FF)
        inc l
        ld [hl], ((Music_InstrumentEnd >> 8) & $FF)
Music_Stop_nosfx2:

        bit 2, b
        jr nz, Music_Stop_nosfx3
        ld a, [MusicSFXInstChnl3Lock]
        or a
        jp nz, Music_Stop_nosfx3
        ;xor a
        ld [$FF1A], a
        ld hl, MusicSFXInstPtr + 4
        ld [hl], (Music_InstrumentEnd & $FF)
        inc l
        ld [hl], ((Music_InstrumentEnd >> 8) & $FF)
Music_Stop_nosfx3:

        bit 3, b
        jr nz, Music_Stop_nosfx4
        xor a
        ld [Chnl4_Env], a
        ld a, c
        ld [Chnl4_FDiv+1], a
        ld hl, MusicSFXInstPtr + 6
        ld [hl], (Music_InstrumentEnd & $FF)
        inc l
        ld [hl], ((Music_InstrumentEnd >> 8) & $FF)
Music_Stop_nosfx4:

        ;restore memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, [intRAMBank]
            ld [RAM_BANK], a
        ENDC

        ret

; stop music
Music_Stop:
        push af
        push bc
        push hl

        ; switch to player memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, SOUNDSYSTEM_RAMBANK
            ld [RAM_BANK], a
        ENDC

        ; stop player
        ld a, 0
        ld [MusicPlayMode], A

        ; turn off channels used by music

        ld a, [SoundFXLock]
        ld b, a
        ld c, $80

        bit 0, b
        jr z, Music_Stop_nomusic1
        xor a
        ld [Chnl1_Env], a
        ld a, c
        ld [Chnl1_Freq+1], a
        ld hl, MusicSFXInstPtr
        ld [hl], (Music_InstrumentEnd & $FF)
        inc l
        ld [hl], ((Music_InstrumentEnd >> 8) & $FF)
Music_Stop_nomusic1:

        bit 1, b
        jr z, Music_Stop_nomusic2
        xor a
        ld [Chnl2_Env], a
        ld a, c
        ld [Chnl2_Freq+1], a
        ld hl, MusicSFXInstPtr + 2
        ld [hl], (Music_InstrumentEnd & $FF)
        inc l
        ld [hl], ((Music_InstrumentEnd >> 8) & $FF)
Music_Stop_nomusic2:

        bit 2, b
        jr z, Music_Stop_nomusic3
        xor a
        ld [$FF1A], a
        ld hl, MusicSFXInstPtr + 4
        ld [hl], (Music_InstrumentEnd & $FF)
        inc l
        ld [hl], ((Music_InstrumentEnd >> 8) & $FF)
Music_Stop_nomusic3:

        bit 3, b
        jr z, Music_Stop_nomusic4
        xor a
        ld [Chnl4_Env], a
        ld a, c
        ld [Chnl4_FDiv+1], a
        ld hl, MusicSFXInstPtr + 6
        ld [hl], (Music_InstrumentEnd & $FF)
        inc l
        ld [hl], ((Music_InstrumentEnd >> 8) & $FF)
Music_Stop_nomusic4:

        ;restore memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, [intRAMBank]
            ld [RAM_BANK], a
        ENDC

        pop hl
        pop bc
        pop af
        ret

; resume music player
Music_Resume:
        push af

        ; switch to player memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, SOUNDSYSTEM_RAMBANK
            ld [RAM_BANK], a
        ENDC

        ; resume player
        ld a, 1
        ld [MusicPlayMode], A

        ;restore memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, [intRAMBank]
            ld [RAM_BANK], a
        ENDC

        pop af
        ret


SoundSystem_MOVABLECODE_END:
SECTION "SoundSystemHomeCode", HOME
SoundSystem_HOMECODE_START:

; dummy instrument to init all intrument pointers with
Music_InstrumentEnd: DB MUSIC_INSTCMD_X_END

; called every frame for sound processing
SoundSystem_FrameProcess:

        ; switch to player memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, SOUNDSYSTEM_RAMBANK
            ld [RAM_BANK], a
        ENDC

        ; -- SFX Start process
        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, SoundFXBank
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [SoundFXBank]
            ld c, a
        ENDC
        MBC_SelectRom
        push bc

        ld hl, SoundFXStart
        ld c, 4
SSFP_multi_sfx:
        ld a, [hl]
        push hl
        push bc

        xor $FF
        jp z, SSFP_NoNewSFX
        ; lock & update SFX
        cpl
        ; calculate table plus index address
        ld b, a ;save
        ld a, [SoundFXTable]
        ld e, a
        ld a, [SoundFXTable+1]
        ld d, a
        ld a, b ;restore
        ld b, 0
        add a
        RL b
        add a
        RL b
        add a ; 4 WORDs
        RL b
        add e
        ld l, a
        ld a, 0
        adc d
        add b
        ld h, a

        push hl
        ld a, [SoundFXNote]
        add a
        add (FrequencyTable & $FF)
        ld l, a
        ld h, ((FrequencyTable >> 8)& $FF)

        ld a, [hli]
        ld [Temp], a
        ld a, [hl]
        ld [Temp+1], a   ; store note freq
        pop hl

        ; update SoundFXLock
        ld a, [SoundFXLock]
        ld d, a

        ; load
        ld a, [hli]
        ld c, a
        ld a, [hli]
        ld b, a
        or c
        jp z, SSFP_NoSFXChnl_1
        ld a,  c
        ld [MusicSFXInstPtr], a
        ld a,  b
        ld [MusicSFXInstPtr+1], a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            push hl
            ld hl, SoundFXBank
            ld a, [hli]
            ld [MusicSFXInstBank+0*2], a
            ld a, [hl]
            ld [MusicSFXInstBank+0*2+1], a
            pop hl
        ELSE
            ld a, [SoundFXBank]
            ld [MusicSFXInstBank+0*2], a
        ENDC

        ld a, [Temp]
        ld [ChannelFreqs+0], a
        ld a, [Temp+1]
        ld [ChannelFreqs+1], a

        ld a, d
        and %11101110
        ld d, a
        ld a, 1    ; set counter to immediate start
        ld [MusicSFXInstPause], a
SSFP_NoSFXChnl_1:

        ; load
        ld a, [hli]
        ld c, a
        ld a, [hli]
        ld b, a
        or c
        jp z, SSFP_NoSFXChnl_2
        ld a,  c
        ld [MusicSFXInstPtr+2], a
        ld a,  b
        ld [MusicSFXInstPtr+3], a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            push hl
            ld hl, SoundFXBank
            ld a, [hli]
            ld [MusicSFXInstBank+1*2], a
            ld a, [hl]
            ld [MusicSFXInstBank+1*2+1], a
            pop hl
        ELSE
            ld a, [SoundFXBank]
            ld [MusicSFXInstBank+1*2], a
        ENDC

        ld a, [Temp]
        ld [ChannelFreqs+2], a
        ld a, [Temp+1]
        ld [ChannelFreqs+3], a

        ld a, d
        and %11011101
        ld d, a
        ld a, 1    ; set counter to immediate start
        ld [MusicSFXInstPause+1], a
SSFP_NoSFXChnl_2:
        ; load
        ld a, [hli]
        ld c, a
        ld a, [hli]
        ld b, a
        or c
        jp z, SSFP_NoSFXChnl_3
        ld a, [MusicSFXInstChnl3Lock]
        or a
        jp nz, SSFP_NoSFXChnl_3
        ld a,  c
        ld [MusicSFXInstPtr+4], a
        ld a,  b
        ld [MusicSFXInstPtr+5], a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            push hl
            ld hl, SoundFXBank
            ld a, [hli]
            ld [MusicSFXInstBank+2*2], a
            ld a, [hl]
            ld [MusicSFXInstBank+2*2+1], a
            pop hl
        ELSE
            ld a, [SoundFXBank]
            ld [MusicSFXInstBank+2*2], a
        ENDC

        ld a, [Temp]
        ld [ChannelFreqs+4], a
        ld a, [Temp+1]
        ld [ChannelFreqs+5], a

        ld a, d
        and %10111011
        ld d, a
        ld a, 1    ; set counter to immediate start
        ld [MusicSFXInstPause+2], a
SSFP_NoSFXChnl_3:
        ; load
        ld a, [hli]
        ld c, a
        ld a, [hli]
        ld b, a
        or c
        jp z, SSFP_NoSFXChnl_4
        ld a,  c
        ld [MusicSFXInstPtr+6], a
        ld a,  b
        ld [MusicSFXInstPtr+7], a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)        
            ld hl, SoundFXBank
            ld a, [hli]
            ld [MusicSFXInstBank+3*2], a
            ld a, [hl]
            ld [MusicSFXInstBank+3*2+1], a
        ELSE
            ld a, [SoundFXBank]
            ld [MusicSFXInstBank+3*2], a
        ENDC

        ld a, d
        and %01110111
        ld d, a
        ld a, 1    ; set counter to immediate start
        ld [MusicSFXInstPause+3], a
SSFP_NoSFXChnl_4:

        pop bc
        pop hl
        ; update SoundFXLock
        ld a, d
        ld [SoundFXLock], a

        ; de-flag sfx start
        ld a, $FF
        ld [hli], a
        dec c
        jp nz, SSFP_multi_sfx
        jr SSFP_NewSFXDone
SSFP_NoNewSFX:
        add sp, 4
SSFP_NewSFXDone:

        ; instruments and SFX process
        ld HL, MusicSFXInstPause
        dec [hl]
        jr  nz, SSFP_Inst1UpdateDone

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicSFXInstBank+0*2
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicSFXInstBank+0*2]
        ENDC
        MBC_SelectRomQuick

        ld hl, MusicSFXInstPtr
        ld a, [hli]
        ld d, [hl]
        ld e, a
        jp SSFP_Inst1Update
SSFP_Inst1UpdateFrameEnd:
        ; save back
        ld hl, MusicSFXInstPtr
        ld a, e
        ld [hli], a
        ld [hl], d
SSFP_Inst1UpdateDone:

        ld HL, MusicSFXInstPause+1
        dec [hl]
        jr  nz, SSFP_Inst2UpdateDone

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicSFXInstBank+1*2
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicSFXInstBank+1*2]
        ENDC
        MBC_SelectRomQuick

        ld hl, MusicSFXInstPtr+2
        ld a, [hli]
        ld d, [hl]
        ld e, a
        jp SSFP_Inst2Update
SSFP_Inst2UpdateFrameEnd:
        ; save back
        ld hl, MusicSFXInstPtr+2
        ld a, e
        ld [hli], a
        ld [hl], d
SSFP_Inst2UpdateDone:

        ld HL, MusicSFXInstPause+2
        dec [hl]
        jr  nz, SSFP_Inst3UpdateDone

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicSFXInstBank+2*2
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicSFXInstBank+2*2]
        ENDC
        MBC_SelectRomQuick

        ld hl, MusicSFXInstPtr+4
        ld a, [hli]
        ld d, [hl]
        ld e, a
        jp SSFP_Inst3Update
SSFP_Inst3UpdateFrameEnd:
        ; save back
        ld hl, MusicSFXInstPtr+4
        ld a, e
        ld [hli], a
        ld [hl], d
SSFP_Inst3UpdateDone:

        ld HL, MusicSFXInstPause+3
        dec [hl]
        jr  nz, SSFP_Inst4UpdateDone

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicSFXInstBank+3*2
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicSFXInstBank+3*2]
        ENDC
        MBC_SelectRomQuick

        ld HL, MusicSFXInstPtr+6
        ld a, [hli]
        ld d, [hl]
        ld e, a
        jp SSFP_Inst4Update
SSFP_Inst4UpdateFrameEnd:
        ; save back
        ld hl, MusicSFXInstPtr+6
        ld a, e
        ld [hli], a
        ld [hl], d
SSFP_Inst4UpdateDone:


        ; -- Music update process
        ld a, [MusicPlayMode]
        or a
        jp z, SSFP_MusicOff

        ; music effects process
        ld a, [ChannelMusicEffects]
        or a
        jr z, SSFP_MusicFX_Done1

        ; check if sound effect active (no music fx then)
        ld b, a
        ld a, [SoundFXLock]
        bit 0, a
        jr z, SSFP_MusicFX_Done1
        ld a, b

        ld hl, SSFP_MusicFX_JumpTable1
        add a
        add l
        ld l, a
        ld a, [hli]
        ld h, [hl]
        ld l, a
        jp [hl]
SSFP_MusicFX_Done1:
        ld a, [ChannelMusicEffects+1]
        or a
        jr z, SSFP_MusicFX_Done2

        ; check if sound effect active (no music fx then)
        ld b, a
        ld a, [SoundFXLock]
        bit 1, a
        jr z, SSFP_MusicFX_Done2
        ld a, b

        ld hl, SSFP_MusicFX_JumpTable2
        add a
        add l
        ld l, a
        ld a, [hli]
        ld h, [hl]
        ld l, a
        jp [hl]
SSFP_MusicFX_Done2:
        ld a, [ChannelMusicEffects+2]
        or a
        jr z, SSFP_MusicFX_Done3

        ; check if sound effect active (no music fx then)
        ld b, a
        ld a, [SoundFXLock]
        bit 2, a
        jr z, SSFP_MusicFX_Done3
        ld a, b

        ld hl, SSFP_MusicFX_JumpTable3
        add a
        add l
        ld l, a
        ld a, [hli]
        ld h, [hl]
        ld l, a
        jp [hl]
SSFP_MusicFX_Done3:

        ; *** update music

        ld a, [MusicNextFrame]
        dec a
        ld [MusicNextFrame], a
        jp nz, SSFP_MusicNoUpdate

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicCommandBank
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicCommandBank]
        ENDC
        MBC_SelectRomQuick

        ld hl, MusicCommandPtr
        ld a, [hli]
        ld e, a
        ld d, [hl]

SSFP_MusicUpdate:
        ld a, [de]
        inc de
        ld hl, SSFP_Music_JumpTable
        add a
        add l
        ld l, a
        ld a, [hli]
        ld h, [hl]
        ld l, a
        jp [hl]
SSFP_MusicUpdateFrameEnd:
        ld hl, MusicCommandPtr
        ld a, e
        ld [hli], a
        ld [hl], d

SSFP_MusicNoUpdate:


SSFP_MusicOff:

        ; done

        pop bc
        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
        ELSE
            ld a, c
        ENDC
        MBC_SelectRomQuick

        ;restore memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, [intRAMBank]
            ld [RAM_BANK], a
        ENDC

SSFP_RET:
        ret

;----------------------------------------------------------------------------------------
; MusicFX Code
;----------------------------------------------------------------------------------------
SSFP_MUSIC_FX1_VIB1:
    ld hl, ChannelFreqs+0*2
    ld a, [hl]
    add 1
    ld [hli], a
    ld [Chnl1_Freq], a
    ld a, [hl]
    adc 0
    and $07
    ld [hl],a
    ld [Chnl1_Freq+1], a

    ld hl, ChannelMusicFXParam+0*2+1
    ld a, [hl]
    dec a
    ld [hld], a
    jp nz, SSFP_MusicFX_Done1
    ld a, [hli]
    ld [hl], a
    ld a, MUSIC_FX_VIB2

    ld [ChannelMusicEffects+0], a
    jp SSFP_MusicFX_Done1

SSFP_MUSIC_FX1_VIB2:
    ld hl, ChannelFreqs+0*2
    ld a, [hl]
    add $FF
    ld [hli], a
    ld [Chnl1_Freq], a
    ld a, [hl]
    adc $FF
    and $07
    ld [hl],a
    ld [Chnl1_Freq+1], a
    ld hl,ChannelMusicFXParam+0*2+1
    ld a, [hl]
    dec a
    ld [hld], a
    jp nz, SSFP_MusicFX_Done1
    ld a, [hli]
    ld [hl], a
    ld a, MUSIC_FX_VIB1
    ld [ChannelMusicEffects+0], a
    jp SSFP_MusicFX_Done1

IF DEF(MUSIC_FX_DUALFREQ1)
SSFP_MUSIC_FX1_DUALFREQ1:
    ld hl, ChannelMusicFXParam+0*2
    ld a, [hli]
    ld [Chnl1_Freq], a
    ld a, [hl]
    ld [Chnl1_Freq+1], a

    ld a, MUSIC_FX_DUALFREQ2
    ld [ChannelMusicEffects+0], a
    jp SSFP_MusicFX_Done1

SSFP_MUSIC_FX1_DUALFREQ2:
    ld hl, ChannelFreqs+0*2
    ld a, [hli]
    ld [Chnl1_Freq], a
    ld a, [hl]
    ld [Chnl1_Freq+1], a

    ld a, MUSIC_FX_DUALFREQ1
    ld [ChannelMusicEffects+0], a
    jp SSFP_MusicFX_Done1
ENDC

SSFP_MUSIC_FX1_TF1:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+0]
    ld c, a
    ld a, [ChannelMusicFXParam+0*2+0]
    add c
    cp 6*12
    jp c, SSFP_MUSIC_FX1_TF1_noteok
    ld a, 6*12-1
SSFP_MUSIC_FX1_TF1_noteok:
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl1_Freq], a
    ld a, [hl]
    ld [Chnl1_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ2
    ld [ChannelMusicEffects+0], a
    jp SSFP_MusicFX_Done1

SSFP_MUSIC_FX1_TF2:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+0]
    ld c, a
    ld a, [ChannelMusicFXParam+0*2+1]
    add c
    cp 6*12
    jp c, SSFP_MUSIC_FX1_TF2_noteok
    ld a, 6*12-1
SSFP_MUSIC_FX1_TF2_noteok:
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl1_Freq], a
    ld a, [hl]
    ld [Chnl1_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ3
    ld [ChannelMusicEffects+0], a
    jp SSFP_MusicFX_Done1

SSFP_MUSIC_FX1_TF3:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+0]
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl1_Freq], a
    ld a, [hl]
    ld [Chnl1_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ1
    ld [ChannelMusicEffects+0], a
    jp SSFP_MusicFX_Done1

SSFP_MUSIC_FX1_PITCHUP:
    ld hl, ChannelMusicFXParam+0*2
    ld a, [hl]
    dec a
    ld [hli], a
    jp nz, SSFP_MusicFX_Done1
    ld a, [hld]
    ld [hl], a

    ld hl, ChannelMusicFXParam2 + 0*2
    ld b, [hl]
    ld hl, ChannelFreqs+0*2
    ld a, [hl]
    add b
    ld [hli], a
    ld [Chnl1_Freq], a
    ld a, [hl]
    adc 0
    and $07
    ld [hl],a
    ld [Chnl1_Freq+1], a

    jp SSFP_MusicFX_Done1

SSFP_MUSIC_FX1_PITCHDOWN:
    ld hl, ChannelMusicFXParam+0*2
    ld a, [hl]
    dec a
    ld [hli], a
    jp nz, SSFP_MusicFX_Done1
    ld a, [hld]
    ld [hl], a

    ld hl, ChannelMusicFXParam2 + 0*2
    ld b, [hl]
    ld hl, ChannelFreqs+0*2
    ld a, [hl]
    sub b
    ld [hli], a
    ld [Chnl1_Freq], a
    ld a, [hl]
    sbc $00
    and $07
    ld [hl],a
    ld [Chnl1_Freq+1], a

    jp SSFP_MusicFX_Done1
;........................................................................................

SSFP_MUSIC_FX2_VIB1:
    ld hl, ChannelFreqs+1*2
    ld a, [hl]
    add 1
    ld [hli], a
    ld [Chnl2_Freq], a
    ld a, [hl]
    adc 0
    and $07
    ld [hl],a
    ld [Chnl2_Freq+1], a

    ld hl,ChannelMusicFXParam+1*2+1
    ld a, [hl]
    dec a
    ld [hld], a
    jp nz, SSFP_MusicFX_Done2
    ld a, [hli]
    ld [hl], a

    ld a, MUSIC_FX_VIB2
    ld [ChannelMusicEffects+1], a
    jp SSFP_MusicFX_Done2

SSFP_MUSIC_FX2_VIB2:
    ld hl, ChannelFreqs+1*2
    ld a, [hl]
    add $FF
    ld [hli], a
    ld [Chnl2_Freq],a
    ld a, [hl]
    adc $FF
    and $07
    ld [hl],a
    ld [Chnl2_Freq+1], a

    ld hl,ChannelMusicFXParam+1*2+1
    ld a, [hl]
    dec a
    ld [hld], a
    jp nz, SSFP_MusicFX_Done2
    ld a, [hli]
    ld [hl], a

    ld a, MUSIC_FX_VIB1
    ld [ChannelMusicEffects+1], a
    jp SSFP_MusicFX_Done2

IF DEF(MUSIC_FX_DUALFREQ1)
SSFP_MUSIC_FX2_DUALFREQ1:
    ld hl, ChannelMusicFXParam+1*2
    ld a, [hli]
    ld [Chnl2_Freq], a
    ld a, [hl]
    ld [Chnl2_Freq+1], a

    ld a, MUSIC_FX_DUALFREQ2
    ld [ChannelMusicEffects+1], a
    jp SSFP_MusicFX_Done2

SSFP_MUSIC_FX2_DUALFREQ2:
    ld hl, ChannelFreqs+1*2
    ld a, [hli]
    ld [Chnl2_Freq], a
    ld a, [hl]
    ld [Chnl2_Freq+1], a

    ld a, MUSIC_FX_DUALFREQ1
    ld [ChannelMusicEffects+1], a
    jp SSFP_MusicFX_Done2
ENDC

SSFP_MUSIC_FX2_TF1:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+1]
    ld c, a
    ld a, [ChannelMusicFXParam+1*2+0]
    add c
    cp 6*12
    jp c, SSFP_MUSIC_FX2_TF1_noteok
    ld a, 6*12-1
SSFP_MUSIC_FX2_TF1_noteok:
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl2_Freq], a
    ld a, [hl]
    ld [Chnl2_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ2
    ld [ChannelMusicEffects+1], a
    jp SSFP_MusicFX_Done2

SSFP_MUSIC_FX2_TF2:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+1]
    ld c, a
    ld a, [ChannelMusicFXParam+1*2+1]
    add c
    cp 6*12
    jp c, SSFP_MUSIC_FX2_TF2_noteok
    ld a, 6*12-1
SSFP_MUSIC_FX2_TF2_noteok:
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl2_Freq], a
    ld a, [hl]
    ld [Chnl2_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ3
    ld [ChannelMusicEffects+1], a
    jp SSFP_MusicFX_Done2

SSFP_MUSIC_FX2_TF3:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+1]
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl2_Freq], a
    ld a, [hl]
    ld [Chnl2_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ1
    ld [ChannelMusicEffects+1], a
    jp SSFP_MusicFX_Done2

SSFP_MUSIC_FX2_PITCHUP:
    ld hl, ChannelMusicFXParam+1*2
    ld a, [hl]
    dec a
    ld [hli], a
    jp nz, SSFP_MusicFX_Done2
    ld a, [hld]
    ld [hl], a

    ld hl, ChannelMusicFXParam2 + 1*2
    ld b, [hl]
    ld hl, ChannelFreqs+1*2
    ld a, [hl]
    add b
    ld [hli], a
    ld [Chnl2_Freq],a
    ld a, [hl]
    adc 0
    and $07
    ld [hl],a
    ld [Chnl2_Freq+1], a

    jp SSFP_MusicFX_Done2

SSFP_MUSIC_FX2_PITCHDOWN:
    ld hl, ChannelMusicFXParam+1*2
    ld a, [hl]
    dec a
    ld [hli], a
    jp nz, SSFP_MusicFX_Done2
    ld a, [hld]
    ld [hl], a

    ld hl, ChannelMusicFXParam2 + 1*2
    ld b, [hl]
    ld hl, ChannelFreqs+1*2
    ld a, [hl]
    sub b
    ld [hli], a
    ld [Chnl2_Freq],a
    ld a, [hl]
    sbc $00
    and $07
    ld [hl],a
    ld [Chnl2_Freq+1], a

    jp SSFP_MusicFX_Done2
;........................................................................................

SSFP_MUSIC_FX3_VIB1:
    ld hl, ChannelFreqs+2*2
    ld a, [hl]
    add 1
    ld [hli], a
    ld [Chnl3_Freq],a
    ld a, [hl]
    adc 0
    and $07
    ld [hl],a
    ld [Chnl3_Freq+1], a
    ld hl,ChannelMusicFXParam+2*2+1
    ld a, [hl]
    dec a
    ld [hld], a
    jp nz, SSFP_MusicFX_Done3
    ld a, [hli]
    ld [hl], a
    ld a, MUSIC_FX_VIB2
    ld [ChannelMusicEffects+2], a
    jp SSFP_MusicFX_Done3

SSFP_MUSIC_FX3_VIB2:
    ld hl, ChannelFreqs+2*2
    ld a, [hl]
    add $FF
    ld [hli], a
    ld [Chnl3_Freq], a
    ld a, [hl]
    adc $FF
    and $07
    ld [hl],a
    ld [Chnl3_Freq+1], a
    ld hl, ChannelMusicFXParam+2*2+1
    ld a, [hl]
    dec a
    ld [hld], a
    jp nz, SSFP_MusicFX_Done3
    ld a, [hli]
    ld [hl], a
    ld a, MUSIC_FX_VIB1
    ld [ChannelMusicEffects+2], a
    jp SSFP_MusicFX_Done3
IF DEF(MUSIC_FX_DUALFREQ1)
SSFP_MUSIC_FX3_DUALFREQ1:
    ld hl, ChannelMusicFXParam+2*2
    ld a, [hli]
    ld [Chnl3_Freq], a
    ld a, [hl]
    ld [Chnl3_Freq+1], a

    ld a, MUSIC_FX_DUALFREQ2
    ld [ChannelMusicEffects+2], a
    jp SSFP_MusicFX_Done3

SSFP_MUSIC_FX3_DUALFREQ2:
    ld hl, ChannelFreqs+2*2
    ld a, [hli]
    ld [Chnl3_Freq], a
    ld a, [hl]
    ld [Chnl3_Freq+1], a

    ld a, MUSIC_FX_DUALFREQ1
    ld [ChannelMusicEffects+2], a
    jp SSFP_MusicFX_Done3
ENDC

SSFP_MUSIC_FX3_TF1:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+2]
    ld c, a
    ld a, [ChannelMusicFXParam+2*2+0]
    add c
    cp 6*12
    jp c, SSFP_MUSIC_FX3_TF1_noteok
    ld a, 6*12-1
SSFP_MUSIC_FX3_TF1_noteok:
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl3_Freq], a
    ld a, [hl]
    ld [Chnl3_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ2
    ld [ChannelMusicEffects+2], a
    jp SSFP_MusicFX_Done3

SSFP_MUSIC_FX3_TF2:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+2]
    ld c, a
    ld a, [ChannelMusicFXParam+2*2+1]
    add c
    cp 6*12
    jp c, SSFP_MUSIC_FX3_TF2_noteok
    ld a, 6*12-1
SSFP_MUSIC_FX3_TF2_noteok:
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl3_Freq], a
    ld a, [hl]
    ld [Chnl3_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ3
    ld [ChannelMusicEffects+2], a
    jp SSFP_MusicFX_Done3

SSFP_MUSIC_FX3_TF3:
    ld hl, FrequencyTable
    ld a, [ChannelMusicNotes+2]
    add a
    add l
    ld l, a
    ld a, [hli]
    ld [Chnl3_Freq], a
    ld a, [hl]
    ld [Chnl3_Freq+1], a

    ld a, MUSIC_FX_TRIPLEFREQ1
    ld [ChannelMusicEffects+2], a
    jp SSFP_MusicFX_Done3

SSFP_MUSIC_FX3_PITCHUP:
    ld hl, ChannelMusicFXParam+2*2
    ld a, [hl]
    dec a
    ld [hli], a
    jp nz, SSFP_MusicFX_Done3
    ld a, [hld]
    ld [hl], a

    ld hl, ChannelMusicFXParam2 + 2*2
    ld b, [hl]
    ld hl, ChannelFreqs+2*2
    ld a, [hl]
    add b
    ld [hli], a
    ld [Chnl3_Freq], a
    ld a, [hl]
    adc 0
    and $07
    ld [hl],a
    ld [Chnl3_Freq+1], a

    jp SSFP_MusicFX_Done3

SSFP_MUSIC_FX3_PITCHDOWN:
    ld hl, ChannelMusicFXParam+2*2
    ld a, [hl]
    dec a
    ld [hli], a
    jp nz, SSFP_MusicFX_Done3
    ld a, [hld]
    ld [hl], a

    ld hl, ChannelMusicFXParam2 + 2*2
    ld b, [hl]
    ld hl, ChannelFreqs+2*2
    ld a, [hl]
    sub b
    ld [hli], a
    ld [Chnl3_Freq], a
    ld a, [hl]
    sbc $00
    and $07
    ld [hl],a
    ld [Chnl3_Freq+1], a

    jp SSFP_MusicFX_Done3
;----------------------------------------------------------------------------------------
; Music Code
;----------------------------------------------------------------------------------------
SSFP_MUSIC_CMD_ENDOFFRAME:
        ld a, [de]
        inc de
        ld [MusicNextFrame], a
        jp SSFP_MusicUpdateFrameEnd

SSFP_MUSIC_CMD_PLAYINSTNOTE:

        ld a, [de]
        inc de

        ld l, a
        ld a, [de]
        and $03
        ld b, ((ChannelMusicNotes >> 8)& $FF)
        add (ChannelMusicNotes & $FF)
        ld c, a
        ld a, l
        ld [bc], a

        ld a, l
        add a
        add (FrequencyTable & $FF)
        ld l, a
        ld h, ((FrequencyTable >> 8)& $FF)

        ld b, ((ChannelMusicFreqs >> 8)& $FF)
        ld a, [de]
        and $03
        add a
        add (ChannelMusicFreqs & $FF)
        ld c, a
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a   ; store note freq
SSFP_MUSIC_CMD_PLAYINST:
        ld a, [de]
        inc de

        ld b, a ;save
	  	and $FC
	  	SRL A
	  	ld c, a
	  	ld hl, MusicInstrumentTable
        ld a, [hli]
	  	add c
        ld c, a
        ld a, [hl]
	  	adc 0
	  	ld h, a
        ld l, c

        ; check for lock
        ld a, [SoundFXLock]
        ld c, a

        ld a, b ;restore
	    and $03
    	jp z, SSFP_MUSIC_PLAY_channel_1
    	dec a
    	jr z, SSFP_MUSIC_PLAY_channel_2
    	dec a
    	jr z, SSFP_MUSIC_PLAY_channel_3
SSFP_MUSIC_PLAY_channel_4:
    	bit 3, c
    	jp z, SSFP_MUSIC_PLAY_channel_Done

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicInstrumentBank
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicInstrumentBank]
        ENDC
        MBC_SelectRomQuick

    	ld a, [hli]
    	ld [MusicSFXInstPtr + 3 * 2], a
    	ld a, [hl]
    	ld [MusicSFXInstPtr + 3 * 2 + 1], a
    	ld a, 1
    	ld [MusicSFXInstPause+3], a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicInstrumentBank
            ld a, [hli]
            ld [MusicSFXInstBank+3*2], a
            ld a, [hl]
            ld [MusicSFXInstBank+3*2+1], a
        ELSE
            ld a, [MusicInstrumentBank]
            ld [MusicSFXInstBank+3*2], a
        ENDC

        ld hl, ChannelMusicFreqs+3*2
        ld bc, ChannelFreqs+3*2
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a

      	jp SSFP_MUSIC_PLAY_channel_Done
SSFP_MUSIC_PLAY_channel_2:
      	bit 1, c
	  	jp z, SSFP_MUSIC_PLAY_channel_Done

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicInstrumentBank
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicInstrumentBank]
        ENDC
        MBC_SelectRomQuick

	  	ld a, [hli]
	  	ld [MusicSFXInstPtr + 1 * 2], a
	  	ld a, [hl]
	  	ld [MusicSFXInstPtr + 1 * 2 + 1], a
	  	ld a, 1
	  	ld [MusicSFXInstPause+1], a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicInstrumentBank
            ld a, [hli]
            ld [MusicSFXInstBank+1*2], a
            ld a, [hl]
            ld [MusicSFXInstBank+1*2+1], a
        ELSE
            ld a, [MusicInstrumentBank]
            ld [MusicSFXInstBank+1*2], a
        ENDC

        ld hl, ChannelMusicFreqs+1*2
        ld bc, ChannelFreqs+1*2
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a

	  	jr SSFP_MUSIC_PLAY_channel_Done
SSFP_MUSIC_PLAY_channel_3:
	  	bit 2, c
	  	jr z, SSFP_MUSIC_PLAY_channel_Done

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicInstrumentBank
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicInstrumentBank]
        ENDC
        MBC_SelectRomQuick

	  	ld a, [hli]
	  	ld [MusicSFXInstPtr + 2 * 2], a
	  	ld a, [hl]
	  	ld [MusicSFXInstPtr + 2 * 2 + 1], a
	  	ld a, 1
	  	ld [MusicSFXInstPause+2], a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicInstrumentBank
            ld a, [hli]
            ld [MusicSFXInstBank+2*2], a
            ld a, [hl]
            ld [MusicSFXInstBank+2*2+1], a
        ELSE
            ld a, [MusicInstrumentBank]
            ld [MusicSFXInstBank+2*2], a
        ENDC

        ld hl, ChannelMusicFreqs+2*2
        ld bc, ChannelFreqs+2*2
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a

	  	jr SSFP_MUSIC_PLAY_channel_Done
SSFP_MUSIC_PLAY_channel_1:
	  	bit 0, c
	  	jr z, SSFP_MUSIC_PLAY_channel_Done

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicInstrumentBank
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicInstrumentBank]
        ENDC
        MBC_SelectRomQuick

	  	ld a, [hli]
	  	ld [MusicSFXInstPtr + 0 * 2], a
	  	ld a, [hl]
	  	ld [MusicSFXInstPtr + 0 * 2 + 1], a
	  	ld a, 1
	  	ld [MusicSFXInstPause+0], a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicInstrumentBank
            ld a, [hli]
            ld [MusicSFXInstBank+0*2], a
            ld a, [hl]
            ld [MusicSFXInstBank+0*2+1], a
        ELSE
            ld a, [MusicInstrumentBank]
            ld [MusicSFXInstBank+0*2], a
        ENDC

        ld hl, ChannelMusicFreqs+0*2
        ld bc, ChannelFreqs+0*2
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a

SSFP_MUSIC_PLAY_channel_Done:

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicCommandBank
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicCommandBank]
        ENDC
        MBC_SelectRomQuick

      	jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_SETVOLUME:
        ld a, [de]
        inc de
        ld c, a
        and $03
        add (ChannelVols & $FF)
        ld l, a
        ld a, ((ChannelVols >> 8) & $FF)
        adc 0
        ld h, a
        ld a, c
        and $F0
        ld [hl], a
        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_SETPANNING:
        ld a, [de]
        inc de
        ld hl, SoundFXLock
        and [hl]
        cpl
        ld [$FF25], a
        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_VIBRATO_ON:
        ld a, [de]
        ld c, a
        and 3
        add (ChannelMusicEffects & $FF)
        ld h, ((ChannelMusicEffects >> 8) & $FF)
        ld l, a
        ld [hl], MUSIC_FX_VIB1

        sub (ChannelMusicEffects & $FF)
        add a
        add (ChannelMusicFXParam & $FF)
        ld c, a
        ld b, ((ChannelMusicFXParam >> 8)& $FF)
        ld a, [de]
        swap a
        and $0F
        ld [bc], a   ; store max
        inc bc
        ld l, a
        and 1
        SRL l
        or l
        ld [bc], a   ; store max
        inc de

        jp SSFP_MusicUpdate

IF DEF(MUSIC_CMD_DUALNOTE_ON)
SSFP_MUSIC_CMD_DUALNOTE_ON:
        ld a, [de]
        inc de
        ; note
        add a
        add (FrequencyTable & $FF)
        ld l, a
        ld h, ((FrequencyTable >> 8)& $FF)

        ld b, ((ChannelMusicFXParam >> 8)& $FF)
        ld a, [de]
        and $03
        add a
        add (ChannelMusicFXParam & $FF)
        ld c, a
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a   ; store note freq

        ld a, [de]
        inc de

        ld c, a
        and 3
        add (ChannelMusicEffects & $FF)
        ld h, ((ChannelMusicEffects >> 8) & $FF)
        ld l, a
        ld [hl], MUSIC_FX_DUALFREQ1

        jp SSFP_MusicUpdate
ENDC

SSFP_MUSIC_CMD_PITCHUP_ON:
        ld a, [de]
        and 3
        add (ChannelMusicEffects & $FF)
        ld h, ((ChannelMusicEffects >> 8) & $FF)
        ld l, a
        ld [hl], MUSIC_FX_PITCHUP
        jr SSFP_MUSIC_CMD_PITCHUP_reuse

SSFP_MUSIC_CMD_PITCHDOWN_ON:
        ld a, [de]
        and 3
        add (ChannelMusicEffects & $FF)
        ld h, ((ChannelMusicEffects >> 8) & $FF)
        ld l, a
        ld [hl], MUSIC_FX_PITCHDOWN
SSFP_MUSIC_CMD_PITCHUP_reuse:
        sub (ChannelMusicEffects & $FF)
        add a
        add (ChannelMusicFXParam & $FF)
        ld c, a
        ld b, ((ChannelMusicFXParam >> 8)& $FF)
        ld a, [de]
        swap a
        and $0F
        ld [bc], a   ; store max
        inc c
        ld [bc], a   ; store max
        ld a, 7
        add c
        ld c, a
        ld a, [de]
        SRL A
        SRL A
        and 3
        inc a
        ld [bc], a
        inc de
        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_TRIPLENOTE_ON:
        ld a, [de]
        inc de
        ; note
        ld l, a

        ld b, ((ChannelMusicFXParam >> 8)& $FF)
        ld a, [de]
        and $03
        add a
        add (ChannelMusicFXParam & $FF)
        ld c, a
        ld a, l
        swap a
        and $0F
        ld [bc], a
        inc c
        ld a, l
        and $0F
        ld [bc], a   ; store note freq

        ld a, [de]
        inc de

        ld c, a
        and 3
        add (ChannelMusicEffects & $FF)
        ld h, ((ChannelMusicEffects >> 8) & $FF)
        ld l, a
        ld [hl], MUSIC_FX_TRIPLEFREQ1

        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_EFFECT_OFF:
        ld a, [de]
        inc de
        add (ChannelMusicEffects & $FF)
        ld h, ((ChannelMusicEffects >> 8) & $FF)
        ld l, a
        ld [hl], MUSIC_FX_NONE
        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_ENDOFPATTERN:
        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicOrderBank
            ld a, [hli]
            ld c, a
            ld b, [hl]
        ELSE
            ld a, [MusicOrderBank]
        ENDC
        MBC_SelectRomQuick

        ld hl, MusicOrderPtr
        ld a, [hli]
        ld h, [hl]
        ld l, a
        add 4
        ld [MusicOrderPtr], A
        ld a, h
        adc 0
        ld [MusicOrderPtr+1], A

        ld A, [HLI]
        ld e, a
        ld a, [HLI]
        ld d, a

        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld a, [hli]
            ld c, a
            ld [MusicCommandBank], c
            ld a, [hl]
            ld [MusicCommandBank+1], a
            ld b, a
        ELSE
            ld a, [HL]
            ld [MusicCommandBank], a
        ENDC
        MBC_SelectRomQuick

        ld a, 1
        ld [MusicNextFrame], a
        jp SSFP_MusicUpdateFrameEnd

IF DEF(MUSIC_CMD_SETMASTERVOLUME)
SSFP_MUSIC_CMD_SETMASTERVOLUME:
        ld a, [de]
        inc de
        ld [$FF24], a
        jp SSFP_MusicUpdate
ENDC

IF DEF(MUSIC_CMD_LP)
SSFP_MUSIC_CMD_LP:
        ld a, [MusicPatternLoopCounter]
        or a
        jp nz, MUSIC_CMD_LP_alreadylooping
        ; loop
        ld a, [de]
        ld l, a
        inc de
        ld a, [de]
        ld h, a
        add hl, de
        inc de
        ld a, [de]
        ld e, l
        ld d, h
        ld [MusicPatternLoopCounter], a
        jp SSFP_MusicUpdate
MUSIC_CMD_LP_alreadylooping:
        dec a
        ld [MusicPatternLoopCounter], a
        jp z, MUSIC_CMD_LP_done_looping
        ; loop
        ld a, [de]
        ld l, a
        inc de
        ld a, [de]
        ld h, a
        add hl, de
        ld e, l
        ld d, h
        jp SSFP_MusicUpdate

MUSIC_CMD_LP_done_looping:
        ; skip
        inc de
        inc de
        inc de
        jp SSFP_MusicUpdate
ENDC

SSFP_MUSIC_CMD_GOTOORDER:
        ld a, [MusicOrderPtr]
        ld c, a
        ld a, [MusicOrderPtr+1]
        ld b, a
        ld a, [de]
        inc de
        ld l, a
        ld a, [de]
        inc de
        ld h, a
        add hl, bc
        ld a, h
        ld [MusicOrderPtr+1], a
        ld a, l
        ld [MusicOrderPtr], a
        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_SYNCFLAG:
        ld a, [de]
        inc de
        ld [MusicSyncFlag], a
        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_EXTRA:
        ld a, [de]
        inc de
        ld c, a
        and 3
        jr z, SSFP_MUSIC_CMD_EXTRA_chnl1
        dec a
        jr z, SSFP_MUSIC_CMD_EXTRA_chnl2
        dec a
        jr z, SSFP_MUSIC_CMD_EXTRA_chnl3
        ; chnl 4
        jp SSFP_MusicUpdate
SSFP_MUSIC_CMD_EXTRA_chnl1:
        ld a, c
        and $FC
        ld [Chnl1_Len], a
        jp SSFP_MusicUpdate
SSFP_MUSIC_CMD_EXTRA_chnl2:
        ld a, c
        and $FC
        ld [Chnl2_Len], a
        jp SSFP_MusicUpdate
SSFP_MUSIC_CMD_EXTRA_chnl3:
        ld a, [MusicSFXInstChnl3Lock]
        or a
        jp nz, SSFP_MusicUpdate
        ld a, c
        and $FC
        ld [Chnl3_Vol], a
        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_ENDOFSONG:
        xor a
        ld [MusicPlayMode], a
        dec de
        jp SSFP_MusicUpdateFrameEnd

SSFP_MUSIC_CMD_SETSPEED:
        ld a, [de]
        inc de
        ld [MusicSpeed], a
        jp SSFP_MusicUpdate

SSFP_MUSIC_CMD_ENDOFFRAME1X:
        ld a, [MusicSpeed]
        ld [MusicNextFrame], a
        jp SSFP_MusicUpdateFrameEnd
SSFP_MUSIC_CMD_ENDOFFRAME2X:
        ld a, [MusicSpeed]
        add a
        ld [MusicNextFrame], a
        jp SSFP_MusicUpdateFrameEnd
SSFP_MUSIC_CMD_ENDOFFRAME3X:
        ld a, [MusicSpeed]
        ld c, a
        add a
        add c
        ld [MusicNextFrame], a
        jp SSFP_MusicUpdateFrameEnd
SSFP_MUSIC_CMD_ENDOFFRAME4X:
        ld a, [MusicSpeed]
        add a
        add a
        ld [MusicNextFrame], a
        jp SSFP_MusicUpdateFrameEnd
;----------------------------------------------------------------------------------------
; Instruments Code
;----------------------------------------------------------------------------------------

CHANNELINDEX SET 0

SSFP_Inst1Update:
        ld a, [de]
        inc de
        ld hl, SSFP_Inst1_JumpTable
        add a
        add l
        ld l, a
        ld a, [hli]
        ld h, [hl]
        ld l, a
        jp [hl]

SSFP_Inst1_CMD_FRAMEEND:
        ld a, [de]
        inc de
        ld [MusicSFXInstPause + CHANNELINDEX], a   ; load new pause
        jp SSFP_Inst1UpdateFrameEnd

SSFP_Inst1_CMD_STARTFREQ:
        ld a, [de]
        inc de
        ld [Chnl1_Freq], a       ; ***
        ld a, [de]
        inc de
        ld [Chnl1_Freq+1], a       ; ***
        jp SSFP_Inst1Update
SSFP_Inst1_CMD_START:
        ld a, [ChannelFreqs + CHANNELINDEX*2]
        ld [Chnl1_Freq], a       ; ***
        ld a, [de]
        inc de
        ld hl, ChannelFreqs + CHANNELINDEX*2+1
        or [HL]
        ld [Chnl1_Freq+1], a       ; ***
        jp SSFP_Inst1Update

SSFP_Inst1_CMD_STARTENVVOLFREQ:
        ld a, [de]
        inc de
        ld [Chnl1_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+0], a
        ENDC

        ld a, [de]
        inc de
        ld [Chnl1_Freq], a       ; ***
        ld a, [de]
        inc de
        ld [Chnl1_Freq+1], a       ; ***
        jp SSFP_Inst1Update

SSFP_Inst1_CMD_ENVELOPEVOL:
        ld a, [de]
        inc de
        ld [Chnl1_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+0], a
        ENDC

        jp SSFP_Inst1Update
IF DEF(MUSIC_INSTCMD_X_ENVELOPE)
SSFP_Inst1_CMD_ENVELOPE:
        ld a, [de]
        inc de
        ld hl, ChannelVols + CHANNELINDEX
        or [HL]
        ld [Chnl1_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+0], a
        ENDC

        jp SSFP_Inst1Update
ENDC

SSFP_Inst1_CMD_END:
        dec de                      ; rewind counter
        ld a, [SoundFXLock]
        bit 0, a
        jp nz, SSFP_Inst1UpdateFrameEnd
        or %00010001
        ld [SoundFXLock], a

        ; restore music freq
        ld hl, ChannelMusicFreqs+0*2
        ld bc, ChannelFreqs+0*2
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a

        jp SSFP_Inst1UpdateFrameEnd ; do nothing else (counter loaded with 0 (256) frame wait)

SSFP_Inst1_CMD_PANMID:
    ld hl, MusicSFXPanning
    ld a, %00010001
    or [hl]
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst1Update
SSFP_Inst1_CMD_PANRIGHT:
    ld hl, MusicSFXPanning
    ld a, %00000001
    or [hl]
    and %11101111
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst1Update
SSFP_Inst1_CMD_PANLEFT:
    ld hl, MusicSFXPanning
    ld a, %00010000
    or [hl]
    and %11111110
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst1Update
;........................................................................................
SSFP_Inst1_CMD_PULSELEN:
        ld a, [de]
        inc de
        ld [Chnl1_Len], a      ; ***
        jp SSFP_Inst1Update

SSFP_Inst1_CMD_SWEEP:
        ld a, [de]
        inc de
        ld [$FF10], a      ; ***
        jp SSFP_Inst1Update
;----------------------------------------------------------------------------------------

CHANNELINDEX SET 1

SSFP_Inst2Update:
        ld a, [de]
        inc de
        ld hl, SSFP_Inst2_JumpTable
        add a
        add l
        ld l, a
        ld a, [hli]
        ld h, [hl]
        ld l, a
        jp [hl]

SSFP_Inst2_CMD_FRAMEEND:
        ld a, [de]
        inc de
        ld [MusicSFXInstPause + CHANNELINDEX], a   ; load new pause
        jp SSFP_Inst2UpdateFrameEnd

SSFP_Inst2_CMD_STARTFREQ:
        ld a, [de]
        inc de
        ld [Chnl2_Freq], a       ; ***
        ld a, [de]
        inc de
        ld [Chnl2_Freq+1], a       ; ***
        jp SSFP_Inst2Update
SSFP_Inst2_CMD_START:
        ld a, [ChannelFreqs + CHANNELINDEX*2]
        ld [Chnl2_Freq], a       ; ***
        ld a, [de]
        inc de
        ld hl, ChannelFreqs + CHANNELINDEX*2+1
        or [HL]
        ld [Chnl2_Freq+1], a       ; ***
        jp SSFP_Inst2Update

SSFP_Inst2_CMD_STARTENVVOLFREQ:
        ld a, [de]
        inc de
        ld [Chnl2_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+1], a
        ENDC

        ld a, [de]
        inc de
        ld [Chnl2_Freq], a       ; ***
        ld a, [de]
        inc de
        ld [Chnl2_Freq+1], a       ; ***
        jp SSFP_Inst2Update

SSFP_Inst2_CMD_ENVELOPEVOL:
        ld a, [de]
        inc de
        ld [Chnl2_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+1], a
        ENDC

        jp SSFP_Inst2Update
IF DEF(MUSIC_INSTCMD_X_ENVELOPE)
SSFP_Inst2_CMD_ENVELOPE:
        ld a, [de]
        inc de
        ld hl, ChannelVols + CHANNELINDEX
        or [HL]
        ld [Chnl2_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+1], a
        ENDC

        jp SSFP_Inst2Update
ENDC
SSFP_Inst2_CMD_END:
        dec de                      ; rewind counter
        ld a, [SoundFXLock]
        bit 1, a
        jp nz, SSFP_Inst2UpdateFrameEnd
        or %00100010
        ld [SoundFXLock], a

        ; restore music freq
        ld hl, ChannelMusicFreqs+1*2
        ld bc, ChannelFreqs+1*2
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a

        jp SSFP_Inst2UpdateFrameEnd ; do nothing else (counter loaded with 0 (256) frame wait)


SSFP_Inst2_CMD_PANMID:
    ld hl, MusicSFXPanning
    ld a, %00100010
    or [hl]
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst2Update
SSFP_Inst2_CMD_PANRIGHT:
    ld hl, MusicSFXPanning
    ld a, %00000010
    or [hl]
    and %11011111
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst2Update
SSFP_Inst2_CMD_PANLEFT:
    ld hl, MusicSFXPanning
    ld a, %00100000
    or [hl]
    and %11111101
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst2Update
;........................................................................................
SSFP_Inst2_CMD_PULSELEN:
        ld a, [de]
        inc de
        ld [Chnl2_Len], a      ; ***
        jp SSFP_Inst2Update

SSFP_Inst2_CMD_SWEEP:
        inc de           ; ** ignore
        jp SSFP_Inst2Update
;----------------------------------------------------------------------------------------

CHANNELINDEX SET 2

SSFP_Inst3Update:
        ld a, [de]
        inc de
        ld hl, SSFP_Inst3_JumpTable
        add a
        add l
        ld l, a
        ld a, [hli]
        ld h, [hl]
        ld l, a
        jp [hl]

SSFP_Inst3_CMD_FRAMEEND:
        ld a, [de]
        inc de
        ld [MusicSFXInstPause + CHANNELINDEX], a   ; load new pause
        jp SSFP_Inst3UpdateFrameEnd

SSFP_Inst3_CMD_STARTFREQ:
        ld a, [de]
        inc de
        ld [Chnl3_Freq], a       ; ***
        ld a, $80
        ld [$FF1A], a
        ld a, [de]
        inc de
        ld [Chnl3_Freq+1], a       ; ***
        jp SSFP_Inst3Update
SSFP_Inst3_CMD_START:
        ld a, [ChannelFreqs + CHANNELINDEX*2]
        ld [Chnl3_Freq], a       ; ***
        ld a, $80
        ld [$FF1A], a
        ld a, [de]
        inc de
        ld hl, ChannelFreqs + CHANNELINDEX*2+1
        or [HL]
        ld [Chnl3_Freq+1], a       ; ***
        jp SSFP_Inst3Update

SSFP_Inst3_CMD_STARTENVVOLFREQ:
        ld a, [de]
        inc de
        ld [Chnl3_Vol], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        SLA a
        and $0C
        dec a
        xor $0C
        ld [Scopes+2], a
        ENDC

        ld a, [de]
        inc de
        ld [Chnl3_Freq], a       ; ***
        ld a, $80
        ld [$FF1A], a
        ld a, [de]
        inc de
        ld [Chnl3_Freq+1], a       ; ***
        jp SSFP_Inst3Update

SSFP_Inst3_CMD_ENVELOPEVOL:
        ld a, [de]
        inc de
        ld [Chnl3_Vol], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        SLA a
        and $0C
        dec a
        xor $0C
        ld [Scopes+2], a
        ENDC

        jp SSFP_Inst3Update
IF DEF(MUSIC_INSTCMD_X_ENVELOPE)
;SSFP_Inst3_CMD_ENVELOPE:
        ;ld a, [de]
        ;inc de
        ;ld hl, ChannelVols + CHANNELINDEX
        ;or [HL]
        ;ld [Chnl3_Vol], a       ; ***

        IF DEF(SCOPEENABLE)
        ;swap a
        ;SLA a
        ;and $0C
        ;dec a
        ;xor $0C
        ;ld [Scopes+2], a
        ENDC

        ;jp SSFP_Inst3Update
ENDC

SSFP_Inst3_CMD_END:
        dec de                      ; rewind counter
        ld a, $00
        ld [$FF1A], a

        IF DEF(SCOPEENABLE)
        ld [Scopes+2], a
        ENDC

        ld a, [SoundFXLock]
        bit 2, a
        jp nz, SSFP_Inst3UpdateFrameEnd
        or %01000100
        ld [SoundFXLock], a

        ; restore music freq
        ld hl, ChannelMusicFreqs+2*2
        ld bc, ChannelFreqs+2*2
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a

        jp SSFP_Inst3UpdateFrameEnd ; do nothing else (counter loaded with 0 (256) frame wait)

SSFP_Inst3_CMD_PANMID:
    ld hl, MusicSFXPanning
    ld a, %01000100
    or [hl]
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst3Update
SSFP_Inst3_CMD_PANRIGHT:
    ld hl, MusicSFXPanning
    ld a, %00000100
    or [hl]
    and %10111111
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst3Update
SSFP_Inst3_CMD_PANLEFT:
    ld hl, MusicSFXPanning
    ld a, %01000000
    or [hl]
    and %11111011
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst3Update
;........................................................................................

SSFP_Inst3_CMD_WAVE:
        ld hl, MusicSFXInstChnl3WaveID
        ld a, [de]
        inc de
        cp 255
        jp z, SSFP_Inst3_CMD_WAVE_loadlong
        cp [hl]
        jp z, SSFP_Inst3_CMD_WAVE_skip
SSFP_Inst3_CMD_WAVE_loadlong:

        ld hl, $FF30
        xor a
        ld [$FF1A], a
        REPT 16
        ld a, [de]
        inc de
        ld [hli], a
        ENDR
        jp SSFP_Inst3Update
SSFP_Inst3_CMD_WAVE_skip:
        ld a, e
        add 16
        ld e, a
        ld a, d
        adc 0
        ld d, a
        jp SSFP_Inst3Update

SSFP_Inst3_CMD_LEN:
        ld a, [de]
        inc de
        ld [Chnl3_Len], a
        jp SSFP_Inst3Update
;----------------------------------------------------------------------------------------

CHANNELINDEX SET 3

SSFP_Inst4Update:
        ld a, [de]
        inc de
        ld hl, SSFP_Inst4_JumpTable
        add a
        add l
        ld l, a
        ld a, [hli]
        ld h, [hl]
        ld l, a
        jp [hl]

SSFP_Inst4_CMD_FRAMEEND:
        ld a, [de]
        inc de
        ld [MusicSFXInstPause + CHANNELINDEX], a   ; load new pause
        jp SSFP_Inst4UpdateFrameEnd

SSFP_Inst4_CMD_STARTFREQ:
        ld a, [de]
        inc de
        ld [Chnl4_FDiv], a
        ld a, [de]
        inc de
        ld [Chnl4_FDiv+1], a
        jp SSFP_Inst4Update
SSFP_Inst4_CMD_START:
        ld a, [de]
        inc de
        ld [Chnl4_FDiv+1], a
        jp SSFP_Inst4Update

SSFP_Inst4_CMD_STARTENVVOLFREQ:
        ld a, [de]
        inc de
        ld [Chnl4_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+3], a
        ENDC

        ld a, [de]
        inc de
        ld [Chnl4_FDiv], a
        ld a, [de]
        inc de
        ld [Chnl4_FDiv+1], a
        jp SSFP_Inst4Update

SSFP_Inst4_CMD_ENVELOPEVOL:
        ld a, [de]
        inc de
        ld [Chnl4_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+3], a
        ENDC

        jp SSFP_Inst4Update
IF DEF(MUSIC_INSTCMD_X_ENVELOPE)
SSFP_Inst4_CMD_ENVELOPE:
        ld a, [de]
        inc de
        ld hl, ChannelVols + CHANNELINDEX
        or [HL]
        ld [Chnl4_Env], a       ; ***

        IF DEF(SCOPEENABLE)
        swap a
        and $0F
        ld [Scopes+3], a
        ENDC

        jp SSFP_Inst4Update
ENDC
SSFP_Inst4_CMD_END:
        dec de                      ; rewind counter
        ld a, [SoundFXLock]
        bit 3, a
        jp nz, SSFP_Inst4UpdateFrameEnd
        or %10001000
        ld [SoundFXLock], a

        ; restore music freq
        ld hl, ChannelMusicFreqs+3*2
        ld bc, ChannelFreqs+3*2
        ld a, [hli]
        ld [bc], a
        inc c
        ld a, [hl]
        ld [bc], a

        jp SSFP_Inst4UpdateFrameEnd ; do nothing else (counter loaded with 0 (256) frame wait)

SSFP_Inst4_CMD_PANMID:
    ld hl, MusicSFXPanning
    ld a, %10001000
    or [hl]
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst4Update
SSFP_Inst4_CMD_PANRIGHT:
    ld hl, MusicSFXPanning
    ld a, %00001000
    or [hl]
    and %01111111
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst4Update
SSFP_Inst4_CMD_PANLEFT:
    ld hl, MusicSFXPanning
    ld a, %10000000
    or [hl]
    and %11110111
    ld [hl], a
    ld [$FF25], a
    jp SSFP_Inst4Update
;........................................................................................
SSFP_Inst4_CMD_POLYLOAD:
        ld a, [de]
        inc de
        ld [Chnl4_FDiv], a
        jp SSFP_Inst4Update

SSFP_Inst4_CMD_LEN:
        ld a, [de]
        inc de
        ld [Chnl4_Len], a
        jp SSFP_Inst4Update


;----------------------------------------------------------------------------------------
; Music Player Code
;----------------------------------------------------------------------------------------

; init Music variables
; start playing at order pointed by HL
; BC = Bank with order list
; HL = Order List array pointer
Music_Play:
        push bc
        push hl
        ; stop music
        MusicStop
        pop hl
        pop bc

        push AF
        push bc

        ; switch to player memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, SOUNDSYSTEM_RAMBANK
            ld [RAM_BANK], a
        ENDC

        push hl
        IF (CART_ROMSIZE > CART_ROMSIZE_32Meg)
            ld hl, MusicOrderBank
            ld a, c
            ld [hli], a
            ld [hl], b
        ELSE
            ld a, c
            ld [MusicOrderBank], a
        ENDC
        MBC_SelectRom
        pop hl
        push bc


        ; set to advance on next frame
        ld A, 1
        ld [MusicNextFrame], A

        ; misc
        xor a
        ld [MusicPatternLoopCounter], A ; init pattern loop count to zero (not in a loop)
        ;ld [MusicOrderLoopCounter], A   ; init order loop count to zero (not in a loop)
        ld [MusicSyncFlag], A           ; set sync flag to zero

        push hl
        ld hl, ChannelMusicEffects     ; clear effects
        ld [hli], a
        ld [hli], a
        ld [hli], a
        ld [hli], a
        pop hl
        push hl
        ; set command pointer to value of first order
        ld A, [HLI]
        ld [MusicCommandPtr], A
        ld A, [HLI]
        ld [MusicCommandPtr+1], A
        ld A, [HLI]
        ld [MusicCommandBank], A
        ld A, [HLI]
        ld [MusicCommandBank+1], A
        pop hl

        ; set order pointer to next order
        ld A, L
        add 4
        ld [MusicOrderPtr], A
        ld a, h
        adc 0
        ld [MusicOrderPtr+1], A

        ;
        ld A, 1
        ld [MusicPlayMode], A

        ;restore memory bank
        IF COLOR_FLAG != COLOR_FLAG_BW
            ld a, [intRAMBank]
            ld [RAM_BANK], a
        ENDC

        pop bc
        MBC_SelectRom

        pop bc
        pop af
        ret

SoundSystem_HOMECODE_END:

PRINTT "Music player HOME code size:"
PRINTV SoundSystem_HOMECODE_END - SoundSystem_HOMECODE_START
PRINTT "\n"
PRINTT "Music player Movable code size:"
PRINTV SoundSystem_MOVABLECODE_END - SoundSystem_MOVABLECODE_START
PRINTT "\n"
PRINTT "Ram usage:"
PRINTV SoundSystem_RAM_END-SoundSystem_RAM_START
PRINTT "\n"
;----------------------------------------------------------------------------------------
; Tables
;----------------------------------------------------------------------------------------
SECTION "SSTableMusixFX", HOME[$3EB8]
;----------------------------------------------------------------------------------------
SSFP_MusicFX_JumpTable1:
IF DEF(MUSIC_FX_NONE)
        dw $0000 ; dummy
ENDC
IF DEF(MUSIC_FX_VIB1)
        dw SSFP_MUSIC_FX1_VIB1
ENDC
IF DEF(MUSIC_FX_VIB2)
        dw SSFP_MUSIC_FX1_VIB2
ENDC
IF DEF(MUSIC_FX_DUALFREQ1)
        dw SSFP_MUSIC_FX1_DUALFREQ1
ENDC
IF DEF(MUSIC_FX_DUALFREQ2)
        dw SSFP_MUSIC_FX1_DUALFREQ2
ENDC
IF DEF(MUSIC_FX_TRIPLEFREQ1)
        dw SSFP_MUSIC_FX1_TF1
ENDC
IF DEF(MUSIC_FX_TRIPLEFREQ2)
        dw SSFP_MUSIC_FX1_TF2
ENDC
IF DEF(MUSIC_FX_TRIPLEFREQ3)
        dw SSFP_MUSIC_FX1_TF3
ENDC
IF DEF(MUSIC_FX_PITCHUP)
        dw SSFP_MUSIC_FX1_PITCHUP
ENDC
IF DEF(MUSIC_FX_PITCHDOWN)
        dw SSFP_MUSIC_FX1_PITCHDOWN
ENDC
;.............................................................................
SSFP_MusicFX_JumpTable2:
IF DEF(MUSIC_FX_NONE)
        dw $0000 ; dummy
ENDC
IF DEF(MUSIC_FX_VIB1)
        dw SSFP_MUSIC_FX2_VIB1
ENDC
IF DEF(MUSIC_FX_VIB2)
        dw SSFP_MUSIC_FX2_VIB2
ENDC
IF DEF(MUSIC_FX_DUALFREQ1)
        dw SSFP_MUSIC_FX2_DUALFREQ1
ENDC
IF DEF(MUSIC_FX_DUALFREQ2)
        dw SSFP_MUSIC_FX2_DUALFREQ2
ENDC
IF DEF(MUSIC_FX_TRIPLEFREQ1)
        dw SSFP_MUSIC_FX2_TF1
ENDC
IF DEF(MUSIC_FX_TRIPLEFREQ2)
        dw SSFP_MUSIC_FX2_TF2
ENDC
IF DEF(MUSIC_FX_TRIPLEFREQ3)
        dw SSFP_MUSIC_FX2_TF3
ENDC
IF DEF(MUSIC_FX_PITCHUP)
        dw SSFP_MUSIC_FX2_PITCHUP
ENDC
IF DEF(MUSIC_FX_PITCHDOWN)
        dw SSFP_MUSIC_FX2_PITCHDOWN
ENDC
;.............................................................................
SSFP_MusicFX_JumpTable3:
IF DEF(MUSIC_FX_NONE)
        dw $0000 ; dummy
ENDC
IF DEF(MUSIC_FX_VIB1)
        dw SSFP_MUSIC_FX3_VIB1
ENDC
IF DEF(MUSIC_FX_VIB2)
        dw SSFP_MUSIC_FX3_VIB2
ENDC
IF DEF(MUSIC_FX_DUALFREQ1)
        dw SSFP_MUSIC_FX3_DUALFREQ1
ENDC
IF DEF(MUSIC_FX_DUALFREQ2)
        dw SSFP_MUSIC_FX3_DUALFREQ2
ENDC

IF DEF(MUSIC_FX_TRIPLEFREQ1)
        dw SSFP_MUSIC_FX3_TF1
ENDC
IF DEF(MUSIC_FX_TRIPLEFREQ2)
        dw SSFP_MUSIC_FX3_TF2
ENDC
IF DEF(MUSIC_FX_TRIPLEFREQ3)
        dw SSFP_MUSIC_FX3_TF3
ENDC
IF DEF(MUSIC_FX_PITCHUP)
        dw SSFP_MUSIC_FX3_PITCHUP
ENDC
IF DEF(MUSIC_FX_PITCHDOWN)
        dw SSFP_MUSIC_FX3_PITCHDOWN
ENDC
SSFP_MusicFX_JumpTable_END:
;----------------------------------------------------------------------------------------
SECTION "SSTableMusic", HOME[$3F00]
;----------------------------------------------------------------------------------------
SSFP_Music_JumpTable:
IF DEF(MUSIC_CMD_ENDOFFRAME)
        dw SSFP_MUSIC_CMD_ENDOFFRAME
ENDC
IF DEF(MUSIC_CMD_PLAYINSTNOTE)
        dw SSFP_MUSIC_CMD_PLAYINSTNOTE
ENDC
IF DEF(MUSIC_CMD_PLAYINST)
        dw SSFP_MUSIC_CMD_PLAYINST
ENDC

IF DEF(MUSIC_CMD_SETVOLUME)
        dw SSFP_MUSIC_CMD_SETVOLUME
ENDC
IF DEF(MUSIC_CMD_SETPANNING)
        dw SSFP_MUSIC_CMD_SETPANNING
ENDC
IF DEF(MUSIC_CMD_VIBRATO_ON)
        dw SSFP_MUSIC_CMD_VIBRATO_ON
ENDC
IF DEF(MUSIC_CMD_DUALNOTE_ON)
        dw SSFP_MUSIC_CMD_DUALNOTE_ON
ENDC
IF DEF(MUSIC_CMD_EFFECT_OFF)
        dw SSFP_MUSIC_CMD_EFFECT_OFF
ENDC

IF DEF(MUSIC_CMD_SETMASTERVOLUME)
        dw SSFP_MUSIC_CMD_SETMASTERVOLUME
ENDC
IF DEF(MUSIC_CMD_SYNCFLAG)
        dw SSFP_MUSIC_CMD_SYNCFLAG
ENDC

IF DEF(MUSIC_CMD_ENDOFPATTERN)
        dw SSFP_MUSIC_CMD_ENDOFPATTERN
ENDC
IF DEF(MUSIC_CMD_LP)
        dw SSFP_MUSIC_CMD_LP
ENDC
IF DEF(MUSIC_CMD_GOTOORDER)
        dw SSFP_MUSIC_CMD_GOTOORDER
ENDC
IF DEF(MUSIC_CMD_ENDOFSONG)
        dw SSFP_MUSIC_CMD_ENDOFSONG
ENDC

IF DEF(MUSIC_CMD_SETSPEED)
        dw SSFP_MUSIC_CMD_SETSPEED
ENDC
IF DEF(MUSIC_CMD_ENDOFFRAME1X)
        dw SSFP_MUSIC_CMD_ENDOFFRAME1X
ENDC
IF DEF(MUSIC_CMD_ENDOFFRAME2X)
        dw SSFP_MUSIC_CMD_ENDOFFRAME2X
ENDC
IF DEF(MUSIC_CMD_ENDOFFRAME3X)
        dw SSFP_MUSIC_CMD_ENDOFFRAME3X
ENDC
IF DEF(MUSIC_CMD_ENDOFFRAME4X)
        dw SSFP_MUSIC_CMD_ENDOFFRAME4X
ENDC

IF DEF(MUSIC_CMD_PITCHUP_ON)
        dw SSFP_MUSIC_CMD_PITCHUP_ON
ENDC
IF DEF(MUSIC_CMD_PITCHDOWN_ON)
        dw SSFP_MUSIC_CMD_PITCHDOWN_ON
ENDC
IF DEF(MUSIC_CMD_TRIPLENOTE_ON)
        dw SSFP_MUSIC_CMD_TRIPLENOTE_ON
ENDC
IF DEF(MUSIC_CMD_EXTRA)
        dw SSFP_MUSIC_CMD_EXTRA
ENDC
SSFP_Music_JumpTable_END:
;----------------------------------------------------------------------------------------
SECTION "SSTableInst1", HOME[$3EE8]
;----------------------------------------------------------------------------------------
; common commands
SSFP_Inst1_JumpTable:
IF DEF(MUSIC_INSTCMD_X_FRAMEEND)
        dw SSFP_Inst1_CMD_FRAMEEND
ENDC
IF DEF(MUSIC_INSTCMD_X_START)
        dw SSFP_Inst1_CMD_START
ENDC
IF DEF(MUSIC_INSTCMD_X_END)
        dw SSFP_Inst1_CMD_END
ENDC
IF DEF(MUSIC_INSTCMD_X_ENVELOPE)
        dw SSFP_Inst1_CMD_ENVELOPE
ENDC
IF DEF(MUSIC_INSTCMD_X_STARTFREQ)
        dw SSFP_Inst1_CMD_STARTFREQ
ENDC
IF DEF(MUSIC_INSTCMD_X_ENVELOPEVOL)
        dw SSFP_Inst1_CMD_ENVELOPEVOL
ENDC
IF DEF(MUSIC_INSTCMD_X_STARTENVVOLFREQ)
        dw SSFP_Inst1_CMD_STARTENVVOLFREQ
ENDC
IF DEF(MUSIC_INSTCMD_X_PANMID)
        dw SSFP_Inst1_CMD_PANMID
ENDC
IF DEF(MUSIC_INSTCMD_X_PANRIGHT)
        dw SSFP_Inst1_CMD_PANRIGHT
ENDC
IF DEF(MUSIC_INSTCMD_X_PANLEFT)
        dw SSFP_Inst1_CMD_PANLEFT
ENDC
;........................................................................................
; specific commands

IF DEF(MUSIC_INSTCMD_12_PULSELEN)
        dw SSFP_Inst1_CMD_PULSELEN
ENDC
IF DEF(MUSIC_INSTCMD_1_SWEEP)
        dw SSFP_Inst1_CMD_SWEEP
ENDC
SSFP_Inst1_JumpTable_END:
;----------------------------------------------------------------------------------------
SECTION "SSTableInst2", HOME[$3F28]
;----------------------------------------------------------------------------------------
; common commands
SSFP_Inst2_JumpTable:
IF DEF(MUSIC_INSTCMD_X_FRAMEEND)
        dw SSFP_Inst2_CMD_FRAMEEND
ENDC
IF DEF(MUSIC_INSTCMD_X_START)
        dw SSFP_Inst2_CMD_START
ENDC
IF DEF(MUSIC_INSTCMD_X_END)
        dw SSFP_Inst2_CMD_END
ENDC
IF DEF(MUSIC_INSTCMD_X_ENVELOPE)
        dw SSFP_Inst2_CMD_ENVELOPE
ENDC
IF DEF(MUSIC_INSTCMD_X_STARTFREQ)
        dw SSFP_Inst2_CMD_STARTFREQ
ENDC
IF DEF(MUSIC_INSTCMD_X_ENVELOPEVOL)
        dw SSFP_Inst2_CMD_ENVELOPEVOL
ENDC
IF DEF(MUSIC_INSTCMD_X_STARTENVVOLFREQ)
        dw SSFP_Inst2_CMD_STARTENVVOLFREQ
ENDC
IF DEF(MUSIC_INSTCMD_X_PANMID)
        dw SSFP_Inst2_CMD_PANMID
ENDC
IF DEF(MUSIC_INSTCMD_X_PANRIGHT)
        dw SSFP_Inst2_CMD_PANRIGHT
ENDC
IF DEF(MUSIC_INSTCMD_X_PANLEFT)
        dw SSFP_Inst2_CMD_PANLEFT
ENDC
;........................................................................................
; specific commands

IF DEF(MUSIC_INSTCMD_12_PULSELEN)
        dw SSFP_Inst2_CMD_PULSELEN
ENDC
IF DEF(MUSIC_INSTCMD_1_SWEEP)
        dw SSFP_Inst2_CMD_SWEEP
ENDC
SSFP_Inst2_JumpTable_END:
;----------------------------------------------------------------------------------------
SECTION "SSTableInst3", HOME[$3F40]
;----------------------------------------------------------------------------------------
; common commands
SSFP_Inst3_JumpTable:
IF DEF(MUSIC_INSTCMD_X_FRAMEEND)
        dw SSFP_Inst3_CMD_FRAMEEND
ENDC
IF DEF(MUSIC_INSTCMD_X_START)
        dw SSFP_Inst3_CMD_START
ENDC
IF DEF(MUSIC_INSTCMD_X_END)
        dw SSFP_Inst3_CMD_END
ENDC
IF DEF(MUSIC_INSTCMD_X_ENVELOPE)
        dw SSFP_Inst3_CMD_ENVELOPEVOL ; crash prevent
ENDC
IF DEF(MUSIC_INSTCMD_X_STARTFREQ)
        dw SSFP_Inst3_CMD_STARTFREQ
ENDC
IF DEF(MUSIC_INSTCMD_X_ENVELOPEVOL)
        dw SSFP_Inst3_CMD_ENVELOPEVOL
ENDC
IF DEF(MUSIC_INSTCMD_X_STARTENVVOLFREQ)
        dw SSFP_Inst3_CMD_STARTENVVOLFREQ
ENDC
IF DEF(MUSIC_INSTCMD_X_PANMID)
        dw SSFP_Inst3_CMD_PANMID
ENDC
IF DEF(MUSIC_INSTCMD_X_PANRIGHT)
        dw SSFP_Inst3_CMD_PANRIGHT
ENDC
IF DEF(MUSIC_INSTCMD_X_PANLEFT)
        dw SSFP_Inst3_CMD_PANLEFT
ENDC
;........................................................................................
; specific commands

IF DEF(MUSIC_INSTCMD_3_WAVE)
        dw SSFP_Inst3_CMD_WAVE
ENDC

IF DEF(MUSIC_INSTCMD_3_LEN)
        dw SSFP_Inst3_CMD_LEN
ENDC
SSFP_Inst3_JumpTable_END:
;----------------------------------------------------------------------------------------
SECTION "SSTableInst4", HOME[$3F58]
;----------------------------------------------------------------------------------------
; common commands
SSFP_Inst4_JumpTable:
IF DEF(MUSIC_INSTCMD_X_FRAMEEND)
        dw SSFP_Inst4_CMD_FRAMEEND
ENDC
IF DEF(MUSIC_INSTCMD_X_START)
        dw SSFP_Inst4_CMD_START
ENDC
IF DEF(MUSIC_INSTCMD_X_END)
        dw SSFP_Inst4_CMD_END
ENDC
IF DEF(MUSIC_INSTCMD_X_ENVELOPE)
        dw SSFP_Inst4_CMD_ENVELOPE
ENDC
IF DEF(MUSIC_INSTCMD_X_STARTFREQ)
        dw SSFP_Inst4_CMD_STARTFREQ
ENDC
IF DEF(MUSIC_INSTCMD_X_ENVELOPEVOL)
        dw SSFP_Inst4_CMD_ENVELOPEVOL
ENDC
IF DEF(MUSIC_INSTCMD_X_STARTENVVOLFREQ)
        dw SSFP_Inst4_CMD_STARTENVVOLFREQ
ENDC
IF DEF(MUSIC_INSTCMD_X_PANMID)
        dw SSFP_Inst4_CMD_PANMID
ENDC
IF DEF(MUSIC_INSTCMD_X_PANRIGHT)
        dw SSFP_Inst4_CMD_PANRIGHT
ENDC
IF DEF(MUSIC_INSTCMD_X_PANLEFT)
        dw SSFP_Inst4_CMD_PANLEFT
ENDC
;........................................................................................
; specific commands

IF DEF(MUSIC_INSTCMD_4_POLYLOAD)
        DW SSFP_Inst4_CMD_POLYLOAD
ENDC

IF DEF(MUSIC_INSTCMD_4_LEN)
        DW SSFP_Inst4_CMD_LEN
ENDC
SSFP_Inst4_JumpTable_END:
;----------------------------------------------------------------------------------------
SECTION "SSTableFreq", HOME[$3F70]
;----------------------------------------------------------------------------------------
FrequencyTable:
    DW $0020,$0091,$00FC,$0160,$01C0,$0219,$026E,$02BE,$030A,$0351,$0394,$03D4
    DW $0410,$0448,$047E,$04B0,$04E0,$050D,$0537,$055F,$0585,$05A8,$05CA,$05EA
    DW $0608,$0624,$063F,$0658,$0670,$0686,$069C,$06B0,$06C2,$06D4,$06E5,$06F5
    DW $0704,$0712,$071F,$072C,$0738,$0743,$074E,$0758,$0761,$076A,$0773,$077A
    DW $0782,$0789,$0790,$0796,$079C,$07A2,$07A7,$07AC,$07B1,$07B5,$07B9,$07BD
    DW $07C1,$07C5,$07C8,$07CB,$07CE,$07D1,$07D3,$07D6,$07D8,$07DB,$07DD,$07DF
FrequencyTable_END:
;----------------------------------------------------------------------------------------

PRINTT "Tables sizes: FX="
PRINTV SSFP_MusicFX_JumpTable_END-SSFP_MusicFX_JumpTable1
PRINTT ", M="
PRINTV SSFP_Music_JumpTable_END-SSFP_Music_JumpTable
PRINTT ", I="
PRINTV SSFP_Inst1_JumpTable_END-SSFP_Inst1_JumpTable
PRINTT " "
PRINTV SSFP_Inst2_JumpTable_END-SSFP_Inst2_JumpTable
PRINTT " "
PRINTV SSFP_Inst3_JumpTable_END-SSFP_Inst3_JumpTable
PRINTT " "
PRINTV SSFP_Inst4_JumpTable_END-SSFP_Inst4_JumpTable
PRINTT ", F="
PRINTV FrequencyTable_END-FrequencyTable
PRINTT ", Total="
PRINTV (SSFP_MusicFX_JumpTable_END-SSFP_MusicFX_JumpTable1)+( SSFP_Music_JumpTable_END-SSFP_Music_JumpTable)+( SSFP_Inst1_JumpTable_END-SSFP_Inst1_JumpTable)+( SSFP_Inst2_JumpTable_END-SSFP_Inst2_JumpTable)+( SSFP_Inst3_JumpTable_END-SSFP_Inst3_JumpTable)+( SSFP_Inst4_JumpTable_END-SSFP_Inst4_JumpTable)+( FrequencyTable_END-FrequencyTable)
PRINTT "\n"
