;----------------------------------------------------------------------------------------
; rv's GB sound system V1.1
; code by Stephane Hockenhull
;
; August-99
;
;----------------------------------------------------------------------------------------

SoundSystemInit: MACRO
    fcall SoundSystem_Init
    ENDM

SoundSystemFrameProcess: MACRO
    call SoundSystem_FrameProcess
    ENDM

; MusicPlay OrderList
MusicPlay: MACRO
    ld bc, BANK(\1)
    ld hl, \1
    call Music_Play
    ENDM

MusicStop: MACRO
    fcall Music_Stop
    ENDM

MusicResume: MACRO
    fcall Music_Resume
    ENDM

; SFXPlay sfx
SFXPlay: MACRO
    ld a, \1
    fcall SFX_Play
    ENDM

SFXStop: MACRO
    fcall SFX_Stop
    ENDM

;----------------------------------------------------------------------------------------
; functions
;----------------------------------------------------------------------------------------

; Init sound system
GLOBAL SoundSystem_Init

; called every frame for sound processing
; any registers you want saved must be before calling
GLOBAL SoundSystem_FrameProcess

; stop (pause) music playback and turn off all music used channels
GLOBAL Music_Stop

; init Music variables
; start playing at order pointed by HL
; HL = Order List array pointer
; BC = Bank with order list
; Orderlist is WORD pattern0ptr, Word pattern0bank, WORD pattern1ptr, Word pattern1bank, ...
GLOBAL	Music_Play

; resume music playback
GLOBAL	Music_Resume

; play an sfx if index < SoundFXCurrent
; a = SFX index number
; l = note index
; a gets trashed with value of l
GLOBAL 	SFX_Play

; stop all sfx (turn off all sfx used channels)
GLOBAL 	SFX_Stop

; lock/unlock channel 3
; A get trashed
; other registers preserved
GLOBAL  SFX_LockChnl3
GLOBAL  SFX_UnlockChnl3

;----------------------------------------------------------------------------------------
; Music & SFX vars
;----------------------------------------------------------------------------------------

; table of pointers to sound effects (4 pointers per SFX (one per channel) NULL = channel unused)
;GLOBAL  SoundFXTable
; bank where the SoundFXTable and soundfx are located (WORD)
;GLOBAL  SoundFXBank

;GLOBAL  SoundFXLock     ; read only, for debug

; table of pointers to instruments (1 pointer per Instrument)
;GLOBAL  MusicInstrumentTable
;bank where the MusicInstrumentTable and instruments are located (WORD)
;GLOBAL  MusicInstrumentBank

; arbitrary data set by music to allow visual effects synced with music
; originally initialized to 0
;GLOBAL  MusicSyncFlag

SoundSystem_RAM_START EQU $DF80

RSSET SoundSystem_RAM_START

MusicSyncFlag           RB 1    ; arbitrary value set by the song to sync visual effects
                            ; with bg music

;*** Soundfx vars
SoundFXLock             RB 1    ; bit field, %43214321, 1 = Music, 0 = SFX Locked
SoundFXTable            RB 2    ; table of soundfx pointers
SoundFXBank             RB 2    ; bank of soundfxs
SoundFXStart            RB 4    ; sound fx to start (255 = none)
SoundFXNote             RB 1    ; sound fx's start note

;*** music/sfx shared vars
MusicSFXPanning         RB 1
MusicSFXInstPause       RB 4    ; Frames Left before instrument/soundfx update
MusicSFXInstPtr         RB 8    ; pointers to playing instruments/soundfx
MusicSFXInstBank        RB 8    ; bank of active instrument
MusicSFXInstChnl3WaveID RB 1    ; current waveid loaded, 255 = none, IDs of 255 in instruments will load, whatever the value here
MusicSFXInstChnl3Lock   RB 1    ; 0 = no lock, 1 = external lock

;*** Music vars
MusicPlayMode           RB 1    ; current music mode, 0 = off
MusicNextFrame          RB 1    ; number of frames until the next music commands
MusicCommandPtr         RB 2    ; position of playing music
MusicCommandBank        RB 2    ; bank of playing music
MusicOrderPtr           RB 2    ; position of pattern order list (list of pointers to start of patterns)
MusicOrderBank          RB 2    ; bank of order list
MusicInstrumentTable    RB 2    ; table of instrument pointers
MusicInstrumentBank     RB 2  ; bank of instruments

MusicPatternLoopCounter RB 1    ; pattern loop counter

; ** misc vars
ChannelMusicFreqs       RB 8    ; GB frequencies of channels for music backup
ChannelMusicNotes       RB 8    ; GB frequencies of channels for music backup
ChannelFreqs            RB 8    ; GB frequencies of channels
ChannelVols             RB 4    ; volumes of channels, byte[4:VOL,4:xxxx]

MusicSpeed              RB 1    ; speed

; ** effect vars
ChannelMusicEffects     RB 4    ; active effect, 0 = none
ChannelMusicFXParam     RB 8    ; parameters for effects (WORDs)
ChannelMusicFXParam2    RB 8    ; parameters for effects (WORDs)

Temp                    RB 2    ; Temporary storage for player calcs

SoundSystem_RAM_END     RB 0

;----------------------------------------------------------------------------------------
; music commands
;----------------------------------------------------------------------------------------
RSRESET

MUSIC_CMD_ENDOFFRAME      RB 1

MUSIC_CMD_PLAYINSTNOTE    RB 1
MUSIC_CMD_PLAYINST        RB 1

MUSIC_CMD_SETVOLUME       RB 1
;MUSIC_CMD_SETPANNING      RB 1
MUSIC_CMD_VIBRATO_ON      RB 1
;MUSIC_CMD_DUALNOTE_ON     RB 1
MUSIC_CMD_EFFECT_OFF      RB 1
;MUSIC_CMD_SETMASTERVOLUME RB 1

MUSIC_CMD_SYNCFLAG        RB 1

MUSIC_CMD_ENDOFPATTERN    RB 1
;MUSIC_CMD_LOOPPATTERN     RB 1
MUSIC_CMD_GOTOORDER       RB 1
MUSIC_CMD_ENDOFSONG       RB 1

MUSIC_CMD_SETSPEED        RB 1
MUSIC_CMD_ENDOFFRAME1X    RB 1
MUSIC_CMD_ENDOFFRAME2X    RB 1
MUSIC_CMD_ENDOFFRAME3X    RB 1
MUSIC_CMD_ENDOFFRAME4X    RB 1

MUSIC_CMD_PITCHUP_ON      RB 1
MUSIC_CMD_PITCHDOWN_ON    RB 1
MUSIC_CMD_TRIPLENOTE_ON   RB 1

MUSIC_CMD_EXTRA           RB 1

; number of commands
MUSIC_CMD_TOTALCOUNT     RB 0
;----------------------------------------------------------------------------------------
; music effects
;----------------------------------------------------------------------------------------
RSRESET

MUSIC_FX_NONE           RB 1
MUSIC_FX_VIB1           RB 1
MUSIC_FX_VIB2           RB 1
;MUSIC_FX_DUALFREQ1      RB 1
;MUSIC_FX_DUALFREQ2      RB 1

MUSIC_FX_TRIPLEFREQ1    RB 1
MUSIC_FX_TRIPLEFREQ2    RB 1
MUSIC_FX_TRIPLEFREQ3    RB 1

MUSIC_FX_PITCHUP        RB 1
MUSIC_FX_PITCHDOWN      RB 1
;----------------------------------------------------------------------------------------
; instrument commands
;----------------------------------------------------------------------------------------

; common commands
RSRESET

MUSIC_INSTCMD_X_FRAMEEND        RB 1
MUSIC_INSTCMD_X_START           RB 1
MUSIC_INSTCMD_X_END             RB 1
MUSIC_INSTCMD_X_ENVELOPE        RB 1
MUSIC_INSTCMD_X_STARTFREQ       RB 1
MUSIC_INSTCMD_X_ENVELOPEVOL     RB 1
MUSIC_INSTCMD_X_STARTENVVOLFREQ RB 1
MUSIC_INSTCMD_X_PANMID          RB 1
MUSIC_INSTCMD_X_PANRIGHT        RB 1
MUSIC_INSTCMD_X_PANLEFT         RB 1
; count of common instrument commands
MUSIC_INSTCMD_COMMONCOUNT RB 0

; specific commands

; channel 1&2
RSSET MUSIC_INSTCMD_COMMONCOUNT
MUSIC_INSTCMD_12_PULSELEN       RB 1
MUSIC_INSTCMD_1_SWEEP           RB 1

; channel 3
RSSET MUSIC_INSTCMD_COMMONCOUNT
MUSIC_INSTCMD_3_WAVE            RB 1
MUSIC_INSTCMD_3_LEN             RB 1

; channel 4
RSSET MUSIC_INSTCMD_COMMONCOUNT
MUSIC_INSTCMD_4_POLYLOAD        RB 1
MUSIC_INSTCMD_4_LEN             RB 1

