; Simplest possible example of using MUSE with ASM6.
    
    .include "muse-flags.inc"
    
    ; iNES header.
    NUM_16K_PRG_BANKS  = 2
    NUM_8K_CHR_BANKS   = 0 ; CHR-RAM
    MAPPER             = 0 ; NROM
    MIRRORING          = 0 ; Horizontal
    .byte "NES", $1A
    .byte NUM_16K_PRG_BANKS
    .byte NUM_8K_CHR_BANKS
    .byte ( MAPPER & $F ) << 4 | MIRRORING
    .byte MAPPER & $F0
    .dsb 8, 0
    
    .enum $0000
        ; 7 bytes of zeropage.
        MUSE_ZEROPAGE   .dsb 7
    .ende
    
    .enum $0200
        ; 256 bytes of RAM.
        MUSE_RAM        .dsb 256
    .ende
    
    .base $8000
    
    .org $8000
reset:
    ; Initialize MUSE.
    lda #<snd_data
    ldx #>snd_data
    jsr MUSE_init
    
    ; Load the song.
    lda #0
    jsr MUSE_startMusic
    
    ; MUSE_init sets the MUSE_PAUSE flag by default, so clear that now.
    ; I'm also setting the MUSE_NTSC_MODE flag here for demonstration purposes.
    ; In a real program you should detect the system and set the flag based on that.
    lda #MUSE_NTSC_MODE
    jsr MUSE_setFlags
    
    ; Enable NMI to start playing.
    lda #$80
    sta $2000

inf:
    jmp inf

nmi:
    ; Update the music (sound effects not used in this demo).
    jsr MUSE_update
    rti
    
irq:
    jmp irq
    
; General data.
    .include "snd-data/snd-data.asm"
; Song data.
    .include "snd-data/snd-data-cheetah.asm"
; No sound effect data.

    .align 256
; MUSE library requires ~8K of space, and must be aligned to a 256 byte page.
    .include "muse-asm6.inc"
    
    .org $C000
; DPCM data (must be at $C000-FFFF and aligned to 64 bytes).
    .include "snd-data/snd-data-dpcm.asm"
    
    .org $FFFA
    .word nmi
    .word reset
    .word irq
