/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import symreader.SamplePool;

public class ImportSample {
    float BaseFrequency = 0.0f;
    float SampledFrequency = 0.0f;
    private int NumbOfSamples = 0;
    private int SampleStartOffset = 0;
    private int SampleLengthByte = 0;
    int SampleResolutionBit = 0;
    float SampleMIN = 0.0f;
    float SampleMAX = 0.0f;
    private boolean isMSBFirst = false;
    private boolean isInterleaved = false;
    private boolean isUnsigned = true;
    boolean FormatRecognized = false;
    int Format;
    float FormatVersion;
    String FormatString;
    private float LoopStart = 0.0f;
    private float LoopLength = 0.0f;
    private int NumbOfSamplePools = 0;
    private boolean SamplePoolsReady = false;
    private float[] SamplePoolSrc;
    SamplePool[] SamplePools;
    byte[] RawSample;
    int RawSampleLen;
    AudioFileFormat myAudioFileFormat;
    ByteArrayInputStream myByteArrayInputStream;
    ByteArrayOutputStream tempDestStreamWAV;
    AudioInputStream myAudioInputStream;
    boolean isJavaInternalFormat = false;

    boolean Analyse(byte[] src, int len) {
        this.FormatRecognized = false;
        this.SamplePoolsReady = false;
        this.isJavaInternalFormat = false;
        this.NumbOfSamplePools = 0;
        if (!this.FormatRecognized) {
            this.FormatRecognized = this.AnalyseIFF(src, len);
        }
        if (!this.FormatRecognized) {
            this.FormatRecognized = this.AnalyseAIF(src, len);
        }
        if (!this.FormatRecognized) {
            this.FormatRecognized = this.AnalyseMAESTRO(src, len);
        }
        if (!this.FormatRecognized) {
            this.FormatRecognized = this.AnalyseWAV(src, len);
        }
        if (!this.FormatRecognized) {
            this.FormatRecognized = this.AnalyseSYMPHEXPORT16BT(src, len);
        }
        if (!this.FormatRecognized) {
            this.FormatRecognized = this.AnalyseRAW(src, len);
        }
        this.makeRawBackup(src, len);
        this.copyToSamplePoolSrc(src, len);
        this.buildSamplePools();
        return this.FormatRecognized;
    }

    void makeRawBackup(byte[] src, int len) {
        this.RawSample = new byte[len];
        this.RawSampleLen = len;
        for (int i = 0; i < len; ++i) {
            this.RawSample[i] = src[i];
        }
    }

    int getSampleLen(int i) {
        if (this.SamplePoolsReady && i < this.NumbOfSamplePools) {
            return this.SamplePools[i].getNumbOfSamples();
        }
        return 0;
    }

    int getNumbOfChannels() {
        if (this.SamplePoolsReady) {
            return this.NumbOfSamplePools;
        }
        return 0;
    }

    SamplePool getSamplePool(int i) {
        if (this.SamplePoolsReady && i < this.NumbOfSamplePools) {
            return this.SamplePools[i];
        }
        return null;
    }

    private int IntBytesToInt(int MSB, int LSB) {
        MSB &= 0xFF;
        MSB *= 256;
        if ((MSB += (LSB &= 0xFF)) >= 32768) {
            MSB = -65536 + MSB;
        }
        return MSB;
    }

    private void copyToSamplePoolSrc(byte[] src, int len) {
        this.SamplePoolSrc = new float[len];
        assert (this.SamplePoolSrc == null);
        this.DecodeToFloat(src, this.SamplePoolSrc);
    }

    private void buildSamplePools() {
        if (this.NumbOfSamplePools > 0) {
            this.SamplePools = new SamplePool[this.NumbOfSamplePools];
            for (int i = 0; i < this.NumbOfSamplePools; ++i) {
                this.SamplePools[i] = new SamplePool();
                this.copyToSamplePool(i);
            }
            this.SamplePoolsReady = true;
        }
    }

    private void copyToSamplePool(int SamplePoolIndex) {
        int LenOneSamplePoolSamples = this.NumbOfSamples / this.NumbOfSamplePools;
        float SampleBoost = this.SampleMAX;
        if (-this.SampleMIN > this.SampleMAX) {
            SampleBoost = -this.SampleMIN;
        }
        this.SamplePools[SamplePoolIndex].Samples = new float[LenOneSamplePoolSamples];
        this.SamplePools[SamplePoolIndex].setNumbOfSamples(LenOneSamplePoolSamples);
        if (!this.isInterleaved) {
            int StartOffset = LenOneSamplePoolSamples * SamplePoolIndex;
            for (int i = 0; i < LenOneSamplePoolSamples; ++i) {
                this.SamplePools[SamplePoolIndex].Samples[i] = this.SamplePoolSrc[i + StartOffset] * (1.0f / SampleBoost);
            }
        } else {
            int StartOffset = SamplePoolIndex;
            for (int i = 0; i < LenOneSamplePoolSamples; ++i) {
                this.SamplePools[SamplePoolIndex].Samples[i] = this.SamplePoolSrc[StartOffset + i * this.NumbOfSamplePools] * (1.0f / SampleBoost);
            }
        }
    }

    byte[] convertToWav(byte[] src) {
        boolean success = false;
        try {
            AudioFormat DestAudioFormat = new AudioFormat(this.SampledFrequency, 16, this.NumbOfSamplePools, true, false);
            if (AudioSystem.isConversionSupported(DestAudioFormat, this.myAudioFileFormat.getFormat())) {
                this.myAudioInputStream = AudioSystem.getAudioInputStream(this.myByteArrayInputStream);
                this.tempDestStreamWAV = new ByteArrayOutputStream();
                AudioSystem.write(this.myAudioInputStream, AudioFileFormat.Type.AIFF, this.tempDestStreamWAV);
                success = true;
                return this.tempDestStreamWAV.toByteArray();
            }
        }
        catch (UnsupportedAudioFileException ex) {
            Logger.getLogger(ImportSample.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImportSample.class.getName()).log(Level.SEVERE, null, ex);
        }
        return src;
    }

    private void DecodeToFloat(byte[] src, float[] dest) {
        float Sample_LEN = 2.0f;
        float Max = 0.0f;
        float Min = 65536.0f;
        if (this.FormatRecognized && this.SampleLengthByte > 0) {
            float s;
            int i;
            float SampleOffset;
            float SampleFactor;
            if (this.SampleResolutionBit == 8) {
                this.NumbOfSamples = this.SampleLengthByte;
                SampleFactor = Sample_LEN / 256.0f;
                SampleOffset = 0.0f;
                for (i = 0; i < this.NumbOfSamples; ++i) {
                    byte b;
                    s = !this.isUnsigned ? (float)src[i + this.SampleStartOffset] : ((b = src[i + this.SampleStartOffset]) >= 0 ? (float)b - 128.0f : (float)(256 + b) - 128.0f);
                    if ((s = s * SampleFactor - SampleOffset) > Max) {
                        Max = s;
                    }
                    if (s < Min) {
                        Min = s;
                    }
                    dest[i] = s;
                }
            }
            if (this.SampleResolutionBit == 16) {
                byte a;
                SampleFactor = Sample_LEN / 65536.0f;
                SampleOffset = 0.0f;
                this.NumbOfSamples = this.SampleLengthByte / 2;
                if (!this.isMSBFirst) {
                    for (i = 0; i < this.NumbOfSamples; ++i) {
                        int Offset = (i + this.SampleStartOffset) * 2;
                        byte b = src[Offset];
                        a = src[Offset + 1];
                        s = this.IntBytesToInt(a, b);
                        if ((s = s * SampleFactor - SampleOffset) > Max) {
                            Max = s;
                        }
                        if (s < Min) {
                            Min = s;
                        }
                        dest[i] = s;
                    }
                } else {
                    for (i = 0; i < this.NumbOfSamples; ++i) {
                        int Offset = (i + this.SampleStartOffset) * 2;
                        a = src[Offset];
                        byte b = src[Offset + 1];
                        s = this.IntBytesToInt(a, b);
                        if ((s = s * SampleFactor - SampleOffset) > Max) {
                            Max = s;
                        }
                        if (s < Min) {
                            Min = s;
                        }
                        dest[i] = s;
                    }
                }
            }
            this.SampleMIN = Min;
            this.SampleMAX = Max;
        }
    }

    private void InitInfo(byte[] src, int len) {
        this.BaseFrequency = 440.0f;
        this.SampledFrequency = 44100.0f;
        this.SampleResolutionBit = 8;
        this.SampleStartOffset = 0;
        this.SampleLengthByte = len;
        this.FormatVersion = 1.0f;
        this.LoopLength = 0.0f;
        this.LoopStart = 0.0f;
        this.isInterleaved = false;
        this.isMSBFirst = false;
        this.FormatString = "";
        this.NumbOfSamplePools = 1;
    }

    private boolean FindStringAtPos(byte[] src, int len, String s, int pos) {
        boolean found = true;
        int i = 0;
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == src[i + pos]) continue;
            found = false;
        }
        return found;
    }

    private int FindString(byte[] src, int len, String s, int maxoffset) {
        int foundpos = -1;
        int i = 0;
        for (i = 0; i < maxoffset; ++i) {
            if (!this.FindStringAtPos(src, len, s, i)) continue;
            foundpos = i;
        }
        return foundpos;
    }

    private int ReadBinaryIntMSB(byte[] src, int pos) {
        int d = src[pos] & 0xFF;
        int c = src[pos + 1] & 0xFF;
        int b = src[pos + 2] & 0xFF;
        int a = src[pos + 3] & 0xFF;
        int BinInt = d * 256 * 256 * 256 + c * 256 * 256 + b * 256 + a;
        return BinInt;
    }

    private int ReadBinaryInt(byte[] src, int pos) {
        int a = src[pos] & 0xFF;
        int b = src[pos + 1] & 0xFF;
        int c = src[pos + 2] & 0xFF;
        int d = src[pos + 3] & 0xFF;
        int BinInt = d * 256 * 256 * 256 + c * 256 * 256 + b * 256 + a;
        return BinInt;
    }

    private int ReadBinaryShort(byte[] src, int pos) {
        int a = src[pos] & 0xFF;
        int b = src[pos + 1] & 0xFF;
        int BinInt = b * 256 + a;
        return BinInt;
    }

    private boolean AnalyseJAVANative(byte[] src, int len) {
        boolean FormatFound = false;
        try {
            this.myByteArrayInputStream = new ByteArrayInputStream(src);
            this.myAudioFileFormat = AudioSystem.getAudioFileFormat(this.myByteArrayInputStream);
            this.InitInfo(src, len);
            this.Format = 7;
            this.SampleResolutionBit = this.myAudioFileFormat.getFormat().getSampleSizeInBits();
            this.isMSBFirst = this.myAudioFileFormat.getFormat().isBigEndian();
            this.isInterleaved = true;
            this.FormatString = "JAVA Converted to: " + this.myAudioFileFormat.toString();
            this.NumbOfSamplePools = this.myAudioFileFormat.getFormat().getChannels();
            this.SampledFrequency = this.myAudioFileFormat.getFormat().getSampleRate();
            FormatFound = true;
            this.isJavaInternalFormat = true;
        }
        catch (Exception ex) {
            Logger.getLogger(ImportSample.class.getName()).log(Level.SEVERE, null, ex);
            this.isJavaInternalFormat = false;
        }
        return FormatFound;
    }

    private boolean AnalyseMAESTRO(byte[] src, int len) {
        boolean FormatFound = false;
        if (this.FindStringAtPos(src, len, "MAESTRO", 0)) {
            this.InitInfo(src, len);
            this.Format = 1;
            this.SampleResolutionBit = 16;
            this.isInterleaved = true;
            this.isMSBFirst = true;
            FormatFound = true;
            if (this.ReadBinaryInt(src, 12) == 0) {
                this.NumbOfSamplePools = 2;
                this.FormatString = "Maestro v1.0 (Stereo)";
            } else {
                this.FormatString = "Maestro v1.0 (Mono)";
            }
        }
        this.SampleStartOffset = 16;
        if (this.SampleResolutionBit == 16) {
            this.SampleLengthByte -= this.SampleStartOffset;
            this.SampleStartOffset /= 2;
        } else {
            this.SampleLengthByte -= this.SampleStartOffset;
        }
        return FormatFound;
    }

    private boolean AnalyseWAV(byte[] src, int len) {
        boolean FormatFound = false;
        if (this.FindStringAtPos(src, len, "RIFF", 0) && this.FindStringAtPos(src, len, "WAVE", 8)) {
            int posBody = 0;
            int searchLen = 0;
            this.InitInfo(src, len);
            this.Format = 2;
            this.SampleResolutionBit = 16;
            this.isInterleaved = true;
            this.isMSBFirst = false;
            FormatFound = true;
            this.FormatString = "WAVE-RIFF (Windows Audio) 1.0";
            if (this.FindStringAtPos(src, len, "fmt", 12)) {
                int CompressionType = this.ReadBinaryShort(src, 20);
                int BitsPerSample = this.ReadBinaryShort(src, 34);
                if (BitsPerSample == 8) {
                    this.SampleResolutionBit = 8;
                    this.isUnsigned = true;
                } else if (BitsPerSample != 16) {
                    this.Format = 0;
                    this.FormatString = "Warn:WAVE-RIFF (" + BitsPerSample + "Bit unsupported)";
                    return false;
                }
                if (CompressionType != 1) {
                    this.Format = 0;
                    this.FormatString = this.FormatString + " Compression unsupported)";
                    return false;
                }
            }
            if ((searchLen = 256) > len + 8) {
                searchLen = len - 8;
            }
            if ((posBody = this.FindString(src, len, "data", searchLen)) > 0) {
                this.SampleStartOffset = posBody + 8;
                int foundlen = this.ReadBinaryInt(src, posBody + 4);
                if (foundlen < this.SampleLengthByte) {
                    this.SampleLengthByte = foundlen;
                }
                if (this.SampleResolutionBit == 16) {
                    this.SampleLengthByte -= this.SampleStartOffset;
                    this.SampleStartOffset /= 2;
                } else {
                    this.SampleLengthByte -= this.SampleStartOffset;
                }
            }
        }
        return FormatFound;
    }

    private boolean AnalyseIFF(byte[] src, int len) {
        boolean FormatFound = false;
        if (this.FindStringAtPos(src, len, "FORM", 0) && this.FindStringAtPos(src, len, "8SVX", 8)) {
            int Chan;
            int posBody = 0;
            int searchLen = 0;
            this.InitInfo(src, len);
            this.Format = 5;
            this.SampleResolutionBit = 8;
            this.isInterleaved = false;
            this.isMSBFirst = false;
            this.isUnsigned = false;
            FormatFound = true;
            this.NumbOfSamplePools = 1;
            this.FormatString = "IFF-8SVX Audio 8 Bit (Amiga OS) v1.0";
            searchLen = 1024;
            if (searchLen > len + 8) {
                searchLen = len - 8;
            }
            if ((posBody = this.FindString(src, len, "BODY", searchLen)) > 0) {
                this.SampleStartOffset = posBody + 4;
                this.SampleLengthByte -= this.SampleStartOffset;
            }
            if ((searchLen = 256) > len + 8) {
                searchLen = len - 8;
            }
            if ((posBody = this.FindString(src, len, "Conv. by  Symphonie", searchLen)) > 0 && (posBody = this.FindString(src, len, "CHAN", searchLen)) > 0 && (Chan = this.ReadBinaryIntMSB(src, posBody + 4)) == 4) {
                this.NumbOfSamplePools = 2;
            }
        }
        return FormatFound;
    }

    private boolean AnalyseSYMPHEXPORT16BT(byte[] src, int len) {
        boolean FormatFound = false;
        if (this.FindStringAtPos(src, len, "16BT", 0)) {
            this.InitInfo(src, len);
            this.Format = 6;
            this.SampleResolutionBit = 16;
            this.SampleStartOffset = 6;
            this.SampleLengthByte -= 12;
            this.isInterleaved = false;
            this.isMSBFirst = true;
            FormatFound = true;
            this.FormatString = "Symphonie Export 16 Bit v1.0";
        }
        return FormatFound;
    }

    private boolean AnalyseAIF(byte[] src, int len) {
        boolean FormatFound = false;
        if (this.FindStringAtPos(src, len, "FORM", 0) && this.FindStringAtPos(src, len, "AIFF", 8)) {
            int posBody = 0;
            int searchLen = 0;
            this.InitInfo(src, len);
            this.Format = 3;
            this.SampleResolutionBit = 16;
            this.isInterleaved = true;
            this.isMSBFirst = true;
            FormatFound = true;
            this.FormatString = "AIF Audio 16 Bit v1.0 (Mono)";
            this.NumbOfSamplePools = 1;
            searchLen = 512;
            if (searchLen > len + 8) {
                searchLen = len - 8;
            }
            if ((posBody = this.FindString(src, len, "COMM", searchLen)) > 0 && src[posBody + 9] != 1) {
                this.FormatString = "AIF Audio 16 Bit v1.0 (Stereo)";
                this.NumbOfSamplePools = 2;
            }
            if ((searchLen = 512) > len + 8) {
                searchLen = len - 8;
            }
            if ((posBody = this.FindString(src, len, "SSND", searchLen)) > 0) {
                this.SampleStartOffset = (posBody + 16) / 2;
                this.SampleLengthByte -= this.SampleStartOffset * 2;
            }
        }
        return FormatFound;
    }

    private boolean AnalyseRAW(byte[] src, int len) {
        this.InitInfo(src, len);
        this.SampleResolutionBit = 8;
        this.isUnsigned = false;
        this.Format = 4;
        this.FormatString = "RAW (Assuming 8 Bit 0-255)";
        return true;
    }
}

