/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import symreader.Song;
import symreader.SongEvent;
import symreader.SongPattern;

class PEDBlock {
    Song mySong;
    int NumbOfVoices = 0;
    boolean isMarking = false;
    int x;
    int y;
    int w;
    int h;
    int x2;
    int y2;
    int PatNr;
    public SongPattern TempPattern;

    PEDBlock(Song newmySong) {
        this.mySong = newmySong;
        this.NumbOfVoices = this.mySong.getNumbOfVoices();
    }

    String getInfo() {
        if (this.isMarking) {
            return "Marking Block...: (x:" + this.x + ",y:" + this.y + ")";
        }
        return "Block Marked: (x:" + this.x + ",y:" + this.y + ")" + " (w:" + this.w + ",h:" + this.h + ")";
    }

    void markReset() {
        this.isMarking = false;
    }

    void markBlockXY(int myPatNr, int tx, int ty) {
        if (!this.isMarking) {
            this.x = tx;
            this.y = ty;
        } else {
            int temp = 0;
            this.x2 = tx;
            this.y2 = ty;
            if (this.x2 < this.x) {
                temp = this.x2;
                this.x2 = this.x;
                this.x = temp;
            }
            if (this.y2 < this.y) {
                temp = this.y2;
                this.y2 = this.y;
                this.y = temp;
            }
            this.w = this.x2 - this.x + 1;
            this.h = this.y2 - this.y + 1;
        }
        this.PatNr = myPatNr;
        this.isMarking = !this.isMarking;
    }

    void finishMarking(int myPatNr, int tx, int ty) {
        if (this.isMarking) {
            this.markBlockXY(myPatNr, tx, ty);
        }
    }

    boolean checkMarkingFinished() {
        return !this.isMarking;
    }

    void copyBlock(int myPatNr, int tx, int ty) {
        this.finishMarking(myPatNr, tx, ty);
        for (int RowNr = 0; RowNr < this.h; ++RowNr) {
            for (int VoiceNr = 0; VoiceNr < this.w; ++VoiceNr) {
                SongEvent SrcEvent = this.mySong.getSongEvent(myPatNr, this.x + VoiceNr, this.y + RowNr);
                SongEvent DestEvent = this.getTempPattern().getSongEventForced(VoiceNr, RowNr);
                if (SrcEvent != null) {
                    SrcEvent.copyValues(DestEvent);
                    continue;
                }
                DestEvent.clear();
            }
        }
    }

    void rotateBlockDown(int myPatNr, int tx, int ty) {
        SongEvent LowestEvent = new SongEvent();
        LowestEvent.clear();
        this.finishMarking(myPatNr, tx, ty);
        if (this.h > 1) {
            for (int VoiceNr = 0; VoiceNr < this.w; ++VoiceNr) {
                SongEvent DestEvent;
                SongEvent SrcEvent = this.mySong.getSongEvent(myPatNr, this.x + VoiceNr, this.y + this.h - 1);
                if (SrcEvent != null) {
                    SrcEvent.copyValues(LowestEvent);
                }
                for (int RowNr = this.h - 2; RowNr >= 0; --RowNr) {
                    SrcEvent = this.mySong.getSongEvent(myPatNr, this.x + VoiceNr, this.y + RowNr);
                    DestEvent = this.mySong.getSongEventForced(myPatNr, this.x + VoiceNr, this.y + RowNr + 1);
                    if (SrcEvent != null) {
                        SrcEvent.copyValues(DestEvent);
                        continue;
                    }
                    DestEvent.clear();
                }
                DestEvent = this.mySong.getSongEventForced(myPatNr, this.x + VoiceNr, this.y);
                LowestEvent.copyValues(DestEvent);
            }
        }
    }

    void rotateBlockUp(int myPatNr, int tx, int ty) {
        SongEvent LowestEvent = new SongEvent();
        LowestEvent.clear();
        this.finishMarking(myPatNr, tx, ty);
        if (this.h > 1) {
            for (int VoiceNr = 0; VoiceNr < this.w; ++VoiceNr) {
                SongEvent DestEvent;
                SongEvent SrcEvent = this.mySong.getSongEvent(myPatNr, this.x + VoiceNr, this.y);
                if (SrcEvent != null) {
                    SrcEvent.copyValues(LowestEvent);
                }
                for (int RowNr = 1; RowNr < this.h; ++RowNr) {
                    SrcEvent = this.mySong.getSongEvent(myPatNr, this.x + VoiceNr, this.y + RowNr);
                    DestEvent = this.mySong.getSongEventForced(myPatNr, this.x + VoiceNr, this.y + RowNr - 1);
                    if (SrcEvent != null) {
                        SrcEvent.copyValues(DestEvent);
                        continue;
                    }
                    DestEvent.clear();
                }
                DestEvent = this.mySong.getSongEventForced(myPatNr, this.x + VoiceNr, this.y + this.h - 1);
                LowestEvent.copyValues(DestEvent);
            }
        }
    }

    void pasteBlock(int myPatNr, int tx, int ty) {
        if (this.h == this.mySong.getNumbOfRows()) {
            ty = 0;
        }
        if (this.w == this.mySong.getNumbOfVoices()) {
            tx = 0;
        }
        for (int RowNr = 0; RowNr < this.h; ++RowNr) {
            for (int VoiceNr = 0; VoiceNr < this.w; ++VoiceNr) {
                SongEvent DestEvent = this.mySong.getSongEventForced(myPatNr, tx + VoiceNr, ty + RowNr);
                SongEvent SrcEvent = this.getTempPattern().getSongEvent(VoiceNr, RowNr);
                if (SrcEvent == null || DestEvent == null) continue;
                SrcEvent.copyValues(DestEvent);
            }
        }
    }

    void addBlock(int myPatNr, int tx, int ty) {
        if (this.h == this.mySong.getNumbOfRows()) {
            ty = 0;
        }
        if (this.w == this.mySong.getNumbOfVoices()) {
            tx = 0;
        }
        for (int RowNr = 0; RowNr < this.h; ++RowNr) {
            for (int VoiceNr = 0; VoiceNr < this.w; ++VoiceNr) {
                SongEvent DestEvent = this.mySong.getSongEventForced(myPatNr, tx + VoiceNr, ty + RowNr);
                SongEvent SrcEvent = this.getTempPattern().getSongEvent(VoiceNr, RowNr);
                if (SrcEvent == null || DestEvent == null || DestEvent.SongFXType != 0) continue;
                SrcEvent.copyValues(DestEvent);
            }
        }
    }

    void clearBlock(int myPatNr, int tx, int ty) {
        if (this.checkMarkingFinished()) {
            for (int RowNr = 0; RowNr < this.h; ++RowNr) {
                for (int VoiceNr = 0; VoiceNr < this.w; ++VoiceNr) {
                    SongEvent DestEvent = this.mySong.getSongEvent(myPatNr, this.x + VoiceNr, this.y + RowNr);
                    if (DestEvent == null) continue;
                    DestEvent.clear();
                }
            }
        }
    }

    SongPattern getTempPattern() {
        if (this.TempPattern == null || !this.TempPattern.checkIsInitialized()) {
            if (this.TempPattern == null) {
                this.TempPattern = new SongPattern();
            }
            this.TempPattern.init(this.NumbOfVoices);
            return this.TempPattern;
        }
        return this.TempPattern;
    }
}

