/*
 * Decompiled with CFR 0.152.
 */
package symreader;

public class SampleFilter {
    private boolean LPFilter = true;
    private double high = 0.0;
    private double mid = 0.0;
    private double low = 0.0;
    private double freq;
    private double recq;
    private double q;
    private int Type = 0;

    SampleFilter() {
        this.init(0, 0.0, 44100.0, 0.0);
        this.clearSampleBuffers();
    }

    void clearSampleBuffers() {
        this.high = 0.0;
        this.low = 0.0;
        this.mid = 0.0;
    }

    void init(int newFiltertype, double myq, double FilterFreq, double SampleRate) {
        this.Type = newFiltertype;
        if (this.Type > 4) {
            this.Type = 0;
        }
        if (FilterFreq == 0.0) {
            this.Type = 0;
        } else {
            this.freq = 2.0 * Math.sin(Math.PI * FilterFreq * 10.0 / SampleRate);
            this.recq = myq != 0.0 ? 1.0 / myq : 1.0;
        }
    }

    boolean isActive() {
        return this.Type != 0;
    }

    float getNextFilteredSample(float Sample) {
        if (this.freq == 0.0) {
            this.Type = 0;
        }
        if (this.isActive()) {
            this.high = this.clip((double)Sample - this.mid * this.recq - this.low);
            this.mid += this.high * this.freq;
            this.mid = this.clip(this.mid);
            this.low += this.mid * this.freq;
            this.low = this.clip(this.low);
            switch (this.Type) {
                case 1: {
                    return (float)this.low;
                }
                case 3: {
                    return (float)this.high;
                }
                case 2: {
                    return (float)this.mid;
                }
                case 4: {
                    return (float)(this.low + this.high);
                }
            }
            return (float)this.low;
        }
        return Sample;
    }

    private double clip(double Sample) {
        if (Sample > 1.0) {
            return 1.0;
        }
        if (Sample < -1.0) {
            return -1.0;
        }
        return Sample;
    }
}

