/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import symreader.Song;

class SongEvent {
    Song ParentSong = null;
    int FXClass;
    int SongFXType = 0;
    float A = 0.0f;
    float B = 0.0f;
    float C = 0.0f;
    float D = 0.0f;

    SongEvent() {
        this.UpdateEventClass();
    }

    void UpdateEventClass() {
        this.FXClass = this.SongFXType / 1000;
    }

    void copyValues(SongEvent DestSongEvent) {
        if (DestSongEvent != null) {
            DestSongEvent.A = this.A;
            DestSongEvent.B = this.B;
            DestSongEvent.C = this.C;
            DestSongEvent.D = this.D;
            DestSongEvent.SongFXType = this.SongFXType;
            DestSongEvent.UpdateEventClass();
        }
    }

    void setType(int i) {
        this.SongFXType = i;
        this.UpdateEventClass();
    }

    void clear() {
        this.SongFXType = 0;
        this.FXClass = 0;
        this.A = 0.0f;
        this.B = 0.0f;
        this.C = 0.0f;
        this.D = 0.0f;
    }

    void setKeyOn(int InstrNr, int Pitch, float Vol) {
        this.SongFXType = 1;
        this.A = InstrNr;
        this.B = Pitch;
        this.C = Vol;
        this.UpdateEventClass();
    }

    void setSampleFromAndPitch(int InstrNr, int Pitch, float SamplePos) {
        this.SongFXType = 3001;
        this.A = InstrNr;
        this.B = Pitch;
        this.D = SamplePos;
        this.UpdateEventClass();
    }

    void setVolume(float Vol) {
        this.SongFXType = 1000;
        this.C = Vol;
        this.UpdateEventClass();
    }

    void setPitch(int InstrNr, int Pitch) {
        this.SongFXType = 2000;
        this.A = InstrNr;
        this.B = Pitch;
        this.UpdateEventClass();
    }

    void setPauseEvent() {
        this.SongFXType = 1007;
        this.UpdateEventClass();
    }

    void setContEvent() {
        this.SongFXType = 1008;
        this.UpdateEventClass();
    }

    int getInstrIndexID() {
        if (this.SongFXType == 2000 || this.SongFXType == 3001 || this.SongFXType == 1 || this.SongFXType == 3000) {
            return (int)this.B;
        }
        return -1;
    }
}

