/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import symreader.PatternVoice;
import symreader.Position;
import symreader.Sequence;
import symreader.Song;
import symreader.SongEvent;
import symreader.SongEventPool;
import symreader.SongPattern;
import symreader.SongToken;
import symreader.SymReaderView;
import symreader.SymphonieInstrument;

public class SongIO {
    private boolean ok;
    private JFileChooser JFC = new JFileChooser();
    private File baseFile;
    FileOutputStream basefounbuffered;
    BufferedOutputStream basefo;
    String ObjectID;
    FileInputStream basefi;
    SongToken IOToken = new SongToken();
    byte[] ReadBuffer = new byte[1024];
    int ReadBufferPos = 0;
    boolean EOF = false;
    String[] TokenArray = new String[20];
    String[] TokenArray2 = new String[20];
    char Limiter = (char)34;
    SymReaderView.UIManager SymphManager = null;

    void setUIManager(SymReaderView.UIManager mySymphManager) {
        this.SymphManager = mySymphManager;
    }

    void SongSave() {
    }

    void saveAs(Song MySong) {
        File f = new File(this.SymphManager.getNewModPath());
        this.JFC.setCurrentDirectory(f);
        if (this.JFC.showSaveDialog(this.JFC) == 0) {
            this.baseFile = this.JFC.getSelectedFile();
            this.SymphManager.registerNewModPath(this.JFC.getCurrentDirectory().getAbsolutePath());
            this.save(MySong, this.baseFile);
        }
    }

    void loadAs(Song MySong) {
        boolean Sucess = false;
        File f = new File(this.SymphManager.getNewModPath());
        this.JFC.setCurrentDirectory(f);
        if (this.JFC.showOpenDialog(this.JFC) == 0) {
            try {
                this.baseFile = this.JFC.getSelectedFile();
                this.SymphManager.registerNewModPath(this.JFC.getCurrentDirectory().getAbsolutePath());
                this.basefi = new FileInputStream(this.baseFile);
                if (this.checkIsSymphonieFormat() && !this.EOF) {
                    Sucess = this.loadSongInfo(MySong);
                }
                this.basefi.close();
            }
            catch (Exception ex) {
                Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    boolean loadSongInfo(Song MySong) {
        boolean Sucess = false;
        SongPattern MyPattern = null;
        Position Pos = null;
        SongEvent se = new SongEvent();
        SongEvent myEvent = null;
        SymphonieInstrument si = null;
        int ActualSampleIndex = 0;
        int EventCounter = 0;
        MySong.allocDefaultSong();
        while (!this.EOF) {
            this.readToken(this.IOToken);
            if (this.IOToken.Object.equals("Song")) {
                if (this.IOToken.ID.equals("BPM")) {
                    this.SymphManager.PrintToInfoWindow("BPM:" + this.IOToken.getFloatValue());
                    this.SymphManager.setBPM(this.IOToken.getFloatValue());
                    MySong.setBPM(this.IOToken.getFloatValue());
                }
                if (this.IOToken.ID.equals("NumbOfSequences")) {
                    MySong.allocNumbOfSequences(this.IOToken.getIntValue());
                }
                if (this.IOToken.ID.equals("NumbOfPositions")) {
                    MySong.allocNumbOfPositions(this.IOToken.getIntValue());
                }
                if (this.IOToken.ID.equals("NumbOfVoices")) {
                    MySong.setNumbOfVoices(this.IOToken.getIntValue());
                }
                if (this.IOToken.ID.equals("NumbOfPatterns")) {
                    MySong.allocNumbOfPatterns(this.IOToken.getIntValue());
                }
                if (this.IOToken.ID.equals("NumbOfInstruments")) {
                    MySong.allocNumbInstruments(this.IOToken.getIntValue());
                }
                if (this.IOToken.ID.equals("NumbOfTimePos")) {
                    MySong.setNumbOfRows(this.IOToken.getIntValue());
                }
            }
            if (this.IOToken.Object.equals("Sequence")) {
                // empty if block
            }
            if (this.IOToken.Object.equals("Position")) {
                if (this.IOToken.ID.equals("@ARRAYPOS")) {
                    Pos = MySong.getPosition(this.IOToken.getIntValue());
                    Pos.setNumbOfLayers(1);
                }
                if (Pos != null && this.IOToken.ID.equals("Name")) {
                    Pos.Name = this.IOToken.getStringValue();
                }
                if (Pos != null && this.IOToken.ID.equals("StartRow")) {
                    Pos.StartRow = this.IOToken.getIntValue();
                }
                if (Pos != null && this.IOToken.ID.equals("RowLength")) {
                    Pos.RowLength = this.IOToken.getIntValue();
                }
                if (Pos != null && this.IOToken.ID.equals("PatternNr")) {
                    Pos.PatternNumbers[0] = this.IOToken.getIntValue();
                }
                if (Pos != null && this.IOToken.ID.equals("NumbOfLayers")) {
                    Pos.NumbOfLayers = this.IOToken.getIntValue();
                }
                if (Pos != null && this.IOToken.ID.equals("SpeedCycl")) {
                    Pos.Speed_Cycl = this.IOToken.getIntValue();
                }
                if (Pos != null && this.IOToken.ID.equals("Tune")) {
                    Pos.Tune = this.IOToken.getIntValue();
                }
                if (Pos != null && this.IOToken.ID.equals("NumbOfLoops")) {
                    Pos.NumbOfLoops = this.IOToken.getIntValue();
                }
            }
            if (this.IOToken.Object.equals("Event")) {
                if (this.IOToken.ID.equals("@ARRAYPOS")) {
                    if (this.IOToken.getArrayLen() == 3) {
                        this.IOToken.resetArray();
                    }
                    this.IOToken.addArrayCoor(this.IOToken.getFloatValue());
                    if (this.IOToken.getArrayLen() == 3) {
                        int PatternNr = (int)this.IOToken.getArrayCoor(0);
                        int VoiceIndex = (int)this.IOToken.getArrayCoor(1);
                        float TimePos = this.IOToken.getArrayCoor(2);
                        MyPattern = MySong.getPattern((int)this.IOToken.getArrayCoor(0));
                        if (!MyPattern.checkIsInitialized()) {
                            MyPattern.init(MySong.getNumbOfVoices());
                        }
                        MyPattern.addSongEvent(VoiceIndex, TimePos, se);
                        PatternVoice PatVoc = MyPattern.PatternVoices[VoiceIndex];
                        SongEventPool sep = PatVoc.getSongEventPool(TimePos);
                        myEvent = sep.getSongEvent(0);
                        ++EventCounter;
                    }
                }
                if (myEvent != null && this.IOToken.ID.equals("FXClass")) {
                    myEvent.FXClass = this.IOToken.getIntValue();
                }
                if (myEvent != null && this.IOToken.ID.equals("SongFXType")) {
                    myEvent.SongFXType = this.IOToken.getIntValue();
                }
                if (myEvent != null && this.IOToken.ID.equals("A")) {
                    myEvent.A = this.IOToken.getIntValue();
                }
                if (myEvent != null && this.IOToken.ID.equals("B")) {
                    myEvent.B = this.IOToken.getIntValue();
                }
                if (myEvent != null && this.IOToken.ID.equals("C")) {
                    myEvent.C = this.IOToken.getIntValue();
                }
                if (myEvent != null && this.IOToken.ID.equals("D")) {
                    myEvent.D = this.IOToken.getIntValue();
                }
            }
            if (this.IOToken.Object.equals("Instrument")) {
                if (this.IOToken.ID.equals("@ARRAYPOS")) {
                    ActualSampleIndex = this.IOToken.getIntValue();
                    si = MySong.getInstrumentIndex(ActualSampleIndex);
                }
                if (si != null) {
                    if (this.IOToken.ID.equals("Name")) {
                        si.Name = this.IOToken.getStringValue();
                    }
                    if (this.IOToken.ID.equals("Type")) {
                        si.Type = this.IOToken.getIntValue();
                        if (si.Type == 0) {
                            si.deactivateLoop();
                        }
                        if (si.Type == 4) {
                            si.setHasLoop(true);
                        }
                    }
                    if (this.IOToken.ID.equals("Volume")) {
                        si.Volume = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("ID")) {
                        si.ID = this.IOToken.getIntValue();
                        MySong.setIDOfInstrIndex(si.ID, ActualSampleIndex);
                    }
                    if (this.IOToken.ID.equals("Tune")) {
                        si.Tune = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("FineTune")) {
                        si.FineTune = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("LoopStart")) {
                        si.setLoopStart(this.IOToken.getIntValue());
                    }
                    if (this.IOToken.ID.equals("Looplen")) {
                        si.setLoopLen(this.IOToken.getIntValue());
                    }
                    if (this.IOToken.ID.equals("NumbOfLoops")) {
                        si.setNumbOfLoops(this.IOToken.getIntValue());
                    }
                    if (this.IOToken.ID.equals("LineSampleFlags")) {
                        si.LineSampleFlags = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("PlayFlag")) {
                        si.PlayFlag = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("MultiChannel")) {
                        si.MultiChannel = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("Resonance")) {
                        si.Resonance = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("VirtualSample")) {
                        si.VirtualSample = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("AllowPosDetune")) {
                        si.AllowPosDetune = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("NoDsp")) {
                        si.NoDsp = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("MirrorX")) {
                        si.MirrorX = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("PlayReverse")) {
                        si.PlayReverse = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("PlaySynced")) {
                        si.PlaySynced = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("PanningActive")) {
                        si.PanningActive = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("PanningX")) {
                        si.PanningX = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("MetaMainLead")) {
                        si.MetaInfo.MainLead = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("MetaLead2")) {
                        si.MetaInfo.Lead2 = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("MetaPercussion")) {
                        si.MetaInfo.Percussion = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("MetaBeat")) {
                        si.MetaInfo.Beat = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("MetaSubBeat")) {
                        si.MetaInfo.SubBeat = this.IOToken.getBoolValue();
                    }
                    if (this.IOToken.ID.equals("MetaR")) {
                        si.MetaInfo.R = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("MetaG")) {
                        si.MetaInfo.G = this.IOToken.getIntValue();
                    }
                    if (this.IOToken.ID.equals("MetaB")) {
                        si.MetaInfo.B = this.IOToken.getIntValue();
                    }
                }
            }
            if (!this.IOToken.Object.equals("RawSampleData")) continue;
            if (this.IOToken.ID.equals("@ARRAYPOS")) {
                ActualSampleIndex = this.IOToken.getIntValue();
                si = MySong.getInstrumentIndex(ActualSampleIndex);
            }
            if (si == null || !this.IOToken.ID.equals("@RAWDATALEN")) continue;
            try {
                int SampleLenByte = this.IOToken.getIntValue();
                byte[] Samples = new byte[SampleLenByte];
                this.basefi.read(Samples);
                this.BuildInstrumentSamples(si, Samples, Samples.length, ActualSampleIndex, MySong);
                MySong.getInstrumentIndex((int)ActualSampleIndex).SampleDataLoaded = true;
                this.SymphManager.PrintToInfoWindow("Sample imported(" + ActualSampleIndex + "):" + Samples.length + " byte");
            }
            catch (IOException ex) {
                this.EOF = true;
                this.SymphManager.PrintToInfoWindow("Error while reading Sample Data. Aborted.");
                Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.SymphManager.PrintToInfoWindow("Number of Events:" + EventCounter);
        this.SymphManager.refreshPositionsList();
        return Sucess;
    }

    private void BuildInstrumentSamples(SymphonieInstrument si, byte[] src, int len, int ActualSampleIndex, Song MySong) {
        si.ImportSample.Analyse(src, len);
        si.sp = si.ImportSample.SamplePools[0];
        si.sp.initLoopData(si.hasLoop(), si.getLoopStart(), si.getLoopLen(), si.getNumbOfLoops());
        si.SampleDataLoaded = true;
        si.isInUse = true;
        if (si.MultiChannel == 1 && si.ImportSample.getNumbOfChannels() == 2) {
            SymphonieInstrument siRight = MySong.getInstrumentIndex(ActualSampleIndex + 1);
            siRight.sp = si.ImportSample.SamplePools[1];
            siRight.sp.initLoopData(si.hasLoop(), si.getLoopStart(), si.getLoopLen(), si.getNumbOfLoops());
            siRight.SampleDataLoaded = true;
            siRight.isInUse = true;
            siRight.MultiChannel = 2;
            siRight.Name = si.Name;
        }
    }

    boolean checkIsSymphonieFormat() {
        this.EOF = false;
        this.readToken(this.IOToken);
        return this.IOToken.Object.equals("Content") && this.IOToken.ID.equals("SymphonieSongModule");
    }

    void readToken(SongToken myToken) {
        String s = this.readNextLine();
        myToken.isValid = true;
        this.TokenArray = s.split("" + this.Limiter, 10);
        if (this.TokenArray.length >= 5 && this.TokenArray[0].equals("{") && this.TokenArray[2].equals(":") && this.TokenArray[4].equals("}")) {
            s = this.TokenArray[1];
            myToken.Value = this.TokenArray[3];
            int pos = this.TokenArray[1].indexOf(".");
            if (pos > 0) {
                myToken.Object = s.substring(0, pos);
                myToken.ID = s.substring(pos + 1);
                myToken.isValid = true;
            }
        }
    }

    String readNextLine() {
        String s = "";
        boolean done = false;
        int MaxReadLen = 1024;
        int Count = 0;
        this.ReadBufferPos = 0;
        try {
            while (!done) {
                int len = this.basefi.read();
                if (len == -1) {
                    done = true;
                    this.EOF = true;
                    continue;
                }
                if (len == 13) {
                    done = true;
                    continue;
                }
                byte b = (byte)len;
                s = s + (char)b;
                if (++Count < MaxReadLen) continue;
                done = true;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            done = true;
            this.EOF = true;
        }
        return s;
    }

    void save(Song MySong, File myFile) {
        try {
            if (myFile.createNewFile()) {
                this.basefounbuffered = new FileOutputStream(myFile);
                this.basefo = new BufferedOutputStream(this.basefounbuffered);
                this.ok = this.saveSongInfo(MySong);
                this.ok = this.saveSongSequences(MySong);
                this.ok = this.saveSongPositions(MySong);
                this.ok = this.saveInstruments(MySong);
                this.ok = this.savePatterns(MySong);
                this.ok = this.saveInstrumentsSamples(MySong);
                this.basefo.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    boolean saveSongInfo(Song MySong) throws IOException {
        this.ObjectID = "Content";
        this.writeKey("SymphonieSongModule", 2.0f);
        this.writeObjectBegin("Song");
        this.writeKey("Mixfrequency", MySong.MixFrequency);
        this.writeKey("BPM", MySong.getBPM());
        this.writeKey("MasterVolume", MySong.Volume);
        this.writeKey("NumbOfSequences", MySong.getNumbOfSequences());
        this.writeKey("NumbOfInstruments", MySong.getNumbOfInstruments());
        this.writeKey("NumbOfPatterns", MySong.getNumbOfPatterns());
        this.writeKey("NumbOfPositions", MySong.getNumbOfPositions());
        this.writeKey("NumbOfVoices", MySong.getNumbOfVoices());
        this.writeKey("PatternSize", MySong.getPatternSize());
        this.writeKey("FlexibleTiming", false);
        this.writeKey("EventsPerEventPool", 1);
        this.writeKey("EventsPerEventPool", 1);
        this.writeKey("NumbOfTimePos", MySong.getNumbOfRows());
        this.writeObjectEnd();
        return true;
    }

    boolean saveSongSequences(Song MySong) throws IOException {
        this.writeObjectBegin("Sequence");
        this.writeKey("@ARRAYNAME", "SequenceIndex");
        for (int i = 0; i < MySong.getNumbOfSequences(); ++i) {
            Sequence Obj = MySong.getSequence(i);
            this.writeKey("@ARRAYPOS", i);
            this.writeKey("Action", Obj.Action);
            this.writeKey("StartPosition", Obj.StartPosition);
            this.writeKey("EndPosition", Obj.EndPosition);
            this.writeKey("Name", Obj.Name);
            this.writeKey("NumbOfLoops", Obj.NumbOfLoops);
            this.writeKey("Tune", Obj.Tune);
            this.writeKey("@ARRAYEND", 0);
        }
        this.writeObjectEnd();
        return true;
    }

    boolean saveSongPositions(Song MySong) throws IOException {
        this.writeObjectBegin("Position");
        this.writeKey("@ARRAYNAME", "PositionIndex");
        for (int i = 0; i < MySong.getNumbOfPositions(); ++i) {
            Position Obj = MySong.getPosition(i);
            this.writeKey("@ARRAYPOS", i);
            this.writeKey("Name", Obj.Name);
            this.writeKey("StartRow", Obj.StartRow);
            this.writeKey("NumbOfLayers", Obj.NumbOfLayers);
            if (Obj.PatternNumbers != null) {
                this.writeKey("PatternNr", Obj.PatternNumbers[0]);
            }
            this.writeKey("NumbOfLoops", Obj.NumbOfLoops);
            this.writeKey("RowLength", Obj.RowLength);
            this.writeKey("SpeedCycl", Obj.Speed_Cycl);
            this.writeKey("Tune", Obj.Tune);
            this.writeKey("@ARRAYEND", 0);
        }
        this.writeObjectEnd();
        return true;
    }

    boolean saveInstruments(Song MySong) throws IOException {
        this.writeObjectBegin("Instrument");
        this.writeKey("@ARRAYNAME", "InstrumentIndex");
        for (int i = 0; i < MySong.getNumbOfInstruments(); ++i) {
            if (!MySong.checkInstrumentIndexInUse(i)) continue;
            SymphonieInstrument Obj = MySong.getInstrumentIndex(i);
            this.writeKey("@ARRAYPOS", i);
            this.writeKey("Name", Obj.Name);
            this.writeKey("Type", Obj.Type);
            this.writeKey("Volume", Obj.Volume);
            this.writeKey("ID", Obj.ID);
            this.writeKey("Tune", Obj.Tune);
            this.writeKey("FineTune", Obj.FineTune);
            this.writeKey("LoopStart", Obj.getLoopStart());
            this.writeKey("Looplen", Obj.getLoopLen());
            this.writeKey("NumbOfLoops", Obj.getNumbOfLoops());
            this.writeKey("LineSampleFlags", Obj.LineSampleFlags);
            this.writeKey("PlayFlag", Obj.PlayFlag);
            this.writeKey("MultiChannel", Obj.MultiChannel);
            this.writeKey("Resonance", Obj.Resonance);
            this.writeKey("VirtualSample", Obj.VirtualSample);
            this.writeKey("AllowPosDetune", Obj.AllowPosDetune);
            this.writeKey("NoDsp", Obj.NoDsp);
            this.writeKey("MirrorX", Obj.MirrorX);
            this.writeKey("PlayReverse", Obj.PlayReverse);
            this.writeKey("PlaySynced", Obj.PlaySynced);
            this.writeKey("PanningActive", Obj.PanningActive);
            this.writeKey("PanningX", Obj.PanningX);
            this.writeKey("MetaR", Obj.MetaInfo.R);
            this.writeKey("MetaG", Obj.MetaInfo.G);
            this.writeKey("MetaB", Obj.MetaInfo.B);
            this.writeKey("MetaMainLead", Obj.MetaInfo.MainLead);
            this.writeKey("MetaLead2", Obj.MetaInfo.Lead2);
            this.writeKey("MetaPercussion", Obj.MetaInfo.Percussion);
            this.writeKey("MetaBeat", Obj.MetaInfo.Beat);
            this.writeKey("MetaSubBeat", Obj.MetaInfo.SubBeat);
            this.writeKey("@ARRAYEND", 0);
        }
        this.writeObjectEnd();
        return true;
    }

    boolean saveInstrumentsSamples(Song MySong) throws IOException {
        this.writeObjectBegin("RawSampleData");
        this.writeKey("@ARRAYNAME", "InstrumentIndex");
        for (int i = 0; i < MySong.getNumbOfInstruments(); ++i) {
            SymphonieInstrument Obj = MySong.getInstrumentIndex(i);
            if (Obj.ImportSample.RawSample == null) continue;
            this.writeKey("@ARRAYPOS", i);
            this.writeKey("ID", Obj.ID);
            this.writeRawByteBlock(Obj.ImportSample.RawSample);
            this.writeKey("@ARRAYEND", 0);
        }
        this.writeObjectEnd();
        return true;
    }

    boolean savePatterns(Song MySong) throws IOException {
        this.writeObjectBegin("Event");
        this.writeKey("@ARRAYNAME", "PatternNr,VoiceNr,PosTime");
        for (int i = 0; i < MySong.getNumbOfPatterns(); ++i) {
            SongPattern Obj = MySong.getPattern(i);
            for (int PatVocNr = 0; PatVocNr < Obj.getNumbOfVoices(); ++PatVocNr) {
                for (int RowNr = 0; RowNr < Obj.getNumbOfRows(); ++RowNr) {
                    this.savePatternsEventPool(MySong, Obj, i, PatVocNr, RowNr);
                }
            }
        }
        this.writeObjectEnd();
        return true;
    }

    boolean savePatternsEventPool(Song MySong, SongPattern Obj, int PatNr, int PatVocNr, int RowNr) {
        SongEvent mySongEvent;
        SongEventPool se;
        PatternVoice myPatternVoices = Obj.PatternVoices[PatVocNr];
        if (myPatternVoices != null && (se = myPatternVoices.getSongEventPool(RowNr)) != null && (mySongEvent = se.getSongEvent(0)) != null && mySongEvent.SongFXType != 0) {
            this.writeKey("@ARRAYPOS", PatNr);
            this.writeKey("@ARRAYPOS", PatVocNr);
            this.writeKey("@ARRAYPOS", se.TimePosition);
            this.writeKey("FXClass", mySongEvent.FXClass);
            this.writeKey("SongFXType", mySongEvent.SongFXType);
            this.writeKey("A", mySongEvent.A);
            this.writeKey("B", mySongEvent.B);
            this.writeKey("C", mySongEvent.C);
            this.writeKey("D", mySongEvent.D);
            this.writeKey("@ARRAYEND", 0);
        }
        return true;
    }

    boolean writeObjectBegin(String myObjectID) {
        this.writeBeginKey();
        this.ObjectID = myObjectID;
        this.writeString2(this.ObjectID + "." + "@OBJECTBEGIN");
        this.writeEndKey();
        return true;
    }

    boolean writeObjectEnd() {
        this.writeBeginKey();
        this.writeString2(this.ObjectID + "." + "@OBJECTEND");
        this.writeEndKey();
        return true;
    }

    boolean writeKey(String skey, boolean bValue) {
        if (bValue) {
            this.writeKey(skey, "@TRUE");
        } else {
            this.writeKey(skey, "@FALSE");
        }
        return true;
    }

    boolean writeKey(String skey, int sValue) {
        this.writeKey(skey, "" + (float)sValue);
        return true;
    }

    boolean writeKey(String skey, float sValue) {
        this.writeKey(skey, "" + sValue);
        return true;
    }

    boolean writeKey(String skey, String sValue) {
        this.writeBeginKey();
        this.writeString2(this.ObjectID + "." + skey);
        this.writeString(":");
        this.writeString2(sValue);
        this.writeEndKey();
        return true;
    }

    boolean writeBeginKey() {
        this.writeString("{");
        return true;
    }

    boolean writeEndKey() {
        this.writeString("}");
        this.writeEOL();
        return true;
    }

    boolean writeEOL() {
        return this.writeByte(13);
    }

    boolean writeByte(int b) {
        try {
            this.basefo.write(b);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    boolean writeRawByteBlock(byte[] ByteArray) {
        try {
            this.writeKey("@RAWDATALEN", ByteArray.length);
            this.basefo.write(ByteArray);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    boolean writeString2(String s) {
        this.writeByte(34);
        this.writeString(s);
        this.writeByte(34);
        return true;
    }

    boolean writeString(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                try {
                    this.basefo.write((byte)s.charAt(i));
                    continue;
                }
                catch (IOException ex) {
                    Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
        }
        return true;
    }
}

