/*
 * Decompiled with CFR 0.152.
 */
package symreader;

class VoiceSmoother {
    private boolean SampleSmoothing = false;
    private boolean FadeOut = false;
    private int SampleSmoothingRemaining = 0;
    private float PrevSample;
    int SmoothNumbOfSamples = 25;

    VoiceSmoother() {
    }

    void setSmoothingLen(int len) {
        this.SmoothNumbOfSamples = len;
    }

    void stop() {
        this.SampleSmoothing = false;
        this.FadeOut = false;
    }

    void activateSampleSmoothing() {
        this.SampleSmoothing = false;
        this.SampleSmoothingRemaining = this.SmoothNumbOfSamples;
        this.SampleSmoothing = true;
        this.FadeOut = false;
    }

    void activateFadeOut() {
        this.SampleSmoothing = false;
        this.SampleSmoothingRemaining = this.SmoothNumbOfSamples;
        this.SampleSmoothing = true;
        this.FadeOut = true;
    }

    void activateFadeIn() {
        this.SampleSmoothing = false;
        this.SampleSmoothingRemaining = this.SmoothNumbOfSamples;
        this.PrevSample = 0.0f;
        this.SampleSmoothing = true;
        this.FadeOut = false;
    }

    boolean isFadeingOut() {
        return this.SampleSmoothing && this.FadeOut;
    }

    float getSmoothedSample(float Sample) {
        if (this.SampleSmoothing && this.SampleSmoothingRemaining > 0) {
            if (this.FadeOut) {
                Sample = 0.0f;
            }
            float OriginalPart = this.SampleSmoothingRemaining;
            Sample = (OriginalPart /= (float)this.SmoothNumbOfSamples) * this.PrevSample + Sample * (1.0f - OriginalPart);
            --this.SampleSmoothingRemaining;
            if (this.SampleSmoothingRemaining <= 0) {
                this.SampleSmoothing = false;
            }
        } else {
            this.SampleSmoothing = false;
            this.PrevSample = Sample;
        }
        return Sample;
    }
}

