/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package symreader;

/**
 *
 * @author (c) Patrick Meng 2008
 */

interface InterpolateSampleType {
    int None    = 0;
    int Linear  = 1;
    int Cubic	= 2;
    int Cosinus = 3;
    int Hermite = 4; // Bicubic Hermite Spline
    int Max = 4;
}

public class InterpolateSample {
    private int Type = InterpolateSampleType.Cubic;
    double bias = 0.0d;
    double tension = 0.0d;
    float y0,y1,y2,y3;
    float mu;
    int ptr;
    float Sample;
    double a0,a1,a2,a3;
    double m0,m1,mu2,mu3;
    
    InterpolateSample() {
    }
    
    void setInterpolateType(int newType) {
	Type = newType;
	if(Type>InterpolateSampleType.Max) {
	    Type = InterpolateSampleType.Max;
	}
    }
    
    float getSample(float[] Samples, float SamplePtr) {
        ptr= (int) SamplePtr;
        mu = SamplePtr - ptr; // mu range 0  to 1.0
        
        switch(Type){
            case InterpolateSampleType.None:
                return(Samples[ptr]);
            
            case InterpolateSampleType.Linear:
                if((ptr+1)<=(Samples.length-1) ) {

                    Sample = Samples[ptr+1] * mu;
                    Sample += Samples[ptr] * (1-mu);
                    return(Sample);
                } else {
                    return(Samples[ptr]);
                }
		
	   case InterpolateSampleType.Cubic:
		y1 = Samples[ptr];
		if(ptr<(Samples.length-1)) {	y2 = Samples[ptr+1];} else {y2 = Samples[ptr];}
		if(ptr<(Samples.length-2)) {	y3 = Samples[ptr+2];} else {y3 = Samples[ptr];}
		if(ptr>0)		   {	y0 = Samples[ptr-1];} else {y0 = Samples[0];}
		return(CubicInterpolate(y0, y1, y2, y3, mu));
                
            case InterpolateSampleType.Cosinus:
                if((ptr+1)<=(Samples.length-1) ) {
                    return(CosineInterpolate(Samples[ptr], Samples[ptr+1], mu));
                } else {
                    return(Samples[ptr]);
                }
            
	    case InterpolateSampleType.Hermite:
		y1 = Samples[ptr];
		if(ptr<(Samples.length-1)) {	y2 = Samples[ptr+1];} else {y2 = Samples[ptr];}
		if(ptr<(Samples.length-2)) {	y3 = Samples[ptr+2];} else {y3 = Samples[ptr];}
		if(ptr>0)		   {	y0 = Samples[ptr-1];} else {y0 = Samples[0];}
		return(HermiteInterpolate(y0, y1, y2, y3, mu));
		

	}
	return(Samples[ptr]);
    }
    
    
    private float CubicInterpolate(double y0, double y1, double y2, double y3, double mu) { 
        // Interpolate between y1 and y2, mu ist the exact position between y1 and y2
        // mu = 0.0 -> at y1
        mu2 = mu * mu; 
        a0 = y3 - y2 - y0 + y1; 
        a1 = y0 - y1 - a0; 
        a2 = y2 - y0; 
        a3 = y1; 
	return ((float) (a0 * mu * mu2 + a1 * mu2 + a2 * mu + a3)); 
    }
    
    float CosineInterpolate(double y1,double y2,double mu){
	mu2 = (1-java.lang.Math.cos(mu*java.lang.Math.PI))/2;   
	return((float) (y1*(1-mu2)+y2*mu2));
    }
    
    float HermiteInterpolate(double y0, double y1, double y2, double y3, double mu) {
	    mu2 = mu * mu;
	    mu3 = mu2 * mu;
	    m0  = (y1-y0)*(1+bias)*(1-tension)/2;   
	    m0 += (y2-y1)*(1-bias)*(1-tension)/2;   
	    m1  = (y2-y1)*(1+bias)*(1-tension)/2;   
	    m1 += (y3-y2)*(1-bias)*(1-tension)/2;   
	    a0 =  2*mu3 - 3*mu2 + 1;   
	    a1 =    mu3 - 2*mu2 + mu;   
	    a2 =    mu3 -   mu2;   
	    a3 = -2*mu3 + 3*mu2;   
	    return((float) (a0*y1+a1*m0+a2*m1+a3*y2));
    }
    
    
    
}

