/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package symreader;


/**
 *
 * @author (c) Patrick Meng 2008
 */

interface SongEventClass { // Event Types as in SymphonieNote.NOTE_FX
    //int NONE        =-1;
    int GENERAL     =0;
    int VOLUME      =1;
    int PITCH       =2;
    int SAMPLE      =3;
    int SPEED       =4;
    int DSP         =5;
    int MAX         = 5;
}

interface SongEventType { // Event Types as in SymphonieNote.NOTE_FX
    // General
    int FX_NONE             =0;
    int FX_KEYON            =1;
    int FX_KEYOFF           =2;
    int FX_RETRIG           =3;
    int FX_EMPHASIS         =4;
    
    // Volume
    //int FX_CLASS_VOL        =1000;
    int FX_SETVOLUME        =1000;
    int FX_VOLUMESLIDEUP    =1001;
    int FX_VOLUMESLIDEDOWN  =1002;
    int FX_ADDVOLUME        =1003;
    int FX_VIBRATO          =1004;
    int FX_CV               =1005;
    int FX_CVADD            =1006;
    int FX_STOPSAMPLE       =1007;
    int FX_CONTSAMPLE       =1008;
    int FX_STARTSAMPLE      =1009;    
    
    // Pitch
    //int FX_CLASS_PITCH      =2000;
    int FX_SETPITCH         =2000;
    int FX_PSLIDETO         =2001;
    int FX_PITCHSLIDEUP     =2002;
    int FX_PITCHSLIDEDOWN   =2003;
    int FX_ADDPITCH         =2004;
    int FX_TREMOLO          =2005;
    int FX_ADDHALVTONE      =2006;
    int FX_PITCHUP          =2007;
    int FX_PITCHDOWN        =2008;
    int FX_PITCHUP2         =2009;
    int FX_PITCHDOWN2       =2010;
    int FX_PITCHUP3         =2011;
    int FX_PITCHDOWN3       =2012;
    
    // Sample
    //int FX_CLASS_SAMPLE     =3000;
    int FX_REPLAYFROM       =3000;
    int FX_FROMANDPITCH     =3001;
    int FX_FROMANDPITCHVOL  =3002;
    int FX_SETFROMADD       =3003;
    int FX_FROMADD          =3004;
    int FX_SAMPLEVIB        =3005;
    
    // Speed
    int FX_CLASS_SPEED      =4000;
    int FX_SETSPEED         =4000;
    int FX_SPEEDDOWN        =4001;
    int FX_SPEEDUP          =4002;
    
    // Dsp
    int FX_CLASS_DSP        =5000;
    int FX_CHANNELFILTER    =5000;  
    int FX_DSPECHO          =5001; // Echo is defined as repeating delays
    int FX_DSPCROSSECHO     =5002; // Echo is defined as repeating delays
    int FX_DSPDELAY         =5003; // Delay
    int FX_DSPCROSSDELAY    =5004; // Delay
    int FX_DSPCHOR          =5005; // Chorus Experimental
}

public class Song {
    String Name = "Unnamed";
    float Volume = 100;
    private float BPM = 125.0f;
    float MixFrequency = 44100.0f;
    
    private int NumbOfSequences = 64;
    private int NumbOfPositions = 1024;
    private int NumbOfInstruments = 256;
    private int NumbOfVoices = 16;
    private int NumbOfRows = 64;
    private int NumbOfPatterns = 100;
    private int PatternSize;
    private boolean InstrumentsAllocated = false;
    
    private Sequence[] Sequences;
    private Position[] Positions;
    
    private SongPattern[] Patterns;
    PEDBlock myPEDBlock = new PEDBlock(this);
    
    private int[] IDs;
    
    private SymphonieInstrument[] Instruments;
    private VoiceExpander LinkedVoiceExpander = null;
    
    // Play Management
    boolean SongPlaying = false;
    int PlayingPatternNr = 0;

    boolean isPositionPlaying = false;
    
    boolean ForceJumpToPos = false;
    boolean ForceSyncedBreak = false;
    int ForcedPosNr = 0;
    
    int PlayPositionIndex = 0;
    int PosNumbOfLoops = 0;
    int PosStart = 0;
    int PosLen = 0;
    int PosSpeed = 0;
    int PosTuneOffset = 0;
    private float PlayLinePos = 0;
    private boolean UpdatePlayingPos = false;
    
    private boolean RealtimeModifyActivated = false;
    private int ModifyVoiceNr = 0;
    private int ModifyParameter = 0;
    private float ModifyValueTo = 0.0f;
    
    void activateRealtimeModify(boolean b) {
	RealtimeModifyActivated = b;
    }    
    
    boolean checkRealtimeModifyVoice(int VoiceNr) {
	return((RealtimeModifyActivated == true) && (ModifyVoiceNr == VoiceNr));
    }    
    
    void realtimeModifyEventD(int VoiceNr, float NewValue) {
	ModifyVoiceNr = VoiceNr;
	ModifyParameter = 4;
	ModifyValueTo = NewValue;
    }
    void realtimeModifyEventC(int VoiceNr, float NewValue) {
	ModifyVoiceNr = VoiceNr;
	ModifyParameter = 3;
	ModifyValueTo = NewValue;
    }
    
    void modifyRealtimeEvent(SongEvent se) {
	if(se.SongFXType != SongEventType.FX_NONE) {
	    if(ModifyParameter==4) {
		se.D = ModifyValueTo;
	    }
	    if(ModifyParameter==3) {
		se.C = ModifyValueTo;
	    }
	}
    }
    
    
    SongEvent getFreeSongEvent(int PatNr, int x, int y) {
	SongPattern Pat;
	if(hasContent() && Patterns!=null) {
	    Pat = getPattern(PatNr);
	    if(Pat != null) return(Pat.getFreeSongEvent(x, y));
	}
	return(null);
    }
    
    SongEvent getSongEvent(int PatNr, int x, int y) {
	SongPattern Pat;
	if(hasContent() && Patterns!=null) {
	    Pat = getPattern(PatNr);
	    if(Pat != null) return(Pat.getSongEvent(x, y));
	}
	return(null);
    }
    
        SongEvent getSongEventForced(int PatNr, int x, int y) {
	SongPattern Pat;
	if(hasContent() && Patterns!=null) {
	    Pat = getPattern(PatNr);
	    if(Pat != null) return(Pat.getSongEventForced(x, y));
	}
	return(null);
    } 

    void copySongEvent(SongEvent e, int PatNr, int x, int y) {
	SongPattern Pat;
	if(hasContent() && Patterns!=null && e != null) {
	    Pat = getPattern(PatNr);
	    Pat.addSongEvent(PosLen, Volume, e);
	}
    } 
    
    float getPlayingLineNr() {
        return(PlayLinePos);
    }
    
    int getPlayingPatternNr() {
        return(PlayingPatternNr);
    }
    
    int getPositionSpeed() {
        return(PosSpeed);
    }
    
    float getSongBPM() {
        return(BPM);
    }
    
    int getPositionIndexPlaying() {
        if(isPositionPlaying && SongPlaying) {
            return(PlayPositionIndex);
        } else {
            return(-1);
        }
    }

    boolean checkEarlyBreakImmediate() {
	return(ForceJumpToPos && !ForceSyncedBreak);
    }
    
    boolean checkEarlyBreak() {
	return(ForceJumpToPos);
    }
    
    void setNextPositionToPlaySynced(int NewNextPos, boolean SyncedBreak) {
	if(NewNextPos<this.getNumbOfPositions()) {
	    ForceJumpToPos = true;
	    ForcedPosNr = NewNextPos;
	    ForceSyncedBreak = SyncedBreak;
	}
    }
    
    private int getNextPositionToPlay() {
	int nextpos;
	
	if(ForceJumpToPos==true) {
	    nextpos = ForcedPosNr;
	    ForceJumpToPos = false;
	} else {
	    nextpos = PlayPositionIndex+1;
	}
	return(nextpos);
    }
    
    private void MoveToNextPosition() {
        PlayPositionIndex = getNextPositionToPlay();
        if(PlayPositionIndex >= this.getNumbOfPositions()) {
            StopSong();
        } else {
            PlayPositionInit();
        }
	setUpdatePlayingPos(true);
    }
    
    private void PlayPositionInit() {
        if(( (Positions != null) && (PlayPositionIndex<Positions.length) && (Positions[PlayPositionIndex]!=null)) ){
            PosTuneOffset = Positions[PlayPositionIndex].Tune;
            PosNumbOfLoops = Positions[PlayPositionIndex].NumbOfLoops;
            PosStart = Positions[PlayPositionIndex].StartRow;
            PosLen = Positions[PlayPositionIndex].RowLength; // in Lines
            PosSpeed = Positions[PlayPositionIndex].Speed_Cycl; // in Lines
            PlayingPatternNr = Positions[PlayPositionIndex].PatternNumbers[0]; // in Lines
            PlayLinePos = PosStart;
            isPositionPlaying = true;
        }
	setUpdatePlayingPos(true);
    }
    
    void PlayPosition(int PosIndex) {
        SongPlaying = false;
        PlayPositionIndex = PosIndex;
        PlayPositionInit();
        SongPlaying = true;
	setUpdatePlayingPos(true);
    }
    
    void playfromActualPosition() {
	PlayPosition(PlayPositionIndex);
    }
    
    void PlaySong() {
        PlayLinePos = 0.0f;
        SongPlaying = true;
    }
    
    void PlayFromFirstSequence() {
        if(this.Sequences[0] != null) {
            if(this.Sequences[0].Action == 0) { // 0=PLAY 1=SKIP -1=LAST OF SONG 
                PlayPosition(this.Sequences[0].StartPosition);
            } else {
                PlayPosition(0);
            }
        } else {
            PlayPosition(0);
        }
    }
    
    void StopSong() {
        isPositionPlaying = false;
        SongPlaying = false;
	ForceJumpToPos = false;
	ForceSyncedBreak = false;
    }
    
    // Resource Management
//    void initResources(int NumbSeq, int NumbPos, int NumbPattern, int Instr) {
//        Sequences = new Sequence[NumbSeq];
//        Positions = new Position[NumbPos];
//        Patterns = new SongPattern[NumbPattern];
//        if (InstrumentsAllocated==false) Instruments = new SymphonieInstrument[Instr];
//        InstrumentsAllocated = true;
//        ResourcesAllocated = true;
//    }
    
    public boolean hasContent() {
        if( (Sequences != null) && 
            (Positions != null) &&
            (Patterns != null) &&
            (Instruments != null) ) {
            return(true);
        }
        return(false);
        //return(ResourcesAllocated);
    }
    
    void allocDefaultSong() { // alles löschen
        setNumbOfVoices(16);
        setBPM(120);
        setNumbOfRows(64);
        allocNumbOfSequences(16);
        allocNumbOfPositions(512);
        allocNumbOfPatterns(100);
        allocDefaultNumbInstruments();
    }
    
    void allocDefaultNumbInstruments() {
        if(InstrumentsAllocated==false) {
            allocNumbInstruments(256);
        }
    }
    
    void allocNumbOfPatterns(int i) {
        Patterns = new SongPattern[i];
	myPEDBlock = new PEDBlock(this);
	myPEDBlock.TempPattern = new SongPattern();
	myPEDBlock.TempPattern.ParentSong = this;
        NumbOfPatterns = i;
    }
    
    void allocNumbOfPositions(int i) {
        Positions = new Position[i];
        setNumbOfPositions(i);
    }
    
    void fillPositionsToDefault() {
	for(int i = 0; i<getNumbOfPositions();i++) {
	    Positions[i] = getPosition(i);
	    Positions[i].setNumbOfLayers(1);
	}
    }
    
    void allocNumbOfSequences(int i) {
        Sequences = new Sequence[i];
        setNumbOfSequences(i);
    }
    
    void allocNumbInstruments(int i) {
        Instruments = new SymphonieInstrument[i];
        IDs = new int[i];
        java.util.Arrays.fill(IDs, -1);
        InstrumentsAllocated = true;
        setNumbOfInstruments(i);
    }
    
    int getNumbInstrumentsAllocated() {
        if(InstrumentsAllocated == true) {
            return(getNumbOfInstruments());
        } else {
            return(0);
        }
    }

    void updatePatternSize() {
        PatternSize = NumbOfVoices * NumbOfRows;
    }
    int getPatternSize() {return(PatternSize);};
    
//    void setNumbOfPatterns(int i) {
//        Patterns = new SongPattern[i];
//        NumbOfPatterns = i;
//    };
    
    int getNumbOfPatterns() {return(NumbOfPatterns);};    
    
    void setNumbOfSequences(int i) {NumbOfSequences = i;};
    int getNumbOfSequences() {return(NumbOfSequences);};
    
    void setNumbOfPositions(int i) {NumbOfPositions = i;};
    int getNumbOfPositions() {return(NumbOfPositions);};
 
    void setNumbOfVoices(int i) {NumbOfVoices = i;updatePatternSize();};
    int getNumbOfVoices() {return(NumbOfVoices);};

    void setNumbOfRows(int i) {NumbOfRows = i;updatePatternSize();};
    int getNumbOfRows() {return(NumbOfRows);};

    void setNumbOfInstruments(int i) {NumbOfInstruments = i;};
    int getNumbOfInstruments() {
	if(Instruments != null) {
	    return(NumbOfInstruments);
	} else {
	    return(0);
	}
    };
    
    void setBPM(float i) {BPM = i;};
    float getBPM() {return(BPM);};
    
    Sequence getSequence(int i) {
        if(i<getNumbOfSequences()) {
            if(Sequences[i] == null) Sequences[i] = new Sequence();
            Sequences[i].ParentSong = this;
            return(Sequences[i]);
        } else {
            return(null);
        }
    }
    
    
    
    
    
    Position getPosition(int i) {
        
        if(i<getNumbOfPositions()) {
            if(Positions[i] == null) Positions[i] = new Position();
            Positions[i].ParentSong = this;
            return(Positions[i]);
        } else {
            return(null);
        }
    }
    
    SongPattern getPattern(int i) {
        if(i<getNumbOfPatterns()) {
            if(Patterns[i] == null) Patterns[i] = new SongPattern();
            Patterns[i].ParentSong = this;
            return(Patterns[i]);
        } else {
            return(null);
        }
    }
    


    int getIndexOfInstrumentID(int i) {
        return(IDs[i]);
    }

    SymphonieInstrument getInstrumentID(int i) {
        return(getInstrumentIndex(getIndexOfInstrumentID(i)));
    }
    
    void setIDofInstrumentIndex(int i, int newid) {
	SymphonieInstrument si = getInstrumentIndex(i);
	if(si!=null && i!=-1) {
	    si.ID = newid;
	}
    }
    
    int getIDofInstrumentIndex(int i) {
	SymphonieInstrument si = getInstrumentIndex(i);
	if(si!=null) {
	    return(si.ID);
	} else {
	    return(-1);
	}
    }
    
    SymphonieInstrument getInstrumentIndex(int i) { // auto allocates
        if((i<getNumbOfInstruments()) && (i >= 0)) {
            if(Instruments[i] == null) Instruments[i] = new SymphonieInstrument();
            return(Instruments[i]);
        } else {
            return(null);
        }
    }
    
    void removeInstrumentIndex(int i) {
	if(Instruments[i]!=null && i<getNumbOfInstruments()) {
	    if(Instruments[i].MultiChannel==2) {
		removeInstrumentIndex(i+1);
	    }
	    IDs[Instruments[i].ID] = -1;
	    Instruments[i] = null;
	}
    }
    
    boolean checkInstrumentIndexInUse(int i) { // auto allocates
        if((i<getNumbOfInstruments()) && (i >= 0)) {
            if(Instruments[i] == null) return(false);
            return(Instruments[i].isInUse);
        } else {
            return(false);
        }
    }
    
    
    SymphonieInstrument getInstrumentExisting(int i) { // auto allocates
        if( (i<getNumbOfInstruments()) && (i>=0) ){
            if(Instruments[i] != null) {
		return(Instruments[i]);
	    }
        } else {
            return(null);
        }
        return(null);
    } 

    SymphonieInstrument getFreeInstrument() {
        for(int i=0;i<getNumbOfInstruments();i++) {
            if(getInstrumentIndex(i).isInUse==false) {
                Instruments[i].ID = getFreeInstrID(i);
                return(Instruments[i]);
            }
        }
        return(null);
    }
    
    int getFreeInstrID(int InstrIndex) {
        for(int i=0;i<IDs.length;i++) {
            if(IDs[i]==-1) {
                IDs[i] = InstrIndex;
                return(i);
            }
        }
        return(-1);
    }
    
    void setIDOfInstrIndex(int ID, int InstrIndex) {
        IDs[ID] = InstrIndex;
    }
    
    // Play Song Section
    int PlaySongEvent(VoiceExpander vx) {
        this.LinkedVoiceExpander = vx;
        if(this.isPositionPlaying==true) {
            PlayEventsAtPos(vx, PlayLinePos);
            PlayLinePos += 1;
            if( (PlayLinePos >= (this.PosStart + this.PosLen)) || checkEarlyBreakImmediate() ) {
                // Last Line reached
                this.PosNumbOfLoops --;
                if((this.PosNumbOfLoops <= 0) || (checkEarlyBreak() ) ) { // reloop and no early break
                    // Move to next Position or to position forced to play
                    MoveToNextPosition();
                    vx.setSongSpeed(this.BPM, this.PosSpeed);
                } else {
                    // reloop position
                    PlayLinePos = PosStart;
                }
            }
        } else { 
            // Play Pattern
	    PlayEventsAtPos(vx, PlayLinePos);
            PlayLinePos += 1;
            if(PlayLinePos >= this.NumbOfRows) {
                PlayLinePos = 0;
                //this.SongPlaying = false; Stop Song playing
            }
        }
        return(0); // No change SamplesTillNext Event
    }
    
    void setUpdatePlayingPos(boolean b) {
	UpdatePlayingPos = b;
    }
    
    boolean checkUpdatePlayingPos() {
	boolean b = UpdatePlayingPos;
	UpdatePlayingPos = false;
	return(b);
    }
    
    void PlayEventsAtPos(VoiceExpander vx, float PlayLinePos) {
        for(int VoiceNr = 0;VoiceNr<this.getNumbOfVoices();VoiceNr++) {
            PlayEventsOfVoiceAtPos(vx, PlayLinePos, VoiceNr);
        }
    }
    
    void PlayEventsOfVoiceAtPos(VoiceExpander vx, float PlayLinePos, int VoiceNr ) {
        SongPattern Pat = this.getPattern(PlayingPatternNr);
        PatternVoice pv = Pat.PatternVoices[VoiceNr];
	SongEventPool sep = pv.getSongEventPool(PlayLinePos);
        if(sep!=null) {
	    for(int i=0;i<sep.getNumberOfSongEvents();i++) {
		SongEvent mySongEvent = sep.getSongEvent(i);
		if(mySongEvent!=null) {
		    PlaySongEvent(vx, VoiceNr, mySongEvent);
		}
	    }
	}
    }
    
    SongEventPool getSongEventPool(int PatNr, int VoiceNr, float TimePosition) {
        SongPattern Pat = getPattern(PatNr);
        PatternVoice pv = Pat.PatternVoices[VoiceNr];
        return(pv.getSongEventPool(TimePosition));
    }
    
    
/*    int ConvertSymphInstrToNewInstrIndex(int SymphInstr) {
        for(int i=0;i<this.getNumbOfInstruments();i++) {
            SymphonieInstrument si = this.getInstrumentExisting(i);
            if(si != null) {
                if(si.ID==SymphInstr) return(i);
            }
        }
        return(-1);
    }
*/    
    
    boolean checkIsLeftStereoChannel(int ChannelIndex) {
        return((ChannelIndex & 0x0001) == 0);
    }

    
    
    void addKeyOnEvent(int PatNr, int x, int y, int InstrNr, int Pitch, int Vol) {
        SongEventPool se = getSongEventPool(PatNr, x, y);
        SongEvent MySongEvent = se.getSongEventForced(0);
        if(MySongEvent != null) {
            MySongEvent.setKeyOn(InstrNr, Pitch, Vol);
        }
    }
    
    void clrEvent(int PatNr, int x, int y) {
        SongEventPool se = getSongEventPool(PatNr, x, y);
        SongEvent MySongEvent = se.getSongEvent(0);
        if(MySongEvent != null) {
            MySongEvent.clear();
        }
    }
    
    void setEventType(int PatNr, int x, int y, int newEventType) {
        SongEventPool se = getSongEventPool(PatNr, x, y);
        SongEvent MySongEvent = se.getSongEventForced(0);
        if(MySongEvent != null) {
	    MySongEvent.setType(newEventType);
        }
    }
    
    void PlaySongEvent(VoiceExpander vx, int VoiceNr, SongEvent e) {
        if(this.checkRealtimeModifyVoice(VoiceNr)) {
	    modifyRealtimeEvent(e);
	}
	
	int tempPitch = (int) e.B;
        int tempInstrNr = (int) e.A;
        tempInstrNr = getIndexOfInstrumentID(tempInstrNr);
        SymphonieInstrument si;
        
        switch(e.SongFXType) {
            case SongEventType.FX_KEYON:
                
                float tempVolume = e.C;
                if(tempVolume<=100.0f) {
                    si = this.getInstrumentExisting(tempInstrNr);
                    if((si!=null) && si.checkReady() ) {
                        vx.SongEventKeyOn(si, VoiceNr, tempPitch, tempVolume);
                        // Play Stereo Too
                        if( (si.MultiChannel == 1) && (checkIsLeftStereoChannel(VoiceNr) ) ) {
                            si = this.getInstrumentExisting(tempInstrNr+1);
                            if(si.checkReady()) {
                                vx.SongEventKeyOn(si, VoiceNr+1, tempPitch, tempVolume);
                            }
                        }
                    }
                }
                break;

            case SongEventType.FX_SETPITCH:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.SongEventSetPitch(si, VoiceNr, tempPitch );
                }
                break;            
            
            case SongEventType.FX_PITCHUP:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.adjustVoiceFreq(si, VoiceNr, 1.0078125f );
                }
                break;  
            case SongEventType.FX_PITCHUP2:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.adjustVoiceFreq(si, VoiceNr, 1.015625f );
                }
                break;  
            case SongEventType.FX_PITCHUP3:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.adjustVoiceFreq(si, VoiceNr, 1.03125f );
                }
                break;  
            case SongEventType.FX_PITCHDOWN:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.adjustVoiceFreq(si, VoiceNr, 0.9921875f );
                }
                break; 
            case SongEventType.FX_PITCHDOWN2:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.adjustVoiceFreq(si, VoiceNr, 0.984375f );
                }
                break; 
            case SongEventType.FX_PITCHDOWN3:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.adjustVoiceFreq(si, VoiceNr, 0.9788f );
                }
                break; 
                
            case SongEventType.FX_PITCHSLIDEUP:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.SongEventPSlide(VoiceNr, e.D );
                }
                break;                
            case SongEventType.FX_PITCHSLIDEDOWN:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.SongEventPSlide(VoiceNr, -e.D );
                }
                break;
            case SongEventType.FX_PSLIDETO:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.SetVoicePSlideTo(si, VoiceNr, tempPitch, e.D);
                }
                break; 
                
            case SongEventType.FX_VOLUMESLIDEUP:
                vx.SongEventVSlide(VoiceNr, e.D );
                break;
            
            case SongEventType.FX_VOLUMESLIDEDOWN:
                vx.SongEventVSlide(VoiceNr, -e.D );
                break;
            
            case SongEventType.FX_ADDVOLUME:
                vx.SongEventAddVolume(VoiceNr, (e.C/8) );
                break;            
            case SongEventType.FX_SETVOLUME:
                vx.SongEventSetVolume(VoiceNr, e.C );
                break;
            case SongEventType.FX_STOPSAMPLE:
                vx.SongEventPausePlaying(VoiceNr);
                break;
            case SongEventType.FX_CONTSAMPLE:
                vx.SongEventContinue(VoiceNr, true);
                break;
            case SongEventType.FX_FROMANDPITCH:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.SongEventKeyOnSamplePos(si, VoiceNr, tempPitch, e.D);
                }
                break;
            case SongEventType.FX_REPLAYFROM:
                si = this.getInstrumentExisting(tempInstrNr);
                if(si != null) {
                    vx.SongEventKeyOnSamplePos(si, VoiceNr, e.D);
                }
                break;
            case SongEventType.FX_CHANNELFILTER:
		vx.setFilter(VoiceNr, (int) e.A, e.C, e.D); // Type, q, Freq
                break;
        }
    }
}

interface SeqActType { 
    int Play		=	0;
    int Skip		=	1;
    int EndOfSong	=	-1;
}

class Sequence {
    String Name ="@NOTIMPLEMENTED";
    Song ParentSong = null;
    int Action = SeqActType.Play; 
    int StartPosition = 0;
    int EndPosition = 511;
    int NumbOfLoops = 1; // = 1 Once
    int Tune = 0; // in Halvetones
}

class Position {
    String Name = "Unamed";
    Song ParentSong = null;
    int NumbOfLayers = 1;
    int[] PatternNumbers; // List to Patternnumbers ( Layers )
    int StartRow = 0;
    int RowLength = 64;
    int Tune = 0; // 0 = none
    int NumbOfLoops = 1;
    int Speed_Cycl = 4;
    
    void setNumbOfLayers(int i) {
        PatternNumbers = new int[i];
        NumbOfLayers = i;
    };
    
    String buildPosListString(int i) {
	return("" + i + ". Pat:" + PatternNumbers[0]
                        + " Spd:" + Speed_Cycl
                        + " Loops:" + NumbOfLoops
                        + " LineNr:" + StartRow
                        + " Len:" + RowLength
                        + " Tune:" + Tune
                );
    }
    
    void copyValues(Position dest) {
	dest.Name = Name;
	dest.NumbOfLayers = NumbOfLayers;
	dest.StartRow = StartRow;
	dest.RowLength = RowLength;
	dest.Tune = Tune;
	dest.NumbOfLoops = NumbOfLoops;
	dest.Speed_Cycl = Speed_Cycl;
	dest.PatternNumbers[0] = PatternNumbers[0];
    }
    
    
}

class SongPattern {
    String Name;
    Song ParentSong = null;
    private int NumbOfRows = 0;
    private int NumbOfVoices = 0;
    private boolean initialized = false;
    PatternVoice[] PatternVoices;
    
    int getNumbOfRows() {return(NumbOfRows);}
    int getNumbOfVoices() {return(NumbOfVoices);}
    
    boolean checkIsInitialized() {
        return(initialized);
    }
    
    void init(int NumbOfVoc) {
        PatternVoices = new PatternVoice[NumbOfVoc];
        for(int i=0;i<NumbOfVoc;i++) {
            PatternVoices[i] = new PatternVoice();
            PatternVoices[i].ParentSong = ParentSong;
        }
        initialized = true;
        NumbOfVoices = NumbOfVoc;
        NumbOfRows = ParentSong.getNumbOfRows();
    }

    SongEvent getSongEventForced(int VoiceIndex, float TimePosition) { // autoallocates new if needed
        if(this.initialized==true && VoiceIndex<this.getNumbOfVoices() && TimePosition<this.getNumbOfRows()) {
            PatternVoice pv = PatternVoices[VoiceIndex];
            SongEventPool sepool = pv.getSongEventPool(TimePosition);
            sepool.ParentSong = ParentSong;
            return(sepool.getSongEventForced(0));
        } else {
            return(null);
        }
    }
    
    SongEvent getSongEvent(int VoiceIndex, float TimePosition) { // returns null if none there
        if(this.initialized==true) {
            PatternVoice pv = PatternVoices[VoiceIndex];
            if(pv==null) return(null);
	    SongEventPool sepool = pv.getSongEventPool(TimePosition);
            if(sepool==null) return(null);
            sepool.ParentSong = ParentSong;
            return(sepool.getSongEvent(0));
        } else {
            return(null);
        }
    }    
    
  
    SongEvent getFreeSongEvent(int VoiceIndex, float TimePosition) {
        if(this.initialized==true) {
            PatternVoice pv = PatternVoices[VoiceIndex];
            SongEventPool sepool = pv.getSongEventPool(TimePosition);
            sepool.ParentSong = ParentSong;
            return(sepool.getFreeSongEvent());
        } else {
            return(null);
        }
    }


    
    void addSongEvent(int VoiceIndex, float TimePosition, SongEvent e) {
        if(this.initialized==true) {
            SongEvent fillSongEvent;
            fillSongEvent = this.getFreeSongEvent(VoiceIndex, TimePosition);
            if(fillSongEvent != null) {
                fillSongEvent.SongFXType = e.SongFXType;
                fillSongEvent.A = e.A;
                fillSongEvent.B = e.B;
                fillSongEvent.C = e.C;
                fillSongEvent.D = e.D;
                fillSongEvent.UpdateEventClass();
            }
        } else {
            
        }
    }
    
    void copySongEvent(int VoiceIndex, float TimePosition, SongEvent e) {
        if(this.initialized==true) {
            SongEvent fillSongEvent;
            fillSongEvent = this.getSongEventForced(VoiceIndex, TimePosition);
            if(fillSongEvent != null) {
                fillSongEvent.SongFXType = e.SongFXType;
                fillSongEvent.A = e.A;
                fillSongEvent.B = e.B;
                fillSongEvent.C = e.C;
                fillSongEvent.D = e.D;
                fillSongEvent.UpdateEventClass();
            }
        }
    }
    
}

class PatternVoice {
    SongEventPool[] SongEventPools;
    Song ParentSong = null;
    private boolean initialized = false;
    private int NumbOfPools = 0;
    private int NumbOfPoolsUsed = 0;
    
    float getTotalLength() {
        return(NumbOfPools);    // returns nummber of Pools which is noch quite correct
    }
    
    SongEventPool getSongEventPool(float TimePosition) {
        SongEventPool FoundSongEventPool = null;
        if(this.initialized== false) {
            this.NumbOfPools = ParentSong.getNumbOfRows();
            this.SongEventPools = new SongEventPool[this.NumbOfPools]; // assuming max 1 pools per line
            this.initialized = true;
        }
        
        // to do: always gets the next free one instead of looking at TimePosition
        for(int i = 0;i<this.NumbOfPools;i++) {
            if(this.SongEventPools[i] == null) {
                this.SongEventPools[i] = new SongEventPool();
                FoundSongEventPool = this.SongEventPools[i];
                FoundSongEventPool.TimePosition = TimePosition;
                //bug FoundSongEventPool.ParentSong = this.ParentSong;
                this.NumbOfPoolsUsed ++;
                return(FoundSongEventPool);
            } else {
                if(TimePosition == this.SongEventPools[i].TimePosition) {
                    return(this.SongEventPools[i]);
                }
            }
        }
        return(null);
    }
}

class SongEventPool {
    Song ParentSong = null;
    float TimePosition = 0.0f; //( 1.0 = FirstRow, 2.0 = 2nd Row)
    private int NumbOfSongEventsAvail = 0;
    private int NumbOfSongEvents = 0;
    private boolean initialized = false;
    SongEvent[] SongEvents;
    
    int getNumberOfSongEventsAvailable() { // Anzahl aktiver Songevents
        if(initialized==true) {
            return(NumbOfSongEventsAvail);
        } else {
            return(0);
        }
    }
    
    int getNumberOfSongEvents() { // Anzahl aktiver Songevents
        if(initialized==true) {
            return(this.NumbOfSongEvents);
        } else {
            return(0);
        }
    }
    
    SongEvent getSongEvent(int i) {
         if(initialized==true) {
            return(SongEvents[i]);
        } else {
            return(null);
        }       
    }
    
    SongEvent getSongEventForced(int i) { // auto allocates a new event if none there
         if(initialized==true) {
            return(SongEvents[i]);
        } else {
            return(getFreeSongEvent());
        }       
    }
    
    
    
    SongEvent getFreeSongEvent() {
        SongEvent se = null;
        if(this.initialized==false){
            this.NumbOfSongEventsAvail = 4;
            this.SongEvents = new SongEvent[this.NumbOfSongEventsAvail];
            this.NumbOfSongEvents = 0;
            this.initialized = true;
        }
        for(int i=0;i<this.NumbOfSongEventsAvail;i++) {
            if(this.SongEvents[i]==null) {
                this.SongEvents[i] = new SongEvent();
                this.SongEvents[i].ParentSong = this.ParentSong;
                this.NumbOfSongEvents ++;
                se = this.SongEvents[i];
                return(se);
            }
        }
        return(null);
    }
}


class SongEventParameter {
}

class SongEventDef {
    int SongFXType;
    java.util.Set<SongEventParameter> SongEventParameters;
}


interface SongEventAction {
    int Set = 1;
    int Validate = 2;
}


class SongEvent {
    Song ParentSong = null;
    int FXClass;
    int SongFXType;
    float A,B,C,D;
    
    SongEvent() {
	A = 0;
	B = 0;
	C = 0;
	D = 0;
	SongFXType = SongEventType.FX_NONE;
	UpdateEventClass();
    }
    
    void UpdateEventClass() {
        FXClass = SongFXType / 1000;
    }
    
    void copyValues(SongEvent DestSongEvent) {
	if(DestSongEvent!=null) {
	    DestSongEvent.A = A;
	    DestSongEvent.B = B;
	    DestSongEvent.C = C;
	    DestSongEvent.D = D;
	    DestSongEvent.SongFXType = SongFXType;
	    DestSongEvent.UpdateEventClass();
	}
    }
    
    
    void setType(int i) {
	SongFXType = i;
	UpdateEventClass();
    }
    
    void clear() {
	SongFXType = SongEventType.FX_NONE;
        FXClass = SongEventClass.GENERAL;
	A = 0;
        B = 0;
        C = 0;
	D = 0;
    }
    
    void setKeyOn(int InstrNr, int Pitch, float Vol) {
        //clear();
	SongFXType = SongEventType.FX_KEYON;
        A = InstrNr;
        B = Pitch;
        C = Vol;
        UpdateEventClass();
    }

    void setSampleFromAndPitch(int InstrNr, int Pitch, float SamplePos) {
        //clear();
	SongFXType = SongEventType.FX_FROMANDPITCH;
        A = InstrNr;
        B = Pitch;
        D = SamplePos;
        UpdateEventClass();
    }
    
    void setVolume(float Vol) {
        //clear();
	SongFXType = SongEventType.FX_SETVOLUME;
        C = Vol;
        UpdateEventClass();
    }
    
    void setPitch(int InstrNr, int Pitch) {
        //clear();
	SongFXType = SongEventType.FX_SETPITCH;
        A = InstrNr;
        B = Pitch;
        UpdateEventClass();
    }
    
    void setPauseEvent() {
        SongFXType = SongEventType.FX_STOPSAMPLE;
        UpdateEventClass();
    }
    
    void setContEvent() {
        SongFXType = SongEventType.FX_CONTSAMPLE;
        UpdateEventClass();
    }
    
    int getInstrIndexID() { //-1 = none
	if( (SongFXType == SongEventType.FX_SETPITCH) ||
	    (SongFXType == SongEventType.FX_FROMANDPITCH) ||
	    (SongFXType == SongEventType.FX_KEYON) ||
	    (SongFXType == SongEventType.FX_REPLAYFROM) 
	) {
	    return((int) this.B);
	} else {
	    return(-1);
	}
	    
    }
    

}


class SongEventEdit extends SongEvent  {

}

class PEDBlock {
    
    PEDBlock(Song newmySong) {
	mySong = newmySong;
	NumbOfVoices= mySong.getNumbOfVoices();
    }
    
    Song mySong;
    int NumbOfVoices = 0;
    boolean isMarking = false;
    int x,y,w,h;
    int x2,y2;
    int PatNr;
    public SongPattern TempPattern;
    
    String getInfo() {
	if(isMarking) {
	    return("Marking Block...:" + " (x:" + x + ",y:" + y + ")"); 
//		    + " (w:" + w + ",h:" + h + ")");
	} else {
	    return("Block Marked:" + " (x:" + x + ",y:" + y + ")" 
		    + " (w:" + w + ",h:" + h + ")");
	}
    }
    
    void markReset() { // Begin new marking
	isMarking = false;
    }
    
    void markBlockXY(int myPatNr, int tx,int ty) {
	if(isMarking == false) {
	    x = tx;y = ty;
	} else {
	    int temp=0;
	    x2 = tx;y2 = ty;
	    if(x2<x) {
		temp=x2;x2=x;x=temp;
	    }
	    if(y2<y) {
		temp=y2;y2=y;y=temp;
	    }
	    w = x2-x+1;
	    h = y2-y+1;
	}
	PatNr = myPatNr;
	isMarking = !isMarking;
	
    }
    
    void finishMarking(int myPatNr, int tx,int ty) {
	if(isMarking==true) {
	    markBlockXY(myPatNr,tx,ty);
	}
    }
    
    boolean checkMarkingFinished() {
	return(!isMarking);
    }
    
    void copyBlock(int myPatNr, int tx,int ty) {
	SongEvent SrcEvent;
	SongEvent DestEvent;
	//getTempPattern().ParentSong = mySong;
	finishMarking(myPatNr,tx,ty);
	for(int RowNr = 0;RowNr<h;RowNr++) {
	    for(int VoiceNr = 0;VoiceNr<w;VoiceNr++) {
		SrcEvent = mySong.getSongEvent(myPatNr, x+VoiceNr, y+RowNr);
		DestEvent = getTempPattern().getSongEventForced(VoiceNr, RowNr);
		if(SrcEvent!=null) {
		    SrcEvent.copyValues(DestEvent);
		} else {
		    DestEvent.clear();
		}
	    }
	}
    }
    
    void rotateBlockDown(int myPatNr, int tx,int ty) {
	SongEvent SrcEvent;
	SongEvent DestEvent;
	SongEvent LowestEvent = new SongEvent();
	LowestEvent.clear();
	
	finishMarking(myPatNr,tx,ty);
        if(h>1) {
	    
	    for(int VoiceNr = 0;VoiceNr<w;VoiceNr++) {
		SrcEvent = mySong.getSongEvent(myPatNr, x+VoiceNr, y+h-1);
		if(SrcEvent!=null) SrcEvent.copyValues(LowestEvent);
		
		for(int RowNr = h-2;RowNr>=0;RowNr--) {
		    SrcEvent = mySong.getSongEvent(myPatNr, x+VoiceNr, y+RowNr);
		    DestEvent = mySong.getSongEventForced(myPatNr, x+VoiceNr, y+RowNr+1);
		    if(SrcEvent!=null) {
			SrcEvent.copyValues(DestEvent);
		    } else {
			DestEvent.clear();
		    }
		}
		DestEvent = mySong.getSongEventForced(myPatNr, x+VoiceNr, y);
		LowestEvent.copyValues(DestEvent);
		
	    }
	}
    }
    
    void rotateBlockUp(int myPatNr, int tx,int ty) {
	SongEvent SrcEvent;
	SongEvent DestEvent;
	SongEvent LowestEvent = new SongEvent();
	LowestEvent.clear();
	
	finishMarking(myPatNr,tx,ty);
        if(h>1) {
	    
	    for(int VoiceNr = 0;VoiceNr<w;VoiceNr++) {
		SrcEvent = mySong.getSongEvent(myPatNr, x+VoiceNr, y);
		if(SrcEvent!=null) SrcEvent.copyValues(LowestEvent);
		
		for(int RowNr = 1;RowNr<h;RowNr++) {
		    SrcEvent = mySong.getSongEvent(myPatNr, x+VoiceNr, y+RowNr);
		    DestEvent = mySong.getSongEventForced(myPatNr, x+VoiceNr, y+RowNr-1);
		    if(SrcEvent!=null) {
			SrcEvent.copyValues(DestEvent);
		    } else {
			DestEvent.clear();
		    }
		}
		DestEvent = mySong.getSongEventForced(myPatNr, x+VoiceNr, y+h-1);
		LowestEvent.copyValues(DestEvent);
		
	    }
	}
    }    
    
    
    void pasteBlock(int myPatNr, int tx,int ty) {
	SongEvent SrcEvent;
	SongEvent DestEvent;
	if(h==mySong.getNumbOfRows()) ty = 0;
	if(w==mySong.getNumbOfVoices()) tx = 0;
	//getTempPattern().ParentSong = mySong;
	//finishMarking(myPatNr,tx,ty);
	for(int RowNr = 0;RowNr<h;RowNr++) {
	    for(int VoiceNr = 0;VoiceNr<w;VoiceNr++) {
		 DestEvent = mySong.getSongEventForced(myPatNr, tx+VoiceNr, ty+RowNr);
		 SrcEvent = getTempPattern().getSongEvent(VoiceNr, RowNr);
		 if(SrcEvent!=null && DestEvent!=null) {
		    SrcEvent.copyValues(DestEvent);
		 }
	    }
	}
    }
    
    void addBlock(int myPatNr, int tx,int ty) {
	SongEvent SrcEvent;
	SongEvent DestEvent;
	if(h==mySong.getNumbOfRows()) ty = 0;	
	if(w==mySong.getNumbOfVoices()) tx = 0;
	//getTempPattern().ParentSong = mySong;
	//finishMarking(myPatNr,tx,ty);
	for(int RowNr = 0;RowNr<h;RowNr++) {
	    for(int VoiceNr = 0;VoiceNr<w;VoiceNr++) {
		 DestEvent = mySong.getSongEventForced(myPatNr, tx+VoiceNr, ty+RowNr);
		 SrcEvent = getTempPattern().getSongEvent(VoiceNr, RowNr);
		 if(SrcEvent!=null && DestEvent!=null && DestEvent.SongFXType == SongEventType.FX_NONE) {
		    SrcEvent.copyValues(DestEvent);
		 }
	    }
	}
    }
    
    void clearBlock(int myPatNr, int tx,int ty) {
	SongEvent DestEvent;
	if(checkMarkingFinished()==true) {
	    for(int RowNr = 0;RowNr<h;RowNr++) {
		for(int VoiceNr = 0;VoiceNr<w;VoiceNr++) {
		     DestEvent = mySong.getSongEvent(myPatNr, x+VoiceNr, y+RowNr);
		     if(DestEvent!=null) {
			DestEvent.clear();
		     }
		}
	    }
	}
    }
    
    SongPattern getTempPattern() {
	if(TempPattern == null || TempPattern.checkIsInitialized()==false) {
	    if(TempPattern == null) TempPattern = new SongPattern();
	    TempPattern.init(NumbOfVoices);
            return(TempPattern);
        } else {
            return(TempPattern);
        }
    }
    
}




/*
NOTE_FULLEMPTY	EQU	$00ff0000
NOTE_VI		EQU	2	;WORD VVII

NOTE_SIZEOF	EQU	4

FXADDPITCH_LN		EQU	7+3
FXADDVOL_LN		EQU	5

FX_OLDNONE		EQU	-1
FX_NONE			EQU	0

FX_MIN	EQU	1
FX_MAX	EQU	FX_DSPDELAY

VOLUME_STOPSAMPLE	EQU	254
VOLUME_CONTSAMPLE	EQU	253
VOLUME_STARTSAMPLE	EQU	252
VOLUME_KEYOFF		EQU	251
VOLUME_SPEEDDOWN	EQU	250
VOLUME_SPEEDUP		EQU	249
VOLUME_SETPITCH		EQU	248
VOLUME_PITCHUP		EQU	247
VOLUME_PITCHDOWN	EQU	246
VOLUME_PITCHUP2		EQU	245
VOLUME_PITCHDOWN2	EQU	244
VOLUME_PITCHUP3		EQU	243
VOLUME_PITCHDOWN3	EQU	242
VOLUME_NONE		EQU	0
VOLUME_MIN		EQU	1
VOLUME_MAX		EQU	100
VOLUME_COMMAND		EQU	200


NOTEPITCH_NONOTE	EQU	-1
NOTEPITCH_MIN		EQU	0
NOTEPITCH_OCTAVE	EQU	12
NOTEPITCH_MAX		EQU	(NOTEPITCH_OCTAVE*7)

INSTR_MAX		EQU	127	;FUER EDITOR

DSPNOTE_TYPE	EQU	NOTE_PITCH
DSPNOTE_LEVEL	EQU	NOTE_INSTR
DSPNOTE_BUF	EQU	NOTE_VOLUME


PEDTITLE_H	EQU	1	;CHARS
PEDLINETITLE_W	EQU	5	;CHARS 

 EKeyOn		dc.l	DrawNotePitch,EVENTDrawDecByte,DrawDecByte6
		dc.b	"Key On      ",0,"Pitch ",0,"Instr ",0,"Volume",0
		even

EFX1		dc.l	EDrawNone,EDrawNone,DrawDecByte6
		dc.b	"VSlide Up   ",0,"------",0,"------",0,"Speed ",0
		even
EFX2		dc.l	EDrawNone,EDrawNone,DrawDecByte6
		dc.b	"VSlide Down ",0,"------",0,"------",0,"Speed ",0
		even
EFX3		dc.l	EDrawNone,EDrawNone,DrawDecByte6
		dc.b	"PSlide Up   ",0,"------",0,"------",0,"Speed ",0
		even
EFX4		dc.l	EDrawNone,EDrawNone,DrawDecByte6
		dc.b	"PSlide Down ",0,"------",0,"------",0,"Speed ",0
		even
EFX5		dc.l	DrawFromPi,DrawFromInstr,DrawPerHexXY
		dc.b	"ReplaySaFrom",0,"(Ptch)",0,"(Inst)",0,"Sa.Pos",0
		even
EFX6		dc.l	DrawNotePitch,DrawDecByte6,DrawPerHexXY
		dc.b	"SaFrom&Pitch",0,"Pitch ",0,"Instr ",0,"Sa.Pos",0
		even
EFX7		dc.l	EDrawNone,DrawDecByte6,DrawPerHexXY
		dc.b	"SaFromOffset",0,"------",0,"------",0,"Sa.Pos",0
		even
EFX8		dc.l	EDrawNone,DrawDecByte6,DrawFx8V
		dc.b	"ModifyFOffst",0,"------",0,"------",0,"FinePo",0
		even
EFX9		dc.l	EDrawNone,EDrawNone,DrawDecByte6
		dc.b	"Set Speed   ",0,"------",0,"------",0,"Cycl  ",0
		even
EFX10		dc.l	EDrawNone,EDrawNone,DrawFx12V
		dc.b	"Add Pitch   ",0,"------",0,"------",0,"Intens",0
		even
EFX11		dc.l	EDrawNone,EDrawNone,DrawFx11V
		dc.b	"Add Volume  ",0,"------",0,"------",0,"Intens",0
		even
EFX12		dc.l	EDrawNone,DrawDecByte6,DrawPerHexXY
		dc.b	"Tremolo     ",0,"------",0,"Speed ",0,"Rate  ",0
		even
EFX13		dc.l	EDrawNone,DrawDecByte6,DrawPerHexXY
		dc.b	"Vibrato     ",0,"------",0,"Speed ",0,"Rate  ",0
		even
EFX14		dc.l	EDrawNone,DrawDecByte6,DrawPerHexXY
		dc.b	"SamplePtrVib",0,"------",0,"Speed ",0,"Rate  ",0
		even
EFX15		dc.l	DrawNotePitch,DrawDecByte6,DrawDecByte6
		dc.b	"PitchSlideTo",0,"Pitch ",0,"Instr ",0,"Speed ",0
		even
EFX16		dc.l	EDrawNone,DrawDecPlus1,DrawDecByte6
		dc.b	"Retrig      ",0,"------",0,"Cycl  ",0,"Number",0
		even
EFX17		dc.l	DrawDecByte6,DrawDecByte6,DrawDecByte6
		dc.b	"ShOfEmphasis",0,"Start%",0,"End%  ",0,"Type  ",0
		even
EFX18		dc.l	EDrawNone,EDrawNone,DrawEVCV
		dc.b	"Add HalvTone",0,"------",0,"------",0,"Offset",0
		even
EFX19		dc.l	DrawCVIdXY,DrawDecByte6,DrawEVCV	;DrawSignDecByte6
		dc.b	"Channel Vol ",0,"Type  ",0,"Pos   ",0,"Ampl  ",0
		even
EFX20		dc.l	DrawSignDecByte6,DrawSignDecByte6,DrawSignDecByte6
		dc.b	"Illegal     ",0,"Red   ",0,"Green ",0,"Blue  ",0
		even
EFX23		dc.l	EDrawFilterID,DrawDecByte6,DrawDecByte6
		dc.b	"ResoFilter  ",0,"Type  ",0,"Reso  ",0,"Freq  ",0
		even
EFX24		dc.l	DrawDspFxXY,DrawEVEchoLvl,DrawDecByte6
		dc.b	"Dsp Echo    ",0,"§",0,"Level ",0,"Len   ",0
		even
EFX25		dc.l	DrawDspFxXY,DrawEVDelayLvl,DrawDecByte6
		dc.b	"Dsp Delay   ",0,"§",0,"Level ",0,"Len   ",0
		even
EFX26		dc.l	DrawDspFxXY,DrawDecByte6,DrawDecByte6
		dc.b	"Dsp Chorus  ",0,"§",0,"Level ",0,"Len   ",0
		even

EVibrato	dc.l	EDrawNone,DrawDecByte6,DrawPerHexXY
		dc.b	"Vibrato     ",0,"------",0,"Speed ",0,"Rate  ",0
		even

ETremolo	dc.l	EDrawNone,DrawDecByte6,DrawPerHexXY
		dc.b	"Vibrato     ",0,"------",0,"Speed ",0,"Rate  ",0
		even

ESimpleFX	dc.l	EDrawNone,EDrawNone,DrawNoteVolume
		dc.b	"Simple FX   ",0,"------",0,"------",0,"FX ID ",0  
  
  
 */
