;-----------------------------------------------------------------------------
; Music Box Musicplayer V1.00.06 RGBDS Version
;
; Library Header
;
; By Ray 'Credo' Nemes of Black Box Development <credo@scs-trc.net>
;
; From 05/09/1998 to 02/07/1999
;
; notes: first, check the documentation for more infos and the function
; desciptions below, call MBInit first and after this call MBPlay in every
; frame even for soundeffects only when those are using arpeggios, call
; MBPlaySFX any time to play soundeffects and call MBStop when you want to
; stop the music (after doing this there's no reason to call MBPlay, MBStop
; and MBPlaySFX, however doing it can't cause any trouble)
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; MBInit - Init musicsystem, call this first before you use the system
; in:  hl = address of the music
;      a  = beginning pattern position
;      b  = pattern position to loop to after end ($ff)
; out: -
; used regs: a, b, hl
; note: don't forget to activate the bank where the music is (ROM or RAM)
; before you call this and the other music subroutines
;-----------------------------------------------------------------------------

GLOBAL  MBInit

;-----------------------------------------------------------------------------
; MBStop - Stop musicsystem and all music and sound output
; in: -
; out: -
; used regs: a
; note: this will stop all the music and sound output (and save many battery
; energy), after this there's no reason to waste CPU time with MBPlaySFX,
; although MBPlay will return when this stop mode is active immediately
; without doing anything, only MBInit can activate the system again
;-----------------------------------------------------------------------------

GLOBAL  MBStop

;-----------------------------------------------------------------------------
; MBPlay - Play music (call this in every frame to update music)
; in: -
; out: -
; used regs: af, bc, de, hl
; note: to play and update the music, call this subroutine in every frame and
; call it at the same LCD raster position if it is possible, this will update
; and play the music and update the arpeggios too, so even call this if you
; only use sondeffects with arpeggio
;-----------------------------------------------------------------------------

GLOBAL  MBPlay

;-----------------------------------------------------------------------------
; MBPlaySFX - Play soundeffects
; in:  a = samplenumber ($00 is the first sample in this routine)
;      b = notenumber ($00 is the first note: C-3 in this routine)
;      c = channel number ($00 is the first channel, $01 is the second, etc)
; out: -
; used regs: af, bc, de, hl
; note: use this subroutine to play soundeffects, there are many things you
; have to keep in mind, check out my Music Box docs, some small hints: use
; this after you used MBInit and didn't used MBStop, use $00 as the first
; sample, note and channel (in the music $01 is the first sample and note),
; you can use soundeffects without music too, but if you don't update the
; music with MBPlay each frame, the sounds will not use the arpeggio, only
; the first value in the actual arpeggio table, try to use soundeffects on
; that channel where no notes are used in the music (empty channel) and keep
; in mind that the fourth channel doesn't have note and arpeggio, so that you
; can use totally without MBPlay called in every frame and you can store
; anything in b when c = $03, and play samples created for channel 1 on
; channel 1 etc otherwise you'll get garbage, there are a lot of things in the
; manual too
;-----------------------------------------------------------------------------

GLOBAL  MBPlaySFX

;-----------------------------------------------------------------------------
