@echo off
chcp 65001 >nul
setlocal enabledelayedexpansion

set "version=1.0"
set "date=January 22, 2025"

:main
cls
echo ========================================================
echo                FFmpeg Audio Normalizer v%version%
echo                Created on: %date%
echo --------------------------------------------------------
echo This batch file normalizes the volume of an audio file
echo and saves it in a new file with the suffix '-Normalized'.
echo --------------------------------------------------------
echo Please place this batch file in the same folder as
echo 'ffmpeg.exe', which you can download from here:
echo https://github.com/BtbN/FFmpeg-Builds/releases/tag/latest
echo ========================================================
echo.
echo Select an option:
echo [1] Start normalization process
echo.
echo [D] Show directory contents
echo [Q] Quit program
echo.

set /p option=
if /i "!option!"=="1" goto input
if /i "!option!"=="D" goto directory
if /i "!option!"=="Q" goto end

echo Invalid input. Please try again.
pause
goto main

:directory
cls
echo ========================================================
echo                    Directory contents
echo ========================================================
echo.
dir /b /o:n /t:w
echo.
echo You can mark the filename with the mouse and copy it either with right-click or with CTRL+C.
echo.
pause
goto main

:input
cls
echo ========================================================
echo                FFmpeg Audio Normalizer v%version%
echo                Created on: %date%
echo --------------------------------------------------------
echo This batch file normalizes the volume of an audio file
echo and saves it in a new file with the suffix '-Normalized'.
echo ========================================================
echo.
echo Please enter the name of the original file (including extension, e.g., "file.wav"):
echo Or simply drag the file into this window and press Enter.
echo.
set /p source=

:: Remove quotation marks if present
set "source=!source:"=!"

echo.
echo You have entered !source!.
echo The program will start the process to normalize the file and create the output file.
echo.

echo Do you want to proceed with this process? [Y]es / [N]o / [Q]uit
set /p confirm=
if /i "!confirm!"=="Y" goto process
if /i "!confirm!"=="N" goto input
if /i "!confirm!"=="Q" goto end

:process
if not exist "ffmpeg.exe" (
    echo.
    echo FFmpeg not found. Please make sure that the file 'ffmpeg.exe' is in the same directory as this batch file.
    echo.
    pause
    goto main
)
if not exist "!source!" (
    echo.
    echo The file !source! was not found. Please check the filename and try again.
    echo.
    pause
    goto input
)
set "output=!source!"
set "output=!output:.wav=-Normalized.wav!"
ffmpeg.exe -i "!source!" -af "loudnorm=I=-10:TP=-1" -ar 48000 -ac 2 -c:a pcm_f32le "!output!"
if %errorlevel% neq 0 (
    echo.
    echo Error during normalization. Further details can be found in the log.txt file.
    echo.
) else (
    echo.
    echo The output file "!output!" has been created.
    echo.
)
pause
goto main

:end
cls
echo ========================================================
echo This file was created by Andreas 'melcom' Urban.
echo This file is free and open for anyone to modify and share.
echo --------------------------------------------------------
echo If you have any questions, you can contact melcom through the following link:
echo https://www.melcom-music.de/p/contact.html
echo ========================================================
echo.
pause
exit
