@echo off
chcp 65001 >nul
setlocal enabledelayedexpansion

set "version=1.4"
set "date=January 23, 2025"
set "logfile=log.txt"
set "templogfile=templog.txt"
set "max_log_size=10240" :: 10 KB (the maximum size of the log file)

:main
cls
echo ========================================================
echo                FFmpeg Audio Normalizer v%version%
echo                Created on: %date%
echo --------------------------------------------------------
echo This batch file normalizes the volume of an audio file
echo and saves it in a new file with the suffix '-Normalized'.
echo --------------------------------------------------------
echo Please copy 'ffmpeg.exe' into the same directory as
echo this batch file. You can download 'ffmpeg.exe' from here:
echo https://github.com/BtbN/FFmpeg-Builds/releases/tag/latest
echo ========================================================
echo.
echo Choose an option:
echo [1] Start normalization process
echo.
echo [D] Display directory contents
echo [Q] Exit program
echo.

set /p option=
if /i "!option!"=="1" goto input
if /i "!option!"=="D" goto directory
if /i "!option!"=="Q" goto end

echo Invalid input. Please try again.
pause
goto main
:directory
cls
echo ========================================================
echo                    Directory Contents
echo ========================================================
echo.
dir /b /o:n /t:w
echo.
echo You can highlight the filename with your mouse and either right-click to copy or use CTRL+C.
echo.
pause
goto main

:input
cls
echo ========================================================
echo                FFmpeg Audio Normalizer v%version%
echo                Created on: %date%
echo --------------------------------------------------------
echo This batch file normalizes the volume of an audio file
echo and saves it in a new file with the suffix '-Normalized'.
echo ========================================================
echo.
echo Please enter the name of the original file (with extension, e.g., "file.wav"):
echo Or simply drag the file into this window and press Enter.
echo.
set /p source=

:: Remove quotes if present
set "source=!source:"=!"

if not exist "!source!" (
    echo.
    echo The file !source! was not found. Please check the filename and try again.
    echo.
    pause
    goto input
)
echo.
echo You entered !source!.
echo.
echo The program will start the process to normalize the file and create the output file.
echo.

echo Do you want to proceed with this process? [Y]es / [N]o / [Q]uit
set /p confirm=
echo.

if /i "!confirm!"=="Y" goto loudness_query
if /i "!confirm!"=="N" (
    set "loudness=-10"
    goto check_output_exists
)
if /i "!confirm!"=="Q" goto end

goto main

:loudness_query
echo Do you want to change the default value of -10 LUFS? [Y]es / [N]o
set /p change_loudness=
echo.

if /i "!change_loudness!"=="Y" goto process_input
if /i "!change_loudness!"=="N" (
    set "loudness=-10"
    goto check_output_exists
)

goto main

:process_input
echo Please enter the target loudness value (default: -10 LUFS):
set /p loudness=
:: Check the loudness value
if "!loudness!"=="" set "loudness=-10"
goto check_output_exists
:check_output_exists
set "output=!source!"
set "output=!output:.wav=-Normalized.wav!"

if exist "!output!" (
    echo.
    echo The output file "!output!" already exists. Do you want to delete and recreate it? [Y]es / [N]o
    set /p delete=
    if /i "!delete!"=="Y" (
        del "!output!"
        goto process
    )
    if /i "!delete!"=="N" (
        goto main
    )
    goto main
)

goto process

:process
if not exist "ffmpeg.exe" (
    echo.
    echo FFmpeg was not found. Please ensure that the 'ffmpeg.exe' file is in the same directory as this batch file.
    echo.
    pause
    goto main
)

:: Add date and time to the temporary log file (without hundredths of a second)
for /f "tokens=1-3 delims=:.," %%a in ("%time%") do set time_stamp=%%a:%%b:%%c
echo ======================================================== > %templogfile%
echo Process started: %date% %time_stamp% >> %templogfile%
:: Start progress display
cls
echo ========================================================
echo                FFmpeg Audio Normalizer v%version%
echo                Created on: %date%
echo --------------------------------------------------------
echo This batch file normalizes the volume of an audio file
echo and saves it in a new file with the suffix '-Normalized'.
echo ========================================================
echo.
echo The process is running. Please wait a moment:
echo.

:: Start ffmpeg in the background and display progress
start /b cmd /c ffmpeg.exe -i "!source!" -af "loudnorm=I=!loudness!:TP=-1" -ar 48000 -ac 2 -c:a pcm_f32le "!output!" >> %templogfile% 2>>&1

:: Simulated progress display
set "progress=0"
:progress_loop
set /a progress+=10
if %progress% leq 100 (
    echo %progress%%
    timeout /t 1 >nul
    goto progress_loop
)

:: Check if the process was successful
if exist "!output!" (
    echo Process completed: %date% %time_stamp% >> %templogfile%
    echo ======================================================== >> %templogfile%
    goto merge_logs
) else (
    echo.
    echo Error during normalization. For more details, see the %templogfile% file.
    echo.
    echo Error during normalization: %date% %time_stamp% >> %templogfile%
    echo ======================================================== >> %templogfile%
    goto merge_logs
)
:merge_logs
type %logfile% >> %templogfile%
move /y %templogfile% %logfile%

:show_output
cls
echo ========================================================
echo                FFmpeg Audio Normalizer v%version%
echo                Created on: %date%
echo --------------------------------------------------------
echo This batch file normalizes the volume of an audio file
echo and saves it in a new file with the suffix '-Normalized'.
echo ========================================================
echo.
echo The output file "!output!" has been created.
echo.
echo The process log has been saved to "%logfile%".
echo Do you want to view the log file? [Y]es / [N]o
set /p view_log=
if /i "!view_log!"=="Y" (
    notepad %logfile%
    echo.
    pause
    goto main
)
if /i "!view_log!"=="N" (
    goto main
)

echo.
echo Press any key to continue . . .
pause
goto main

:end
cls
echo ========================================================
echo This file was created by Andreas 'melcom' Urban.
echo This file is free and open for anyone to modify and distribute.
echo --------------------------------------------------------
echo If you have any questions, you can contact melcom through the following link:
echo https://www.melcom-music.de/p/contact.html
echo ========================================================
echo.
pause
exit
