﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Linq;
using System.Windows.Forms;
using System.IO;
using KSDManager;
using Jacobi.Vst.Framework;
using Jacobi.Vst.Core;
using System.Configuration;
using System.Reflection;
using System.Runtime.InteropServices;
using Jacobi.Vst.Interop.Host;

namespace SoftSynthVST
{
    public partial class VSTUserControl : UserControl
    {
        public Plugin _plugin;
        public string LeftSideMode;
        public string RightSideMode;
        public bool   ShowButtomPanel;
        public float  ButtomPanelTop;
        public int    CompressorMode;

        public int Compressor_Mode
        {
            get
            {
                return CompressorMode;
            }

            set
            {
                if (value == 0) radioCompOff.Checked = true;
                if (value == 1) radioCompInst.Checked = true;
                if (value == 2) radioCompEffect.Checked = true;
                trackCompChanged(null, null);
            }
        }

        public float Compressor_Threshold
        {
            get { return trackCompThreshold.Value; }
            set { trackCompThreshold.Value = (int)value; trackCompChanged(null, null); }
        }

        public float Compressor_MakeupGain
        {
            get { return trackCompMakeupGain.Value; }
            set { trackCompMakeupGain.Value = (int)value; trackCompChanged(null, null); }
        }

        public float Compressor_AttackTime
        {
            get { return trackCompAttackResp.Value * 0.01f; }
            set { trackCompAttackResp.Value = (int)(value / 0.01f); trackCompChanged(null, null); }
        }

        public float Compressor_ReleaseTime
        {
            get { return trackCompReleaseResp.Value * 5; }
            set { trackCompReleaseResp.Value = (int)(value / 5); trackCompChanged(null, null); }
        }

        public float Compressor_Ratio
        {
            get { return trackCompRatio.Value / 127f; }
            set { trackCompRatio.Value = (int)(value * 127f); trackCompChanged(null, null); }
        }

        public VSTUserControl()
        {
            InitializeComponent();
            OnUIUpdate(null, null);
            tabControl1.SelectedIndex = 1;
            
            // Setup Defaults for compressor
            Compressor_Mode = 1;
            Compressor_AttackTime = 0.1f;
            Compressor_ReleaseTime = 300;
            Compressor_Threshold = -60;
            Compressor_Ratio = 0.5f;

            ButtomPanelTop = pnlButtom.Top;
        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            double Value = trackBar1.Value / 1000.0;
            _plugin.ap.Track1 = (float)Value;
            label1.Text = Value.ToString();
        }

        private void trackBar2_Scroll(object sender, EventArgs e)
        {
            double Value = trackBar2.Value / 1000.0;
            _plugin.ap.Track2 = (float)Value;
            label2.Text = Value.ToString();
        }

        private void trackBar3_Scroll(object sender, EventArgs e)
        {
            double Value = trackBar3.Value / 1000.0;
            _plugin.ap.Track3 = (float)Value;
            label3.Text = Value.ToString();
        }

        private void timerStartup_Tick(object sender, EventArgs e)
        {
            timerStartup.Enabled = false;
            trackBar1.Value = 500; trackBar1_Scroll(null, null);
            trackBar2.Value = 500; trackBar2_Scroll(null, null);
            trackBar3.Value = 500; trackBar3_Scroll(null, null);
            _plugin.LoadKSDFromHost();
        }

        private void timerUpdate_Tick(object sender, EventArgs e)
        {
            // Choose to show/hide buttom panel
            var MousePos = this.PointToClient(Cursor.Position);
            if (!ShowButtomPanel)
                ShowButtomPanel = MousePos.Y > ClientSize.Height - 20;
            else
                ShowButtomPanel = MousePos.Y > ClientSize.Height - pnlButtom.Height - 20;

            // Slide panel
            int TargetTop = ShowButtomPanel ? ClientSize.Height - pnlButtom.Height : ClientSize.Height;
            ButtomPanelTop += (TargetTop - ButtomPanelTop) / 3.0f;
            pnlButtom.Dock = DockStyle.None;
            pnlButtom.Top = (int)ButtomPanelTop;

            lblInEnvLevel_L.Text = _plugin.ap.InEnvLevel.ToString("0.0000");
            lblInEnvLevel_R.Text = "0.0000";
            lblSigLength.Text = _plugin.ap.SignalLength.ToString("0.0000");
            lblMidiNote.Text = _plugin.mp.LastNote.ToString();
            lblSampleCounter.Text = _plugin.ap.SampleCounter.ToString() ;
            lblPref.Text = _plugin.ap.PrefStr;
            lblCurrentOut.Text = _plugin.ap.ScrollLock ? "FM8" : "SoftSynth";

            SoundRenderInterface.DebugParams(_plugin.ap.Track1, _plugin.ap.Track2, _plugin.ap.Track3);
        }

        private void btnCopyWave_Click(object sender, EventArgs e)
        {
            _plugin.ap.GetSample = true;
        }

        public void UnloadFM8()
        {
            _plugin.fm8PluginContext.PluginCommandStub.MainsChanged(false);
            _plugin.fm8PluginContext.PluginCommandStub.Close();
            _plugin.hostCommandStub = null;
            _plugin.fm8PluginContext = null;
        }

        public void LoadFM8()
        {
            // Load FM8 settings
            var IniFilename = Path.GetDirectoryName(Assembly.GetAssembly(this.GetType()).Location) + @"\Settings.ini";
            if (!File.Exists(IniFilename))
            {
                MessageBox.Show("Could not find " + IniFilename);
                return;
            }

            var Ini = new INIFile(IniFilename);
            var ModeStr = Ini.GetValue("General", "Mode", "");
            switch (ModeStr.ToUpper())
            {
                case "EFFECT":
                    // Setup Mode
                    _plugin.Mode = VSTMode.Compressor;
                    break;

                case "SYNTH":
                    // Setup Mode
                    _plugin.Mode = VSTMode.Synth;

                    // Get FM8 vst path
                    var FM8Exe = Ini.GetValue("General", "FM8Exe", "");
                    if (String.IsNullOrEmpty(FM8Exe))
                    {
                        MessageBox.Show("FM8Exe was not defined. ");
                        return;
                    }

                    // Create host stub
                    _plugin.hostCommandStub = new HostCommandStub();
                    _plugin.hostCommandStub._plugin = _plugin;

                    // Setup fm8 context
                    _plugin.fm8PluginContext = VstPluginContext.Create(FM8Exe, _plugin.hostCommandStub);
                    _plugin.fm8PluginContext.Set("PluginPath", FM8Exe);
                    _plugin.fm8PluginContext.Set("HostCmdStub", _plugin.hostCommandStub);
                    _plugin.fm8PluginContext.PluginCommandStub.Open();
                    _plugin.fm8PluginContext.PluginCommandStub.StartProcess();

                    // Get size
                    // Rectangle wndRect = new Rectangle();
                    // _plugin.fm8PluginContext.PluginCommandStub.EditorGetRect(out wndRect);
                    break;

                default:
                    MessageBox.Show("INI error, mode must be Effect or Synth");
                    return;
                    break;
            }
        }

        private void HostCmdStub_PluginCalled(object sender, PluginCalledEventArgs e)
        {
            HostCommandStub hostCmdStub = (HostCommandStub)sender;

            // can be null when called from inside the plugin main entry point.
            if (hostCmdStub.PluginContext.PluginInfo != null)
            {
                //Debug.WriteLine("Plugin " + hostCmdStub.PluginContext.PluginInfo.PluginID + " called:" + e.Message);
            }
            else
            {
                //Debug.WriteLine("The loading Plugin called:" + e.Message);
            }
        }

        private void OnUIUpdate(object sender, EventArgs e)
        {
            LeftSideMode = comboLeftMode.Text;
            RightSideMode = comboRightMode.Text;
        }

        private void btnReload_Click(object sender, EventArgs e)
        {
            _plugin.LoadKSDFromHost();
        }

        private void trackCompChanged(object sender, EventArgs e)
        {
            lblCompThreshold.Text   = string.Format("Threshold {0} [dB]", Compressor_Threshold);
            lblCompMakeupGain.Text  = string.Format("Maleup Gain {0} [dB]", Compressor_MakeupGain);
            lblCompAttackResp.Text  = string.Format("Attack Time {0} [ms]", Compressor_AttackTime);
            lblCompReleaseResp.Text = string.Format("Release Time {0} [ms]", Compressor_ReleaseTime);
            lblCompRatio.Text       = string.Format("Ratio {0}", Compressor_Ratio);

            if (radioCompOff.Checked) CompressorMode = 0;
            if (radioCompInst.Checked) CompressorMode = 1;
            if (radioCompEffect.Checked) CompressorMode = 2;

            if (_plugin != null)
                _plugin.LoadKSDFromHost();
        }

        private void VSTUserControl_VisibleChanged(object sender, EventArgs e)
        {
            if (Visible)
            {
                _plugin.fm8PluginContext.PluginCommandStub.EditorOpen(panel1.Handle);
                // _plugin.fm8PluginContext.PluginCommandStub.MainsChanged(true);
            }
            else
            {
                _plugin.fm8PluginContext.PluginCommandStub.EditorClose();
            }

        }
    }
}
