﻿using System;
using Jacobi.Vst.Core;
using Jacobi.Vst.Framework;
using Jacobi.Vst.Framework.Common;
using System.Runtime.InteropServices;

namespace CompressorFX
{
    /// <summary>
    /// Implements the custom UI editor for the plugin.
    /// </summary>
    public class PluginEditor : IVstPluginEditor
    {
        [DllImport("user32.dll")]
        public static extern IntPtr SetParent(IntPtr child, IntPtr newParent);

        private Plugin _plugin;

        public PluginEditor(Plugin plugin)
        {
            plugin.control = new VSTUserControl();
            plugin.control._plugin = _plugin = plugin;
        }

        #region IVstPluginEditor Members

        public System.Drawing.Rectangle Bounds
        {
            get { return _plugin.control.Bounds; }
        }

        public void Close()
        {
            _plugin.control.Hide();
        }

        public void KeyDown(byte ascii, VstVirtualKey virtualKey, VstModifierKeys modifers)
        {
        }

        public void KeyUp(byte ascii, VstVirtualKey virtualKey, VstModifierKeys modifers)
        {
        }

        public VstKnobMode KnobMode { get; set; }

        public void Open(IntPtr hWnd)
        {
            /*_uiWrapper.SafeInstance.NoteMap = _plugin.NoteMap;
            _uiWrapper.SafeInstance.NoteOnEvents = _plugin.GetInstance<MidiProcessor>().NoteOnEvents;*/
            /*var instance = _uiWrapper.SafeInstance;
            instance._plugin = _plugin;
            _plugin.control = instance;
            _plugin.control.LoadFM8();*/
            //_uiWrapper.Open(hWnd);
            SetParent(_plugin.control.Handle, hWnd);
            _plugin.control.Show();
        }

        public void ProcessIdle()
        {
           //_uiWrapper.SafeInstance.
        }

        #endregion
    }
}
