#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <conio.h>
#include <stdio.h>

#include "FM8_SoundRenderer.h"

extern "C" int _fltused = 0;

HANDLE hOut;
char szTitle[] = "TinyFM8 ExeMusic sample.\n\nComputing waveforms...\n";
char szPlaying[] = "Playing\n";



void IntToStr(int value, char * str)
{
	// count digits
	int valueTemp = value;
	while (valueTemp != 0)
	{
		str++; 
		valueTemp /= 10;
	}

	// null terminanation
	*(str--) = 0;

	// parse text
	while (value != 0)
	{
		*(str--) = 48 + (value % 10);
		value /= 10;
	}
}

void main()
{
	// Write title
	hOut = GetStdHandle(STD_OUTPUT_HANDLE);
	WriteConsoleA(hOut, szTitle, sizeof(szTitle)-1, NULL, NULL);
	FM8_Setup();

	// Write "playing..."
	WriteConsoleA(hOut, szPlaying, sizeof(szPlaying)-1, NULL, NULL);
	FM8_Start();

	// Wait for key press
	while (!(GetAsyncKeyState(VK_ESCAPE) & 0x8000))
	{
		Sleep(10);

		// Report state
		char szReport1Value[20];
		char szReport2Value[20];
		char szReport1[] = "\rBuffer: ";
		char szReport2[] = " Sample Pos: ";
		IntToStr(m_BufferingState, szReport1Value);
		IntToStr(m_PlayPos_Samples, szReport2Value);
		WriteConsoleA(hOut, szReport1,      strlen(szReport1),      NULL, NULL);
		WriteConsoleA(hOut, szReport1Value, strlen(szReport1Value), NULL, NULL);
		WriteConsoleA(hOut, szReport2,      strlen(szReport2),      NULL, NULL);
		WriteConsoleA(hOut, szReport2Value, strlen(szReport2Value), NULL, NULL);
	}

	ExitProcess(0);
}