#pragma once

#include "FM8_Utils.h"

#pragma pack(push, 1)

struct FM8_Compressor
{
    // Loaded values
    Int8 LV_AttackTime;
    Int8 LV_ReleaseTime;
    Int8 LV_Threshold;
    Int8 LV_MakeupGain;
    Int8 LV_Ratio;

    // Computed values
    float m_makeup_gain;
    float m_env_rms_state;
    float m_env_rms_coef;
    float m_env_overB_state;		// over-threshold envelope (dB)
    float m_env_overB_coef_att;
    float m_env_overB_coef_rel;
    float m_thresholdB;				// threshold (dB)
    float m_ratio;					// ratio (compression: < 1 ; expansion: > 1)

    void Setup();
    void Process(float& in1, float& in2);
	void Render(float* pBuffer, int nBufferSize);
};

// Function to create FM8_Compressor array from parameters block
int FM8_CreateCompressors(void* pBlock, FM8_Compressor** pCompressors);

#pragma pack(pop)
