#pragma once

#include "FM8_Utils.h"

#define COMB_FILTERS      6
#define ALLPASS_FILTERS   4
#define NUMDELAYLINES     (COMB_FILTERS + ALLPASS_FILTERS)
#define ALLPASS_0         (COMB_FILTERS + 0)

#pragma pack(push, 1)

struct FM8_Reverb
{
    // Loaded values
    Int8 LV_InDiffuse1;
    Int8 LV_InDiffuse2;
    Int8 LV_BandLimiter;
    Int8 LV_Time;
    Int8 LV_Damping;
    Int8 LV_OutGain;

    // Computed values
    float m_in_gain;
    float m_out_gain;

    float lowpass_out;

    // delay lines
    float* buffers[NUMDELAYLINES];
    int    length[NUMDELAYLINES];
    int    pos[NUMDELAYLINES];

    // comb filters
    float  low[COMB_FILTERS];
    float  c[COMB_FILTERS];

    void Setup();
    void Process(float& sample);
    float& DelayLine(int index);
};

// Load reverb parameters structuer into FM8_Reverb sturcts 
int FM8_CreateReverbs(void* pBlock, FM8_Reverb** pReverb);

// Inplace buffer rendering reverb effect
void FM8_ReverbRender(FM8_Reverb* pLeft, FM8_Reverb* pRight, float* pBuffer, int nBufferSize);

#pragma pack(pop)
