#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include <conio.h>
#include <stdio.h>

#include "FM8_Utils.h"
#include "FM8_Synth.h"
#include "FM8_Compressor.h"
#include "FM8_Reverb.h"
#include "MusicData.h"

// Instrument/Voice bank
int             m_VoiceCount[255];
FM8_Synth*      m_Instruments[255/*Instrument*/][255/*Voices*/];
FM8_Reverb*     m_LReverbs[32];
FM8_Reverb*     m_RReverbs[32];
FM8_Compressor* m_Compressors[32];

// Rendering consts
#define AUDIO_CHANNELS       (2)
#define BYTES_PER_SAMPLE     (2)
#define CHANNEL_BUFFER_DEPTH (1048576) //  2^20 / (SAMPLE_RATE * AUDIO_CHANNELS) = 24 seconds*/
#define OUT_BUFFER_MASK      (0x001FFFFF) // 20 bits + 1 bit for stereo channeling

// Render line buffers
float LineWorkBuf[SAMPLES_PER_LINE * AUDIO_CHANNELS];
float LineSumBuf [SAMPLES_PER_LINE * AUDIO_CHANNELS];

Int16* pSoundBuffer;
HANDLE g_ThreadID;

// Rendering counters
int m_QueuePos_Line;
int m_QueuePos_Samples;
int m_QueuePos_NextEvent;
int m_PlayPos_Line;
int m_PlayPos_Samples;
int m_PlayPos_NextEvent;
int m_BufferingState;

void UpdatePlayPosition()
{
    // Update played samples count
    m_PlayPos_Samples  = FM8_soundGetPosInSamples();
    m_PlayPos_Line     = m_PlayPos_Samples / SAMPLES_PER_LINE;

    // Update buffering state
    m_BufferingState = (m_QueuePos_Samples - m_PlayPos_Samples) * 100 / CHANNEL_BUFFER_DEPTH;
    if (m_BufferingState < 0) m_BufferingState = 0;

    // Track on the currently processed event
    while ((m_PlayPos_NextEvent < SONG_EVENTS) && (songEvent_Time[m_PlayPos_NextEvent] <= m_PlayPos_Line))
    {
        // Notify on new note sent
        // if (OnNoteCommandSent != null)
        //    OnNoteCommandSent(m_PlayPos_NextEvent);

        // Next event
        m_PlayPos_NextEvent++;
    }
}

DWORD WINAPI MainRenderThread( LPVOID lpParam ) 
{
    while(true)
    {
        // Update Play position before it is used 
        UpdatePlayPosition();
        
        // Check if we need to render a fragment (if there is free space in buffer)
        while (CHANNEL_BUFFER_DEPTH + m_PlayPos_Samples - m_QueuePos_Samples > SAMPLES_PER_LINE)
        {
            // Check if there are new events in fragment
            while ((m_QueuePos_NextEvent < SONG_EVENTS) && (songEvent_Time[m_QueuePos_NextEvent] <= m_QueuePos_Line))
            {
                // Get instrument
                int nInstIndex = songEvent_Inst[m_QueuePos_NextEvent];

                // Check if it's a release command
                if (songEvent_Velocity[m_QueuePos_NextEvent] == 0)
                {
                    // release all voices in instrument
                    for (int nVoice = 0; nVoice < m_VoiceCount[nInstIndex]; nVoice++)
                        if (m_Instruments[nInstIndex][nVoice]->Note_Index == songEvent_Note[m_QueuePos_NextEvent])
                            m_Instruments[nInstIndex][nVoice]->ReleaseNote();
                }
                else
                {
                    int nPolyVoices   = m_VoiceCount[nInstIndex];
                    int nUnisonVoices = m_Instruments[nInstIndex][0]->Unison_Voices;

                    // init instrument
                    for (int nVoice = 0; nVoice < nUnisonVoices; nVoice++)
                    {
                        FM8_Synth* inst = m_Instruments[nInstIndex][nVoice];
                        inst->PlayNote(songEvent_Note[m_QueuePos_NextEvent], nVoice);
                        inst->SetVelocity(songEvent_Velocity[m_QueuePos_NextEvent] / 127.f);
                    }

                    // move head->tail
                    FM8_memcpy(&m_Instruments[nInstIndex][nPolyVoices], &m_Instruments[nInstIndex][0],             4 * nUnisonVoices);
                    FM8_memcpy(&m_Instruments[nInstIndex][0],           &m_Instruments[nInstIndex][nUnisonVoices], 4 * nPolyVoices);
                }

                // Next event
                m_QueuePos_NextEvent++;
            }

            // Render audio of all voices
            FM8_memset(LineSumBuf, 0, sizeof(LineSumBuf));
            for (int iTrack = 0; iTrack < 12; iTrack++)
            {
                // Render all tracks related instruments into LineWorkBuf
                FM8_memset(LineWorkBuf, 0, sizeof(LineWorkBuf));
                for (int nInst = 0; nInst < InstData[0]; nInst++)
                {
                    // Skip no relevent track
                    if (m_Instruments[nInst][0]->TrackIndex != iTrack)
                        continue;

                    // Render all voices to track
                    for (int nVoice = 0; nVoice < m_VoiceCount[nInst]; nVoice++)
                        m_Instruments[nInst][nVoice]->RenderToBuffer(LineWorkBuf, SAMPLES_PER_LINE); 
                }

                // Apply effect chain (TRACKS_FX_PROCESS is defined inside MusicData.h)
				TRACKS_FX_PROCESS

                // add samples to main buffer
                for (int i = 0; i < SAMPLES_PER_LINE * AUDIO_CHANNELS; i++)
                    LineSumBuf[i] += LineWorkBuf[i];
            }

			// Master channel effects (MASTER_FX_PROCESS is defined inside MusicData.h)
			MASTER_FX_PROCESS
						
            // Convert to 16 bit and write into memory
            int BufferOffset = m_QueuePos_Samples * AUDIO_CHANNELS;
            for (int i = 0; i < SAMPLES_PER_LINE * AUDIO_CHANNELS; i++)
            {
                // Get sample and trim it
                float sample = LineSumBuf[i] * 0.5f;
                if (sample > +1) sample = +1;
                if (sample < -1) sample = -1;

                // Uncomment the following lines to have a stream writen to file
                //static HANDLE outfile = CreateFileA("c:\\out.raw", GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
                //DWORD WriteCount;
                //WriteFile(outfile, &sample, sizeof(sample), &WriteCount, NULL); 

                // Write sample to buffer
                pSoundBuffer[BufferOffset++ & OUT_BUFFER_MASK] = (signed short)(sample * 0x7FFF);
            }

            // Increment line queue counter
            m_QueuePos_Samples += SAMPLES_PER_LINE;
            m_QueuePos_Line++;

            // Update Buffering state
            UpdatePlayPosition();
        }

        Sleep(10);
    }
}

void FM8_Setup()
{
    // Load Instruments
    FM8_Synth* InstArray;
    FM8_LoadInstruments(InstData, InstArray);

    // Create Polyphonic voices for all instruments
    for (int nInst = 0; nInst < InstData[0]; nInst++)
    {
        Int8 Voices = m_VoiceCount[nInst] = (InstArray + nInst)->Polyphony_Voices;
        for (Int8  nVoice = 0; nVoice < Voices; nVoice++)
        {
            FM8_Synth* pInst = m_Instruments[nInst][nVoice] = (FM8_Synth*)GlobalAlloc( GMEM_ZEROINIT, sizeof(FM8_Synth) );
            FM8_memcpy(pInst, InstArray + nInst, sizeof(FM8_Synth));
        }
    }

	// Create track effects
	FM8_CreateCompressors(CompData, (FM8_Compressor**) &m_Compressors);
	FM8_CreateReverbs(ReverbData,   (FM8_Reverb**)     &m_LReverbs);
	FM8_CreateReverbs(ReverbData,   (FM8_Reverb**)     &m_RReverbs);
}

void FM8_Start()
{
    // Create sound device
    pSoundBuffer = (signed short*)GlobalAlloc( GMEM_ZEROINIT, CHANNEL_BUFFER_DEPTH * AUDIO_CHANNELS * BYTES_PER_SAMPLE);
    FM8_soundInit(pSoundBuffer, CHANNEL_BUFFER_DEPTH * AUDIO_CHANNELS * BYTES_PER_SAMPLE);
    FM8_soundStart();

    unsigned long thid;
    g_ThreadID = CreateThread(NULL, 0, &MainRenderThread, NULL, 0, &thid);
}