#pragma once

#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#include "FM8_AppAbstractionLayer.h"

// Type definitions
#define Int8       signed char
#define UInt8      unsigned char
#define Int16      short
#define UInt16     unsigned short

// Const definitions
#define FLT_MAX  1E+38F
#define M_E  2.7182818284F
#define M_PI 3.1415926536F

// Sample logging and debugging (excluded in release)
#if 0
    #define ENABLE_SAMPLE_LOGGING
	void LOG_CREATE(HANDLE& hFile, char* szFilename);
	void LOG_SAMPLE(HANDLE file, float Sample);
#else
	#define LOG_CREATE(a, b) 
	#define LOG_SAMPLE(a, b)
#endif

static inline float lin2dB( float lin ) 
{
    static const float LOG_2_DB = 6.02059991327962f;	// 20 / log( 10, 2)
    return FM8_log2f( lin ) * LOG_2_DB;
}

static inline float dB2lin( float dB ) 
{
    static const float DB_2_LOG = 0.11512925464970228420089957273422f;	// ln( 10 ) / 20
    return FM8_expf( dB * DB_2_LOG );
}

static inline float MIX100(float a, float b, float ratio)
{
	return (a * (1-(float)ratio/100) + b * ((float)ratio/100.f));
}

static inline float MIN(float a, float b)
{
	return a < b ? a : b;
}

static inline float MAX(float a, float b)
{
	return a > b ? a : b;
}

static inline float SIGN(float a)
{
	return a > 0 ? +1.0f : -1.0f;
}

int LoadInterlacedStruct(UInt8*& pInterlacedData, UInt8*& pStructs, int nStructSize, int nLoadSize);

void Load2DJaggedArray(UInt8* pDst, UInt8*& pSrc, int nItemSize, Int8* nRowsLength);

