﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TinyFM8.UserControls
{
    public partial class panelOpZ : UserControl
    {
        public PatchData pd;
        public EventHandler UIChanged;

        private bool InternalValueChange = false;

        public void LoadFromData()
        {
            if (pd == null)
                return;

            // Block self change reporting
            InternalValueChange = true;
            knobMix.Value    = pd.OPZ_Mix;
            knobParSer.Value = pd.OPZ_Routing;
            knobCutoff.Value = pd.OPZ_CutOff;
            knobReso1.Value  = pd.OPZ_Reso1;
            knobMode1.Value  = pd.OPZ_Mode1;
            knobSpread.Value = pd.OPZ_Spread;
            knobReso2.Value  = pd.OPZ_Reso2;
            knobMode2.Value  = pd.OPZ_Mode2;
            InternalValueChange = false;
        }

        public void SaveToData()
        {
            if (pd == null)
                return;
            
            pd.OPZ_Mix     = (byte)knobMix.Value    ;
            pd.OPZ_Routing = (byte)knobParSer.Value ;
            pd.OPZ_CutOff  = (byte)knobCutoff.Value ; 
            pd.OPZ_Reso1   = (byte)knobReso1.Value  ; 
            pd.OPZ_Mode1   = (byte)knobMode1.Value  ; 
            pd.OPZ_Spread  = (byte)knobSpread.Value ; 
            pd.OPZ_Reso2   = (byte)knobReso2.Value  ; 
            pd.OPZ_Mode2   = (byte)knobMode2.Value  ; 
        }

        public panelOpZ()
        {
            InitializeComponent();
        }

        private void ValueChanged(object sender, EventArgs e)
        {
            // Block re-entry caused by self changing 
            if (InternalValueChange)
                return;

            // Save data
            if (UIChanged != null)
                UIChanged(this, null);
        }
    }
}
