
/* Include file generated by Toolmaker V1.19 */

#include "VIC20_tm_text.h"	/* Toolmaker text header file */

/* TMScreenInfo structure */
 
struct TMScreenInfo
  {
  struct Screen *Screen;	/* pointer to Screen structure */
  struct TagItem *MoreTags;	/* pointer to additional tag array */
  struct VisualInfo *VisualInfo;	/* pointer to VisualInfo structure */
  APTR UserData;
  };

/* TMWindowInfo structure */
 
struct TMWindowInfo
  {
  struct Window *Window;	/* pointer to Window structure */
  struct TagItem *MoreTags;	/* pointer to additional tag array */
  struct IntuiMessage *GT_IMsg;	/* pointer to last gadtools IntuiMessage */
  struct Menu *Menu;	/* pointer to Menu structure */
  struct Requester Requester;	/* Requester structure for DISABLE/ENABLE */
  UBYTE DisableCount;	/* Count for nested DISABLE/ENABLEs */
  ULONG Flags;	/* TMWF_ flags */
  struct Gadget *FirstGadget;	/* pointer to first gadget */
  struct Gadget *ContextGadget;	/* pointer to context gadget */
  APTR UserData;
  };

/* TMGadgetInfo structure */
 
struct TMGadgetInfo
  {
  struct Gadget *Gadget;
  struct TagItem *MoreTags;
  APTR UserData;
  };

/* TMData structure */
 
struct TMData
  {
  ULONG Size;	/* Size of TMData structure */
  struct MsgPort *WindowMsgPort;	/* pointer to window message port */
  LONG ReturnCode;	/* Return code for exit() */
  struct FileRequester *FileRequester;	/* ASL file requester pointer */
  struct FontRequester *FontRequester;	/* ASL font requester pointer */
  struct TMScreenInfo TMScreenInfo[1];	/* TMScreenInfo structure array */
  struct TMGadgetInfo TMGadgetInfo_VIC20[6];	/* TMGadgetInfo structure array */
  struct TMWindowInfo TMWindowInfo[1];	/* TMWindowInfo structure array */
  APTR UserData;
  };

/* Function Prototypes */
 
struct TMData *TM_Open(ULONG *);
VOID TM_Close(struct TMData *);
LONG TM_Request(struct Window *, UBYTE *, UBYTE *, UBYTE *, ULONG *, APTR, ...);
VOID TM_EventLoop(struct TMData *);
BOOL OpenScreen_Workbench(struct TMData *);
VOID CloseScreen_Workbench(struct TMData *);
BOOL OpenWindow_VIC20(struct TMData *);
VOID CloseWindow_VIC20(struct TMData *);
VOID DisableWindow_VIC20(struct TMData *);
VOID EnableWindow_VIC20(struct TMData *);
BOOL Window_VIC20_MENUPICK(struct TMData *, struct IntuiMessage *);
BOOL Window_VIC20_GADGETUP(struct TMData *, struct IntuiMessage *);
BOOL Window_VIC20_CLOSEWINDOW(struct TMData *, struct IntuiMessage *);

/* Library pointers */
 
extern struct Library *SysBase;
extern struct Library *DOSBase;
extern struct Library *IntuitionBase;
extern struct Library *GadToolsBase;
extern struct Library *UtilityBase;
extern struct Library *AslBase;

/* Constants */
 
#define OPENFILE	0	/* For open file requester */
#define SAVEFILE	1	/* For save file requester */

#define TMWF_OPENED	0x00000001	/* Window opened flag */
#define TMWF_DISABLED	0x00000002	/* Window disabled flag */

#define TMERR_OK	0
#define TMERR_MEMORY	1
#define TMERR_MSGPORT	2

/* Screen pointer */
 
#define screen_Workbench	TMData->TMScreenInfo[0].Screen	/* Default public screen pointer */

/* Window, Menu, and Gadget pointers */
 
#define window_VIC20	TMData->TMWindowInfo[0].Window	/* Window pointer */
#define menu_VIC20	TMData->TMWindowInfo[0].Menu	/* Menu pointer */
#define gadget_TEXT2	TMData->TMGadgetInfo_VIC20[0].Gadget	/* Gadget pointer */
#define gadget_TEXT1	TMData->TMGadgetInfo_VIC20[1].Gadget	/* Gadget pointer */
#define gadget_CHANBUT	TMData->TMGadgetInfo_VIC20[2].Gadget	/* Gadget pointer */
#define gadget_ABOUBUT	TMData->TMGadgetInfo_VIC20[3].Gadget	/* Gadget pointer */
#define gadget_RESEBUT	TMData->TMGadgetInfo_VIC20[4].Gadget	/* Gadget pointer */
#define gadget_CONTBUT	TMData->TMGadgetInfo_VIC20[5].Gadget	/* Gadget pointer */

/* Gadget IDs */
 
#define ID_TEXT2	1	/* Gadget ID */
#define ID_TEXT1	2	/* Gadget ID */
#define ID_CHANBUT	3	/* Gadget ID */
#define ID_ABOUBUT	4	/* Gadget ID */
#define ID_RESEBUT	5	/* Gadget ID */
#define ID_CONTBUT	6	/* Gadget ID */

/* Menu, item, and subitem IDs */
 
#define MENU_PROJECT	0	/* Menu number */
#define ITEM_CONTINUE	0	/* Item number */
#define ITEM_RESET	1	/* Item number */
#define ITEM_LOADPREF	2	/* Item number */
#define ITEM_SAVEPREF	3	/* Item number */
#define ITEM_LOADCART	4	/* Item number */
#define ITEM_CHANGEDI	5	/* Item number */
#define ITEM_ABOUT	6	/* Item number */
#define ITEM_QUIT	7	/* Item number */
#define MENU_MEMORY	1	/* Menu number */
#define ITEM_UNEXPAND	0	/* Item number */
#define ITEM_3KEXP	1	/* Item number */
#define ITEM_8EXPBLK1	2	/* Item number */
#define ITEM_8EXPBLK2	3	/* Item number */
#define ITEM_8EXPBLK3	4	/* Item number */
#define ITEM_FULLEXPA	5	/* Item number */
#define MENU_GRAPHICS	2	/* Menu number */
#define ITEM_SPEEDOME	0	/* Item number */
#define ITEM_SAVESCRE	1	/* Item number */
#define ITEM_INTERLAC	2	/* Item number */
#define ITEM_HIRES	3	/* Item number */
#define	ITEM_MULTISYN	4	/* Item number */
#define MENU_IO	3	/* Menu number */
#define ITEM_ABOUTKEY	0	/* Item number */
#define ITEM_PADDLES	1	/* Item number */
#define ITEM_DISKDRIV	2	/* Item number */
#define ITEM_CASSETTE	3	/* Item number */

/* ScreenInfo pointers */
 
#define ScreenInfo_Workbench	TMData->TMScreenInfo[0]	/* TMScreenInfo structure pointer */

/* WindowInfo pointers */
 
#define WindowInfo_VIC20	TMData->TMWindowInfo[0]	/* TMWindowInfo structure pointer */

/* GadgetInfo pointers */
 
#define GadgetInfo_TEXT2	TMData->TMGadgetInfo_VIC20[0]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_TEXT1	TMData->TMGadgetInfo_VIC20[1]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_CHANBUT	TMData->TMGadgetInfo_VIC20[2]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_ABOUBUT	TMData->TMGadgetInfo_VIC20[3]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_RESEBUT	TMData->TMGadgetInfo_VIC20[4]	/* TMGadgetInfo structure pointer */
#define GadgetInfo_CONTBUT	TMData->TMGadgetInfo_VIC20[5]	/* TMGadgetInfo structure pointer */

/* NewMenu UserData structures */
 
extern TMOBJECTDATA tmobjectdata_CONTINUE;	/* CONTINUE */
extern TMOBJECTDATA tmobjectdata_RESET;	/* RESET */
extern TMOBJECTDATA tmobjectdata_LOADPREF;	/* LOADPREF */
extern TMOBJECTDATA tmobjectdata_SAVEPREF;	/* SAVEPREF */
extern TMOBJECTDATA tmobjectdata_LOADCART;	/* LOADCART */
extern TMOBJECTDATA tmobjectdata_CHANGEDI;	/* CHANGEDI */
extern TMOBJECTDATA tmobjectdata_ABOUT;	/* ABOUT */
extern TMOBJECTDATA tmobjectdata_QUIT;	/* QUIT */
extern TMOBJECTDATA tmobjectdata_UNEXPAND;	/* UNEXPAND */
extern TMOBJECTDATA tmobjectdata_3KEXP;	/* 3KEXP */
extern TMOBJECTDATA tmobjectdata_8EXPBLK1;	/* 8EXPBLK1 */
extern TMOBJECTDATA tmobjectdata_8EXPBLK2;	/* 8EXPBLK2 */
extern TMOBJECTDATA tmobjectdata_8EXPBLK3;	/* 8EXPBLK3 */
extern TMOBJECTDATA tmobjectdata_FULLEXPA;	/* FULLEXPA */
extern TMOBJECTDATA tmobjectdata_SPEEDOME;	/* SPEEDOME */
extern TMOBJECTDATA tmobjectdata_SAVESCRE;	/* SAVESCRE */
extern TMOBJECTDATA tmobjectdata_INTERLAC;	/* INTERLAC */
extern TMOBJECTDATA tmobjectdata_HIRES;	/* HIRES */
extern TMOBJECTDATA tmobjectdata_MULTISYN;	/* MULTISYN */
extern TMOBJECTDATA tmobjectdata_ABOUTKEY;	/* ABOUTKEY */
extern TMOBJECTDATA tmobjectdata_PADDLES;	/* PADDLES */
extern TMOBJECTDATA tmobjectdata_DISKDRIV;	/* DISKDRIV */
extern TMOBJECTDATA tmobjectdata_CASSETTE;	/* CASSETTE */

/* NewGadget UserData structures */
 
extern TMOBJECTDATA tmobjectdata_TEXT2;	/* TEXT2 */
extern TMOBJECTDATA tmobjectdata_TEXT1;	/* TEXT1 */
extern TMOBJECTDATA tmobjectdata_CHANBUT;	/* CHANBUT */
extern TMOBJECTDATA tmobjectdata_ABOUBUT;	/* ABOUBUT */
extern TMOBJECTDATA tmobjectdata_RESEBUT;	/* RESEBUT */
extern TMOBJECTDATA tmobjectdata_CONTBUT;	/* CONTBUT */

