/*
 * Decompiled with CFR 0.152.
 */
package perfectpix;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import perfectpix.LAB;

public class BaseLib {
    public static final int NEAR_COLOR_FAST = 0;
    public static final int NEAR_COLOR_CIEDE2000 = 1;
    public static final int NEAR_COLOR_FAST_MIX_CIEDE2000 = 2;
    public static int NC_Method = 0;
    private static int cccRGB = -1;
    private static int cccR = -1;
    private static int cccG = -1;
    private static int cccB = -1;
    private static LAB rgbLAB = null;
    public static double NC_CIEDE_prop = 0.5;
    private static double NC_CIEDE_f1 = 1.0;
    private static double NC_CIEDE_f2 = 52.77755393265;
    public static final int NO_DITHER = 0;
    public static final int DIFFUSION_DITHER = 1;
    public static final int ORDERED_DITHER = 2;
    public static double[][] FloydSteinberg_dm = new double[][]{{0.0, 0.0, 0.4375}, {0.1875, 0.3125, 0.0625}};
    public static double[][] JarvisJudiceNinke_dm = new double[][]{{0.0, 0.0, 0.0, 0.14583333333333334, 0.10416666666666667}, {0.0625, 0.10416666666666667, 0.14583333333333334, 0.10416666666666667, 0.0625}, {0.020833333333333332, 0.0625, 0.10416666666666667, 0.0625, 0.020833333333333332}};
    public static double[][] Stucki_dm = new double[][]{{0.0, 0.0, 0.0, 0.19047619047619047, 0.09523809523809523}, {0.047619047619047616, 0.09523809523809523, 0.19047619047619047, 0.09523809523809523, 0.047619047619047616}, {0.023809523809523808, 0.047619047619047616, 0.09523809523809523, 0.047619047619047616, 0.023809523809523808}};
    public static double[][] Sierra_dm = new double[][]{{0.0, 0.0, 0.0, 0.15625, 0.09375}, {0.0625, 0.125, 0.15625, 0.125, 0.0625}, {0.0, 0.0625, 0.09375, 0.0625, 0.0}};
    public static double[][] Ordered_8x8 = new double[][]{{0.015384615384615385, 0.7538461538461538, 0.2, 0.9384615384615385, 0.06153846153846154, 0.8, 0.24615384615384617, 0.9846153846153847}, {0.5076923076923077, 0.26153846153846155, 0.6923076923076923, 0.4461538461538462, 0.5538461538461539, 0.3076923076923077, 0.7384615384615385, 0.49230769230769234}, {0.13846153846153847, 0.8769230769230769, 0.07692307692307693, 0.8153846153846154, 0.18461538461538463, 0.9230769230769231, 0.12307692307692308, 0.8615384615384616}, {0.6307692307692307, 0.38461538461538464, 0.5692307692307692, 0.3230769230769231, 0.676923076923077, 0.4307692307692308, 0.6153846153846154, 0.36923076923076925}, {0.046153846153846156, 0.7846153846153846, 0.23076923076923078, 0.9692307692307692, 0.03076923076923077, 0.7692307692307693, 0.2153846153846154, 0.9538461538461539}, {0.5384615384615384, 0.2923076923076923, 0.7230769230769231, 0.47692307692307695, 0.5230769230769231, 0.27692307692307694, 0.7076923076923077, 0.46153846153846156}, {0.16923076923076924, 0.9076923076923077, 0.1076923076923077, 0.8461538461538461, 0.15384615384615385, 0.8923076923076924, 0.09230769230769231, 0.8307692307692308}, {0.6615384615384615, 0.4153846153846154, 0.6, 0.35384615384615387, 0.6461538461538462, 0.4, 0.5846153846153846, 0.3384615384615385}};

    public static boolean exec(List<String> _command, boolean _showOutput) {
        try {
            Process _process = new ProcessBuilder(_command).start();
            _process.waitFor();
            if (_showOutput) {
                System.out.println(BaseLib.getStringFromInputStream(_process.getErrorStream()));
                System.out.println(BaseLib.getStringFromInputStream(_process.getInputStream()));
            }
            return true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public static boolean pathInDsk(String _path) {
        return _path.toLowerCase().indexOf(".dsk") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        return sb.toString();
    }

    public static String getFileNameWithoutExtension(String fileName) {
        int _i = fileName.lastIndexOf(46);
        if (_i >= 0 && _i == fileName.length() - 4) {
            return fileName.substring(0, _i).toLowerCase();
        }
        return fileName;
    }

    public static boolean hasExtension(String fileName) {
        int _i = fileName.lastIndexOf(46);
        return _i >= 0 && _i == fileName.length() - 4;
    }

    public static String getFileExtension(String fileName) {
        if (BaseLib.hasExtension(fileName)) {
            return fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
        }
        return null;
    }

    public static void writeIInt(DataOutputStream _dos, int _v) throws Exception {
        _dos.writeByte(_v & 0xFF);
        _dos.writeByte(_v >> 8 & 0xFF);
        _dos.writeByte(_v >> 16 & 0xFF);
        _dos.writeByte(_v >> 24 & 0xFF);
    }

    public static void writeIShort(DataOutputStream _dos, int _v) throws Exception {
        _dos.writeByte(_v & 0xFF);
        _dos.writeByte(_v >> 8 & 0xFF);
    }

    public static int getNearColorIndex(int rgb, int[] pal) {
        double minDif = Double.MAX_VALUE;
        int index = -1;
        for (int i = pal.length - 1; i >= 0; --i) {
            double dif;
            switch (NC_Method) {
                case 1: {
                    dif = BaseLib.getPixelsDifs_ciede2000(rgb, pal[i]);
                    break;
                }
                case 2: {
                    dif = BaseLib.getPixelsDifs_fast_mix_ciede2000(rgb, pal[i]);
                    break;
                }
                default: {
                    dif = BaseLib.getPixelsDifs_fast(rgb, pal[i]);
                }
            }
            if (!(dif <= minDif)) continue;
            minDif = dif;
            index = i;
        }
        return index;
    }

    public static double getPixelsDifs_fast(int argb1, int argb2) {
        if (cccRGB != argb1) {
            cccRGB = argb1;
            cccR = argb1 >> 16 & 0xFF;
            cccG = argb1 >> 8 & 0xFF;
            cccB = argb1 & 0xFF;
        }
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        double rmean = (double)(cccR + r2) * 0.5;
        double r = cccR - r2;
        double g = cccG - g2;
        double b = cccB - b2;
        return (512.0 + rmean) * r * r / 256.0 + 4.0 * g * g + (767.0 - rmean) * b * b / 256.0;
    }

    public static double getPixelsDifs_ciede2000(int argb1, int argb2) {
        if (cccRGB != argb1) {
            cccRGB = argb1;
            cccR = argb1 >> 16 & 0xFF;
            cccG = argb1 >> 8 & 0xFF;
            cccB = argb1 & 0xFF;
            rgbLAB = LAB.fromRGB(cccR, cccG, cccB, 0.0);
        }
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        return LAB.ciede2000(rgbLAB, LAB.fromRGB(r2, g2, b2, 0.0));
    }

    public static double getPixelsDifs_fast_mix_ciede2000(int argb1, int argb2) {
        if (NC_CIEDE_prop == 0.0) {
            return BaseLib.getPixelsDifs_fast(argb1, argb2);
        }
        if (NC_CIEDE_prop == 1.0) {
            return BaseLib.getPixelsDifs_ciede2000(argb1, argb2);
        }
        if (cccRGB != argb1) {
            cccRGB = argb1;
            cccR = argb1 >> 16 & 0xFF;
            cccG = argb1 >> 8 & 0xFF;
            cccB = argb1 & 0xFF;
            rgbLAB = LAB.fromRGB(cccR, cccG, cccB, 0.0);
        }
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        double rmean = (double)(cccR + r2) * 0.5;
        double r = cccR - r2;
        double g = cccG - g2;
        double b = cccB - b2;
        double d1 = (512.0 + rmean) * r * r / 256.0 + 4.0 * g * g + (767.0 - rmean) * b * b / 256.0;
        double d3 = LAB.ciede2000(rgbLAB, LAB.fromRGB(r2, g2, b2, 0.0));
        return d1 * NC_CIEDE_f1 + d3 * NC_CIEDE_f2;
    }

    public static void setCIEDE_prop(double _prop) {
        NC_CIEDE_prop = _prop;
        NC_CIEDE_f1 = 1.0 - NC_CIEDE_prop;
        NC_CIEDE_f2 = NC_CIEDE_prop * 52.77755393265;
    }

    public static void RGBToIndexed(int[] srcRGB, int[] desIndex, int[] pal) {
        int nPixels = srcRGB.length;
        for (int i = 0; i < nPixels; ++i) {
            int index;
            desIndex[i] = index = BaseLib.getNearColorIndex(srcRGB[i], pal);
            if ((i & 0xFF) != 0) continue;
            int progress = (int)((double)i * 100.0 / (double)nPixels);
            System.out.print("Completed " + progress + "%\r");
        }
    }

    public static void diffusionRGBToIndexed(int[] srcRGB, int[] desIndex, int[] pal, int width, int height, double[][] ditherMatrix, double ditherLevel) {
        int dm_h = ditherMatrix.length;
        int dm_w = ditherMatrix[0].length;
        int dm_w2 = dm_w >> 1;
        int dm_h2 = dm_h + 1 >> 1;
        int nPixels = srcRGB.length;
        double[] srcR = new double[nPixels];
        double[] srcG = new double[nPixels];
        double[] srcB = new double[nPixels];
        BaseLib.decomposeRGB_array(srcRGB, srcR, srcG, srcB, nPixels);
        int nPalColors = pal.length;
        double[] palR = new double[nPalColors];
        double[] palG = new double[nPalColors];
        double[] palB = new double[nPalColors];
        BaseLib.decomposeRGB_array(pal, palR, palG, palB, nPalColors);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int index;
                int i = y * width + x;
                double o_r = srcR[i];
                double o_g = srcG[i];
                double o_b = srcB[i];
                int oRGB = BaseLib.composeRGB(o_r, o_g, o_b);
                desIndex[i] = index = BaseLib.getNearColorIndex(oRGB, pal);
                double dif_r = o_r - palR[index];
                double dif_g = o_g - palG[index];
                double dif_b = o_b - palB[index];
                int xi = Math.max(0, x - dm_w2);
                int xf = Math.min(width, x + dm_w2 + 1);
                int yf = Math.min(height, y + dm_h2 + 1);
                for (int _y = y; _y < yf; ++_y) {
                    int _yo = _y - y;
                    int _cpo = _y * width;
                    double[] _dml = ditherMatrix[_yo];
                    for (int _x = xi; _x < xf; ++_x) {
                        int cp;
                        int _xo = _x - xi;
                        double _df = _dml[_xo] * ditherLevel;
                        if (!(_df > 0.0)) continue;
                        int n = cp = _cpo + _x;
                        srcR[n] = srcR[n] + dif_r * _df;
                        int n2 = cp;
                        srcG[n2] = srcG[n2] + dif_g * _df;
                        int n3 = cp;
                        srcB[n3] = srcB[n3] + dif_b * _df;
                    }
                }
            }
            int progress = (int)((double)y * 100.0 / (double)height);
            System.out.print("Completed " + progress + "%\r");
        }
    }

    public static void patternRGBToIndexed(int[] srcRGB, int[] desIndex, int[] pal, int width, int height, double[][] ditherMatrix, double ditherLevel) {
        int dm_h = ditherMatrix.length;
        int dm_w = ditherMatrix[0].length;
        double brightness = -20.0 * ditherLevel;
        double contrast = -0.03 * ditherLevel;
        double max_c = 1.0156862745098039;
        double c_f = max_c * (contrast + 1.0) / (1.0 * (max_c - contrast));
        ditherLevel *= 0.5;
        for (int y = 0; y < height; ++y) {
            double[] dmy = ditherMatrix[y % dm_h];
            for (int x = 0; x < width; ++x) {
                int index;
                int i = y * width + x;
                int oRGB = srcRGB[i];
                double o_r = oRGB >> 16 & 0xFF;
                double o_g = oRGB >> 8 & 0xFF;
                double o_b = oRGB & 0xFF;
                double dp = dmy[x % dm_w] * ditherLevel;
                double n_r = o_r + o_r * dp;
                double n_g = o_g + o_g * dp;
                double n_b = o_b + o_b * dp;
                n_r += brightness;
                n_g += brightness;
                n_b += brightness;
                n_r = (c_f * (n_r / 255.0 - 0.5) + 0.5) * 255.0;
                n_g = (c_f * (n_g / 255.0 - 0.5) + 0.5) * 255.0;
                n_b = (c_f * (n_b / 255.0 - 0.5) + 0.5) * 255.0;
                double d = n_r > 255.0 ? 255.0 : (n_r = n_r < 0.0 ? 0.0 : n_r);
                double d2 = n_g > 255.0 ? 255.0 : (n_g = n_g < 0.0 ? 0.0 : n_g);
                n_b = n_b > 255.0 ? 255.0 : (n_b < 0.0 ? 0.0 : n_b);
                desIndex[i] = index = BaseLib.getNearColorIndex(BaseLib.composeRGB(n_r, n_g, n_b), pal);
            }
            int progress = (int)((double)y * 100.0 / (double)height);
            System.out.print("Completed " + progress + "%\r");
        }
    }

    private static void decomposeRGB_array(int[] rgb, double[] r, double[] g, double[] b, int n) {
        for (int i = 0; i < n; ++i) {
            int oRGB = rgb[i];
            r[i] = oRGB >> 16 & 0xFF;
            g[i] = oRGB >> 8 & 0xFF;
            b[i] = oRGB & 0xFF;
        }
    }

    private static void composeRGB_array(int[] rgb, double[] r, double[] g, double[] b, int n) {
        for (int i = 0; i < n; ++i) {
            rgb[i] = BaseLib.composeRGB(r[i], g[i], b[i]);
        }
    }

    private static int composeRGB(double c_r, double c_g, double c_b) {
        int _r = (int)((c_r < 0.0 ? 0.0 : (c_r > 255.0 ? 255.0 : c_r)) + 0.5);
        int _g = (int)((c_g < 0.0 ? 0.0 : (c_g > 255.0 ? 255.0 : c_g)) + 0.5);
        int _b = (int)((c_b < 0.0 ? 0.0 : (c_b > 255.0 ? 255.0 : c_b)) + 0.5);
        return _r << 16 | _g << 8 | _b;
    }

    public static int getRGBInt(byte _r, byte _g, byte _b) {
        return (_r & 0xFF) << 16 | (_g & 0xFF) << 8 | _b & 0xFF;
    }
}

