/*
 * Decompiled with CFR 0.152.
 */
package perfectpix;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import perfectpix.BaseLib;

public class VFile
extends BaseLib {
    static final boolean DEBUG = true;
    static final String FILE_TEMP1 = "temp1.bin";
    static final String FILE_TEMP2 = "temp2.bin";
    static final int CAT = 0;
    static final int SRC = 1;
    static final int DES = 2;
    public static final int AMSDOS_HEADER_SIZE = 128;
    boolean ready;
    boolean inDsk;
    boolean removeTempFileOnClose;
    String mPath;
    String mDskPath;
    String mFilenameInDSK;
    File mFile;
    File mDskFile;
    byte[] data;

    public VFile(String _path, int _type) {
        try {
            this.ready = false;
            this.removeTempFileOnClose = false;
            this.mPath = _path.toLowerCase();
            int _i = this.mPath.indexOf(".dsk");
            boolean bl = this.inDsk = _i >= 0;
            if (this.inDsk) {
                this.mDskPath = this.mPath.substring(0, _i + 4);
                System.out.println("mDskPath = " + this.mDskPath);
                if (_type != 0) {
                    this.mFilenameInDSK = this.mPath.substring(_i + 5);
                    System.out.println("mFilenameInDSK = " + this.mFilenameInDSK);
                }
                this.mDskFile = new File(this.mDskPath);
                if (!this.mDskFile.exists()) {
                    System.out.println("mDskPath no exists!");
                    if (_type == 2) {
                        VFile.exec(Arrays.asList("cpcxfs.exe", "-nd", this.mDskPath), true);
                    } else {
                        System.out.println("Source file not found!");
                        return;
                    }
                }
                this.mPath = FILE_TEMP1;
                this.removeTempFileOnClose = true;
                if (_type == 1) {
                    VFile.exec(Arrays.asList("cpcxfs.exe", this.mDskPath, "-b", "-f", "-g", this.mFilenameInDSK, this.mPath), true);
                }
            }
            this.mFile = new File(this.mPath);
            boolean bl2 = this.ready = _type == 0 || _type == 2 || this.mFile.exists();
            if (this.ready && _type == 1) {
                this.data = new byte[(int)this.mFile.length()];
                FileInputStream _fis = new FileInputStream(this.mFile);
                DataInputStream _dis = new DataInputStream(_fis);
                _dis.readFully(this.data);
                _dis.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.ready = false;
        }
    }

    public byte[] getRawBytes() throws Exception {
        if (this.inDsk) {
            byte[] _data = new byte[this.data.length - 128];
            System.arraycopy(this.data, 128, _data, 0, _data.length);
            return _data;
        }
        return this.data;
    }

    public boolean save(VFile _src, int _off, int _len) {
        try {
            return this.saveData(_src.getRawBytes(), _off, _len);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public boolean saveData(byte[] _data, int _off, int _len) {
        try {
            System.out.println("Saving data...");
            FileOutputStream _fos = new FileOutputStream(this.mFile);
            DataOutputStream _dos = new DataOutputStream(_fos);
            _dos.write(_data, _off, _len);
            _dos.flush();
            _dos.close();
            if (this.inDsk) {
                VFile.exec(Arrays.asList("addhead.exe", "-a", this.mPath, FILE_TEMP2), true);
                VFile.exec(Arrays.asList("cpcxfs.exe", this.mDskPath, "-b", "-f", "-p", FILE_TEMP2, this.mFilenameInDSK), true);
                new File(FILE_TEMP2).delete();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    public boolean copy(VFile _src) {
        try {
            byte[] _data = _src.getRawBytes();
            return this.saveData(_data, 0, _data.length);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public void close() {
        if (this.removeTempFileOnClose && this.mFile != null) {
            this.mFile.delete();
        }
    }

    public void cat() {
        if (this.ready && this.inDsk) {
            VFile.exec(Arrays.asList("cpcxfs.exe", this.mDskPath, "-d"), true);
        }
    }
}

