/* CC0 license (public domain)
 * By Julien Aubert (a.k.a noglin)
 */
#include <Quickdraw.h>
#include <Fonts.h>
#include <Events.h>
#include <Menus.h>
#include <Windows.h>
#include <TextEdit.h>
#include <Dialogs.h>
#include <OSUtils.h>
#include <ToolUtils.h>
#include <Devices.h>

#include <stdint.h>
#include <math.h>

#ifndef M_PI
#define M_PI 3.1415926536
#endif

#include "mac_video.h"
#include "mac_sound.h"
#include "mac_valkyrie.h"
#include "mac_demo.h"


uint8_t pixel_video_key = 0;


int main(void) {
	struct framebuffer fb0, fb1;
	struct framebuffer *fb;
	int fb_pages = 2;
	int frames;
    long tickcount0;
    long tickcount;
	int use_valkyrie = valkyrie_available();
	int use_vbl = 0;
	int use_main_gdevice = 0;

	InitGraf(&qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(nil);
	InitCursor();

	if (use_valkyrie) {
		use_main_gdevice = 1;
		mac_video_init(640, 480, 8, use_vbl, use_main_gdevice);
		atexit(mac_video_cleanup);
		valkyrie_init(pixel_video_key);
		atexit(valkyrie_stop);
		fb0.w = 320;	
		fb0.h = 240;
		fb0.rowbytes = VALKYRIE_BUFFER_VIDEO_ROWBYTES;
		fb0.b = valkyrie_buffer_video0;
		fb1 = fb0;
		fb1.b = valkyrie_buffer_video1;
	} else {
		mac_video_init(640, 480, 16, use_vbl, use_main_gdevice);
		atexit(mac_video_cleanup);
		mac_video_init_backbuffer(&fb0, 320, 240, 16);
		mac_video_init_backbuffer(&fb1, 320, 240, 16);
		memset(fb0.b, 0, fb0.h * fb0.rowbytes);
		memset(fb1.b, 0, fb1.h * fb1.rowbytes);
 	}
 	fb = &fb0;
	{
		if (use_valkyrie) {
			fb = fb0.b == valkyrie_get_video_backbuffer() ? &fb0 : &fb1;
		} else {
			fb = fb == &fb1 ? &fb0 : &fb1;
		}
		mac_video_wait_vbl();
		if (use_valkyrie) {
			valkyrie_pageflip_video();
		} else {
			mac_video_blit(fb);
		}
	}
	mac_demo_init(fb_pages, fb0.w, fb0.h, fb0.rowbytes);
	atexit(mac_demo_cleanup);
	mac_sound_init();
	atexit(mac_sound_cleanup);
	frames = 0;
	tickcount0 = TickCount();
	do {
		if (use_valkyrie) {
			fb = fb0.b == valkyrie_get_video_backbuffer() ? &fb0 : &fb1;
		} else {
			fb = fb == &fb1 ? &fb0 : &fb1;
		}
		mac_demo_update(fb);
		mac_video_wait_vbl();
		if (use_valkyrie) {
			valkyrie_pageflip_video();
		} else {
			mac_video_blit(fb);
		}
		frames++;
	} while (!Button());
	tickcount = TickCount();
#if 0
	{
		long ticks = tickcount - tickcount0;
		float frame_ms = ticks/60.f * 1000/frames;
		float fps = 1000.f/frame_ms;
		printf("fps: %f frame_ms: %f\n", fps, frame_ms);
    }
#endif
	/* atexit will call cleanup */	
	return 0;
}
