#ifndef MAC_VIDEO_H
#define MAC_VIDEO_H

#include <stdint.h>

struct framebuffer {
	int rowbytes;
	int w;
	int h;
	int bpp;
	void *b;
};


extern struct framebuffer mac_video_screen;

void mac_video_init(int w, int h, int bpp, int use_vbl, int use_main_gdevice);
void mac_video_cleanup(void);
void mac_video_wait_vbl(void);

void mac_video_get_framebuffer(struct framebuffer *fb);
void mac_video_init_backbuffer(struct framebuffer *fb, int w, int h, int bpp);
void mac_video_blit(struct framebuffer *fb);



unsigned int asm blitter2x(
	register void *r3 /* dst */,
	register unsigned int r4 /* dst_rowbytes */, 
	register void *r5 /* src */,
	register int r6 /* dst_height */
);

unsigned int asm blitter2x_interlaced(
	register void *r3, /* dst */
	register uint32_t r4, /* dst_rowbytes */
	register void *r5, /* src */
	register int r6, /* dst_height */
	register uint32_t *r7 /* tmp 32 bytes */
);

#endif MAC_VIDEO_H
